/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
implements Receiver {
    private PipelineConfiguration pipe;
    private NamePool namePool;
    private Node currentNode;
    private Document document;
    private boolean canNormalize = true;
    private String systemId;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        this.namePool = pipelineConfiguration.getConfiguration().getNamePool();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int n2) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        String string = this.namePool.getDisplayName(n2);
        String string2 = this.namePool.getURI(n2);
        try {
            Element element = this.document.createElementNS("".equals(string2) ? null : string2, string);
            this.currentNode.appendChild(element);
            this.currentNode = element;
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void namespace(int n2, int n3) throws XPathException {
        try {
            String string = this.namePool.getPrefixFromNamespaceCode(n2);
            String string2 = this.namePool.getURIFromNamespaceCode(n2);
            Element element = (Element)this.currentNode;
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                if (string.equals("")) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
                } else {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
                }
            }
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        String string = this.namePool.getDisplayName(n2);
        String string2 = this.namePool.getURI(n2);
        try {
            Element element = (Element)this.currentNode;
            element.setAttributeNS("".equals(string2) ? null : string2, string, ((Object)charSequence).toString());
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable throwable) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        try {
            Text text = this.document.createTextNode(((Object)charSequence).toString());
            this.currentNode.appendChild(text);
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        try {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, ((Object)charSequence).toString());
            this.currentNode.appendChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        try {
            Comment comment = this.document.createComment(((Object)charSequence).toString());
            this.currentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new DynamicError(dOMException);
        }
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.currentNode = node;
        this.document = node.getNodeType() == 9 ? (Document)node : this.currentNode.getOwnerDocument();
    }
}

