/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.CharacterSetFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class CDATAFilter
extends ProxyReceiver {
    private FastStringBuffer buffer = new FastStringBuffer(256);
    private Stack stack = new Stack();
    private int[] nameList;
    private CharacterSet characterSet;

    public void setOutputProperties(Properties properties) throws XPathException {
        this.nameList = this.getCdataElements(properties);
        this.characterSet = CharacterSetFactory.getCharacterSet(properties, this.getPipelineConfiguration().getController());
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        this.flush(this.buffer);
        this.stack.push(new Integer(n2 & 0xFFFFF));
        super.startElement(n2, n3, n4, n5);
    }

    public void endElement() throws XPathException {
        this.flush(this.buffer);
        this.stack.pop();
        super.endElement();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        this.flush(this.buffer);
        super.processingInstruction(string, charSequence, n2, n3);
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if ((n3 & 1) == 0) {
            this.buffer.append(((Object)charSequence).toString());
        } else {
            this.flush(this.buffer);
            super.characters(charSequence, n2, n3);
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.flush(this.buffer);
        super.comment(charSequence, n2, n3);
    }

    public void flush(FastStringBuffer fastStringBuffer) throws XPathException {
        int n2;
        boolean bl;
        int n3 = fastStringBuffer.length();
        if (n3 == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            bl = false;
        } else {
            n2 = (Integer)this.stack.peek();
            bl = this.isCDATA(n2);
        }
        if (bl) {
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = fastStringBuffer.charAt(n4);
                int n6 = 1;
                if (XMLChar.isHighSurrogate((char)n5)) {
                    n5 = XMLChar.supplemental((char)n5, fastStringBuffer.charAt(n4 + 1));
                    n6 = 2;
                }
                if (this.characterSet.inCharset(n5)) {
                    ++n4;
                    continue;
                }
                char[] cArray = new char[n4 - n2];
                fastStringBuffer.getChars(n2, n4, cArray, 0);
                this.flushCDATA(cArray, n4 - n2);
                while (n4 < n3) {
                    super.characters(fastStringBuffer.subSequence(n4, n4 + n6), 0, 0);
                    if ((n4 += n6) >= n3) break;
                    n5 = fastStringBuffer.charAt(n4);
                    n6 = 1;
                    if (XMLChar.isHighSurrogate((char)n5)) {
                        n5 = XMLChar.supplemental((char)n5, fastStringBuffer.charAt(n4 + 1));
                        n6 = 2;
                    }
                    if (!this.characterSet.inCharset(n5)) continue;
                }
                n2 = n4;
            }
            char[] cArray = new char[n3 - n2];
            fastStringBuffer.getChars(n2, n3, cArray, 0);
            this.flushCDATA(cArray, n3 - n2);
        } else {
            super.characters(fastStringBuffer, 0, 0);
        }
        fastStringBuffer.setLength(0);
    }

    private void flushCDATA(char[] cArray, int n2) throws XPathException {
        if (n2 == 0) {
            return;
        }
        super.characters("<![CDATA[", 0, 1);
        int n3 = 0;
        for (int i2 = 0; i2 < n2 - 2; ++i2) {
            if (cArray[i2] != ']' || cArray[i2 + 1] != ']' || cArray[i2 + 2] != '>') continue;
            super.characters(new CharSlice(cArray, n3, i2 + 2 - n3), 0, 1);
            super.characters("]]><![CDATA[", 0, 1);
            n3 = i2 + 2;
        }
        super.characters(new CharSlice(cArray, n3, n2 - n3), 0, 1);
        super.characters("]]>", 0, 1);
    }

    private boolean isCDATA(int n2) {
        for (int i2 = 0; i2 < this.nameList.length; ++i2) {
            if (this.nameList[i2] != n2) continue;
            return true;
        }
        return false;
    }

    private int[] getCdataElements(Properties properties) {
        String string = properties.getProperty("cdata-section-elements");
        if (string == null) {
            return new int[0];
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string);
        while (stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer2.nextToken();
            nArray[n2++] = this.getNamePool().getFingerprintForExpandedName(string2);
        }
        return nArray;
    }
}

