/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Err;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public final class ComplexContentOutputter
extends SequenceReceiver {
    private Receiver receiver;
    private int pendingStartTag = -2;
    private int level = -1;
    private Boolean elementIsInNullNamespace;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private CharSequence[] pendingAttValue = new String[20];
    private int[] pendingAttLocation = new int[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = -1;
    private int startElementProperties;
    private int startElementLocationId;
    private boolean declaresDefaultNamespace;
    private int hostLanguage = 50;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
    }

    public void setHostLanguage(int n2) {
        this.hostLanguage = n2;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void open() throws XPathException {
        this.receiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int n2) throws XPathException {
        ++this.level;
        if (this.level == 0) {
            this.receiver.startDocument(n2);
        } else if (this.pendingStartTag >= 0) {
            this.startContent();
            this.pendingStartTag = -2;
        }
        this.previousAtomic = false;
    }

    public void endDocument() throws XPathException {
        if (this.level == 0) {
            this.receiver.endDocument();
        }
        --this.level;
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.previousAtomic = false;
        if (charSequence == null) {
            return;
        }
        int n4 = charSequence.length();
        if (n4 == 0) {
            return;
        }
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.characters(charSequence, n2, n3);
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        ++this.level;
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.startElementProperties = n5;
        this.startElementLocationId = n4;
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = n2;
        this.elementIsInNullNamespace = null;
        this.currentSimpleType = n3;
        this.previousAtomic = false;
    }

    public void namespace(int n2, int n3) throws XPathException {
        if (this.pendingStartTag < 0) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, this.getNamePool().getPrefixFromNamespaceCode(n2), this.hostLanguage, this.level <= 0 || this.pendingStartTag == -2, this.getPipelineConfiguration().isSerializing() && this.level <= 0);
        }
        boolean bl = (n3 & 0x20) != 0;
        for (int i2 = 0; i2 < this.pendingNSListSize; ++i2) {
            if (n2 == this.pendingNSList[i2]) {
                return;
            }
            if (n2 >> 16 != this.pendingNSList[i2] >> 16) continue;
            if (bl) {
                DynamicError dynamicError = new DynamicError("Cannot create two namespace nodes with the same name");
                dynamicError.setErrorCode("XTDE0430");
                throw dynamicError;
            }
            return;
        }
        if (n2 >> 16 == 0 && (n2 & 0xFFFF) != 0) {
            this.declaresDefaultNamespace = true;
            if (this.elementIsInNullNamespace == null) {
                this.elementIsInNullNamespace = this.getNamePool().getURI(this.pendingStartTag) == "";
            }
            if (this.elementIsInNullNamespace.booleanValue()) {
                DynamicError dynamicError = new DynamicError("Cannot output a namespace node for the default namespace when the element is in no namespace");
                dynamicError.setErrorCode("XTDE0440");
                throw dynamicError;
            }
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n2;
        this.previousAtomic = false;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.pendingStartTag < 0) {
            NoOpenStartTagException noOpenStartTagException = NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(n2), this.hostLanguage, this.level <= 0 || this.pendingStartTag == -2, this.getPipelineConfiguration().isSerializing() && this.level <= 0);
            noOpenStartTagException.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n4));
            throw noOpenStartTagException;
        }
        for (int i2 = 0; i2 < this.pendingAttListSize; ++i2) {
            if ((this.pendingAttCode[i2] & 0xFFFFF) != (n2 & 0xFFFFF)) continue;
            if (this.hostLanguage == 50) {
                this.pendingAttType[i2] = n3;
                this.pendingAttValue[i2] = charSequence;
                this.pendingAttLocation[i2] = n4;
                this.pendingAttProp[i2] = n5;
                return;
            }
            DynamicError dynamicError = new DynamicError("Cannot create an element having two attributes with the same name: " + Err.wrap(this.getNamePool().getDisplayName(n2), 2));
            dynamicError.setErrorCode("XQDY0025");
            throw dynamicError;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] nArray = new int[this.pendingAttListSize * 2];
            int[] nArray2 = new int[this.pendingAttListSize * 2];
            String[] stringArray = new String[this.pendingAttListSize * 2];
            int[] nArray3 = new int[this.pendingAttListSize * 2];
            int[] nArray4 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, nArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, nArray2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, stringArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttLocation, 0, nArray3, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, nArray4, 0, this.pendingAttListSize);
            this.pendingAttCode = nArray;
            this.pendingAttType = nArray2;
            this.pendingAttValue = stringArray;
            this.pendingAttLocation = nArray3;
            this.pendingAttProp = nArray4;
        }
        this.pendingAttCode[this.pendingAttListSize] = n2;
        this.pendingAttType[this.pendingAttListSize] = n3;
        this.pendingAttValue[this.pendingAttListSize] = charSequence;
        this.pendingAttLocation[this.pendingAttListSize] = n4;
        this.pendingAttProp[this.pendingAttListSize] = n5;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int n2, int n3) throws XPathException {
        NamePool namePool = this.getNamePool();
        int n4 = namePool.getNamespaceCode(n2);
        if (n4 == -1) {
            n4 = namePool.allocateNamespaceCode(n2);
        }
        int n5 = n4 >> 16;
        for (int i2 = 0; i2 < this.pendingNSListSize; ++i2) {
            if (n5 != this.pendingNSList[i2] >> 16) continue;
            if ((n4 & 0xFFFF) == (this.pendingNSList[i2] & 0xFFFF)) {
                return n2;
            }
            String string = this.getSubstitutePrefix(n4, n3);
            int n6 = namePool.allocate(string, namePool.getURI(n2), namePool.getLocalName(n2));
            this.namespace(namePool.allocateNamespaceCode(n6), 0);
            return n6;
        }
        this.namespace(n4, 0);
        return n2;
    }

    private String getSubstitutePrefix(int n2, int n3) {
        String string = this.getNamePool().getPrefixFromNamespaceCode(n2);
        return string + '_' + n3;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.endElement();
        --this.level;
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.comment(charSequence, n2, n3);
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.pendingStartTag >= 0) {
            this.startContent();
        }
        this.receiver.processingInstruction(string, charSequence, n2, n3);
        this.previousAtomic = false;
    }

    public void append(Item item, int n2, int n3) throws XPathException {
        if (item == null) {
            return;
        }
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", n2, 0);
            }
            this.characters(item.getStringValueCS(), n2, 0);
            this.previousAtomic = true;
        } else if (((NodeInfo)item).getNodeKind() == 9) {
            Item item2;
            AxisIterator axisIterator = ((NodeInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2, n2, n3);
            }
        } else {
            try {
                ((NodeInfo)item).copy(this, n3, true, n2);
            }
            catch (CopyNamespaceSensitiveException copyNamespaceSensitiveException) {
                copyNamespaceSensitiveException.setErrorCode(this.hostLanguage == 50 ? "XTTE0950" : "XQTY0086");
                throw copyNamespaceSensitiveException;
            }
            this.previousAtomic = false;
        }
    }

    public void close() throws XPathException {
        this.receiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int n2;
        if (this.pendingStartTag < 0) {
            return;
        }
        int n3 = this.startElementProperties;
        int n4 = this.pendingStartTag;
        if (this.declaresDefaultNamespace || NamePool.getPrefixIndex(n4) != 0) {
            n4 = this.checkProposedPrefix(this.pendingStartTag, 0);
            n3 = this.startElementProperties | 0x40;
        }
        this.receiver.startElement(n4, this.currentSimpleType, this.startElementLocationId, n3);
        for (n2 = 0; n2 < this.pendingAttListSize; ++n2) {
            int n5 = this.pendingAttCode[n2];
            if (NamePool.getPrefixIndex(n5) == 0) continue;
            this.pendingAttCode[n2] = this.checkProposedPrefix(n5, n2 + 1);
        }
        for (n2 = 0; n2 < this.pendingNSListSize; ++n2) {
            this.receiver.namespace(this.pendingNSList[n2], 0);
        }
        for (n2 = 0; n2 < this.pendingAttListSize; ++n2) {
            this.receiver.attribute(this.pendingAttCode[n2], this.pendingAttType[n2], this.pendingAttValue[n2], this.pendingAttLocation[n2], this.pendingAttProp[n2]);
        }
        this.receiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

