/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleLocator role;
    private int count = 0;
    private int level = 0;
    private HashSet checkedElements = new HashSet(10);

    public void setRequiredType(ItemType itemType, int n2, RoleLocator roleLocator) {
        this.itemType = itemType;
        this.cardinality = n2;
        this.role = roleLocator;
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n4);
            }
            CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(2, n2, this.getNamePool()), 23, new ContentTypeTest(2, this.getConfiguration().getSchemaType(n3), this.getConfiguration()));
            this.checkItemType(combinedNodeTest, n4);
        }
        super.attribute(n2, n3, charSequence, n4, n5);
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n2);
            }
            NodeKindTest nodeKindTest = NodeKindTest.TEXT;
            this.checkItemType(nodeKindTest, n2);
        }
        super.characters(charSequence, n2, n3);
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n2);
            }
            NodeKindTest nodeKindTest = NodeKindTest.COMMENT;
            this.checkItemType(nodeKindTest, n2);
        }
        super.comment(charSequence, n2, n3);
    }

    public void namespace(int n2, int n3) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest nodeKindTest = NodeKindTest.NAMESPACE;
            this.checkItemType(nodeKindTest, 0);
        }
        super.namespace(n2, n3);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n2);
            }
            NodeKindTest nodeKindTest = NodeKindTest.PROCESSING_INSTRUCTION;
            this.checkItemType(nodeKindTest, n2);
        }
        super.processingInstruction(string, charSequence, n2, n3);
    }

    public void startDocument(int n2) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest nodeKindTest = NodeKindTest.DOCUMENT;
            this.checkItemType(nodeKindTest, 0);
        }
        ++this.level;
        super.startDocument(n2);
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(n3), this.getConfiguration()));
                this.checkItemType(combinedNodeTest, n4);
            } else {
                Long l2;
                if (this.count == 2) {
                    this.checkAllowsMany(n4);
                }
                if (!this.checkedElements.contains(l2 = new Long((long)(n2 & 0xFFFFF) << 32 | (long)(n3 & 0xFFFFF)))) {
                    CombinedNodeTest combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(n3), this.getConfiguration()));
                    this.checkItemType(combinedNodeTest, n4);
                    this.checkedElements.add(l2);
                }
            }
        }
        ++this.level;
        super.startElement(n2, n3, n4, n5);
    }

    public void endDocument() throws XPathException {
        --this.level;
        super.endDocument();
    }

    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            DynamicError dynamicError = new DynamicError("An empty sequence is not allowed as the " + this.role.getMessage());
            String string = this.role.getErrorCode();
            dynamicError.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                dynamicError.setIsTypeError(true);
            }
            throw dynamicError;
        }
    }

    public void append(Item item, int n2, int n3) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(n2);
            }
            this.checkItemType(Value.asValue(item).getItemType(this.getConfiguration().getTypeHierarchy()), n2);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, n2, n3);
        } else {
            super.append(item, n2, n3);
        }
    }

    private void checkItemType(ItemType itemType, int n2) throws DynamicError {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(itemType, this.itemType)) {
            String string = this.role.composeErrorMessage(this.itemType, itemType, this.getNamePool());
            String string2 = this.role.getErrorCode();
            DynamicError dynamicError = new DynamicError(string);
            dynamicError.setErrorCode(string2);
            if (!"XPDY0050".equals(string2)) {
                dynamicError.setIsTypeError(true);
            }
            dynamicError.setLocator(ExpressionLocation.getSourceLocator(n2, this.getPipelineConfiguration().getLocationProvider()));
            throw dynamicError;
        }
    }

    private void checkAllowsMany(int n2) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            DynamicError dynamicError = new DynamicError("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String string = this.role.getErrorCode();
            dynamicError.setErrorCode(string);
            if (!"XPDY0050".equals(string)) {
                dynamicError.setIsTypeError(true);
            }
            dynamicError.setLocator(ExpressionLocation.getSourceLocator(n2, this.getPipelineConfiguration().getLocationProvider()));
            throw dynamicError;
        }
    }
}

