/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class UserFunctionCall
extends FunctionCall
implements InstructionInfoProvider {
    private SequenceType staticType;
    private UserFunction function;
    private boolean tailRecursive = false;
    private boolean confirmed = false;

    public void setStaticType(SequenceType sequenceType) {
        this.staticType = sequenceType;
    }

    public void setFunction(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        this.function = userFunction;
        this.confirmed = true;
    }

    public void checkFunctionCall(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        int n2 = userFunction.getNumberOfArguments();
        for (int i2 = 0; i2 < n2; ++i2) {
            RoleLocator roleLocator = new RoleLocator(0, new Integer(userFunction.getFunctionNameCode()), i2, staticContext.getNamePool());
            roleLocator.setSourceLocator(this);
            this.argument[i2] = TypeChecker.staticTypeCheck(this.argument[i2], userFunction.getArgumentType(i2), false, roleLocator, staticContext);
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public void setConfirmed(boolean bl) {
        this.confirmed = bl;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i2 = 0; i2 < this.argument.length; ++i2) {
            this.argument[i2] = this.argument[i2].simplify(staticContext);
        }
        return this;
    }

    public boolean markTailFunctionCalls() {
        this.tailRecursive = true;
        return true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        return Value.getIterator(valueRepresentation).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.callFunction(xPathContext);
        if (valueRepresentation instanceof FunctionCallPackage) {
            return SingletonIterator.makeIterator((FunctionCallPackage)valueRepresentation);
        }
        return Value.getIterator(valueRepresentation);
    }

    private ValueRepresentation callFunction(XPathContext xPathContext) throws XPathException {
        int n2 = this.argument.length;
        ValueRepresentation[] valueRepresentationArray = new ValueRepresentation[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.function.getParameterDefinitions()[i2].getReferenceCount();
            valueRepresentationArray[i2] = this.argument[i2] instanceof Value ? (Value)this.argument[i2] : (n3 == 0 ? EmptySequence.getInstance() : ((this.argument[i2].getDependencies() & 0x100) != 0 ? ExpressionTool.eagerEvaluate(this.argument[i2], xPathContext) : ExpressionTool.lazyEvaluate(this.argument[i2], xPathContext, n3)));
            if (n3 <= 1 || !(valueRepresentationArray[i2] instanceof Closure) || valueRepresentationArray[i2] instanceof MemoClosure) continue;
            valueRepresentationArray[i2] = ((Closure)valueRepresentationArray[i2]).reduce();
        }
        if (this.tailRecursive) {
            return new FunctionCallPackage(this.function, valueRepresentationArray, xPathContext);
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        try {
            return this.function.call(valueRepresentationArray, xPathContextMajor, true);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new DynamicError("Too many nested function calls. May be due to infinite recursion.", this);
        }
        catch (NullPointerException nullPointerException) {
            if (this.function == null) {
                throw new NullPointerException("Unbound function call " + xPathContextMajor.getConfiguration().getNamePool().getDisplayName(this.getFunctionNameCode()));
            }
            throw nullPointerException;
        }
    }

    public ValueRepresentation dynamicCall(ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) throws XPathException {
        ValueRepresentation[] valueRepresentationArray2 = new ValueRepresentation[valueRepresentationArray.length];
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCaller(xPathContext);
        xPathContextMajor.openStackFrame(valueRepresentationArray.length);
        for (int i2 = 0; i2 < valueRepresentationArray.length; ++i2) {
            xPathContextMajor.setLocalVariable(i2, valueRepresentationArray[i2]);
            valueRepresentationArray2[i2] = ExpressionTool.lazyEvaluate(this.argument[i2], xPathContextMajor, 10);
        }
        XPathContextMajor xPathContextMajor2 = xPathContextMajor.newCleanContext();
        xPathContextMajor2.setOrigin(this);
        return this.function.call(valueRepresentationArray2, xPathContextMajor2, true);
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "call " + this.getDisplayName(configuration.getNamePool()) + (this.tailRecursive ? " (:tail call:)" : ""));
        for (int i2 = 0; i2 < this.argument.length; ++i2) {
            this.argument[i2].display(n2 + 1, printStream, configuration);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2009);
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setObjectNameCode(this.getFunctionNameCode());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setProperty("target", this.function);
        return instructionDetails;
    }

    public class FunctionCallPackage
    extends ObjectValue {
        private UserFunction function;
        private ValueRepresentation[] actualArgs;
        private XPathContext evaluationContext;

        public FunctionCallPackage(UserFunction userFunction, ValueRepresentation[] valueRepresentationArray, XPathContext xPathContext) {
            super(userFunction);
            this.function = userFunction;
            this.actualArgs = valueRepresentationArray;
            this.evaluationContext = xPathContext;
        }

        public ItemType getItemType(TypeHierarchy typeHierarchy) {
            return UserFunctionCall.this.getItemType(typeHierarchy);
        }

        public ValueRepresentation call() throws XPathException {
            XPathContextMajor xPathContextMajor = this.evaluationContext.newCleanContext();
            xPathContextMajor.setOrigin(UserFunctionCall.this);
            return this.function.call(this.actualArgs, xPathContextMajor, false);
        }

        public SequenceIterator iterateResults(XPathContext xPathContext) throws XPathException {
            ValueRepresentation valueRepresentation = this.call();
            MappingFunction mappingFunction = new MappingFunction(this, xPathContext){
                private final /* synthetic */ XPathContext val$context;
                private final /* synthetic */ FunctionCallPackage this$1;
                {
                    this.this$1 = functionCallPackage;
                    this.val$context = xPathContext;
                }

                public Object map(Item item) throws XPathException {
                    if (item instanceof FunctionCallPackage) {
                        return ((FunctionCallPackage)item).iterateResults(this.val$context);
                    }
                    return item;
                }
            };
            return new MappingIterator(Value.getIterator(valueRepresentation), mappingFunction);
        }

        public Value reduce() throws XPathException {
            return new SequenceExtent(this.iterateResults(null)).reduce();
        }

        public AtomicValue getPrimitiveValue() {
            try {
                return ((AtomicValue)this.reduce()).getPrimitiveValue();
            }
            catch (XPathException xPathException) {
                throw new RuntimeException(xPathException);
            }
        }
    }
}

