/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;

public abstract class Random {
    public static SequenceIterator randomSequence(int n2, double d2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("numberOfItems supplied to randomSequence() must be positive");
        }
        long l2 = Double.doubleToLongBits(d2);
        return new RandomIterator(n2, l2);
    }

    public static SequenceIterator randomSequence(int n2) throws IllegalArgumentException {
        return Random.randomSequence(n2, System.currentTimeMillis());
    }

    public static DoubleValue randomSequence() throws XPathException {
        return (DoubleValue)Random.randomSequence(1).next();
    }

    private static class RandomIterator
    extends AxisIteratorImpl {
        private int count;
        private long seed;
        private java.util.Random generator;

        public RandomIterator(int n2, long l2) {
            this.count = n2;
            this.seed = l2;
            this.generator = new java.util.Random(l2);
        }

        public Item next() {
            if (this.position++ >= this.count) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = new DoubleValue(this.generator.nextDouble());
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new RandomIterator(this.count, this.seed);
        }
    }
}

