/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class EscapeURI
extends SystemFunction {
    public static final int ENCODE_FOR_URI = 1;
    public static final int IRI_TO_URI = 2;
    public static final int HTML_URI = 3;
    private static final String hex = "0123456789ABCDEF";

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = item.getStringValueCS();
        switch (this.operation) {
            case 1: {
                return StringValue.makeStringValue(EscapeURI.escape(charSequence, "-_.~"));
            }
            case 2: {
                return StringValue.makeStringValue(EscapeURI.iriToUri(charSequence));
            }
            case 3: {
                return StringValue.makeStringValue(HTMLURIEscaper.escapeURL(charSequence, false));
            }
        }
        throw new UnsupportedOperationException("Unknown escape operation");
    }

    public static CharSequence iriToUri(CharSequence charSequence) {
        if (EscapeURI.allAscii(charSequence)) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 20);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 <= ' ' || c2 >= '\u007f') {
                EscapeURI.escapeChar(c2, i2 + 1 < charSequence.length() ? charSequence.charAt(i2 + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            fastStringBuffer.append(c2);
        }
        return fastStringBuffer;
    }

    private static boolean allAscii(CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 > ' ' && c2 < '\u007f') continue;
            return false;
        }
        return true;
    }

    public static CharSequence escape(CharSequence charSequence, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                fastStringBuffer.append(c2);
                continue;
            }
            if (c2 <= ' ' || c2 >= '\u007f') {
                EscapeURI.escapeChar(c2, i2 + 1 < charSequence.length() ? charSequence.charAt(i2 + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            if (string.indexOf(c2) >= 0) {
                fastStringBuffer.append(c2);
                continue;
            }
            EscapeURI.escapeChar(c2, ' ', fastStringBuffer);
        }
        return fastStringBuffer;
    }

    private static void escapeChar(char c2, char c3, FastStringBuffer fastStringBuffer) {
        byte[] byArray = new byte[4];
        int n2 = UnicodeCharacterSet.getUTF8Encoding(c2, c3, byArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            fastStringBuffer.append('%');
            fastStringBuffer.append(hex.charAt(n3 / 16));
            fastStringBuffer.append(hex.charAt(n3 % 16));
        }
    }
}

