/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import org.xml.sax.Attributes;

public final class AttributeCollectionImpl
implements Attributes,
AttributeCollection {
    private NamePool namePool;
    private LocationProvider locationProvider;
    private String[] values = null;
    private int[] codes = null;
    private int used = 0;
    public static final AttributeCollection EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);
    private static final int RECSIZE = 4;
    private static final int NAMECODE = 0;
    private static final int TYPECODE = 1;
    private static final int LOCATIONID = 2;
    private static final int PROPERTIES = 3;

    public AttributeCollectionImpl(NamePool namePool) {
        this.namePool = namePool;
        this.used = 0;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public void addAttribute(int n2, int n3, String string, int n4, int n5) {
        int n6;
        if (this.values == null) {
            this.values = new String[5];
            this.codes = new int[20];
            this.used = 0;
        }
        if (this.values.length == this.used) {
            n6 = this.used == 0 ? 5 : this.used * 2;
            String[] stringArray = new String[n6];
            int[] nArray = new int[n6 * 4];
            System.arraycopy(this.values, 0, stringArray, 0, this.used);
            System.arraycopy(this.codes, 0, nArray, 0, this.used * 4);
            this.values = stringArray;
            this.codes = nArray;
        }
        n6 = this.used * 4;
        this.codes[n6 + 0] = n2;
        this.codes[n6 + 1] = n3;
        this.codes[n6 + 2] = n4;
        this.codes[n6 + 3] = n5;
        this.values[this.used++] = string;
    }

    public void setAttribute(int n2, int n3, int n4, String string, int n5, int n6) {
        int n7 = n2 * 4;
        this.codes[n7 + 0] = n3;
        this.codes[n7 + 1] = n4;
        this.codes[n7 + 2] = n5;
        this.codes[n7 + 3] = n6;
        this.values[n2] = string;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.codes = null;
            this.values = null;
        } else if (this.values.length > this.used) {
            String[] stringArray = new String[this.used];
            int[] nArray = new int[this.used * 4];
            System.arraycopy(this.values, 0, stringArray, 0, this.used);
            System.arraycopy(this.codes, 0, nArray, 0, this.used * 4);
            this.values = stringArray;
            this.codes = nArray;
        }
    }

    public int getLength() {
        return this.values == null ? 0 : this.used;
    }

    public int getNameCode(int n2) {
        if (this.codes == null) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.used) {
            return -1;
        }
        return this.codes[n2 * 4 + 0];
    }

    public int getTypeAnnotation(int n2) {
        if (this.codes == null) {
            return 642;
        }
        if (n2 < 0 || n2 >= this.used) {
            return 642;
        }
        return this.codes[n2 * 4 + 1];
    }

    public int getLocationId(int n2) {
        if (this.codes == null) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.used) {
            return -1;
        }
        return this.codes[n2 * 4 + 2];
    }

    public String getSystemId(int n2) {
        return this.locationProvider.getSystemId(this.getLocationId(n2));
    }

    public int getLineNumber(int n2) {
        return this.locationProvider.getLineNumber(this.getLocationId(n2));
    }

    public int getProperties(int n2) {
        if (this.codes == null) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.used) {
            return -1;
        }
        return this.codes[n2 * 4 + 3];
    }

    public String getPrefix(int n2) {
        if (this.codes == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.used) {
            return null;
        }
        return this.namePool.getPrefix(this.getNameCode(n2));
    }

    public String getQName(int n2) {
        if (this.codes == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.used) {
            return null;
        }
        return this.namePool.getDisplayName(this.getNameCode(n2));
    }

    public String getLocalName(int n2) {
        if (this.codes == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.used) {
            return null;
        }
        return this.namePool.getLocalName(this.getNameCode(n2));
    }

    public String getURI(int n2) {
        if (this.codes == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.used) {
            return null;
        }
        return this.namePool.getURI(this.getNameCode(n2));
    }

    public String getType(int n2) {
        int n3 = this.getTypeAnnotation(n2) & 0xFFFFF;
        switch (n3) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    public String getType(String string, String string2) {
        int n2 = this.findByName(string, string2);
        return n2 < 0 ? null : this.getType(n2);
    }

    public String getValue(int n2) {
        if (this.values == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.used) {
            return null;
        }
        return this.values[n2];
    }

    public String getValue(String string, String string2) {
        int n2 = this.findByName(string, string2);
        return n2 < 0 ? null : this.getValue(n2);
    }

    public String getValueByFingerprint(int n2) {
        int n3 = this.findByFingerprint(n2);
        return n3 < 0 ? null : this.getValue(n3);
    }

    public int getIndex(String string) {
        String[] stringArray;
        if (this.codes == null) {
            return -1;
        }
        if (string.indexOf(58) < 0) {
            return this.findByName("", string);
        }
        try {
            stringArray = Name11Checker.getInstance().getQNameParts(string);
        }
        catch (QNameException qNameException) {
            return -1;
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            return this.findByName("", string);
        }
        String string3 = stringArray[1];
        for (int i2 = 0; i2 < this.used; ++i2) {
            String string4 = this.namePool.getLocalName(this.getNameCode(i2));
            String string5 = this.namePool.getPrefix(this.getNameCode(i2));
            if (!string3.equals(string4) || !string2.equals(string5)) continue;
            return i2;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        return this.findByName(string, string2);
    }

    public int getIndexByFingerprint(int n2) {
        return this.findByFingerprint(n2);
    }

    public String getType(String string) {
        int n2 = this.getIndex(string);
        return this.getType(n2);
    }

    public String getValue(String string) {
        int n2 = this.getIndex(string);
        return this.getValue(n2);
    }

    private int findByName(String string, String string2) {
        if (this.namePool == null) {
            return -1;
        }
        int n2 = this.namePool.getFingerprint(string, string2);
        if (n2 == -1) {
            return -1;
        }
        return this.findByFingerprint(n2);
    }

    private int findByFingerprint(int n2) {
        if (this.codes == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (n2 != (this.codes[i2 * 4 + 0] & 0xFFFFF)) continue;
            return i2;
        }
        return -1;
    }

    public boolean isId(int n2) {
        return this.getType(n2).equals("ID") || (this.getNameCode(n2) & 0xFFFFF) == 388;
    }

    public boolean isIdref(int n2) {
        return false;
    }
}

