/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.CompressedWhitespace;

public final class FastStringBuffer
implements CharSequence,
Serializable {
    private char[] array;
    private int used = 0;

    public FastStringBuffer(int n2) {
        this.array = new char[n2];
    }

    public void append(String string) {
        int n2 = string.length();
        this.ensureCapacity(n2);
        string.getChars(0, n2, this.array, this.used);
        this.used += n2;
    }

    public void append(CharSlice charSlice) {
        int n2 = charSlice.length();
        this.ensureCapacity(n2);
        charSlice.copyTo(this.array, this.used);
        this.used += n2;
    }

    public void append(FastStringBuffer fastStringBuffer) {
        int n2 = fastStringBuffer.length();
        this.ensureCapacity(n2);
        fastStringBuffer.getChars(0, n2, this.array, this.used);
        this.used += n2;
    }

    public void append(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        this.ensureCapacity(n2);
        stringBuffer.getChars(0, n2, this.array, this.used);
        this.used += n2;
    }

    public void append(CharSequence charSequence) {
        int n2 = charSequence.length();
        this.ensureCapacity(n2);
        if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).copyTo(this.array, this.used);
        } else if (charSequence instanceof String) {
            ((String)charSequence).getChars(0, n2, this.array, this.used);
        } else if (charSequence instanceof FastStringBuffer) {
            ((FastStringBuffer)charSequence).getChars(0, n2, this.array, this.used);
        } else {
            if (charSequence instanceof CompressedWhitespace) {
                ((CompressedWhitespace)charSequence).uncompress(this);
                return;
            }
            ((Object)charSequence).toString().getChars(0, n2, this.array, this.used);
        }
        this.used += n2;
    }

    public void append(char[] cArray, int n2, int n3) {
        this.ensureCapacity(n3);
        System.arraycopy(cArray, n2, this.array, this.used, n3);
        this.used += n3;
    }

    public void append(char[] cArray) {
        int n2 = cArray.length;
        this.ensureCapacity(n2);
        System.arraycopy(cArray, 0, this.array, this.used, n2);
        this.used += n2;
    }

    public void append(char c2) {
        this.ensureCapacity(1);
        this.array[this.used++] = c2;
    }

    public void appendWideChar(int n2) {
        if (n2 > 65535) {
            this.append(XMLChar.highSurrogate(n2));
            this.append(XMLChar.lowSurrogate(n2));
        } else {
            this.append((char)n2);
        }
    }

    public void prependWideChar(int n2) {
        if (n2 > 65535) {
            this.insertCharAt(0, XMLChar.lowSurrogate(n2));
            this.insertCharAt(0, XMLChar.highSurrogate(n2));
        } else {
            this.insertCharAt(0, (char)n2);
        }
    }

    public int length() {
        return this.used;
    }

    public char charAt(int n2) {
        if (n2 >= this.used) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        return this.array[n2];
    }

    public CharSequence subSequence(int n2, int n3) {
        return new CharSlice(this.array, n2, n3 - n2);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.used) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        System.arraycopy(this.array, n2, cArray, n4, n3 - n2);
    }

    public int indexOf(char c2) {
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (this.array[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public String toString() {
        this.condense();
        return new String(this.array, 0, this.used);
    }

    public void setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 > this.used) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        this.array[n2] = c2;
    }

    public void insertCharAt(int n2, char c2) {
        if (n2 < 0 || n2 > this.used) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        this.ensureCapacity(1);
        for (int i2 = this.used; i2 > n2; --i2) {
            this.array[i2] = this.array[i2 - 1];
        }
        ++this.used;
        this.array[n2] = c2;
    }

    public void removeCharAt(int n2) {
        if (n2 < 0 || n2 > this.used) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        --this.used;
        for (int i2 = n2; i2 < this.used; ++i2) {
            this.array[i2] = this.array[i2 + 1];
        }
    }

    public void setLength(int n2) {
        if (n2 < 0 || n2 > this.used) {
            return;
        }
        this.used = n2;
    }

    public void ensureCapacity(int n2) {
        if (this.used + n2 > this.array.length) {
            int n3 = this.array.length * 2;
            if (n3 < this.used + n2) {
                n3 = this.used + n2 * 2;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.array, 0, cArray, 0, this.used);
            this.array = cArray;
        }
    }

    public CharSequence condense() {
        if (this.array.length - this.used > 256 || this.array.length > this.used * 2) {
            char[] cArray = new char[this.used];
            System.arraycopy(this.array, 0, cArray, 0, this.used);
            this.array = cArray;
        }
        return this;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.array, 0, this.used);
    }

    public static String diagnosticPrint(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 2);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 > ' ' && c2 < '\u007f') {
                fastStringBuffer.append(c2);
                continue;
            }
            fastStringBuffer.append("\\u");
            for (int i3 = 12; i3 >= 0; i3 -= 4) {
                fastStringBuffer.append("0123456789abcdef".charAt(c2 >> i3 & 0xF));
            }
        }
        return fastStringBuffer.toString();
    }
}

