/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    StaticQueryContext importingModule;
    XQueryFunctionLibrary baseLibrary;
    HashSet namespaces = new HashSet(5);

    public ImportedFunctionLibrary(StaticQueryContext staticQueryContext, XQueryFunctionLibrary xQueryFunctionLibrary) {
        this.importingModule = staticQueryContext;
        this.baseLibrary = xQueryFunctionLibrary;
    }

    public void addImportedNamespace(String string) {
        this.namespaces.add(string);
    }

    public Expression bind(int n2, String string, String string2, Expression[] expressionArray) throws XPathException {
        if (this.namespaces.contains(string)) {
            Expression expression = this.baseLibrary.bind(n2, string, string2, expressionArray);
            if (expression != null) {
                XQueryFunction xQueryFunction = this.baseLibrary.getDeclaration(n2, string, string2, expressionArray);
                this.importingModule.checkImportedType(xQueryFunction.getResultType(), xQueryFunction);
                for (int i2 = 0; i2 < xQueryFunction.getNumberOfArguments(); ++i2) {
                    SequenceType sequenceType = xQueryFunction.getArgumentTypes()[i2];
                    this.importingModule.checkImportedType(sequenceType, xQueryFunction);
                }
            }
            return expression;
        }
        return null;
    }

    public XQueryFunction getDeclaration(int n2, String string, String string2, Expression[] expressionArray) {
        if (this.namespaces.contains(string)) {
            return this.baseLibrary.getDeclaration(n2, string, string2, expressionArray);
        }
        return null;
    }

    public FunctionLibrary copy() {
        ImportedFunctionLibrary importedFunctionLibrary = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        Iterator iterator = this.namespaces.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            importedFunctionLibrary.addImportedNamespace(string);
        }
        return importedFunctionLibrary;
    }

    public void setImportingModule(StaticQueryContext staticQueryContext) {
        this.importingModule = staticQueryContext;
    }

    public boolean isAvailable(int n2, String string, String string2, int n3) {
        if (this.namespaces.contains(string)) {
            return this.baseLibrary.isAvailable(n2, string, string2, n3);
        }
        return false;
    }
}

