/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Err;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.trans.StaticError;

public class QueryReader {
    private QueryReader() {
    }

    public static String readSourceQuery(StreamSource streamSource, NameChecker nameChecker) throws StaticError {
        String string;
        if (streamSource.getInputStream() != null) {
            InputStream inputStream = streamSource.getInputStream();
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            String string2 = QueryReader.readEncoding(inputStream);
            string = QueryReader.readInputStream(inputStream, string2, nameChecker);
        } else if (streamSource.getReader() != null) {
            string = QueryReader.readQueryFromReader(streamSource.getReader(), nameChecker);
        } else {
            throw new StaticError("Module URI Resolver must supply either an InputSource or a Reader");
        }
        return string.toString();
    }

    public static String readEncoding(InputStream inputStream) throws StaticError {
        try {
            if (!inputStream.markSupported()) {
                throw new IllegalArgumentException("InputStream must have markSupported() = true");
            }
            inputStream.mark(100);
            byte[] byArray = new byte[100];
            int n2 = inputStream.read(byArray, 0, 100);
            if (n2 == -1) {
                StaticError staticError = new StaticError("Query source file is empty");
                throw staticError;
            }
            inputStream.reset();
            return QueryReader.inferEncoding(byArray, n2);
        }
        catch (IOException iOException) {
            StaticError staticError = new StaticError("Failed to read query source file", iOException);
            throw staticError;
        }
    }

    public static String readInputStream(InputStream inputStream, String string, NameChecker nameChecker) throws StaticError {
        if (string == null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            string = QueryReader.readEncoding(inputStream);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            return QueryReader.readQueryFromReader(bufferedReader, nameChecker);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StaticError staticError = new StaticError("Unknown encoding " + Err.wrap(string), unsupportedEncodingException);
            throw staticError;
        }
    }

    private static String readQueryFromReader(Reader reader, NameChecker nameChecker) throws StaticError {
        try {
            int n2;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            char[] cArray = new char[2048];
            boolean bl = true;
            int n3 = 1;
            int n4 = 1;
            while ((n2 = reader.read(cArray, 0, 2048)) >= 0) {
                int n5 = 0;
                while (n5 < n2) {
                    int n6;
                    if ((n6 = cArray[n5++]) == 10) {
                        ++n3;
                        n4 = 0;
                    }
                    ++n4;
                    if (XMLChar.isHighSurrogate(n6)) {
                        char c2 = cArray[n5++];
                        n6 = XMLChar.supplemental((char)n6, c2);
                    }
                    if (nameChecker.isValidChar(n6)) continue;
                    StaticError staticError = new StaticError("The query file contains a character illegal in XML " + nameChecker.getXMLVersion() + " (line=" + n3 + " column=" + n4 + " value=x" + Integer.toHexString(n6) + ')');
                    staticError.setErrorCode("XPST0003");
                    throw staticError;
                }
                if (bl) {
                    bl = false;
                    if (cArray[0] == '\ufeff') {
                        fastStringBuffer.append(cArray, 1, n2 - 1);
                        continue;
                    }
                    fastStringBuffer.append(cArray, 0, n2);
                    continue;
                }
                fastStringBuffer.append(cArray, 0, n2);
            }
            return ((Object)fastStringBuffer.condense()).toString();
        }
        catch (IOException iOException) {
            StaticError staticError = new StaticError("Failed to read input file", iOException);
            throw staticError;
        }
    }

    private static String inferEncoding(byte[] byArray, int n2) throws StaticError {
        if (n2 >= 2) {
            if (QueryReader.ch(byArray[0]) == 254 && QueryReader.ch(byArray[1]) == 255) {
                return "UTF-16";
            }
            if (QueryReader.ch(byArray[0]) == 255 && QueryReader.ch(byArray[1]) == 254) {
                return "UTF-16LE";
            }
        }
        if (n2 >= 3 && QueryReader.ch(byArray[0]) == 239 && QueryReader.ch(byArray[1]) == 187 && QueryReader.ch(byArray[2]) == 191) {
            return "UTF-8";
        }
        if (n2 >= 8 && byArray[0] == 0 && byArray[2] == 0 && byArray[4] == 0 && byArray[6] == 0) {
            return "UTF-16";
        }
        if (n2 >= 8 && byArray[1] == 0 && byArray[3] == 0 && byArray[5] == 0 && byArray[7] == 0) {
            return "UTF-16LE";
        }
        int n3 = 0;
        String string = QueryReader.readToken(byArray, n3, n2);
        if (string.trim().equals("xquery")) {
            n3 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n3, n2);
        if (string.trim().equals("version")) {
            n3 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n3, n2);
        if (string == null) {
            return "UTF-8";
        }
        if ((string = QueryReader.readToken(byArray, n3 += string.length(), n2)).trim().equals("encoding")) {
            n3 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n3, n2).trim();
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("'") && string.endsWith("'") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        throw new StaticError("Unrecognized encoding " + Err.wrap(string) + " in query prolog");
    }

    private static String readToken(byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = n2; n4 < n3 && " \n\r\t".indexOf(QueryReader.ch(byArray[n4])) >= 0; ++n4) {
        }
        if (QueryReader.ch(byArray[n4]) == 34) {
            ++n4;
            while (n4 < n3 && QueryReader.ch(byArray[n4]) != 34) {
                ++n4;
            }
        } else if (QueryReader.ch(byArray[n4]) == 39) {
            ++n4;
            while (n4 < n3 && QueryReader.ch(byArray[n4]) != 39) {
                ++n4;
            }
        } else {
            while (n4 < n3 && " \n\r\t".indexOf(QueryReader.ch(byArray[n4])) < 0) {
                ++n4;
            }
        }
        if (n4 >= n3) {
            return new String(byArray, n2, n3 - n2);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n4 - n2 + 1);
        for (int i2 = n2; i2 <= n4; ++i2) {
            fastStringBuffer.append((char)QueryReader.ch(byArray[i2]));
        }
        return fastStringBuffer.toString();
    }

    private static int ch(byte by) {
        return by & 0xFF;
    }

    static void checkSchemaNamespaceImported(StaticQueryContext staticQueryContext, int n2, Declaration declaration) throws StaticError {
        String string = staticQueryContext.getNamePool().getURI(n2);
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        if (NamespaceConstant.isXDTNamespace(string)) {
            return;
        }
        if (staticQueryContext.isImportedSchema(string)) {
            return;
        }
        String string2 = "Schema component " + staticQueryContext.getNamePool().getDisplayName(n2) + " used in ";
        string2 = declaration instanceof GlobalVariableDefinition ? string2 + "declaration of imported variable " + staticQueryContext.getNamePool().getDisplayName(((GlobalVariableDefinition)declaration).getNameCode()) : string2 + "signature of imported function " + staticQueryContext.getNamePool().getDisplayName(((XQueryFunction)declaration).getNameCode());
        string2 = string2 + " is not declared in any schema imported by ";
        String string3 = staticQueryContext.getModuleNamespace();
        string2 = string3 == null ? string2 + "the main query module" : string2 + "query module " + string3;
        StaticError staticError = new StaticError(string2);
        staticError.setErrorCode("XQST0036");
        staticError.setLocator(declaration);
        throw staticError;
    }
}

