/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int useWhenCode;
    private int xslUseWhenCode;
    private int defaultNamespaceCode;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack defaultNamespaceStack = new Stack();

    public UseWhenFilter(StartTagBuffer startTagBuffer) {
        this.startTag = startTagBuffer;
    }

    public void open() throws XPathException {
        this.useWhenCode = this.getNamePool().allocate("", "", "use-when") & 0xFFFFF;
        this.xslUseWhenCode = this.getNamePool().allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "use-when");
        this.defaultNamespaceCode = this.getNamePool().allocate("", "", "xpath-default-namespace");
        super.open();
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        this.defaultNamespaceStack.push(this.startTag.getAttribute(this.defaultNamespaceCode));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            block9: {
                short s2 = this.getNamePool().getURICode(n2);
                String string = s2 == 2 ? this.startTag.getAttribute(this.useWhenCode) : this.startTag.getAttribute(this.xslUseWhenCode);
                if (string != null) {
                    try {
                        boolean bl = this.evaluateUseWhen(string, this.getDocumentLocator().getLineNumber(n4));
                        if (bl) break block9;
                        int n6 = n2 & 0xFFFFF;
                        if (n6 == 180 || n6 == 183) {
                            this.emptyStylesheetElement = true;
                            break block9;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException xPathException) {
                        StaticError staticError = new StaticError("Error in use-when expression. " + xPathException.getMessage());
                        ExpressionLocation expressionLocation = new ExpressionLocation();
                        expressionLocation.setSystemId(this.getDocumentLocator().getSystemId(n4));
                        expressionLocation.setLineNumber(this.getDocumentLocator().getLineNumber(n4));
                        staticError.setLocator(expressionLocation);
                        staticError.setErrorCode(xPathException.getErrorCodeLocalPart());
                        try {
                            this.getPipelineConfiguration().getErrorListener().fatalError(staticError);
                        }
                        catch (TransformerException transformerException) {
                            throw StaticError.makeStaticError(transformerException);
                        }
                        staticError.setHasBeenReported();
                        throw staticError;
                    }
                }
            }
            super.startElement(n2, n3, n4, n5);
        } else {
            ++this.depthOfHole;
        }
    }

    public void namespace(int n2, int n3) throws XPathException {
        if (this.depthOfHole == 0) {
            super.namespace(n2, n3);
        }
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (this.depthOfHole == 0) {
            super.attribute(n2, n3, charSequence, n4, n5);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            super.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (this.depthOfHole == 0) {
            super.characters(charSequence, n2, n3);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) {
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
    }

    public boolean evaluateUseWhen(String string, int n2) throws XPathException {
        Object object;
        UseWhenStaticContext useWhenStaticContext = new UseWhenStaticContext(this.getConfiguration(), this.startTag);
        useWhenStaticContext.setBaseURI(this.getDocumentLocator().getSystemId(n2));
        for (int i2 = this.defaultNamespaceStack.size() - 1; i2 >= 0; --i2) {
            object = (String)this.defaultNamespaceStack.get(i2);
            if (object == null) continue;
            short s2 = this.getNamePool().getCodeForURI((String)object);
            useWhenStaticContext.setDefaultElementNamespace(s2);
            break;
        }
        Expression expression = ExpressionTool.make(string, useWhenStaticContext, 0, 0, this.getDocumentLocator().getLineNumber(n2));
        object = Type.ITEM_TYPE;
        expression = expression.typeCheck(useWhenStaticContext, (ItemType)object);
        SlotManager slotManager = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expression, slotManager.getNumberOfVariables(), slotManager);
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        XPathContextMajor xPathContextMajor = controller.newXPathContext();
        xPathContextMajor = xPathContextMajor.newCleanContext();
        xPathContextMajor.openStackFrame(slotManager);
        return expression.effectiveBooleanValue(xPathContextMajor);
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            throw new TransformerException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

