/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tinyTree, int n2) {
        this.tree = tinyTree;
        this.nodeNr = n2;
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getTypeAnnotation() {
        return this.tree.getTypeAnnotation(this.nodeNr);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        if (!this.tree.usesNamespaces) {
            return;
        }
        int n2 = this.tree.beta[this.nodeNr];
        if (n2 > 0) {
            while (n2 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n2] == this.nodeNr) {
                int n3 = this.tree.namespaceCode[n2];
                receiver.namespace(n3, 0);
                ++n2;
            }
        }
        if (bl && (nodeInfo = this.getParent()) != null) {
            nodeInfo.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, nArray);
    }

    static final int[] getDeclaredNamespaces(TinyTree tinyTree, int n2, int[] nArray) {
        int n3 = tinyTree.beta[n2];
        if (n3 > 0) {
            int n4 = 0;
            while (n3 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n3] == n2) {
                ++n4;
                ++n3;
            }
            if (n4 == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (n4 <= nArray.length) {
                System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n2], nArray, 0, n4);
                if (n4 < nArray.length) {
                    nArray[n4] = -1;
                }
                return nArray;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n2], nArray2, 0, n4);
            return nArray2;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    static final int[] getInScopeNamespaces(TinyTree tinyTree, int n2, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[10];
        }
        nArray[0] = 65537;
        int n3 = 1;
        if (tinyTree.usesNamespaces) {
            int n4;
            int n5;
            int n6;
            do {
                if ((n6 = tinyTree.beta[n2]) <= 0) continue;
                while (n6 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n6] == n2) {
                    n5 = tinyTree.namespaceCode[n6];
                    n4 = (short)(n5 >> 16);
                    boolean bl = false;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (nArray[i2] >> 16 != n4) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (n3 >= nArray.length) {
                            int[] nArray2 = new int[n3 * 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n3);
                            nArray = nArray2;
                        }
                        nArray[n3++] = n5;
                    }
                    ++n6;
                }
            } while ((n2 = TinyElementImpl.getParentNodeNr(tinyTree, n2)) != -1);
            n6 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                n4 = nArray[n5];
                if ((n4 & 0xFFFF) == 0) continue;
                nArray[n6++] = n4;
            }
            n3 = n6;
        }
        if (n3 < nArray.length) {
            nArray[n3] = -1;
        }
        return nArray;
    }

    public String getAttributeValue(int n2) {
        int n3 = this.tree.alpha[this.nodeNr];
        if (n3 < 0) {
            return null;
        }
        while (n3 < this.tree.numberOfAttributes && this.tree.attParent[n3] == this.nodeNr) {
            if ((this.tree.attCode[n3] & 0xFFFFF) == n2) {
                return ((Object)this.tree.attValue[n3]).toString();
            }
            ++n3;
        }
        return null;
    }

    public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
        short s2 = -1;
        boolean bl2 = false;
        short s3 = this.tree.depth[this.nodeNr];
        boolean bl3 = true;
        boolean bl4 = n2 == 0 && bl;
        Configuration configuration = null;
        int n4 = this.nodeNr;
        do {
            short s4 = this.tree.depth[n4];
            if (bl2) {
                s2 = (short)(s2 + 1);
            }
            while (s2 > s4) {
                receiver.endElement();
                s2 = (short)(s2 - 1);
            }
            s2 = s4;
            switch (this.tree.nodeKind[n4]) {
                case 1: {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = n7 = bl ? this.tree.getTypeAnnotation(n4) : 641;
                    if (bl4) {
                        if (configuration == null) {
                            configuration = this.getConfiguration();
                        }
                        this.checkNotNamespaceSensitive(configuration, n7);
                    }
                    receiver.startElement(this.tree.nameCode[n4], n7, n3, 0);
                    bl2 = true;
                    if (n2 != 0 && this.tree.usesNamespaces) {
                        if (bl3) {
                            this.sendNamespaceDeclarations(receiver, n2 == 2);
                        } else {
                            n6 = this.tree.beta[n4];
                            if (n6 > 0) {
                                while (n6 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n6] == n4) {
                                    n5 = this.tree.namespaceCode[n6];
                                    receiver.namespace(n5, 0);
                                    ++n6;
                                }
                            }
                        }
                    }
                    bl3 = false;
                    n6 = this.tree.alpha[n4];
                    if (n6 >= 0) {
                        while (n6 < this.tree.numberOfAttributes && this.tree.attParent[n6] == n4) {
                            int n9;
                            n5 = this.tree.attCode[n6];
                            int n10 = n9 = bl ? this.tree.getAttributeAnnotation(n6) : -1;
                            if (bl4) {
                                if (configuration == null) {
                                    configuration = this.getConfiguration();
                                }
                                this.checkNotNamespaceSensitive(configuration, n9);
                            }
                            receiver.attribute(n5, n9, this.tree.attValue[n6], n3, 0);
                            ++n6;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    bl2 = false;
                    CharSequence charSequence = TinyTextImpl.getStringValue(this.tree, n4);
                    receiver.characters(charSequence, n3, 1024);
                    break;
                }
                case 4: {
                    bl2 = false;
                    CharSequence charSequence = WhitespaceTextImpl.getStringValue(this.tree, n4);
                    receiver.characters(charSequence, n3, 1024);
                    break;
                }
                case 8: {
                    bl2 = false;
                    int n11 = this.tree.alpha[n4];
                    int n6 = this.tree.beta[n4];
                    if (n6 > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(n11, n11 + n6), n3, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    bl2 = false;
                    TinyNodeImpl tinyNodeImpl = this.tree.getNode(n4);
                    receiver.processingInstruction(tinyNodeImpl.getLocalPart(), tinyNodeImpl.getStringValue(), n3, 0);
                    break;
                }
                case 12: {
                    bl2 = false;
                }
            }
        } while (++n4 < this.tree.numberOfNodes && this.tree.depth[n4] > s3);
        if (bl2) {
            s2 = (short)(s2 + 1);
        }
        while (s2 > s3) {
            receiver.endElement();
            s2 = (short)(s2 - 1);
        }
    }

    private void checkNotNamespaceSensitive(Configuration configuration, int n2) throws DynamicError {
        SchemaType schemaType = configuration.getSchemaType(n2 & 0xFFFFF);
        if (schemaType instanceof SimpleType && ((SimpleType)schemaType).isNamespaceSensitive()) {
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    public String getURIForPrefix(String string, boolean bl) {
        NodeInfo nodeInfo;
        if (!bl && "".equals(string)) {
            return "";
        }
        short s2 = this.getNamePool().getCodeForPrefix(string);
        if (s2 == -1) {
            return null;
        }
        int n2 = this.tree.beta[this.nodeNr];
        if (n2 > 0) {
            while (n2 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n2] == this.nodeNr) {
                int n3 = this.tree.namespaceCode[n2];
                if (n3 >> 16 == s2) {
                    int n4 = n3 & 0xFFFF;
                    if (n4 == 0) {
                        if (s2 == 0) {
                            return "";
                        }
                        return null;
                    }
                    return this.getNamePool().getURIFromURICode((short)n4);
                }
                ++n2;
            }
        }
        if ((nodeInfo = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)nodeInfo)).getURIForPrefix(string, bl);
        }
        return null;
    }

    public boolean isId() {
        return this.getDocumentRoot().selectID(this.getStringValue()).isSameNodeInfo(this);
    }

    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

