/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;

public class ElementWithAttributes
extends ElementImpl {
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    public void initialise(int n2, AttributeCollectionImpl attributeCollectionImpl, NodeInfo nodeInfo, String string, int n3, int n4) {
        this.nameCode = n2;
        this.attributeList = attributeCollectionImpl;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n4;
        this.root = (DocumentImpl)nodeInfo.getDocumentRoot();
        this.root.setLineNumber(n4, n3);
        this.root.setSystemId(n4, string);
    }

    public void setNamespaceDeclarations(int[] nArray, int n2) {
        this.namespaceList = new int[n2];
        System.arraycopy(nArray, 0, this.namespaceList, 0, n2);
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("") && !bl) {
            return "";
        }
        NamePool namePool = this.getNamePool();
        short s2 = namePool.getCodeForPrefix(string);
        if (s2 == -1) {
            return null;
        }
        try {
            short s3 = this.getURICodeForPrefixCode(s2);
            return namePool.getURIFromURICode(s3);
        }
        catch (NamespaceException namespaceException) {
            return null;
        }
    }

    public Iterator iteratePrefixes() {
        HashSet<String> hashSet = new HashSet<String>(10);
        HashSet hashSet2 = new HashSet(10);
        hashSet.add("");
        hashSet.add("xml");
        this.gatherNamespacePrefixes(this.getNamePool(), hashSet, hashSet2);
        return hashSet.iterator();
    }

    public short getURICodeForPrefix(String string) throws NamespaceException {
        if (string.equals("xml")) {
            return 1;
        }
        NamePool namePool = this.getNamePool();
        short s2 = namePool.getCodeForPrefix(string);
        if (s2 == -1) {
            throw new NamespaceException(string);
        }
        return this.getURICodeForPrefixCode(s2);
    }

    private short getURICodeForPrefixCode(int n2) throws NamespaceException {
        if (this.namespaceList != null) {
            for (int i2 = 0; i2 < this.namespaceList.length; ++i2) {
                if (this.namespaceList[i2] >> 16 != n2) continue;
                return (short)(this.namespaceList[i2] & 0xFFFF);
            }
        }
        NodeInfo nodeInfo = this.parent;
        while (true) {
            if (nodeInfo.getNodeKind() == 9) {
                if (n2 == 0) {
                    return 0;
                }
                throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(n2 << 16));
            }
            if (nodeInfo instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeInfo).getURICodeForPrefixCode(n2);
            }
            nodeInfo = nodeInfo.getParent();
        }
    }

    public String getPrefixForURI(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool namePool = this.getNamePool();
        short s2 = namePool.getCodeForURI(string);
        if (s2 < 0) {
            return null;
        }
        return this.getPrefixForURICode(s2);
    }

    private String getPrefixForURICode(int n2) {
        if (this.namespaceList != null) {
            for (int i2 = 0; i2 < this.namespaceList.length; ++i2) {
                if ((this.namespaceList[i2] & 0xFFFF) != n2) continue;
                return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[i2]);
            }
        }
        NodeInfo nodeInfo = this.parent;
        while (!(nodeInfo instanceof DocumentInfo)) {
            if (nodeInfo instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeInfo).getPrefixForURICode(n2);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return null;
    }

    private void gatherNamespacePrefixes(NamePool namePool, Set set, Set set2) {
        if (this.namespaceList != null) {
            for (int i2 = 0; i2 < this.namespaceList.length; ++i2) {
                int n2 = this.namespaceList[i2];
                String string = namePool.getPrefixFromNamespaceCode(n2);
                if ((n2 & 0xFFFF) == 0) {
                    set2.add(string);
                    continue;
                }
                if (set2.contains(string)) continue;
                set.add(string);
                set2.add(string);
            }
        }
        NodeInfo nodeInfo = this.getParent();
        while (nodeInfo != null) {
            if (!(nodeInfo instanceof ElementWithAttributes)) continue;
            ((ElementWithAttributes)nodeInfo).gatherNamespacePrefixes(namePool, set, set2);
        }
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        if (this.namespaceList != null) {
            for (int i2 = 0; i2 < this.namespaceList.length; ++i2) {
                receiver.namespace(this.namespaceList[i2], 0);
            }
        }
        if (bl && this.parent.getNodeKind() != 9) {
            this.parent.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return this.namespaceList;
    }

    public int[] getInScopeNamespaceCodes() {
        return new NamespaceIterator(this, null).getInScopeNamespaceCodes();
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    public String getAttributeValue(int n2) {
        return this.attributeList.getValueByFingerprint(n2);
    }

    public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
        int n4;
        int n5;
        int n6 = n5 = bl ? this.getTypeAnnotation() : -1;
        if (n3 == 0 && receiver instanceof LocationCopier) {
            receiver.setSystemId(this.getBaseURI());
            ((LocationCopier)receiver).setLineNumber(this.getLineNumber());
        }
        receiver.startElement(this.getNameCode(), n5, n3, 0);
        if (n2 != 0) {
            this.sendNamespaceDeclarations(receiver, n2 == 2);
        }
        for (n4 = 0; n4 < this.attributeList.getLength(); ++n4) {
            receiver.attribute(this.attributeList.getNameCode(n4), 642, this.attributeList.getValue(n4), 0, 0);
        }
        receiver.startContent();
        n4 = n2 == 0 ? 0 : 1;
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            nodeImpl.copy(receiver, n4, bl, n3);
        }
        receiver.endElement();
    }
}

