/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.ChildEnumeration;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.TextImpl;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return (long)this.sequence << 32;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    public final AxisIterator enumerateChildren(NodeTest nodeTest) {
        if (this.children == null) {
            return EmptyIterator.getInstance();
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)this.children;
            if (nodeTest == null || nodeTest.matches(nodeImpl)) {
                return SingletonIterator.makeIterator(nodeImpl);
            }
            return EmptyIterator.getInstance();
        }
        if (nodeTest == null || nodeTest instanceof AnyNodeTest) {
            return new ArrayIterator((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, nodeTest);
    }

    public final NodeInfo getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final NodeInfo getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        return nodeImplArray[nodeImplArray.length - 1];
    }

    protected final NodeImpl getNthChild(int n2) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n2 == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
        if (n2 < 0 || n2 >= nodeImplArray.length) {
            return null;
        }
        return nodeImplArray[n2];
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = null;
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = nodeImpl.getNextInDocument(this)) {
            if (!(nodeImpl instanceof TextImpl)) continue;
            if (fastStringBuffer == null) {
                fastStringBuffer = new FastStringBuffer(1024);
            }
            fastStringBuffer.append(nodeImpl.getStringValueCS());
        }
        if (fastStringBuffer == null) {
            return "";
        }
        return fastStringBuffer.condense();
    }

    public void useChildrenArray(NodeImpl[] nodeImplArray) {
        this.children = nodeImplArray;
    }

    public void addChild(NodeImpl nodeImpl, int n2) {
        NodeImpl[] nodeImplArray;
        if (this.children == null) {
            nodeImplArray = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            nodeImplArray = new NodeImpl[10];
            nodeImplArray[0] = (NodeImpl)this.children;
        } else {
            nodeImplArray = (NodeImpl[])this.children;
        }
        if (n2 >= nodeImplArray.length) {
            NodeImpl[] nodeImplArray2 = new NodeImpl[nodeImplArray.length * 2];
            System.arraycopy(nodeImplArray, 0, nodeImplArray2, 0, nodeImplArray.length);
            nodeImplArray = nodeImplArray2;
        }
        nodeImplArray[n2] = nodeImpl;
        nodeImpl.parent = this;
        nodeImpl.index = n2;
        this.children = nodeImplArray;
    }

    public void compact(int n2) {
        if (n2 == 0) {
            this.children = null;
        } else if (n2 == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] nodeImplArray = new NodeImpl[n2];
            System.arraycopy(this.children, 0, nodeImplArray, 0, n2);
            this.children = nodeImplArray;
        }
    }
}

