/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class IntegerValue
extends NumericValue {
    public static final IntegerValue MINUS_ONE = new IntegerValue(-1L);
    public static final IntegerValue ZERO = new IntegerValue(0L);
    public static final IntegerValue PLUS_ONE = new IntegerValue(1L);
    public static final IntegerValue MAX_LONG = new IntegerValue(Long.MAX_VALUE);
    public static final IntegerValue MIN_LONG = new IntegerValue(Long.MIN_VALUE);
    private long value;
    private ItemType type;
    private static long NO_LIMIT = -9999L;
    private static long MAX_UNSIGNED_LONG = -9998L;
    private static long[] ranges = new long[]{532L, NO_LIMIT, NO_LIMIT, 533L, NO_LIMIT, 0L, 534L, NO_LIMIT, -1L, 535L, Long.MIN_VALUE, Long.MAX_VALUE, 536L, Integer.MIN_VALUE, Integer.MAX_VALUE, 537L, -32768L, 32767L, 538L, -128L, 127L, 539L, 0L, NO_LIMIT, 540L, 1L, NO_LIMIT, 541L, 0L, MAX_UNSIGNED_LONG, 542L, 0L, 0xFFFFFFFFL, 543L, 0L, 65535L, 544L, 0L, 255L};
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public IntegerValue(long l2) {
        this.value = l2;
        this.type = Type.INTEGER_TYPE;
    }

    public IntegerValue(long l2, AtomicType atomicType) throws DynamicError {
        this.value = l2;
        this.type = atomicType;
        if (!IntegerValue.checkRange(this.value, atomicType)) {
            DynamicError dynamicError = new DynamicError("Integer value " + l2 + " is out of range for the requested type " + atomicType.getDescription());
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
    }

    public ValidationException convertToSubtype(AtomicType atomicType, boolean bl) {
        if (!bl) {
            this.setSubType(atomicType);
            return null;
        }
        if (this.checkRange(atomicType)) {
            return null;
        }
        ValidationException validationException = new ValidationException("String " + this.value + " cannot be converted to integer subtype " + atomicType.getDescription());
        validationException.setErrorCode("FORG0001");
        return validationException;
    }

    public void setSubType(AtomicType atomicType) {
        this.type = atomicType;
    }

    public boolean checkRange(AtomicType atomicType) {
        this.type = atomicType;
        return IntegerValue.checkRange(this.value, atomicType);
    }

    public static AtomicValue stringToInteger(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && charSequence.charAt(n3) <= ' '; ++n3) {
        }
        for (n2 = n4 - 1; n2 > n3 && charSequence.charAt(n2) <= ' '; --n2) {
        }
        if (n3 > n2) {
            return IntegerValue.numericError("Cannot convert zero-length string to an integer");
        }
        if (n2 - n3 < 16) {
            boolean bl = false;
            long l2 = 0L;
            int n5 = n3;
            if (charSequence.charAt(n5) == '+') {
                ++n5;
            } else if (charSequence.charAt(n5) == '-') {
                bl = true;
                ++n5;
            }
            if (n5 > n2) {
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to integer: no digits after the sign");
            }
            while (n5 <= n2) {
                char c2;
                if ((c2 = charSequence.charAt(n5++)) >= '0' && c2 <= '9') {
                    l2 = 10L * l2 + (long)(c2 - 48);
                    continue;
                }
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
            }
            return new IntegerValue(bl ? -l2 : l2);
        }
        try {
            CharSequence charSequence2 = IntegerValue.trimWhitespace(charSequence);
            if (charSequence2.charAt(0) == '+') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length());
            }
            if (charSequence2.length() < 16) {
                return new IntegerValue(Long.parseLong(((Object)charSequence2).toString()));
            }
            return new BigIntegerValue(new BigInteger(((Object)charSequence2).toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
        }
    }

    private static ValidationErrorValue numericError(String string) {
        ValidationException validationException = new ValidationException(string);
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    static boolean checkRange(long l2, AtomicType atomicType) {
        for (int i2 = 0; i2 < ranges.length; i2 += 3) {
            if (ranges[i2] != (long)atomicType.getFingerprint()) continue;
            long l3 = ranges[i2 + 1];
            if (l3 != NO_LIMIT && l2 < l3) {
                return false;
            }
            long l4 = ranges[i2 + 2];
            return l4 == NO_LIMIT || l4 == MAX_UNSIGNED_LONG || l2 <= l4;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + atomicType.getDescription());
    }

    static boolean checkBigRange(BigInteger bigInteger, AtomicType atomicType) {
        for (int i2 = 0; i2 < ranges.length; i2 += 3) {
            if (ranges[i2] != (long)atomicType.getFingerprint()) continue;
            long l2 = ranges[i2 + 1];
            if (l2 != NO_LIMIT && BigInteger.valueOf(l2).compareTo(bigInteger) > 0) {
                return false;
            }
            long l3 = ranges[i2 + 2];
            if (l3 == NO_LIMIT) {
                return true;
            }
            if (l3 == MAX_UNSIGNED_LONG) {
                return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(bigInteger) >= 0;
            }
            return BigInteger.valueOf(l3).compareTo(bigInteger) >= 0;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + atomicType.getDescription());
    }

    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value != 0L;
    }

    public int compareTo(Object object) {
        if (object instanceof IntegerValue) {
            long l2 = ((IntegerValue)object).value;
            if (this.value == l2) {
                return 0;
            }
            if (this.value < l2) {
                return -1;
            }
            return 1;
        }
        if (object instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).compareTo(object);
        }
        return super.compareTo(object);
    }

    public boolean schemaEquals(Value value) {
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).getPrimitiveValue();
        }
        if (value instanceof DecimalValue) {
            return value.schemaEquals(this);
        }
        if (value instanceof IntegerValue) {
            return this.value == ((IntegerValue)value).value;
        }
        if (value instanceof BigIntegerValue) {
            return this.equals(value);
        }
        return false;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value != 0L);
            }
            case 88: 
            case 532: 
            case 643: 
            case 646: {
                return this;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                IntegerValue integerValue = new IntegerValue(this.value);
                ValidationException validationException = integerValue.convertToSubtype(builtInAtomicType, bl);
                if (validationException != null) {
                    return new ValidationErrorValue(validationException);
                }
                return integerValue;
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 516: {
                return new FloatValue(this.value);
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert integer to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.value + "";
    }

    public NumericValue negate() {
        return new IntegerValue(-this.value);
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundHalfToEven(int n2) {
        long l2;
        long l3 = Math.abs(this.value);
        if (n2 >= 0) {
            return this;
        }
        if (n2 < -15) {
            return new BigIntegerValue(this.value).roundHalfToEven(n2);
        }
        long l4 = 1L;
        for (l2 = 1L; l2 <= (long)(-n2); ++l2) {
            l4 *= 10L;
        }
        l2 = l3 % l4;
        long l5 = l3 - l2;
        long l6 = l2 * 2L;
        if (l6 > l4) {
            l5 += l4;
        } else if (l6 >= l4 && l5 % (2L * l4) != 0L) {
            l5 += l4;
        }
        if (this.value < 0L) {
            l5 = -l5;
        }
        return new IntegerValue(l5);
    }

    public double signum() {
        if (this.value > 0L) {
            return 1.0;
        }
        if (this.value == 0L) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n2, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof IntegerValue) {
            if (this.value >= Integer.MAX_VALUE || this.value <= Integer.MIN_VALUE || ((IntegerValue)numericValue).value >= Integer.MAX_VALUE || ((IntegerValue)numericValue).value <= Integer.MIN_VALUE) {
                return new BigIntegerValue(this.value).arithmetic(n2, numericValue, xPathContext);
            }
            switch (n2) {
                case 15: {
                    return new IntegerValue(this.value + ((IntegerValue)numericValue).value);
                }
                case 16: {
                    return new IntegerValue(this.value - ((IntegerValue)numericValue).value);
                }
                case 17: {
                    return new IntegerValue(this.value * ((IntegerValue)numericValue).value);
                }
                case 50: {
                    try {
                        return new IntegerValue(this.value / ((IntegerValue)numericValue).value);
                    }
                    catch (ArithmeticException arithmeticException) {
                        DynamicError dynamicError;
                        if ("/ by zero".equals(arithmeticException.getMessage())) {
                            dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                        } else {
                            dynamicError = new DynamicError("Integer division failure", arithmeticException);
                        }
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                case 18: {
                    long l2 = ((IntegerValue)numericValue).value;
                    if (l2 == 0L) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setErrorCode("FOAR0001");
                        throw dynamicError;
                    }
                    if (this.value % l2 == 0L) {
                        return new IntegerValue(this.value / l2);
                    }
                    return new DecimalValue(this.value).arithmetic(18, new DecimalValue(l2), xPathContext);
                }
                case 19: {
                    return new IntegerValue(this.value % ((IntegerValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).arithmetic(n2, numericValue, xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType(null).getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n2, numericValue, xPathContext);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.type;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = IntegerValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Long(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = IntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntegerValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = IntegerValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = IntegerValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = IntegerValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = IntegerValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IntegerValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IntegerValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = IntegerValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = IntegerValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = IntegerValue.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf(this.value);
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = IntegerValue.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return BigDecimal.valueOf(this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of integer to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

