/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.StaticProperty;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public final class SequenceType
implements Serializable {
    private ItemType primaryType;
    private int cardinality;
    private static Map pool = Collections.synchronizedMap(new HashMap(50));
    public static final SequenceType ANY_SEQUENCE = SequenceType.makeSequenceType(AnyItemType.getInstance(), 57344);
    public static final SequenceType SINGLE_ITEM = SequenceType.makeSequenceType(AnyItemType.getInstance(), 16384);
    public static final SequenceType SINGLE_ATOMIC = SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, 16384);
    public static final SequenceType OPTIONAL_ATOMIC = SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, 24576);
    public static final SequenceType ATOMIC_SEQUENCE = SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, 57344);
    public static final SequenceType SINGLE_STRING = SequenceType.makeSequenceType(Type.STRING_TYPE, 16384);
    public static final SequenceType SINGLE_INTEGER = SequenceType.makeSequenceType(Type.INTEGER_TYPE, 16384);
    public static final SequenceType OPTIONAL_INTEGER = SequenceType.makeSequenceType(Type.INTEGER_TYPE, 24576);
    public static final SequenceType OPTIONAL_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 24576);
    public static final SequenceType SINGLE_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 16384);
    public static final SequenceType NODE_SEQUENCE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 57344);
    public static final SequenceType NUMERIC_SEQUENCE = SequenceType.makeSequenceType(Type.NUMBER_TYPE, 57344);
    public static final SequenceType EMPTY_SEQUENCE = SequenceType.makeSequenceType(NoNodeTest.getInstance(), 8192);

    private SequenceType(ItemType itemType, int n2) {
        this.primaryType = itemType;
        this.cardinality = itemType instanceof NoNodeTest ? 8192 : n2;
    }

    public static SequenceType makeSequenceType(ItemType itemType, int n2) {
        int n3;
        if (!(itemType instanceof BuiltInAtomicType)) {
            return new SequenceType(itemType, n2);
        }
        SequenceType[] sequenceTypeArray = (SequenceType[])pool.get(itemType);
        if (sequenceTypeArray == null) {
            sequenceTypeArray = new SequenceType[8];
            pool.put(itemType, sequenceTypeArray);
        }
        if (sequenceTypeArray[n3 = StaticProperty.getCardinalityCode(n2)] == null) {
            SequenceType sequenceType;
            sequenceTypeArray[n3] = sequenceType = new SequenceType(itemType, n2);
            return sequenceType;
        }
        return sequenceTypeArray[n3];
    }

    public ItemType getPrimaryType() {
        return this.primaryType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        String string = this.primaryType.toString();
        if (this.cardinality == 49152) {
            string = string + '+';
        } else if (this.cardinality == 57344) {
            string = string + '*';
        } else if (this.cardinality == 24576) {
            string = string + '?';
        }
        return string;
    }

    public int hashCode() {
        return this.primaryType.hashCode() ^ this.cardinality;
    }

    public boolean equals(Object object) {
        if (object instanceof SequenceType) {
            return this.primaryType.equals(((SequenceType)object).primaryType) && this.cardinality == ((SequenceType)object).cardinality;
        }
        return false;
    }
}

