/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;

public class CountingMessageHandlerTest
extends TestCase {
    private static final String ME = "org.aspectj.bridge.CountingMessageHandlerTest";

    public static void main(String[] args) {
        TestRunner.main((String[])new String[]{ME});
    }

    public CountingMessageHandlerTest(String name) {
        super(name);
    }

    public void testSimpleWrapping() {
        MessageHandler m2 = new MessageHandler();
        CountingMessageHandler me = new CountingMessageHandler(m2);
        this.checkCountingMessageHandler(me);
    }

    public void testCounterWrapping() {
        MessageHandler m2 = new MessageHandler();
        CountingMessageHandler first = new CountingMessageHandler(m2);
        CountingMessageHandler me = new CountingMessageHandler(first);
        this.checkCountingMessageHandler(me);
    }

    void checkCountingMessageHandler(CountingMessageHandler me) {
        MessageUtil.warn(me, "warn 1");
        Assert.assertTrue((!me.hasErrors() ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)me.numMessages(IMessage.ERROR, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.WARNING, false));
        Assert.assertEquals((int)0, (int)me.numMessages(IMessage.INFO, false));
        Assert.assertEquals((int)0, (int)me.numMessages(IMessage.ERROR, true));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.WARNING, true));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.INFO, true));
        MessageUtil.info(me, "info 1");
        Assert.assertTrue((!me.hasErrors() ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)me.numMessages(IMessage.ERROR, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.WARNING, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.INFO, false));
        Assert.assertEquals((int)0, (int)me.numMessages(IMessage.ERROR, true));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.WARNING, true));
        Assert.assertEquals((int)2, (int)me.numMessages(IMessage.INFO, true));
        MessageUtil.error(me, "error 1");
        Assert.assertTrue((boolean)me.hasErrors());
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.ERROR, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.WARNING, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.INFO, false));
        Assert.assertEquals((int)1, (int)me.numMessages(IMessage.ERROR, true));
        Assert.assertEquals((int)2, (int)me.numMessages(IMessage.WARNING, true));
        Assert.assertEquals((int)3, (int)me.numMessages(IMessage.INFO, true));
    }
}

