/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.KindTest;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.SourceLocation;

public class MessageTest
extends TestCase {
    private static final String ME = "org.aspectj.bridge.MessageTest";
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public static void main(String[] args) {
        TestRunner.main((String[])new String[]{ME});
    }

    public MessageTest(String name) {
        super(name);
    }

    void checkListOrder(List list, Comparator c2) {
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)c2);
        ListIterator it = list.listIterator();
        Object last = null;
        Object current = null;
        while (it.hasNext()) {
            int i2;
            current = it.next();
            if (null != last && (i2 = c2.compare(last, current)) > 0) {
                Assert.assertTrue((String)(last + " > " + current + " (" + i2 + ")"), (boolean)false);
            }
            last = current;
        }
    }

    public void testKindOrder() {
        this.checkListOrder(Arrays.asList("a", "b", "C"), String.CASE_INSENSITIVE_ORDER);
        this.checkListOrder(IMessage.KINDS, IMessage.Kind.COMPARATOR);
    }

    public void testKind_isSameOrLessThan() {
        IMessage.Kind next = null;
        Iterator iter = IMessage.KINDS.iterator();
        while (iter.hasNext()) {
            IMessage.Kind last = next;
            next = (IMessage.Kind)iter.next();
            if (null == last) continue;
            String label = "last: " + last + " next: " + next;
            Assert.assertTrue((String)label, (!next.isSameOrLessThan(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)label, (!next.isSameOrLessThan(last) ? 1 : 0) != 0);
            Assert.assertTrue((String)label, (boolean)last.isSameOrLessThan(next));
            Assert.assertTrue((String)label, (boolean)next.isSameOrLessThan(next));
        }
    }

    public void testMessageHandler() {
        boolean handleMessageResult = true;
        this.checkEmptyMessageHolder(new MessageHandler(handleMessageResult), handleMessageResult);
        handleMessageResult = false;
        this.checkEmptyMessageHolder(new MessageHandler(handleMessageResult), handleMessageResult);
    }

    public void checkEmptyMessageHolder(IMessageHolder h2, boolean handleMessageResult) {
        Assert.assertNotNull((Object)h2);
        Assert.assertTrue((!h2.hasAnyMessage(null, true) ? 1 : 0) != 0);
        Assert.assertTrue((!h2.hasAnyMessage(null, false) ? 1 : 0) != 0);
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.INFO, true) ? 1 : 0) != 0);
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.INFO, false) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("error 1", IMessage.ERROR)) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("error 2", IMessage.ERROR)) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("fail 1", IMessage.FAIL)) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("fail 2", IMessage.FAIL)) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("debug 1", IMessage.DEBUG)) ? 1 : 0) != 0);
        Assert.assertTrue((handleMessageResult == h2.handleMessage(this.make("debug 2", IMessage.DEBUG)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)h2.hasAnyMessage(null, true));
        Assert.assertTrue((boolean)h2.hasAnyMessage(null, false));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.ERROR, true));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.ERROR, false));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.FAIL, true));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.FAIL, false));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.DEBUG, true));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.DEBUG, false));
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.INFO, false) ? 1 : 0) != 0);
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.WARNING, false) ? 1 : 0) != 0);
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.ABORT, false) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.INFO, true));
        Assert.assertTrue((boolean)h2.hasAnyMessage(IMessage.WARNING, true));
        Assert.assertTrue((!h2.hasAnyMessage(IMessage.ABORT, true) ? 1 : 0) != 0);
        Assert.assertTrue((0 == h2.numMessages(IMessage.INFO, false) ? 1 : 0) != 0);
        Assert.assertTrue((0 == h2.numMessages(IMessage.WARNING, false) ? 1 : 0) != 0);
        Assert.assertTrue((0 == h2.numMessages(IMessage.ABORT, false) ? 1 : 0) != 0);
        Assert.assertTrue((6 == h2.numMessages(null, true) ? 1 : 0) != 0);
        Assert.assertTrue((6 == h2.numMessages(null, false) ? 1 : 0) != 0);
        Assert.assertTrue((6 == h2.numMessages(IMessage.INFO, true) ? 1 : 0) != 0);
        Assert.assertTrue((6 == h2.numMessages(IMessage.DEBUG, true) ? 1 : 0) != 0);
        Assert.assertTrue((4 == h2.numMessages(IMessage.WARNING, true) ? 1 : 0) != 0);
        Assert.assertTrue((4 == h2.numMessages(IMessage.ERROR, true) ? 1 : 0) != 0);
        Assert.assertTrue((2 == h2.numMessages(IMessage.FAIL, true) ? 1 : 0) != 0);
        Assert.assertTrue((0 == h2.numMessages(IMessage.ABORT, true) ? 1 : 0) != 0);
    }

    public void testMessage() {
        String input = "input";
        AbortException thrown = null;
        SourceLocation sl = null;
        Class exClass = null;
        String descriptor = "Message";
        IMessage.Kind kind = IMessage.INFO;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.WARNING;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.ERROR;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.DEBUG;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.FAIL;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.FAIL;
        thrown = new AbortException();
        input = null;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = IMessage.WARNING;
        thrown = null;
        input = "type not found";
        File f2 = new File("some/file.java");
        sl = new SourceLocation(f2, 0, 0, 0);
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        sl = new SourceLocation(f2, 1, 1, 0);
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        kind = null;
        exClass = class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = MessageTest.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
        input = null;
        kind = IMessage.INFO;
        this.roundTrip(input, kind, thrown, sl, descriptor, exClass);
    }

    protected IMessage make(String message, IMessage.Kind kind) {
        return new Message(message, kind, null, null);
    }

    protected IMessage make(String input, IMessage.Kind kind, Throwable thrown, ISourceLocation sourceLocation, String descriptor) {
        return new Message(input, kind, thrown, sourceLocation);
    }

    protected void roundTrip(String input, IMessage.Kind kind, Throwable thrown, ISourceLocation sourceLocation, String descriptor, Class exClass) {
        try {
            IMessage m2 = this.make(input, kind, thrown, sourceLocation, descriptor);
            if (null == input && null != thrown) {
                input = thrown.getMessage();
            }
            this.roundTripCheck(m2, input, kind, thrown, sourceLocation);
        }
        catch (AssertionFailedError x2) {
            throw x2;
        }
        catch (Throwable t2) {
            Assert.assertTrue((null != exClass ? 1 : 0) != 0);
            Assert.assertTrue((boolean)exClass.isAssignableFrom(t2.getClass()));
        }
    }

    protected void roundTripCheck(IMessage message, String input, IMessage.Kind kind, Throwable thrown, ISourceLocation sourceLocation) {
        IMessage m2 = message;
        Assert.assertTrue((String)"not null", (null != m2 ? 1 : 0) != 0);
        Assert.assertEquals((String)input, (String)m2.getMessage());
        Assert.assertTrue((String)("" + kind), (kind == m2.getKind() ? 1 : 0) != 0);
        Assert.assertTrue((String)("" + thrown), (boolean)MessageTest.equals(thrown, m2.getThrown()));
        Assert.assertTrue((String)("" + sourceLocation), (boolean)MessageTest.equals(sourceLocation, m2.getSourceLocation()));
        String err = new KindTest().testKindSet(message, kind);
        if (null != err) {
            Assert.assertTrue((String)err, (boolean)false);
        }
    }

    protected static boolean equals(Object one, Object two) {
        if (null == one) {
            return null == two;
        }
        if (null == two) {
            return false;
        }
        return one.equals(two);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

