/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class FileUtilTest
extends TestCase {
    public static final String[] NONE = new String[0];
    public static boolean log = false;
    final ArrayList tempFiles = new ArrayList();
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public static void main(String[] args) {
        TestRunner.main((String[])new String[]{"org.aspectj.util.FileUtilTest"});
    }

    public static void assertSame(String prefix, String[] lhs, String[] rhs) {
        String destPaths;
        String srcPaths = LangUtil.arrayAsList(lhs).toString();
        if (!srcPaths.equals(destPaths = LangUtil.arrayAsList(rhs).toString())) {
            FileUtilTest.log("expected: " + srcPaths);
            FileUtilTest.log("  actual: " + destPaths);
            Assert.assertTrue((String)(prefix + " expected=" + srcPaths + " != actual=" + destPaths), (boolean)false);
        }
    }

    public static String[] dirContains(File dir, String[] filenames) {
        final ArrayList sought = new ArrayList(LangUtil.arrayAsList(filenames));
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File d2, String name) {
                return !sought.remove(name);
            }
        };
        String[] found = dir.list(filter);
        if (0 < sought.size()) {
            Assert.assertTrue((String)("found " + LangUtil.arrayAsList(dir.list()).toString() + " expected " + sought), (boolean)false);
        }
        return found.length == 0 ? NONE : found;
    }

    public static String[] dirPaths(File dir) {
        return FileUtilTest.dirPaths(dir, new String[0]);
    }

    public static String[] dirPaths(File dir, String[] suffixes) {
        int i2;
        ArrayList result = new ArrayList();
        FileUtilTest.doDirPaths(dir, result);
        if (!LangUtil.isEmpty(suffixes)) {
            ListIterator iter = ((AbstractList)result).listIterator();
            while (iter.hasNext()) {
                String path = iter.next().toString();
                boolean hasSuffix = false;
                for (i2 = 0; !hasSuffix && i2 < suffixes.length; ++i2) {
                    hasSuffix = path.endsWith(suffixes[i2]);
                }
                if (hasSuffix) continue;
                iter.remove();
            }
        }
        Collections.sort(result);
        String prefix = dir.getPath();
        int len = prefix.length() + 1;
        String[] ra = result.toArray(new String[0]);
        for (i2 = 0; i2 < ra.length; ++i2) {
            Assert.assertTrue((String)ra[i2], (ra[i2].length() > len ? 1 : 0) != 0);
            ra[i2] = ra[i2].substring(len);
        }
        return ra;
    }

    private static void doDirPaths(File dir, ArrayList paths) {
        if (null == dir || !dir.canRead() || -1 != dir.getPath().indexOf("CVS")) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            String path = files[i2].getPath();
            if (files[i2].getName().startsWith(".")) continue;
            if (files[i2].isFile()) {
                paths.add(path);
                continue;
            }
            if (files[i2].isDirectory()) {
                FileUtilTest.doDirPaths(files[i2], paths);
                continue;
            }
            FileUtilTest.log("not file or dir: " + dir + "/" + path);
        }
    }

    private static void log(String s2) {
        if (log) {
            System.err.println(s2);
        }
    }

    public FileUtilTest(String s2) {
        super(s2);
    }

    public void tearDown() {
        ListIterator iter = ((AbstractList)this.tempFiles).listIterator();
        while (iter.hasNext()) {
            File dir = (File)iter.next();
            FileUtilTest.log("removing " + dir);
            FileUtil.deleteContents(dir);
            dir.delete();
            iter.remove();
        }
    }

    public void testNotIsFileIsDirectory() {
        File noSuchFile = new File("foo");
        Assert.assertTrue((!noSuchFile.isFile() ? 1 : 0) != 0);
        Assert.assertTrue((!noSuchFile.isDirectory() ? 1 : 0) != 0);
    }

    public void testGetBestFile() {
        Assert.assertNull((Object)FileUtil.getBestFile((String[])null));
        Assert.assertNull((Object)FileUtil.getBestFile(new String[0]));
        Assert.assertNull((Object)FileUtil.getBestFile(new String[]{"!"}));
        File f2 = FileUtil.getBestFile(new String[]{"."});
        Assert.assertNotNull((Object)f2);
        f2 = FileUtil.getBestFile(new String[]{"!", "."});
        Assert.assertNotNull((Object)f2);
        Assert.assertTrue((boolean)f2.canRead());
        boolean setProperty = false;
        try {
            System.setProperty("bestfile", ".");
            setProperty = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (setProperty) {
            f2 = FileUtil.getBestFile(new String[]{"sp:bestfile"});
            Assert.assertNotNull((Object)f2);
            Assert.assertTrue((boolean)f2.canRead());
        }
    }

    public void testCopyFiles() {
        Class iaxClass = class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = FileUtilTest.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException;
        this.checkCopyFiles(null, null, iaxClass, false);
        File noSuchFile = new File("foo");
        this.checkCopyFiles(noSuchFile, null, iaxClass, false);
        this.checkCopyFiles(noSuchFile, noSuchFile, iaxClass, false);
        File tempDir = FileUtil.getTempDir("testCopyFiles");
        this.tempFiles.add(tempDir);
        File fromFile = new File(tempDir, "fromFile");
        String err = FileUtil.writeAsString(fromFile, "contents of from file");
        Assert.assertTrue((String)err, (null == err ? 1 : 0) != 0);
        this.checkCopyFiles(fromFile, null, iaxClass, false);
        this.checkCopyFiles(fromFile, fromFile, iaxClass, false);
        File toFile = new File(tempDir, "toFile");
        this.checkCopyFiles(fromFile, toFile, null, true);
        File toDir = new File(tempDir, "toDir");
        Assert.assertTrue((boolean)toDir.mkdirs());
        this.checkCopyFiles(fromFile, toDir, null, true);
        File fromDir = new File(tempDir, "fromDir");
        Assert.assertTrue((boolean)fromDir.mkdirs());
        this.checkCopyFiles(fromFile, fromDir, null, false);
        File toFile2 = new File(fromDir, "toFile2");
        this.checkCopyFiles(fromFile, toFile2, null, false);
        this.checkCopyFiles(fromDir, toDir, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkCopyFiles(File from, File to, Class exceptionClass, boolean clean) {
        try {
            FileUtil.copyFile(from, to);
            Assert.assertTrue((null == exceptionClass ? 1 : 0) != 0);
            if (to.isFile()) {
                Assert.assertTrue((from.length() == to.length() ? 1 : 0) != 0);
            } else if (!from.isDirectory()) {
                File toFile = new File(to, from.getName());
                Assert.assertTrue((from.length() == toFile.length() ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((boolean)to.exists());
                Assert.assertTrue((from.listFiles().length == to.listFiles().length ? 1 : 0) != 0);
            }
        }
        catch (Throwable t2) {
            Assert.assertTrue((null != exceptionClass ? 1 : 0) != 0);
            Assert.assertTrue((boolean)exceptionClass.isAssignableFrom(t2.getClass()));
        }
        finally {
            if (clean && null != to && to.exists()) {
                if (to.isDirectory()) {
                    FileUtil.deleteContents(to);
                }
                to.delete();
            }
        }
    }

    public void testDirCopySubdirs() throws IOException {
        File srcDir = new File("src");
        File destDir = FileUtil.getTempDir("testDirCopySubdirs");
        this.tempFiles.add(destDir);
        FileUtil.copyDir(srcDir, destDir);
        FileUtilTest.assertSame("testDirCopySubdirs", FileUtilTest.dirPaths(srcDir), FileUtilTest.dirPaths(destDir));
    }

    public void testDirCopySubdirsSuffix() throws IOException {
        File srcDir = new File("src");
        File destDir = FileUtil.getTempDir("testDirCopySubdirsSuffix");
        this.tempFiles.add(destDir);
        FileUtil.copyDir(srcDir, destDir, ".java", ".aj");
        String[] sources = FileUtilTest.dirPaths(srcDir, new String[]{".java"});
        for (int i2 = 0; i2 < sources.length; ++i2) {
            sources[i2] = sources[i2].substring(0, sources[i2].length() - 4);
        }
        String[] sinks = FileUtilTest.dirPaths(destDir, new String[]{".aj"});
        for (int i3 = 0; i3 < sinks.length; ++i3) {
            sinks[i3] = sinks[i3].substring(0, sinks[i3].length() - 2);
        }
        FileUtilTest.assertSame("testDirCopySubdirs", sources, sinks);
    }

    public void testGetURL() {
        String[] args = new String[]{".", "../util/testdata", "../lib/test/aspectjrt.jar"};
        for (int i2 = 0; i2 < args.length; ++i2) {
            this.checkGetURL(args[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGetURL(String arg) {
        Assert.assertTrue((null != arg ? 1 : 0) != 0);
        File f2 = new File(arg);
        Assert.assertTrue((null != f2 ? 1 : 0) != 0);
        URL url = FileUtil.getFileURL(f2);
        Assert.assertTrue((null != url ? 1 : 0) != 0);
        FileUtilTest.log("url       " + url);
        if (!f2.exists()) {
            FileUtilTest.log("not exist        " + f2);
        } else if (f2.isDirectory()) {
            FileUtilTest.log("directory        " + f2);
        } else {
            FileUtilTest.log("     file        " + f2);
            InputStream in = null;
            try {
                in = url.openStream();
            }
            catch (IOException e2) {
                Assert.assertTrue((String)("IOException: " + e2), (boolean)false);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {}
                }
            }
        }
    }

    public void testGetTempDir() {
        boolean pass = true;
        boolean delete = true;
        this.checkGetTempDir("parent", null, pass, delete);
        this.checkGetTempDir(null, "child", pass, delete);
        this.tempFiles.add(this.checkGetTempDir("parent", "child", pass, !delete).getParentFile());
        this.tempFiles.add(this.checkGetTempDir("parent", "child", pass, !delete).getParentFile());
        this.tempFiles.add(this.checkGetTempDir("parent", "child", pass, !delete).getParentFile());
    }

    File checkGetTempDir(String parent, String child, boolean ok, boolean delete) {
        File parentDir = FileUtil.getTempDir(parent);
        Assert.assertTrue((String)("unable to create " + parent), (null != parentDir ? 1 : 0) != 0);
        File dir = FileUtil.makeNewChildDir(parentDir, child);
        FileUtilTest.log("parent=" + parent + " child=" + child + " -> " + dir);
        Assert.assertTrue((String)("dir: " + dir), (ok == (dir.canWrite() && dir.isDirectory()) ? 1 : 0) != 0);
        if (delete) {
            dir.delete();
            parentDir.delete();
        }
        return dir;
    }

    public void testRandomFileString() {
        ArrayList<String> results = new ArrayList<String>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            String s2 = FileUtil.randomFileString();
            if (results.contains(s2)) {
                FileUtilTest.log("warning: got duplicate at iteration " + i2);
            }
            results.add(s2);
        }
    }

    public void testNormalizedPath() {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("FileUtilTest_testNormalizedPath", "tmp");
            this.tempFiles.add(tempFile);
        }
        catch (IOException e2) {
            FileUtilTest.log("aborting test - unable to create temp file");
            return;
        }
        File parentDir = tempFile.getParentFile();
        String tempFilePath = FileUtil.normalizedPath(tempFile, parentDir);
        Assert.assertEquals((String)tempFile.getName(), (String)tempFilePath);
    }

    public void testFileToClassName() {
        File basedir = new File("/base/dir");
        File classFile = new File(basedir, "foo/Bar.class");
        Assert.assertEquals((String)"foo.Bar", (String)FileUtil.fileToClassName(basedir, classFile));
        classFile = new File(basedir, "foo\\Bar.class");
        Assert.assertEquals((String)"foo.Bar", (String)FileUtil.fileToClassName(basedir, classFile));
        Assert.assertEquals((String)"Bar", (String)FileUtil.fileToClassName(null, classFile));
        classFile = new File("/home/classes/org/aspectj/lang/JoinPoint.class");
        Assert.assertEquals((String)"org.aspectj.lang.JoinPoint", (String)FileUtil.fileToClassName(null, classFile));
        classFile = new File("/home/classes/com/sun/tools/Javac.class");
        Assert.assertEquals((String)"com.sun.tools.Javac", (String)FileUtil.fileToClassName(null, classFile));
    }

    public void testDeleteContents() {
        File tempDir = FileUtil.getTempDir("testDeleteContents");
        this.tempFiles.add(tempDir);
        File f2 = new File(tempDir, "foo");
        f2.mkdirs();
        File g2 = new File(f2, "bar");
        g2.mkdirs();
        File h2 = new File(g2, "bash");
        h2.mkdirs();
        int d2 = FileUtil.deleteContents(f2);
        Assert.assertTrue((0 == d2 ? 1 : 0) != 0);
        Assert.assertTrue((0 == f2.list().length ? 1 : 0) != 0);
        f2.delete();
        Assert.assertTrue((!f2.exists() ? 1 : 0) != 0);
    }

    public void testLineSeek() {
        File tempDir = FileUtil.getTempDir("testLineSeek");
        this.tempFiles.add(tempDir);
        File file = new File(tempDir, "testLineSeek");
        String path = file.getPath();
        String contents = "0123456789" + LangUtil.EOL;
        contents = contents + contents;
        FileUtil.writeAsString(file, contents);
        this.tempFiles.add(file);
        ArrayList<String> sourceList = new ArrayList<String>();
        sourceList.add(file.getPath());
        final ArrayList errors = new ArrayList();
        PrintStream errorSink = new PrintStream(System.err, true){

            public void println(String error) {
                errors.add(error);
            }
        };
        for (int i2 = 0; i2 < 10; ++i2) {
            List result = FileUtil.lineSeek("" + i2, sourceList, true, errorSink);
            Assert.assertEquals((int)2, (int)result.size());
            Assert.assertEquals((Object)(path + ":1:" + i2), result.get(0));
            Assert.assertEquals((Object)(path + ":2:" + i2), result.get(1));
            if (LangUtil.isEmpty(errors)) continue;
            Assert.assertTrue((String)("errors: " + errors), (boolean)false);
        }
    }

    public void testLineSeekMore() {
        int MAX = 3;
        File tempDir = FileUtil.getTempDir("testLineSeekMore");
        this.tempFiles.add(tempDir);
        String prefix = new File(tempDir, "testLineSeek").getPath();
        String[] sources = new String[3];
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < sources.length; ++i2) {
            sources[i2] = new File(prefix + i2).getPath();
            sb.append("not matched");
            sb.append(LangUtil.EOL);
            sb.append("0123456789");
            sb.append(LangUtil.EOL);
        }
        String contents = sb.toString();
        for (int i3 = 0; i3 < sources.length; ++i3) {
            File file = new File(sources[i3]);
            FileUtil.writeAsString(file, contents);
            this.tempFiles.add(file);
        }
        final ArrayList errors = new ArrayList();
        PrintStream errorSink = new PrintStream(System.err, true){

            public void println(String error) {
                errors.add(error);
            }
        };
        List<String> sourceList = new ArrayList<String>();
        sourceList.addAll(Arrays.asList(sources));
        sourceList = Collections.unmodifiableList(sourceList);
        for (int k2 = 0; k2 < sources.length; ++k2) {
            List result = FileUtil.lineSeek("" + k2, sourceList, true, errorSink);
            Iterator iter = result.iterator();
            for (int i4 = 0; i4 < 3; ++i4) {
                for (int j2 = 1; j2 < 4; ++j2) {
                    Assert.assertTrue((boolean)iter.hasNext());
                    Assert.assertEquals((Object)(prefix + i4 + ":" + 2 * j2 + ":" + k2), iter.next());
                }
            }
            if (LangUtil.isEmpty(errors)) continue;
            Assert.assertTrue((String)("errors: " + errors), (boolean)false);
        }
    }

    public void testDirCopyNoSubdirs() throws IOException {
        String[] srcFiles = new String[]{"one.java", "two.java", "three.java"};
        String[] destFiles = new String[]{"three.java", "four.java", "five.java"};
        String[] allFiles = new String[]{"one.java", "two.java", "three.java", "four.java", "five.java"};
        File srcDir = this.makeTempDir("FileUtilUT_srcDir", srcFiles);
        File destDir = this.makeTempDir("FileUtilUT_destDir", destFiles);
        Assert.assertTrue((null != srcDir ? 1 : 0) != 0);
        Assert.assertTrue((null != destDir ? 1 : 0) != 0);
        Assert.assertTrue((NONE == FileUtilTest.dirContains(srcDir, srcFiles) ? 1 : 0) != 0);
        Assert.assertTrue((NONE == FileUtilTest.dirContains(destDir, destFiles) ? 1 : 0) != 0);
        FileUtil.copyDir(srcDir, destDir);
        String[] resultOne = FileUtilTest.dirContains(destDir, allFiles);
        FileUtil.copyDir(srcDir, destDir);
        String[] resultTwo = FileUtilTest.dirContains(destDir, allFiles);
        Assert.assertTrue((NONE == resultOne ? 1 : 0) != 0);
        Assert.assertTrue((NONE == resultTwo ? 1 : 0) != 0);
    }

    public void testDirCopyNoSubdirsWithSuffixes() throws IOException {
        String[] srcFiles = new String[]{"one.java", "two.java", "three.java"};
        String[] destFiles = new String[]{"three.java", "four.java", "five.java"};
        String[] allFiles = new String[]{"one.aj", "two.aj", "three.aj", "three.java", "four.java", "five.java"};
        File srcDir = this.makeTempDir("FileUtilUT_srcDir", srcFiles);
        File destDir = this.makeTempDir("FileUtilUT_destDir", destFiles);
        Assert.assertTrue((null != srcDir ? 1 : 0) != 0);
        Assert.assertTrue((null != destDir ? 1 : 0) != 0);
        Assert.assertTrue((NONE == FileUtilTest.dirContains(srcDir, srcFiles) ? 1 : 0) != 0);
        Assert.assertTrue((NONE == FileUtilTest.dirContains(destDir, destFiles) ? 1 : 0) != 0);
        FileUtil.copyDir(srcDir, destDir, ".java", ".aj");
        FileUtil.copyDir(srcDir, destDir, ".java", ".aj");
        Assert.assertTrue((NONE == FileUtilTest.dirContains(destDir, allFiles) ? 1 : 0) != 0);
        Assert.assertTrue((NONE == FileUtilTest.dirContains(destDir, allFiles) ? 1 : 0) != 0);
    }

    public void testDirCopySubdirsSuffixRoundTrip() throws IOException {
        File srcDir = new File("src");
        File one = FileUtil.getTempDir("testDirCopySubdirsSuffixRoundTrip_1");
        File two = FileUtil.getTempDir("testDirCopySubdirsSuffixRoundTrip_2");
        FileUtil.copyDir(srcDir, one);
        FileUtil.copyDir(two, one, ".java", ".aj");
        FileUtil.copyDir(one, two, ".aj", ".java");
        FileUtil.deleteContents(one);
        one.delete();
        FileUtil.deleteContents(two);
        two.delete();
    }

    File makeTempDir(String loc, String[] filenames) throws IOException {
        File d2 = new File(loc);
        d2.mkdirs();
        Assert.assertTrue((boolean)d2.exists());
        this.tempFiles.add(d2);
        Assert.assertTrue((boolean)d2.canWrite());
        for (int i2 = 0; i2 < filenames.length; ++i2) {
            File f2 = new File(d2, filenames[i2]);
            Assert.assertTrue((String)filenames[i2], (boolean)f2.createNewFile());
        }
        return d2;
    }

    public void testPipeEmpty() {
        this.checkPipe("");
    }

    public void testPipeMin() {
        this.checkPipe("0");
    }

    public void testPipe() {
        String str = "The quick brown fox jumped over the lazy dog";
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < 4096; ++i2) {
            sb.append(str);
        }
        this.checkPipe(sb.toString());
    }

    void checkPipe(String data) {
        StringBufferInputStream in = new StringBufferInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtil.Pipe pipe = new FileUtil.Pipe(in, out);
        pipe.run();
        Assert.assertTrue((boolean)data.equals(out.toString()));
        Assert.assertTrue((null == pipe.getThrown() ? 1 : 0) != 0);
        Assert.assertEquals((String)"totalWritten", (long)data.length(), (long)pipe.totalWritten());
    }

    public void testPipeThrown() {
        String data = "The quick brown fox jumped over the lazy dog";
        final IOException thrown = new IOException("test");
        StringBufferInputStream in = new StringBufferInputStream("The quick brown fox jumped over the lazy dog");
        OutputStream out = new OutputStream(){

            public void write(int b2) throws IOException {
                throw thrown;
            }
        };
        FileUtil.Pipe pipe = new FileUtil.Pipe(in, out);
        pipe.run();
        Assert.assertEquals((String)"totalWritten", (long)0L, (long)pipe.totalWritten());
        Assert.assertTrue((thrown == pipe.getThrown() ? 1 : 0) != 0);
    }

    public void xtestPipeHalt() {
        long MAX = 1000000L;
        InputStream in = new InputStream(){
            long max = 0L;

            public int read() throws IOException {
                if (this.max++ > 1000000L) {
                    throw new IOException("test failed");
                }
                return 1;
            }
        };
        int minWritten = 20;
        class Flag {
            boolean hit;

            Flag() {
            }
        }
        final Flag flag = new Flag();
        OutputStream out = new OutputStream(){
            long max = 0L;
            {
            }

            public void write(int b2) throws IOException {
                if (this.max++ > 1000000L) {
                    throw new IOException("test failed");
                }
                if (this.max > 20L && !flag.hit) {
                    flag.hit = true;
                }
            }
        };
        class Result {
            long totalWritten;
            Throwable thrown;
            boolean set;

            Result() {
            }
        }
        final Result result = new Result();
        FileUtil.Pipe pipe = new FileUtil.Pipe(in, out){
            {
            }

            protected void completing(long totalWritten, Throwable thrown) {
                result.totalWritten = totalWritten;
                result.thrown = thrown;
                result.set = true;
            }
        };
        new Thread(pipe).start();
        while (!flag.hit) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e2) {}
        }
        Assert.assertTrue((boolean)pipe.halt(true, true));
        Assert.assertTrue((boolean)result.set);
        Assert.assertTrue((String)("Expected null but result.thrown = " + result.thrown), (null == result.thrown ? 1 : 0) != 0);
        Assert.assertTrue((null == pipe.getThrown() ? 1 : 0) != 0);
        Assert.assertEquals((String)"total written", (long)result.totalWritten, (long)pipe.totalWritten());
        if (20L > pipe.totalWritten()) {
            Assert.assertTrue((String)("written: " + pipe.totalWritten()), (boolean)false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

