/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PartialOrder {
    private static void addNewPartialComparable(List graph, PartialComparable o2) {
        SortObject so = new SortObject(o2);
        Iterator i2 = graph.iterator();
        while (i2.hasNext()) {
            SortObject other = (SortObject)i2.next();
            so.addDirectedLinks(other);
        }
        graph.add(so);
    }

    private static void removeFromGraph(List graph, SortObject o2) {
        Iterator i2 = graph.iterator();
        while (i2.hasNext()) {
            SortObject other = (SortObject)i2.next();
            if (o2 == other) {
                i2.remove();
            }
            other.removeSmallerObject(o2);
        }
    }

    public static List sort(List objects) {
        if (objects.size() < 2) {
            return objects;
        }
        LinkedList sortList = new LinkedList();
        Iterator i2 = objects.iterator();
        while (i2.hasNext()) {
            PartialOrder.addNewPartialComparable(sortList, (PartialComparable)i2.next());
        }
        int N = objects.size();
        for (int index = 0; index < N; ++index) {
            SortObject leastWithNoSmallers = null;
            Iterator i3 = sortList.iterator();
            while (i3.hasNext()) {
                SortObject so = (SortObject)i3.next();
                if (!so.hasNoSmallerObjects() || leastWithNoSmallers != null && so.object.fallbackCompareTo(leastWithNoSmallers.object) >= 0) continue;
                leastWithNoSmallers = so;
            }
            if (leastWithNoSmallers == null) {
                return null;
            }
            PartialOrder.removeFromGraph(sortList, leastWithNoSmallers);
            objects.set(index, leastWithNoSmallers.object);
        }
        return objects;
    }

    public static void main(String[] args) {
        ArrayList<Token> l2 = new ArrayList<Token>();
        l2.add(new Token("a1"));
        l2.add(new Token("c2"));
        l2.add(new Token("b3"));
        l2.add(new Token("f4"));
        l2.add(new Token("e5"));
        l2.add(new Token("d6"));
        l2.add(new Token("c7"));
        l2.add(new Token("b8"));
        l2.add(new Token("z"));
        l2.add(new Token("x"));
        l2.add(new Token("f9"));
        l2.add(new Token("e10"));
        l2.add(new Token("a11"));
        l2.add(new Token("d12"));
        l2.add(new Token("b13"));
        l2.add(new Token("c14"));
        System.out.println(l2);
        PartialOrder.sort(l2);
        System.out.println(l2);
    }

    static class Token
    implements PartialComparable {
        private String s;

        Token(String s2) {
            this.s = s2;
        }

        public int compareTo(Object other) {
            Token t2 = (Token)other;
            int cmp = this.s.charAt(0) - t2.s.charAt(0);
            if (cmp == 1) {
                return 1;
            }
            if (cmp == -1) {
                return -1;
            }
            return 0;
        }

        public int fallbackCompareTo(Object other) {
            return -this.s.compareTo(((Token)other).s);
        }

        public String toString() {
            return this.s;
        }
    }

    private static class SortObject {
        PartialComparable object;
        List smallerObjects = new LinkedList();
        List biggerObjects = new LinkedList();

        public SortObject(PartialComparable o2) {
            this.object = o2;
        }

        boolean hasNoSmallerObjects() {
            return this.smallerObjects.size() == 0;
        }

        boolean removeSmallerObject(SortObject o2) {
            this.smallerObjects.remove(o2);
            return this.hasNoSmallerObjects();
        }

        void addDirectedLinks(SortObject other) {
            int cmp = this.object.compareTo(other.object);
            if (cmp == 0) {
                return;
            }
            if (cmp > 0) {
                this.smallerObjects.add(other);
                other.biggerObjects.add(this);
            } else {
                this.biggerObjects.add(other);
                other.smallerObjects.add(this);
            }
        }

        public String toString() {
            return this.object.toString();
        }
    }

    public static interface PartialComparable {
        public int compareTo(Object var1);

        public int fallbackCompareTo(Object var1);
    }
}

