/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;

public class DeleteVisitor
implements IUnifiedTreeVisitor,
ICoreConstants {
    protected IProgressMonitor monitor;
    protected boolean force;
    protected boolean keepHistory;
    protected MultiStatus status;
    protected List skipList;
    protected boolean convertToPhantom;

    public DeleteVisitor(List skipList, boolean force, boolean convertToPhantom, boolean keepHistory, IProgressMonitor monitor) {
        this.skipList = skipList;
        this.force = force;
        this.convertToPhantom = convertToPhantom;
        this.keepHistory = keepHistory;
        this.monitor = monitor;
        this.status = new MultiStatus("org.eclipse.core.resources", 273, Messages.localstore_deleteProblem, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete(UnifiedTreeNode node, boolean deleteLocalFile, boolean shouldKeepHistory) {
        Resource target = (Resource)node.getResource();
        try {
            try {
                File localFile;
                deleteLocalFile = deleteLocalFile && !target.isLinked() && node.existsInFileSystem();
                File file = localFile = deleteLocalFile ? new File(node.getLocalLocation()) : null;
                if (target.getType() == 2) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    Enumeration children = node.getChildren();
                    while (true) {
                        if (!children.hasMoreElements()) {
                            node.removeChildrenFromTree();
                        }
                        this.delete((UnifiedTreeNode)children.nextElement(), deleteLocalFile, shouldKeepHistory);
                    }
                    this.delete(node.existsInWorkspace() ? target : null, localFile);
                    Object var7_9 = null;
                    this.monitor.worked(1);
                    return;
                }
                if (shouldKeepHistory) {
                    IHistoryStore store = target.getLocalManager().getHistoryStore();
                    store.addState(target.getFullPath(), localFile, node.getLastModified(), true);
                }
                this.delete(node.existsInWorkspace() ? target : null, localFile);
            }
            catch (CoreException e2) {
                this.status.add(e2.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.monitor.worked(1);
            throw throwable;
        }
        {
            Object var7_11 = null;
            this.monitor.worked(1);
            return;
        }
    }

    protected void delete(Resource target, File localFile) {
        if (target != null) {
            try {
                if (localFile != null && !target.isLinked()) {
                    target.getLocalManager().getStore().delete(localFile);
                }
                target.deleteResource(this.convertToPhantom, this.status);
            }
            catch (CoreException e2) {
                this.status.add(e2.getStatus());
            }
        } else if (localFile != null) {
            localFile.delete();
        }
    }

    protected boolean equals(IResource one, IResource another) {
        return one.getFullPath().equals(another.getFullPath());
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    protected boolean isAncestor(IResource one, IResource another) {
        return one.getFullPath().isPrefixOf(another.getFullPath()) && !this.equals(one, another);
    }

    protected boolean isAncestorOfResourceToSkip(IResource resource) {
        if (this.skipList == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.skipList.size()) {
            IResource target = (IResource)this.skipList.get(i2);
            if (this.isAncestor(resource, target)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected void removeFromSkipList(IResource resource) {
        if (this.skipList != null) {
            this.skipList.remove(resource);
        }
    }

    protected boolean shouldSkip(IResource resource) {
        if (this.skipList == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.skipList.size()) {
            if (this.equals(resource, (IResource)this.skipList.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean visit(UnifiedTreeNode node) {
        Policy.checkCanceled(this.monitor);
        Resource target = (Resource)node.getResource();
        if (target.getType() == 4) {
            return true;
        }
        if (this.shouldSkip(target)) {
            this.removeFromSkipList(target);
            int ticks = target.countResources(2, false);
            this.monitor.worked(ticks);
            return false;
        }
        if (this.isAncestorOfResourceToSkip(target)) {
            return true;
        }
        this.delete(node, true, this.keepHistory);
        return false;
    }
}

