/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class HistoryStore2
implements IHistoryStore {
    private BlobStore blobStore;
    private Set blobsToRemove = new HashSet();
    BucketTree tree;
    private Workspace workspace;

    public HistoryStore2(Workspace workspace, IPath location, int limit) {
        this.workspace = workspace;
        location.toFile().mkdirs();
        this.blobStore = new BlobStore(location, limit);
        this.tree = new BucketTree(workspace, new HistoryBucket());
    }

    public synchronized IFileState addState(IPath key, File localFile, long lastModified, boolean moveContents) {
        if (Policy.DEBUG_HISTORY) {
            System.out.println("History: Adding state for key: " + key + ", file: " + localFile + ", timestamp: " + lastModified + ", size: " + localFile.length());
        }
        if (!this.isValid(localFile)) {
            return null;
        }
        UniversalUniqueIdentifier uuid = null;
        try {
            uuid = this.blobStore.addBlob(localFile, moveContents);
            this.tree.loadBucketFor(key);
            HistoryBucket currentBucket = (HistoryBucket)this.tree.getCurrent();
            currentBucket.addBlob(key, uuid, lastModified);
            currentBucket.save();
        }
        catch (CoreException e2) {
            ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
        }
        return new FileState(this, key, lastModified, uuid);
    }

    public synchronized Set allFiles(IPath root, int depth, IProgressMonitor monitor) {
        final HashSet allFiles = new HashSet();
        try {
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry fileEntry) {
                    allFiles.add(fileEntry.getPath());
                    return 0;
                }
            }, root, depth == 2 ? Integer.MAX_VALUE : depth);
        }
        catch (CoreException e2) {
            ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
        }
        return allFiles;
    }

    private void applyPolicy(HistoryBucket.HistoryEntry fileEntry, int maxStates, long minTimeStamp) {
        int i2 = 0;
        while (i2 < fileEntry.getOccurrences()) {
            if (i2 >= maxStates || fileEntry.getTimestamp(i2) < minTimeStamp) {
                this.blobsToRemove.add(fileEntry.getUUID(i2));
                fileEntry.deleteOccurrence(i2);
            }
            ++i2;
        }
    }

    private void applyPolicy(IPath root) throws CoreException {
        WorkspaceDescription description = this.workspace.internalGetDescription();
        final long minimumTimestamp = System.currentTimeMillis() - description.getFileStateLongevity();
        final int maxStates = description.getMaxFileStates();
        this.tree.accept(new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                HistoryStore2.this.applyPolicy((HistoryBucket.HistoryEntry)entry, maxStates, minimumTimestamp);
                return 0;
            }
        }, root, Integer.MAX_VALUE);
        this.tree.getCurrent().save();
    }

    public synchronized void clean(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            WorkspaceDescription description = this.workspace.internalGetDescription();
            final long minimumTimestamp = System.currentTimeMillis() - description.getFileStateLongevity();
            final int maxStates = description.getMaxFileStates();
            final int[] entryCount = new int[1];
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry fileEntry) {
                    entryCount[0] = entryCount[0] + fileEntry.getOccurrences();
                    HistoryStore2.this.applyPolicy((HistoryBucket.HistoryEntry)fileEntry, maxStates, minimumTimestamp);
                    return 0;
                }
            }, Path.ROOT, Integer.MAX_VALUE);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug("Time to apply history store policies: " + (System.currentTimeMillis() - start) + "ms.");
                Policy.debug("Total number of history store entries: " + entryCount[0]);
            }
            start = System.currentTimeMillis();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug("Time to remove " + this.blobsToRemove.size() + " unreferenced blobs: " + (System.currentTimeMillis() - start) + "ms.");
            }
            this.blobsToRemove = new HashSet();
        }
        catch (Exception e2) {
            String message = Messages.history_problemsCleaning;
            ResourceStatus status = new ResourceStatus(273, null, message, e2);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public synchronized void copyHistory(IResource sourceResource, IResource destinationResource, boolean moving) {
        if (sourceResource == null || destinationResource == null) {
            String message = Messages.history_copyToNull;
            ResourceStatus status = new ResourceStatus(566, null, message, null);
            ResourcesPlugin.getPlugin().getLog().log(status);
            return;
        }
        if (sourceResource.equals(destinationResource)) {
            String message = Messages.history_copyToSelf;
            ResourceStatus status = new ResourceStatus(566, sourceResource.getFullPath(), message, null);
            ResourcesPlugin.getPlugin().getLog().log(status);
            return;
        }
        IPath source = sourceResource.getFullPath();
        IPath destination = destinationResource.getFullPath();
        Assert.isLegal(source.segmentCount() > 0);
        Assert.isLegal(destination.segmentCount() > 0);
        Assert.isLegal(source.segmentCount() > 1 || destination.segmentCount() == 1);
        if (moving && sourceResource.getType() == 4) {
            this.tree.getCurrent().flush();
            return;
        }
        try {
            HistoryCopyVisitor copyVisitor = new HistoryCopyVisitor(source, destination);
            this.tree.accept(copyVisitor, source, Integer.MAX_VALUE);
            this.applyPolicy(destinationResource.getFullPath());
        }
        catch (CoreException e2) {
            ResourcesPlugin.getPlugin().getLog().log(e2.getStatus());
        }
    }

    public boolean exists(IFileState target) {
        return this.blobStore.fileFor(((FileState)target).getUUID()).exists();
    }

    public InputStream getContents(IFileState target) throws CoreException {
        if (!target.exists()) {
            String message = Messages.history_notValid;
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        return this.blobStore.getBlob(((FileState)target).getUUID());
    }

    public File getFileFor(IFileState state) {
        return this.blobStore.fileFor(((FileState)state).getUUID());
    }

    public synchronized IFileState[] getStates(IPath filePath, IProgressMonitor monitor) {
        try {
            this.tree.loadBucketFor(filePath);
            HistoryBucket currentBucket = (HistoryBucket)this.tree.getCurrent();
            HistoryBucket.HistoryEntry fileEntry = currentBucket.getEntry(filePath);
            if (fileEntry == null || fileEntry.isEmpty()) {
                return new IFileState[0];
            }
            IFileState[] states = new IFileState[fileEntry.getOccurrences()];
            int i2 = 0;
            while (i2 < states.length) {
                states[i2] = new FileState(this, fileEntry.getPath(), fileEntry.getTimestamp(i2), fileEntry.getUUID(i2));
                ++i2;
            }
            return states;
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
            return new IFileState[0];
        }
    }

    public BucketTree getTree() {
        return this.tree;
    }

    private boolean isValid(File localFile) {
        boolean result;
        WorkspaceDescription description = this.workspace.internalGetDescription();
        boolean bl = result = localFile.length() <= description.getMaxFileStateSize();
        if (Policy.DEBUG_HISTORY && !result) {
            System.out.println("History: Ignoring file (too large). File: " + localFile.getAbsolutePath() + ", size: " + localFile.length() + ", max: " + description.getMaxFileStateSize());
        }
        return result;
    }

    public synchronized void remove(IPath root, IProgressMonitor monitor) {
        try {
            final Set tmpBlobsToRemove = this.blobsToRemove;
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry fileEntry) {
                    int i2 = 0;
                    while (i2 < fileEntry.getOccurrences()) {
                        tmpBlobsToRemove.add(((HistoryBucket.HistoryEntry)fileEntry).getUUID(i2));
                        ++i2;
                    }
                    fileEntry.delete();
                    return 0;
                }
            }, root, Integer.MAX_VALUE);
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
        }
    }

    public synchronized void removeGarbage() {
        try {
            final Set tmpBlobsToRemove = this.blobsToRemove;
            this.tree.accept(new Bucket.Visitor(){

                public int visit(Bucket.Entry fileEntry) {
                    int i2 = 0;
                    while (i2 < fileEntry.getOccurrences()) {
                        tmpBlobsToRemove.remove(((HistoryBucket.HistoryEntry)fileEntry).getUUID(i2));
                        ++i2;
                    }
                    return 0;
                }
            }, Path.ROOT, Integer.MAX_VALUE);
            this.blobStore.deleteBlobs(this.blobsToRemove);
            this.blobsToRemove = new HashSet();
        }
        catch (Exception e2) {
            String message = Messages.history_problemsCleaning;
            ResourceStatus status = new ResourceStatus(273, null, message, e2);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public synchronized void shutdown(IProgressMonitor monitor) throws CoreException {
        this.tree.close();
    }

    public void startup(IProgressMonitor monitor) {
    }

    class HistoryCopyVisitor
    extends Bucket.Visitor {
        private List changes = new ArrayList();
        private IPath destination;
        private IPath source;

        public HistoryCopyVisitor(IPath source, IPath destination) {
            this.source = source;
            this.destination = destination;
        }

        public void afterSaving(Bucket bucket) throws CoreException {
            this.saveChanges();
            this.changes.clear();
        }

        private void saveChanges() throws CoreException {
            if (this.changes.isEmpty()) {
                return;
            }
            Iterator i2 = this.changes.iterator();
            HistoryBucket.HistoryEntry entry = (HistoryBucket.HistoryEntry)i2.next();
            HistoryStore2.this.tree.loadBucketFor(entry.getPath());
            HistoryBucket bucket = (HistoryBucket)HistoryStore2.this.tree.getCurrent();
            bucket.addBlobs(entry);
            while (i2.hasNext()) {
                bucket.addBlobs((HistoryBucket.HistoryEntry)i2.next());
            }
            bucket.save();
        }

        public int visit(Bucket.Entry sourceEntry) {
            IPath destinationPath = this.destination.append(sourceEntry.getPath().removeFirstSegments(this.source.segmentCount()));
            HistoryBucket.HistoryEntry destinationEntry = new HistoryBucket.HistoryEntry(destinationPath, (HistoryBucket.HistoryEntry)sourceEntry);
            this.changes.add(destinationEntry);
            return 0;
        }
    }
}

