/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.runtime.ListenerList;

public class ListenerRegistry {
    static final Object[] EMPTY_LIST = new Object[0];
    ListenerMap registry = new ListenerMap(25);

    public synchronized Object[] getListeners(String path) {
        ListenerList list = this.registry.get(path);
        return list == null ? EMPTY_LIST : list.getListeners();
    }

    public synchronized void add(String path, Object listener) {
        ListenerList list = this.registry.get(path);
        if (list == null) {
            list = new ListenerList(1);
        }
        list.add(listener);
        this.registry.put(path, list);
    }

    public synchronized void remove(String path, Object listener) {
        ListenerList list = this.registry.get(path);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.registry.remove(path);
        }
    }

    public synchronized void clear(String path) {
        this.registry.remove(path);
    }

    private static class ListenerMap {
        private static final int GROW_SIZE = 10;
        String[] keys;
        ListenerList[] values;

        ListenerMap(int size) {
            this.keys = new String[size];
            this.values = new ListenerList[size];
        }

        ListenerList get(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            int i2 = 0;
            while (i2 < this.keys.length) {
                if (key.equals(this.keys[i2])) {
                    return this.values[i2];
                }
                ++i2;
            }
            return null;
        }

        void put(String key, ListenerList value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                this.remove(key);
                return;
            }
            int emptyIndex = -1;
            int i2 = 0;
            while (i2 < this.keys.length) {
                String existing = this.keys[i2];
                if (existing == null) {
                    emptyIndex = i2;
                } else if (existing.equals(key)) {
                    this.values[i2] = value;
                    return;
                }
                ++i2;
            }
            if (emptyIndex == -1) {
                emptyIndex = this.grow();
            }
            this.keys[emptyIndex] = key;
            this.values[emptyIndex] = value;
        }

        private int grow() {
            int size = this.keys.length;
            String[] tempKeys = new String[size + 10];
            System.arraycopy(this.keys, 0, tempKeys, 0, size);
            this.keys = tempKeys;
            ListenerList[] tempValues = new ListenerList[size + 10];
            System.arraycopy(this.values, 0, tempValues, 0, size);
            this.values = tempValues;
            return size;
        }

        void remove(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            int i2 = 0;
            while (i2 < this.keys.length) {
                if (key.equals(this.keys[i2])) {
                    this.keys[i2] = null;
                    this.values[i2] = null;
                    return;
                }
                ++i2;
            }
        }
    }
}

