/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.Hashtable;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ConfigurationElement
extends RegistryObject {
    static final ConfigurationElement[] EMPTY_ARRAY = new ConfigurationElement[0];
    static final int PLUGIN_ERROR = 1;
    int parentId;
    byte parentType;
    private String[] propertiesAndValue;
    private String name;
    private Bundle contributingBundle;

    ConfigurationElement() {
    }

    ConfigurationElement(int self, Bundle bundle, String name, String[] propertiesAndValue, int[] children, int extraDataOffset, int parent, byte parentType) {
        this.setObjectId(self);
        this.contributingBundle = bundle;
        this.name = name;
        this.propertiesAndValue = propertiesAndValue;
        this.setRawChildren(children);
        this.extraDataOffset = extraDataOffset;
        this.parentId = parent;
        this.parentType = parentType;
    }

    Object createExecutableExtension(String attributeName) throws CoreException {
        String prop = null;
        String pluginName = null;
        String className = null;
        Object initData = null;
        if (attributeName != null) {
            prop = this.getAttribute(attributeName);
        } else {
            prop = this.getValue();
            if (prop != null && (prop = prop.trim()).equals("")) {
                prop = null;
            }
        }
        if (prop == null) {
            ConfigurationElement[] exec = this.getChildren(attributeName);
            if (exec.length != 0) {
                ConfigurationElement element = exec[0];
                pluginName = element.getAttribute("plugin");
                className = element.getAttribute("class");
                ConfigurationElement[] parms = element.getChildren("parameter");
                if (parms.length != 0) {
                    Hashtable<String, String> initParms = new Hashtable<String, String>(parms.length + 1);
                    int i2 = 0;
                    while (i2 < parms.length) {
                        String pname = parms[i2].getAttribute("name");
                        if (pname != null) {
                            initParms.put(pname, parms[i2].getAttribute("value"));
                        }
                        ++i2;
                    }
                    if (!initParms.isEmpty()) {
                        initData = initParms;
                    }
                }
            } else {
                this.throwException(NLS.bind(Messages.plugin_extDefNotFound, attributeName), null);
            }
        } else {
            String executable;
            int i3 = prop.indexOf(58);
            if (i3 != -1) {
                executable = prop.substring(0, i3).trim();
                initData = prop.substring(i3 + 1).trim();
            } else {
                executable = prop;
            }
            i3 = executable.indexOf(47);
            if (i3 != -1) {
                pluginName = executable.substring(0, i3).trim();
                className = executable.substring(i3 + 1).trim();
            } else {
                className = executable;
            }
        }
        if (className == null || className.equals("")) {
            this.throwException(NLS.bind(Messages.plugin_extDefNoClass, attributeName), null);
        }
        return this.createExecutableExtension(pluginName, className, initData, this, attributeName);
    }

    private Object createExecutableExtension(String pluginName, String className, Object initData, ConfigurationElement cfig, String propertyName) throws CoreException {
        if (this.contributingBundle == null) {
            this.throwException(NLS.bind(Messages.plugin_loadClassError, "UNKNOWN BUNDLE", className), new InvalidRegistryObjectException());
        }
        String id = this.contributingBundle.getSymbolicName();
        if (pluginName != null && !pluginName.equals("") && !pluginName.equals(id)) {
            Bundle otherBundle = null;
            otherBundle = InternalPlatform.getDefault().getBundle(pluginName);
            return this.createExecutableExtension(otherBundle, className, initData, cfig, propertyName);
        }
        return this.createExecutableExtension(this.contributingBundle, className, initData, cfig, propertyName);
    }

    private Object createExecutableExtension(Bundle bundle, String className, Object initData, ConfigurationElement cfig, String propertyName) throws CoreException {
        if (this.contributingBundle == null) {
            this.throwException(NLS.bind(Messages.plugin_loadClassError, "UNKNOWN BUNDLE", className), new InvalidRegistryObjectException());
        }
        Class classInstance = null;
        try {
            classInstance = bundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(NLS.bind(Messages.plugin_loadClassError, bundle.getSymbolicName(), className), e1);
        }
        catch (LinkageError e2) {
            this.throwException(NLS.bind(Messages.plugin_loadClassError, bundle.getSymbolicName(), className), e2);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e3) {
            this.throwException(NLS.bind(Messages.plugin_instantiateClassError, bundle.getSymbolicName(), className), e3);
        }
        if (result instanceof IExecutableExtension) {
            try {
                ConfigurationElementHandle cfigHandle = new ConfigurationElementHandle(((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).getObjectManager(), cfig.getObjectId());
                ((IExecutableExtension)result).setInitializationData(cfigHandle, propertyName, initData);
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (Exception te) {
                this.throwException(NLS.bind(Messages.plugin_initObjectError, bundle.getSymbolicName(), className), te);
            }
        }
        if (result instanceof IExecutableExtensionFactory) {
            result = ((IExecutableExtensionFactory)result).create();
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        throw new CoreException(new Status(4, "org.eclipse.core.runtime", 1, message, exception));
    }

    String getValue() {
        return this.getValueAsIs();
    }

    String getValueAsIs() {
        if (this.propertiesAndValue.length != 0 && this.propertiesAndValue.length % 2 == 1) {
            return this.propertiesAndValue[this.propertiesAndValue.length - 1];
        }
        return null;
    }

    String getAttribute(String attrName) {
        return this.getAttributeAsIs(attrName);
    }

    String getAttributeAsIs(String attrName) {
        if (this.propertiesAndValue.length <= 1) {
            return null;
        }
        int size = this.propertiesAndValue.length - this.propertiesAndValue.length % 2;
        int i2 = 0;
        while (i2 < size) {
            if (this.propertiesAndValue[i2].equals(attrName)) {
                return this.propertiesAndValue[i2 + 1];
            }
            i2 += 2;
        }
        return null;
    }

    String[] getAttributeNames() {
        if (this.propertiesAndValue.length <= 1) {
            return RegistryObjectManager.EMPTY_STRING_ARRAY;
        }
        int size = this.propertiesAndValue.length / 2;
        String[] result = new String[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = this.propertiesAndValue[i2 * 2];
            ++i2;
        }
        return result;
    }

    void setProperties(String[] value) {
        this.propertiesAndValue = value;
    }

    String[] getPropertiesAndValue() {
        return this.propertiesAndValue;
    }

    void setValue(String value) {
        if (this.propertiesAndValue.length == 0) {
            this.propertiesAndValue = new String[]{value};
            return;
        }
        if (this.propertiesAndValue.length % 2 == 1) {
            this.propertiesAndValue[this.propertiesAndValue.length - 1] = value;
            return;
        }
        String[] newPropertiesAndValue = new String[this.propertiesAndValue.length + 1];
        System.arraycopy(this.propertiesAndValue, 0, newPropertiesAndValue, 0, this.propertiesAndValue.length);
        newPropertiesAndValue[this.propertiesAndValue.length] = value;
        this.propertiesAndValue = newPropertiesAndValue;
    }

    void setContributingBundle(Bundle b2) {
        this.contributingBundle = b2;
    }

    Bundle getContributingBundle() {
        return this.contributingBundle;
    }

    ConfigurationElement[] getChildren(String childrenName) {
        if (this.getRawChildren().length == 0) {
            return EMPTY_ARRAY;
        }
        ConfigurationElement[] result = new ConfigurationElement[1];
        int idx = 0;
        RegistryObjectManager objectManager = ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).getObjectManager();
        int i2 = 0;
        while (i2 < this.children.length) {
            ConfigurationElement toTest = (ConfigurationElement)objectManager.getObject(this.children[i2], this.extraDataOffset == -1 ? (byte)1 : 4);
            if (toTest.name.equals(childrenName)) {
                if (idx != 0) {
                    ConfigurationElement[] copy = new ConfigurationElement[result.length + 1];
                    System.arraycopy(result, 0, copy, 0, result.length);
                    result = copy;
                }
                result[idx++] = toTest;
            }
            ++i2;
        }
        if (idx == 0) {
            result = EMPTY_ARRAY;
        }
        return result;
    }

    void setParentId(int objectId) {
        this.parentId = objectId;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setParentType(byte type) {
        this.parentType = type;
    }

    String getNamespace() {
        return this.contributingBundle == null ? null : this.contributingBundle.getSymbolicName();
    }
}

