/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class MarkerDelta
implements IMarkerDelta,
IMarkerSetElement {
    protected int kind;
    protected IResource resource;
    protected MarkerInfo info;

    public MarkerDelta(int kind, IResource resource, MarkerInfo info) {
        this.kind = kind;
        this.resource = resource;
        this.info = info;
    }

    public Object getAttribute(String attributeName) {
        return this.info.getAttribute(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Object value = this.info.getAttribute(attributeName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Object value = this.info.getAttribute(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Object value = this.info.getAttribute(attributeName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Map getAttributes() {
        return this.info.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) {
        return this.info.getAttributes(attributeNames);
    }

    public long getId() {
        return this.info.getId();
    }

    public int getKind() {
        return this.kind;
    }

    public IMarker getMarker() {
        return new Marker(this.resource, this.getId());
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getType() {
        return this.info.getType();
    }

    public boolean isSubtypeOf(String superType) {
        return ((Workspace)this.getResource().getWorkspace()).getMarkerManager().isSubtype(this.getType(), superType);
    }

    public static Map merge(Map oldChanges, Map newChanges) {
        if (oldChanges == null) {
            return newChanges;
        }
        if (newChanges == null) {
            return oldChanges;
        }
        Iterator it = newChanges.keySet().iterator();
        while (it.hasNext()) {
            IPath key = (IPath)it.next();
            MarkerSet oldSet = (MarkerSet)oldChanges.get(key);
            MarkerSet newSet = (MarkerSet)newChanges.get(key);
            if (oldSet == null) {
                oldChanges.put(key, newSet);
                continue;
            }
            MarkerDelta.merge(oldSet, newSet.elements());
        }
        return oldChanges;
    }

    protected static MarkerSet merge(MarkerSet oldChanges, IMarkerSetElement[] newChanges) {
        if (oldChanges == null) {
            MarkerSet result = new MarkerSet(newChanges.length);
            int i2 = 0;
            while (i2 < newChanges.length) {
                result.add(newChanges[i2]);
                ++i2;
            }
            return result;
        }
        if (newChanges == null) {
            return oldChanges;
        }
        int i3 = 0;
        while (i3 < newChanges.length) {
            MarkerDelta newDelta = (MarkerDelta)newChanges[i3];
            MarkerDelta oldDelta = (MarkerDelta)oldChanges.get(newDelta.getId());
            if (oldDelta == null) {
                oldChanges.add(newDelta);
            } else {
                block0 : switch (oldDelta.getKind()) {
                    case 1: {
                        switch (newDelta.getKind()) {
                            case 1: {
                                break block0;
                            }
                            case 2: {
                                oldChanges.remove(oldDelta);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (newDelta.getKind()) {
                            case 1: {
                                break block0;
                            }
                            case 2: {
                                break block0;
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (newDelta.getKind()) {
                            case 1: {
                                break block0;
                            }
                            case 2: {
                                oldDelta.setKind(2);
                                break block0;
                            }
                        }
                    }
                }
            }
            ++i3;
        }
        return oldChanges;
    }

    private void setKind(int kind) {
        this.kind = kind;
    }
}

