/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Assert;

public class URLTool {
    public static URL appendTrailingSlash(URL url) {
        String file = url.getFile();
        if (file.endsWith("/")) {
            return url;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(file) + "/");
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static URL getChild(URL parent, String member) {
        String file = parent.getFile();
        if (!file.endsWith("/")) {
            file = String.valueOf(file) + "/";
        }
        try {
            return new URL(parent.getProtocol(), parent.getHost(), parent.getPort(), String.valueOf(file) + member);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static Vector getElements(URL url) {
        Vector<String> result = new Vector<String>(5);
        String lastElement = null;
        while ((lastElement = URLTool.getLastElement(url)) != null) {
            result.insertElementAt(lastElement, 0);
            url = URLTool.getParent(url);
        }
        return result;
    }

    public static String getLastElement(URL url) {
        boolean isDirectory;
        String file = url.getFile();
        int len = file.length();
        if (len == 0 || len == 1 && file.charAt(0) == '/') {
            return null;
        }
        int lastSlashIndex = -1;
        int i2 = len - 2;
        while (lastSlashIndex == -1 && i2 >= 0) {
            if (file.charAt(i2) == '/') {
                lastSlashIndex = i2;
            }
            --i2;
        }
        boolean bl = isDirectory = file.charAt(len - 1) == '/';
        if (lastSlashIndex == -1) {
            if (isDirectory) {
                return file.substring(0, len - 1);
            }
            return file;
        }
        if (isDirectory) {
            return file.substring(lastSlashIndex + 1, len - 1);
        }
        return file.substring(lastSlashIndex + 1, len);
    }

    public static URL getParent(URL url) {
        String file = url.getFile();
        int len = file.length();
        if (len == 0 || len == 1 && file.charAt(0) == '/') {
            return null;
        }
        int lastSlashIndex = -1;
        int i2 = len - 2;
        while (lastSlashIndex == -1 && i2 >= 0) {
            if (file.charAt(i2) == '/') {
                lastSlashIndex = i2;
            }
            --i2;
        }
        file = lastSlashIndex == -1 ? "" : file.substring(0, lastSlashIndex + 1);
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        catch (MalformedURLException e2) {
            Assert.isTrue(false, e2.getMessage());
        }
        return url;
    }

    public static URL getRoot(String urlString) throws MalformedURLException {
        return URLTool.getRoot(new URL(urlString));
    }

    public static URL getRoot(URL url) {
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static URL removeTrailingSlash(URL url) {
        String file = url.getFile();
        if (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e2) {
                Assert.isTrue(false, e2.getMessage());
            }
        } else {
            return url;
        }
        return null;
    }

    public static boolean urlsOverlap(URL url1, URL url2) {
        if (!URLTool.getRoot(url1).equals(URLTool.getRoot(url2))) {
            return false;
        }
        Vector elements1 = URLTool.getElements(url1);
        Vector elements2 = URLTool.getElements(url2);
        int i2 = 0;
        while (i2 < elements1.size() && i2 < elements2.size()) {
            String element2;
            String element1 = (String)elements1.elementAt(i2);
            if (!element1.equals(element2 = (String)elements2.elementAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

