/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class BasicNotifierImpl
implements Notifier {
    public EList eAdapters() {
        return ECollections.EMPTY_ELIST;
    }

    protected BasicEList eBasicAdapters() {
        return null;
    }

    public boolean eDeliver() {
        return false;
    }

    public void eSetDeliver(boolean deliver) {
        throw new UnsupportedOperationException();
    }

    public void eNotify(Notification notification) {
        int size;
        if (this.eDeliver() && this.eBasicAdapters() != null && (size = this.eBasicAdapters().size()) > 0) {
            Adapter[] adapters = (Adapter[])this.eBasicAdapters().data();
            int i2 = 0;
            while (i2 < size) {
                adapters[i2].notifyChanged(notification);
                ++i2;
            }
        }
    }

    public boolean eNotificationRequired() {
        BasicEList eAdapters = this.eBasicAdapters();
        return eAdapters != null && this.eDeliver() && !eAdapters.isEmpty();
    }

    public static class EAdapterList
    extends BasicEList {
        protected Notifier notifier;
        protected boolean safe;

        public EAdapterList(Notifier notifier) {
            this.notifier = notifier;
        }

        protected boolean canContainNull() {
            return false;
        }

        protected boolean useEquals() {
            return false;
        }

        protected Object[] newData(int capacity) {
            return new Adapter[capacity];
        }

        protected void didAdd(int index, Object newObject) {
            Adapter adapter = (Adapter)newObject;
            adapter.setTarget(this.notifier);
        }

        protected void didRemove(int index, Object oldObject) {
            Adapter adapter = (Adapter)oldObject;
            if (this.notifier.eDeliver()) {
                NotificationImpl notification = new NotificationImpl(this, 8, oldObject, null, index){
                    final /* synthetic */ EAdapterList this$1;
                    {
                        this.this$1 = eAdapterList;
                    }

                    public Object getNotifier() {
                        return this.this$1.notifier;
                    }
                };
                adapter.notifyChanged(notification);
            }
            if (adapter instanceof Adapter.Internal) {
                ((Adapter.Internal)adapter).unsetTarget(this.notifier);
            } else if (adapter.getTarget() == this.notifier) {
                adapter.setTarget(null);
            }
        }

        public Object[] data() {
            this.safe = true;
            return (Adapter[])this.data;
        }

        protected void ensureSafety() {
            if (this.safe && this.data != null) {
                Object[] oldData = this.data;
                this.data = this.newData(this.data.length);
                System.arraycopy(oldData, 0, this.data, 0, this.size);
                this.safe = false;
            }
        }

        public boolean add(Object object) {
            this.ensureSafety();
            return super.add(object);
        }

        public void add(int index, Object object) {
            this.ensureSafety();
            super.add(index, object);
        }

        public boolean addAll(Collection collection) {
            this.ensureSafety();
            return super.addAll(collection);
        }

        public boolean remove(Object object) {
            this.ensureSafety();
            return super.remove(object);
        }

        public Object remove(int index) {
            this.ensureSafety();
            return super.remove(index);
        }

        public boolean removeAll(Collection collection) {
            this.ensureSafety();
            return super.removeAll(collection);
        }

        public void clear() {
            this.ensureSafety();
            super.clear();
        }

        public boolean retainAll(Collection collection) {
            this.ensureSafety();
            return super.retainAll(collection);
        }

        public Object set(int index, Object object) {
            this.ensureSafety();
            return super.set(index, object);
        }

        public void move(int newPosition, Object object) {
            this.ensureSafety();
            super.move(newPosition, object);
        }

        public Object move(int newPosition, int oldPosition) {
            this.ensureSafety();
            return super.move(newPosition, oldPosition);
        }
    }
}

