/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class ETypedElementImpl
extends ENamedElementImpl
implements ETypedElement {
    protected static final boolean ORDERED_EDEFAULT = true;
    protected static final int ORDERED_EFLAG = 256;
    protected static final boolean UNIQUE_EDEFAULT = true;
    protected static final int UNIQUE_EFLAG = 512;
    protected static final int LOWER_BOUND_EDEFAULT = 0;
    protected int lowerBound = 0;
    protected static final int UPPER_BOUND_EDEFAULT = 1;
    protected int upperBound = 1;
    protected static final boolean MANY_EDEFAULT = false;
    protected static final boolean REQUIRED_EDEFAULT = false;
    protected EClassifier eType = null;

    protected ETypedElementImpl() {
        this.eFlags |= 0x100;
        this.eFlags |= 0x200;
    }

    public void freeze() {
        this.getEType();
        super.freeze();
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getETypedElement();
    }

    public boolean isOrdered() {
        return (this.eFlags & 0x100) != 0;
    }

    public void setOrdered(boolean newOrdered) {
        boolean oldOrdered;
        boolean bl = oldOrdered = (this.eFlags & 0x100) != 0;
        this.eFlags = newOrdered ? (this.eFlags |= 0x100) : (this.eFlags &= 0xFFFFFEFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, oldOrdered, newOrdered));
        }
    }

    public boolean isUnique() {
        return (this.eFlags & 0x200) != 0;
    }

    public void setUnique(boolean newUnique) {
        boolean oldUnique;
        boolean bl = oldUnique = (this.eFlags & 0x200) != 0;
        this.eFlags = newUnique ? (this.eFlags |= 0x200) : (this.eFlags &= 0xFFFFFDFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, oldUnique, newUnique));
        }
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int newLowerBound) {
        int oldLowerBound = this.lowerBound;
        this.lowerBound = newLowerBound;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 4, oldLowerBound, this.lowerBound));
        }
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int newUpperBound) {
        int oldUpperBound = this.upperBound;
        this.upperBound = newUpperBound;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, oldUpperBound, this.upperBound));
        }
    }

    public boolean isMany() {
        int upper = this.getUpperBound();
        return upper > 1 || upper == -1;
    }

    public boolean isRequired() {
        int lower = this.getLowerBound();
        return lower >= 1;
    }

    public EClassifier getETypeGen() {
        if (this.eType != null && this.eType.eIsProxy()) {
            EClassifier oldEType = this.eType;
            this.eType = (EClassifier)this.eResolveProxy((InternalEObject)((Object)this.eType));
            if (this.eType != oldEType && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldEType, (Object)this.eType));
            }
        }
        return this.eType;
    }

    public EClassifier getEType() {
        return this.isFrozen() ? this.eType : this.getETypeGen();
    }

    public EClassifier basicGetEType() {
        return this.eType;
    }

    public void setEType(EClassifier newEType) {
        EClassifier oldEType = this.eType;
        this.eType = newEType;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldEType, (Object)this.eType));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return new Integer(this.getLowerBound());
            }
            case 5: {
                return new Integer(this.getUpperBound());
            }
            case 6: {
                return this.isMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                if (resolve) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return !((this.eFlags & 0x100) != 0);
            }
            case 3: {
                return !((this.eFlags & 0x200) != 0);
            }
            case 4: {
                return this.lowerBound != 0;
            }
            case 5: {
                return this.upperBound != 1;
            }
            case 6: {
                return this.isMany();
            }
            case 7: {
                return this.isRequired();
            }
            case 8: {
                return this.eType != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (ordered: ");
        result.append((this.eFlags & 0x100) != 0);
        result.append(", unique: ");
        result.append((this.eFlags & 0x200) != 0);
        result.append(", lowerBound: ");
        result.append(this.lowerBound);
        result.append(", upperBound: ");
        result.append(this.upperBound);
        result.append(')');
        return result.toString();
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setOrdered((Boolean)newValue);
                return;
            }
            case 3: {
                this.setUnique((Boolean)newValue);
                return;
            }
            case 4: {
                this.setLowerBound((Integer)newValue);
                return;
            }
            case 5: {
                this.setUpperBound((Integer)newValue);
                return;
            }
            case 8: {
                this.setEType((EClassifier)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setOrdered(true);
                return;
            }
            case 3: {
                this.setUnique(true);
                return;
            }
            case 4: {
                this.setLowerBound(0);
                return;
            }
            case 5: {
                this.setUpperBound(1);
                return;
            }
            case 8: {
                this.setEType(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }
}

