/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.adaptor.core.SignedBundle;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.protocol.bundleentry.Handler;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class AbstractBundleData
implements BundleData,
Cloneable {
    protected AbstractFrameworkAdaptor adaptor;
    protected Dictionary manifest = null;
    protected Bundle bundle;
    protected long id;
    protected File bundleStoreDir;
    protected BundleFile baseBundleFile;
    private String location;
    private String fileName;
    private String[] nativePaths;
    private int generation = 1;
    private int startLevel = -1;
    protected File dirData;
    private int status = 0;
    private boolean reference;
    private long lastModified;
    private String symbolicName;
    private Version version;
    private String activator;
    private String classpath;
    private String executionEnvironment;
    private String dynamicImports;
    private int type;

    public AbstractBundleData(AbstractFrameworkAdaptor adaptor, long id) {
        this.adaptor = adaptor;
        this.id = id;
        this.initBundleStoreDirs(String.valueOf(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getManifest() throws BundleException {
        if (this.manifest == null) {
            AbstractBundleData abstractBundleData = this;
            synchronized (abstractBundleData) {
                if (this.manifest == null) {
                    URL url = this.getEntry("META-INF/MANIFEST.MF");
                    if (url == null) {
                        throw new BundleException(NLS.bind(AdaptorMsg.MANIFEST_NOT_FOUND_EXCEPTION, "META-INF/MANIFEST.MF", this.getLocation()));
                    }
                    try {
                        this.manifest = Headers.parseManifest(url.openStream());
                    }
                    catch (IOException e2) {
                        throw new BundleException(NLS.bind(AdaptorMsg.MANIFEST_NOT_FOUND_EXCEPTION, "META-INF/MANIFEST.MF", this.getLocation()), e2);
                    }
                }
            }
        }
        return this.manifest;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getBundleID() {
        return this.id;
    }

    public URL getEntry(String path) {
        BundleEntry entry = this.getBaseBundleFile().getEntry(path);
        if (entry == null) {
            return null;
        }
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("bundleentry", Long.toString(this.id), 0, path, new Handler(entry));
        }
        catch (MalformedURLException e2) {
            return null;
        }
    }

    public Enumeration getEntryPaths(String path) {
        return this.getBaseBundleFile().getEntryPaths(path);
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, BundleProtectionDomain domain, String[] bundleclasspath) {
        return this.getAdaptor().getElementFactory().createClassLoader(delegate, domain, bundleclasspath, this);
    }

    public AbstractFrameworkAdaptor getAdaptor() {
        return this.adaptor;
    }

    static String[] getClassPath(ManifestElement[] classpath) {
        if (classpath == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  no classpath");
            }
            return new String[]{"."};
        }
        ArrayList<String> result = new ArrayList<String>(classpath.length);
        for (int i2 = 0; i2 < classpath.length; ++i2) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  found classpath entry " + classpath[i2].getValueComponents());
            }
            String[] paths = classpath[i2].getValueComponents();
            for (int j2 = 0; j2 < paths.length; ++j2) {
                result.add(paths[j2]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[] getNativePaths() {
        return this.nativePaths;
    }

    public String getNativePathsString() {
        if (this.nativePaths == null || this.nativePaths.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.nativePaths.length; ++i2) {
            sb.append(this.nativePaths[i2]);
            if (i2 >= this.nativePaths.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void setNativePaths(String[] nativePaths) {
        this.nativePaths = nativePaths;
    }

    public void setNativePaths(String nativePaths) {
        if (nativePaths == null) {
            return;
        }
        ArrayList<String> result = new ArrayList<String>(5);
        StringTokenizer st = new StringTokenizer(nativePaths, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            result.add(path);
        }
        this.setNativePaths(result.toArray(new String[result.size()]));
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public File getBundleStoreDir() {
        return this.bundleStoreDir;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void loadFromManifest() throws BundleException {
        this.getManifest();
        if (this.manifest == null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_ERROR_GETTING_MANIFEST, this.getLocation()));
        }
        this.setVersion(Version.parseVersion((String)this.manifest.get("Bundle-Version")));
        ManifestElement[] bsnHeader = ManifestElement.parseHeader("Bundle-SymbolicName", (String)this.manifest.get("Bundle-SymbolicName"));
        int bundleType = 0;
        if (bsnHeader != null) {
            this.setSymbolicName(bsnHeader[0].getValue());
            String singleton = bsnHeader[0].getDirective("singleton");
            if (singleton == null) {
                singleton = bsnHeader[0].getAttribute("singleton");
            }
            if ("true".equals(singleton)) {
                bundleType |= 8;
            }
        }
        this.setClassPathString((String)this.manifest.get("Bundle-ClassPath"));
        this.setActivator((String)this.manifest.get("Bundle-Activator"));
        String host = (String)this.manifest.get("Fragment-Host");
        if (host != null) {
            bundleType |= 1;
            ManifestElement[] hostElement = ManifestElement.parseHeader("Fragment-Host", host);
            if (Constants.getInternalSymbolicName().equals(hostElement[0].getValue()) || "system.bundle".equals(hostElement[0].getValue())) {
                String extensionType = hostElement[0].getDirective("extension");
                bundleType = extensionType == null || extensionType.equals("framework") ? (bundleType |= 2) : (bundleType |= 4);
            }
        }
        this.setType(bundleType);
        this.setExecutionEnvironment((String)this.manifest.get("Bundle-RequiredExecutionEnvironment"));
        this.setDynamicImports((String)this.manifest.get("DynamicImport-Package"));
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getActivator() {
        return this.activator;
    }

    protected File getDataDir() {
        return this.dirData;
    }

    protected void setBundleStoreDir(File bundleStoreDir) {
        this.bundleStoreDir = bundleStoreDir;
    }

    protected void initBundleStoreDirs(String bundleID) {
        this.setBundleStoreDir(new File(this.adaptor.getBundleStoreRootDir(), bundleID));
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    public String[] getClassPath() throws BundleException {
        ManifestElement[] classpathElements = ManifestElement.parseHeader("Bundle-ClassPath", this.classpath);
        return AbstractBundleData.getClassPath(classpathElements);
    }

    public String getClassPathString() {
        return this.classpath;
    }

    public void setClassPathString(String classpath) {
        this.classpath = classpath;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getDynamicImports() {
        return this.dynamicImports;
    }

    public void setDynamicImports(String dynamicImports) {
        this.dynamicImports = dynamicImports;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean matchDNChain(String pattern) {
        if (System.getSecurityManager() == null) {
            return false;
        }
        if (this.getBaseBundleFile() instanceof SignedBundle) {
            return ((SignedBundle)this.getBaseBundleFile()).matchDNChain(pattern);
        }
        return false;
    }

    protected AbstractBundleData nextGeneration(String referenceFile) throws IOException {
        int nextGeneration = this.getGeneration();
        while (nextGeneration < Integer.MAX_VALUE) {
            AbstractBundleData next;
            File nextDirGeneration = new File(this.getBundleStoreDir(), String.valueOf(++nextGeneration));
            if (nextDirGeneration.exists()) continue;
            try {
                next = (AbstractBundleData)this.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new InternalError();
            }
            next.setGeneration(nextGeneration);
            if (referenceFile != null) {
                next.setReference(true);
                next.setFileName(referenceFile);
            } else if (next.isReference()) {
                next.setReference(false);
                next.setFileName("bundlefile");
            }
            next.manifest = null;
            return next;
        }
        throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
    }

    public void initializeNewBundle() throws IOException, BundleException {
        this.createBaseBundleFile();
        this.loadFromManifest();
    }

    protected BundleFile createBaseBundleFile() throws IOException {
        this.baseBundleFile = this.getAdaptor().createBaseBundleFile(this.getBaseFile(), this);
        return this.baseBundleFile;
    }

    protected File getBaseFile() {
        return this.isReference() ? new File(this.getFileName()) : new File(this.createGenerationDir(), this.getFileName());
    }

    protected File[] getClasspathFiles(String[] classpaths) {
        ArrayList<File> results = new ArrayList<File>(classpaths.length);
        for (int i2 = 0; i2 < classpaths.length; ++i2) {
            if (".".equals(classpaths[i2])) {
                results.add(this.getBaseFile());
                continue;
            }
            File result = this.getBaseBundleFile().getFile(classpaths[i2]);
            if (result == null) continue;
            results.add(result);
        }
        return results.toArray(new File[results.size()]);
    }

    protected void setDataDir(File dirData) {
        this.dirData = dirData;
    }

    public String findLibrary(String libname) {
        String mappedName = System.mapLibraryName(libname);
        String path = null;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  mapped library name: " + mappedName);
        }
        if ((path = this.findNativePath(mappedName)) == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  library does not exist: " + mappedName);
            }
            path = this.findNativePath(libname);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("  returning library: " + path);
        }
        return path;
    }

    public void open() throws IOException {
        this.baseBundleFile.open();
    }

    protected String findNativePath(String libname) {
        String[] nativepaths;
        if (!libname.startsWith("/")) {
            libname = '/' + libname;
        }
        if ((nativepaths = this.getNativePaths()) != null) {
            for (int i2 = 0; i2 < nativepaths.length; ++i2) {
                File nativeFile;
                if (!nativepaths[i2].endsWith(libname) || (nativeFile = this.baseBundleFile.getFile(nativepaths[i2])) == null) continue;
                return nativeFile.getAbsolutePath();
            }
        }
        return null;
    }

    public File createGenerationDir() {
        File generationDir = this.getGenerationDir();
        if (!(generationDir.exists() || this.adaptor.canWrite() && generationDir.mkdirs() || !Debug.DEBUG_GENERAL)) {
            Debug.println("Unable to create bundle generation directory: " + generationDir.getPath());
        }
        return generationDir;
    }

    public BundleFile getBaseBundleFile() {
        return this.baseBundleFile;
    }

    public void close() throws IOException {
        if (this.baseBundleFile != null) {
            this.baseBundleFile.close();
        }
    }

    public File getDataFile(String path) {
        if (this.getDataDir() == null) {
            File dataRoot = this.adaptor.getDataRootDir();
            if (dataRoot == null) {
                throw new IllegalStateException(AdaptorMsg.ADAPTOR_DATA_AREA_NOT_SET);
            }
            this.setDataDir(new File(dataRoot, this.id + "/" + "data"));
        }
        if (!(this.getDataDir().exists() || this.adaptor.canWrite() && this.getDataDir().mkdirs() || !Debug.DEBUG_GENERAL)) {
            Debug.println("Unable to create bundle data directory: " + this.getDataDir().getPath());
        }
        return new File(this.getDataDir(), path);
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < nativepaths.length; ++i2) {
            File nativeFile = this.baseBundleFile.getFile(nativepaths[i2]);
            if (nativeFile == null) {
                throw new BundleException(NLS.bind(AdaptorMsg.BUNDLE_NATIVECODE_EXCEPTION, nativepaths[i2]));
            }
            sb.append(nativepaths[i2]);
            if (i2 >= nativepaths.length - 1) continue;
            sb.append(",");
        }
        if (sb.length() > 0) {
            this.setNativePaths(sb.toString());
        }
    }

    protected File getGenerationDir() {
        return new File(this.getBundleStoreDir(), String.valueOf(this.getGeneration()));
    }

    public File getParentGenerationDir() {
        return null;
    }
}

