/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.proxy != null) {
                Debug.println("Bundle.load called when proxy != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        this.proxy = null;
    }

    protected boolean reload(AbstractBundle newBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader().createClassLoader();
                } else {
                    BundleHost.closeBundleLoader(this.proxy);
                }
                this.state = 2;
                this.proxy = null;
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return exporting;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleHost.closeBundleLoader(this.proxy);
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.state == 4) {
            BundleLoaderProxy curProxy = this.getLoaderProxy();
            exporting = curProxy.inUse();
            if (exporting) {
                curProxy.getBundleLoader().createClassLoader();
            } else {
                BundleHost.closeBundleLoader(this.proxy);
            }
            this.state = 2;
            this.proxy = null;
            this.fragments = null;
            this.domain = null;
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return exporting;
    }

    private BundleLoader checkLoader() {
        BundleLoader loader;
        this.checkValid();
        if (!this.isResolved() && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            return null;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.checkLoader() called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if ((loader = this.getBundleLoader()) == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.checkLoader() called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return loader;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        BundleLoader loader;
        if (checkPermission) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException e2) {
                throw new ClassNotFoundException();
            }
        }
        if ((loader = this.checkLoader()) == null) {
            throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_CNFE_NOT_RESOLVED, this.getLocation(), name));
        }
        return loader.loadClass(name);
    }

    public URL getResource(String name) {
        BundleLoader loader = null;
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e2) {
            try {
                this.framework.checkAdminPermission(this, "resource");
            }
            catch (SecurityException ee) {
                return null;
            }
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        BundleLoader loader = null;
        try {
            this.checkResourcePermission();
        }
        catch (SecurityException e2) {
            try {
                this.framework.checkAdminPermission(this, "resource");
            }
            catch (SecurityException ee) {
                return null;
            }
        }
        loader = this.checkLoader();
        if (loader == null) {
            return null;
        }
        return loader.getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startWorker(boolean persistent) throws BundleException {
        long start = 0L;
        if (this.framework.active) {
            if ((this.state & 0x28) != 0) {
                return;
            }
            try {
                if (this.state == 2 && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
                    throw new BundleException(this.getResolutionFailureMessage());
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Bundle: Active sl = " + this.framework.startLevelManager.getStartLevel() + "; Bundle " + this.getBundleId() + " sl = " + this.getStartLevel());
                }
                if (this.getStartLevel() <= this.framework.startLevelManager.getStartLevel()) {
                    BundleWatcher bundleStats;
                    if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                        bundleStats.startActivation(this);
                    }
                    if (Debug.DEBUG_BUNDLE_TIME) {
                        start = System.currentTimeMillis();
                        System.out.println("Starting " + this.getSymbolicName());
                    }
                    this.state = 8;
                    this.context = this.createContext();
                    try {
                        this.context.start();
                        if (this.framework.active) {
                            this.state = 32;
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("->started " + this);
                            }
                            this.framework.publishBundleEvent(2, this);
                        }
                    }
                    catch (BundleException e2) {
                        this.context.close();
                        this.context = null;
                        this.state = 4;
                        throw e2;
                    }
                    if (this.state == 1) {
                        this.context.close();
                        this.context = null;
                        throw new BundleException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getLocation()));
                    }
                }
                Object var6_5 = null;
                if (this.state == 32) {
                    BundleWatcher bundleStats;
                    if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                        bundleStats.endActivation(this);
                    }
                    if (Debug.DEBUG_BUNDLE_TIME) {
                        System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - start));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.state == 32) {
                    BundleWatcher bundleStats;
                    if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                        bundleStats.endActivation(this);
                    }
                    if (Debug.DEBUG_BUNDLE_TIME) {
                        System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - start));
                    }
                }
                throw throwable;
            }
        }
        if (persistent) {
            this.setStatus(1, true);
        }
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    protected BundleContextImpl getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopWorker(boolean persistent) throws BundleException {
        if (persistent) {
            this.setStatus(1, false);
        }
        if (this.framework.active) {
            if ((this.state & 0x16) != 0) {
                return;
            }
            this.state = 16;
            try {
                this.context.stop();
                Object var3_2 = null;
                this.context.close();
                this.context = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.context.close();
                this.context = null;
                this.checkValid();
                this.state = 4;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("->stopped " + this);
                }
                this.framework.publishBundleEvent(4, this);
                throw throwable;
            }
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            {
            }
        }
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            if (this.fragments == null) {
                return null;
            }
            Bundle[] result = new Bundle[this.fragments.length];
            System.arraycopy(this.fragments, 0, result, 0, result.length);
            return result;
        }
    }

    protected void attachFragment(BundleFragment fragment) throws BundleException {
        BundleLoader loader = this.getLoaderProxy().getBasicBundleLoader();
        if (loader != null) {
            loader.attachFragment(fragment);
        }
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{fragment};
        } else {
            boolean inserted = false;
            BundleFragment[] newFragments = new BundleFragment[this.fragments.length + 1];
            for (int i2 = 0; i2 < this.fragments.length; ++i2) {
                if (fragment == this.fragments[i2]) {
                    return;
                }
                if (!inserted && fragment.getBundleId() < this.fragments[i2].getBundleId()) {
                    if (loader != null) {
                        throw new BundleException(NLS.bind(Msg.BUNDLE_LOADER_ATTACHMENT_ERROR, this.fragments[i2].getSymbolicName(), this.getSymbolicName()));
                    }
                    newFragments[i2] = fragment;
                    inserted = true;
                }
                newFragments[inserted ? i2 + 1 : i2] = this.fragments[i2];
            }
            if (!inserted) {
                newFragments[newFragments.length - 1] = fragment;
            }
            this.fragments = newFragments;
        }
    }

    protected BundleLoader getBundleLoader() {
        return this.getLoaderProxy().getBundleLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleLoaderProxy getLoaderProxy() {
        if (this.proxy == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.proxy == null) {
                    BundleDescription bundleDescription = this.getBundleDescription();
                    this.proxy = new BundleLoaderProxy(this, bundleDescription);
                    bundleDescription.setUserObject(this.proxy);
                }
            }
        }
        return this.proxy;
    }

    static void closeBundleLoader(BundleLoaderProxy proxy) {
        if (proxy == null) {
            return;
        }
        BundleLoader loader = proxy.getBasicBundleLoader();
        if (loader != null) {
            loader.close();
        }
        proxy.setStale();
        BundleDescription description = proxy.getBundleDescription();
        description.setUserObject(null);
    }
}

