/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> allExports = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] allDescriptions = this.framework.adaptor.getState().getExportedPackages();
            for (int i2 = 0; i2 < allDescriptions.length; ++i2) {
                ExportedPackageImpl exportedPackage;
                if (!allDescriptions[i2].isRoot() || (exportedPackage = this.createExportedPackage(allDescriptions[i2])) == null || bundle != null && exportedPackage.supplier.getBundle() != bundle) continue;
                allExports.add(exportedPackage);
            }
        }
        return allExports.size() == 0 ? null : allExports.toArray(new ExportedPackage[allExports.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription description) {
        BundleDescription exporter = description.getExporter();
        if (exporter == null || exporter.getHost() != null) {
            return null;
        }
        BundleLoaderProxy proxy = (BundleLoaderProxy)exporter.getUserObject();
        if (proxy == null) {
            BundleHost bundle = (BundleHost)this.framework.getBundle(exporter.getBundleId());
            if (bundle == null) {
                return null;
            }
            proxy = bundle.getLoaderProxy();
        }
        return new ExportedPackageImpl(description, proxy);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ExportedPackage result = null;
        for (int i2 = 0; i2 < allExports.length; ++i2) {
            if (!name.equals(allExports[i2].getName())) continue;
            if (result == null) {
                result = allExports[i2];
                continue;
            }
            Version curVersion = Version.parseVersion(result.getSpecificationVersion());
            Version newVersion = Version.parseVersion(allExports[i2].getSpecificationVersion());
            if (newVersion.compareTo(curVersion) < 0) continue;
            result = allExports[i2];
        }
        return result;
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>(1);
        for (int i2 = 0; i2 < allExports.length; ++i2) {
            if (!name.equals(allExports[i2].getName())) continue;
            result.add(allExports[i2]);
        }
        return result.size() == 0 ? null : result.toArray(new ExportedPackage[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            copy = new AbstractBundle[input.length];
            System.arraycopy(input, 0, copy, 0, input.length);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = this.framework.secureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.doResolveBundles(bundles, true);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    public boolean resolveBundles(Bundle[] bundles) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundles == null) {
            bundles = this.framework.getAllBundles();
        }
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (((AbstractBundle)bundles[i2]).isResolved()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doResolveBundles(AbstractBundle[] bundles, boolean refreshPackages) {
        try {
            block20: {
                try {
                    this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                    AbstractBundle[] refreshedBundles = null;
                    BundleDescription[] descriptions = null;
                    BundleRepository bundleRepository = this.framework.bundles;
                    synchronized (bundleRepository) {
                        int numBundles;
                        int n2 = numBundles = bundles == null ? 0 : bundles.length;
                        if (!refreshPackages) {
                            descriptions = new BundleDescription[]{};
                        } else if (numBundles > 0) {
                            ArrayList<BundleDescription> results = new ArrayList<BundleDescription>(numBundles);
                            for (int i2 = 0; i2 < numBundles; ++i2) {
                                AbstractBundle[] sameNames;
                                BundleDescription description = bundles[i2].getBundleDescription();
                                if (description != null && description.getBundleId() != 0L && !results.contains(description)) {
                                    results.add(description);
                                }
                                if ((sameNames = this.framework.bundles.getBundles(bundles[i2].getSymbolicName())) == null || sameNames.length <= 1) continue;
                                for (int j2 = 0; j2 < sameNames.length; ++j2) {
                                    BundleDescription sameName;
                                    if (sameNames[j2] == bundles[i2] || (sameName = sameNames[j2].getBundleDescription()) == null || sameName.getBundleId() == 0L || !sameName.isSingleton() || results.contains(sameName)) continue;
                                    results.add(sameName);
                                }
                            }
                            descriptions = results.size() == 0 ? null : results.toArray(new BundleDescription[results.size()]);
                        }
                    }
                    StateDelta stateDelta = this.framework.adaptor.getState().resolve(descriptions);
                    refreshedBundles = this.processDelta(stateDelta.getChanges(), refreshPackages);
                    if (!refreshPackages) break block20;
                    AbstractBundle[] allBundles = this.framework.getAllBundles();
                    for (int i3 = 0; i3 < allBundles.length; ++i3) {
                        allBundles[i3].unresolvePermissions(refreshedBundles);
                    }
                    this.resumeBundles(refreshedBundles);
                }
                catch (Throwable t2) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                        Debug.printStackTrace(t2);
                    }
                    if (t2 instanceof RuntimeException) {
                        throw (RuntimeException)t2;
                    }
                    if (t2 instanceof Error) {
                        throw (Error)t2;
                    }
                    Object var15_18 = null;
                    this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                    if (refreshPackages) {
                        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                    }
                }
            }
            Object var15_17 = null;
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (refreshPackages) {
                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (refreshPackages) {
                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            }
            throw throwable;
        }
    }

    private void resumeBundles(AbstractBundle[] bundles) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (bundles == null) {
            return;
        }
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (!bundles[i2].isResolved()) continue;
            this.framework.resumeBundle(bundles[i2]);
        }
    }

    private void suspendBundle(AbstractBundle bundle) throws BundleException {
        if (bundle.isActive() && !bundle.isFragment()) {
            boolean suspended = this.framework.suspendBundle(bundle, true);
            if (!suspended) {
                throw new BundleException(Msg.BUNDLE_STATE_CHANGE_EXCEPTION);
            }
        } else if (bundle.getStateChanging() != Thread.currentThread()) {
            bundle.beginStateChange();
        }
        if (Debug.DEBUG_PACKAGEADMIN && bundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + bundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundle = bundleDelta.getBundle();
            if (bundle.getDependents() != null && bundle.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundle);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            BundleLoaderProxy proxy = (BundleLoaderProxy)bundle.getUserObject();
            if (proxy != null) {
                BundleHost.closeBundleLoader(proxy);
                try {
                    proxy.getBundleHost().getBundleData().close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle bundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (bundle == null) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            return null;
        }
        boolean resolve = true;
        if (bundle.isFragment()) {
            BundleDescription[] hosts = bundleDescription.getHost().getHosts();
            for (int i2 = 0; i2 < hosts.length; ++i2) {
                BundleHost host = (BundleHost)this.framework.getBundle(hosts[i2].getBundleId());
                resolve = ((BundleFragment)bundle).addHost(host.getLoaderProxy());
            }
        }
        if (resolve) {
            bundle.resolve();
        }
        return bundle;
    }

    private AbstractBundle[] applyDeltas(BundleDelta[] bundleDeltas) throws BundleException {
        ArrayList<AbstractBundle> results = new ArrayList<AbstractBundle>(bundleDeltas.length);
        for (int i2 = 0; i2 < bundleDeltas.length; ++i2) {
            AbstractBundle bundle;
            int type = bundleDeltas[i2].getType();
            if ((type & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltas[i2]);
            }
            if ((type & 8) == 0 || (bundle = this.setResolved(bundleDeltas[i2].getBundle())) == null || !bundle.isResolved()) continue;
            results.add(bundle);
        }
        return results.size() == 0 ? null : results.toArray(new AbstractBundle[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBundle[] processDelta(BundleDelta[] bundleDeltas, boolean refreshPackages) {
        Util.sort(bundleDeltas, 0, bundleDeltas.length);
        ArrayList<AbstractBundle> bundlesList = new ArrayList<AbstractBundle>(bundleDeltas.length);
        for (int i2 = 0; i2 < bundleDeltas.length; ++i2) {
            AbstractBundle changedBundle = this.framework.getBundle(bundleDeltas[i2].getBundle().getBundleId());
            if (changedBundle == null) continue;
            bundlesList.add(changedBundle);
        }
        AbstractBundle[] refresh = bundlesList.toArray(new AbstractBundle[bundlesList.size()]);
        boolean[] previouslyResolved = new boolean[refresh.length];
        AbstractBundle[] resolved = null;
        try {
            block37: {
                try {
                    int i3;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                    }
                    boolean restart = false;
                    for (i3 = refresh.length - 1; i3 >= 0; --i3) {
                        previouslyResolved[i3] = refresh[i3].isResolved();
                        if (refresh[i3] == this.framework.systemBundle) {
                            restart = true;
                            continue;
                        }
                        if ((refresh[i3].bundledata.getType() & 2) != 0 && previouslyResolved[i3]) {
                            restart = true;
                            continue;
                        }
                        if ((refresh[i3].bundledata.getType() & 4) == 0) continue;
                        restart = true;
                    }
                    if (restart) {
                        if (refreshPackages) {
                            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                        }
                        this.restartFramework();
                    }
                    if (refreshPackages) {
                        for (i3 = refresh.length - 1; i3 >= 0; --i3) {
                            this.suspendBundle(refresh[i3]);
                        }
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: refresh the bundles");
                    }
                    BundleRepository i4 = this.framework.bundles;
                    synchronized (i4) {
                        for (int i5 = 0; i5 < refresh.length; ++i5) {
                            refresh[i5].refresh();
                        }
                    }
                    for (int i6 = 0; i6 < refresh.length; ++i6) {
                        if (!previouslyResolved[i6]) continue;
                        this.framework.publishBundleEvent(64, refresh[i6]);
                    }
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: applying deltas to bundles");
                    }
                    BundleRepository bundleRepository = this.framework.bundles;
                    synchronized (bundleRepository) {
                        resolved = this.applyDeltas(bundleDeltas);
                    }
                    Object var13_19 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block37;
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    if (refreshPackages) {
                        for (int i7 = 0; i7 < refresh.length; ++i7) {
                            AbstractBundle changedBundle = refresh[i7];
                            changedBundle.completeStateChange();
                        }
                    }
                    throw throwable;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            if (refreshPackages) {
                for (int i7 = 0; i7 < refresh.length; ++i7) {
                    AbstractBundle changedBundle = refresh[i7];
                    changedBundle.completeStateChange();
                }
            }
            if (refreshPackages) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException e2) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + e2.getMessage());
                        Debug.printStackTrace(e2);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e2));
                }
            }
        }
        catch (BundleException e3) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e3.getMessage());
                Debug.printStackTrace(e3.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, e3));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        if (resolved != null) {
            for (int i8 = 0; i8 < resolved.length; ++i8) {
                this.framework.publishBundleEvent(32, (Bundle)resolved[i8]);
            }
        }
        return refresh;
    }

    private void restartFramework() {
        System.getProperties().put("osgi.forcedRestart", "true");
        this.framework.shutdown();
        System.exit(23);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        AbstractBundle[] bundles = symbolicName == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null || bundles.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> result = new ArrayList<BundleLoaderProxy>(bundles.length);
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (bundles[i2].isFragment() || !bundles[i2].isResolved() || bundles[i2].getSymbolicName() == null) continue;
            result.add(((BundleHost)bundles[i2]).getLoaderProxy());
        }
        return result.size() == 0 ? null : result.toArray(new RequiredBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (!range.isIncluded(bundles[i2].getVersion())) continue;
            result.add(bundles[i2]);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] hosts = ((AbstractBundle)bundle).getHosts();
        if (hosts == null) {
            return null;
        }
        Bundle[] result = new Bundle[hosts.length];
        for (int i2 = 0; i2 < hosts.length; ++i2) {
            result[i2] = hosts[i2].getBundleHost();
        }
        return result;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)cl)).getDelegate()).bundle;
        }
        if (cl == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PackageAdminImpl.this.getBundlePriv(clazz);
            }
        });
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        this.checkSystemBundle(systemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        for (int i2 = 0; i2 < descriptions.length; ++i2) {
            long bundleId = descriptions[i2].getBundleId();
            if (bundleId == 0L) continue;
            this.setResolved(descriptions[i2]);
        }
    }

    private void checkSystemBundle(SystemBundle systemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription newSystemBundle = state.getFactory().createBundleDescription(state, systemBundle.getHeaders(""), systemBundle.getLocation(), 0L);
            if (newSystemBundle == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            BundleDescription oldSystemBundle = state.getBundle(0L);
            if (oldSystemBundle != null) {
                ExportPackageDescription[] newPackages;
                ExportPackageDescription[] oldPackages;
                boolean different = false;
                if (newSystemBundle.getVersion() != null && !newSystemBundle.getVersion().equals(oldSystemBundle.getVersion())) {
                    different = true;
                }
                if ((oldPackages = oldSystemBundle.getExportPackages()).length >= (newPackages = newSystemBundle.getExportPackages()).length) {
                    for (int i2 = 0; i2 < newPackages.length; ++i2) {
                        if (oldPackages[i2].getName().equals(newPackages[i2].getName())) {
                            Version oldVersion = oldPackages[i2].getVersion();
                            Version newVersion = newPackages[i2].getVersion();
                            if (oldVersion == null) {
                                if (newVersion == null) continue;
                                different = true;
                            } else {
                                if (((Object)oldVersion).equals(newVersion)) continue;
                                different = true;
                            }
                        } else {
                            different = true;
                        }
                        break;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    state.removeBundle(0L);
                    state.addBundle(newSystemBundle);
                    state.resolve(false);
                }
            } else {
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
            ExportPackageDescription[] packages = newSystemBundle.getExportPackages();
            if (packages != null) {
                String[] systemPackages = new String[packages.length];
                for (int i3 = 0; i3 < packages.length; ++i3) {
                    String version;
                    ExportPackageDescription spec = packages[i3];
                    if (spec.getName().equals("org.osgi.framework") && (version = spec.getVersion().toString()) != null) {
                        System.getProperties().put("org.osgi.framework.version", version);
                    }
                    systemPackages[i3] = spec.getName();
                }
            }
        }
        catch (BundleException e2) {
            e2.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, e2.getMessage()));
        }
    }
}

