/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultElementFactory;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultLog;
import org.eclipse.osgi.framework.internal.defaultadaptor.MetaData;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleException;

public class DefaultAdaptor
extends AbstractFrameworkAdaptor {
    public static final String METADATA_ADAPTOR_NEXTID = "METADATA_ADAPTOR_NEXTID";
    public static final String METADATA_ADAPTOR_IBSL = "METADATA_ADAPTOR_IBSL";
    public static final String METADATA_BUNDLE_GEN = "METADATA_BUNDLE_GEN";
    public static final String METADATA_BUNDLE_LOC = "METADATA_BUNDLE_LOC";
    public static final String METADATA_BUNDLE_REF = "METADATA_BUNDLE_REF";
    public static final String METADATA_BUNDLE_NAME = "METADATA_BUNDLE_NAME";
    public static final String METADATA_BUNDLE_NCP = "METADATA_BUNDLE_NCP";
    public static final String METADATA_BUNDLE_ABSL = "METADATA_BUNDLE_ABSL";
    public static final String METADATA_BUNDLE_STATUS = "METADATA_BUNDLE_STATUS";
    public static final String METADATA_BUNDLE_METADATA = "METADATA_BUNDLE_METADATA";
    public static final String METADATA_LAST_MODIFIED = "METADATA_LAST_MODIFIED";
    protected MetaData fwMetadata;

    public DefaultAdaptor(String[] args) {
        super(args);
    }

    public BundleData[] getInstalledBundles() {
        String[] list = this.getBundleStoreRootDir().list();
        if (list == null) {
            return null;
        }
        ArrayList<DefaultBundleData> bundleDatas = new ArrayList<DefaultBundleData>(list.length);
        for (int i2 = 0; i2 < list.length; ++i2) {
            try {
                long id = -1L;
                try {
                    id = Long.parseLong(list[i2]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                DefaultBundleData data = (DefaultBundleData)this.getElementFactory().createBundleData(this, id);
                this.loadMetaDataFor(data);
                data.initializeExistingBundle();
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("BundleData created: " + data);
                }
                this.processExtension(data, (byte)1);
                bundleDatas.add(data);
                continue;
            }
            catch (BundleException e2) {
                if (!Debug.DEBUG_GENERAL) continue;
                Debug.println("Unable to open Bundle[" + list[i2] + "]: " + e2.getMessage());
                Debug.printStackTrace(e2);
                continue;
            }
            catch (IOException e3) {
                if (!Debug.DEBUG_GENERAL) continue;
                Debug.println("Unable to open Bundle[" + list[i2] + "]: " + e3.getMessage());
                Debug.printStackTrace(e3);
            }
        }
        return bundleDatas.toArray(new BundleData[bundleDatas.size()]);
    }

    public void setInitialBundleStartLevel(int value) {
        super.setInitialBundleStartLevel(value);
        try {
            this.persistInitialBundleStartLevel(value);
        }
        catch (IOException e2) {
            this.eventPublisher.publishFrameworkEvent(2, this.context.getBundle(), e2);
        }
    }

    protected void persistInitialBundleStartLevel(int value) throws IOException {
        this.fwMetadata.setInt(METADATA_ADAPTOR_IBSL, value);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DefaultAdaptor.this.fwMetadata.save();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e2) {
            if (e2.getException() instanceof IOException) {
                throw (IOException)e2.getException();
            }
            throw (RuntimeException)e2.getException();
        }
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new DefaultElementFactory();
        }
        return this.elementFactory;
    }

    protected void loadMetaDataFor(DefaultBundleData data) throws IOException {
        MetaData bundleMetaData = new MetaData(new File(data.getBundleStoreDir(), ".bundle"), "Bundle metadata");
        bundleMetaData.load();
        data.setLocation(bundleMetaData.get(METADATA_BUNDLE_LOC, null));
        data.setFileName(bundleMetaData.get(METADATA_BUNDLE_NAME, null));
        data.setGeneration(bundleMetaData.getInt(METADATA_BUNDLE_GEN, -1));
        data.setNativePaths(bundleMetaData.get(METADATA_BUNDLE_NCP, null));
        data.setStartLevel(bundleMetaData.getInt(METADATA_BUNDLE_ABSL, 1));
        data.setStatus(bundleMetaData.getInt(METADATA_BUNDLE_STATUS, 0));
        data.setReference(bundleMetaData.getBoolean(METADATA_BUNDLE_REF, false));
        data.setLastModified(bundleMetaData.getLong(METADATA_LAST_MODIFIED, 0L));
        if (data.getGeneration() == -1 || data.getFileName() == null || data.getLocation() == null) {
            throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
        }
    }

    public void saveMetaDataFor(AbstractBundleData data) throws IOException {
        MetaData bundleMetadata = new MetaData(new File(((DefaultBundleData)data).createBundleStoreDir(), ".bundle"), "Bundle metadata");
        bundleMetadata.load();
        bundleMetadata.set(METADATA_BUNDLE_LOC, data.getLocation());
        bundleMetadata.set(METADATA_BUNDLE_NAME, data.getFileName());
        bundleMetadata.setInt(METADATA_BUNDLE_GEN, data.getGeneration());
        String nativePaths = data.getNativePathsString();
        if (nativePaths != null) {
            bundleMetadata.set(METADATA_BUNDLE_NCP, nativePaths);
        }
        bundleMetadata.setInt(METADATA_BUNDLE_ABSL, data.getStartLevel());
        bundleMetadata.setInt(METADATA_BUNDLE_STATUS, data.getStatus());
        bundleMetadata.setBoolean(METADATA_BUNDLE_REF, data.isReference());
        bundleMetadata.setLong(METADATA_LAST_MODIFIED, data.getLastModified());
        bundleMetadata.save();
    }

    protected void persistNextBundleID(long id) throws IOException {
        this.fwMetadata.setLong(METADATA_ADAPTOR_NEXTID, this.nextId);
        this.fwMetadata.save();
    }

    protected void initializeMetadata() throws IOException {
        this.fwMetadata = new MetaData(this.getMetaDataFile(), "Framework metadata");
        this.fwMetadata.load();
        this.nextId = this.fwMetadata.getLong(METADATA_ADAPTOR_NEXTID, 1L);
        this.initialBundleStartLevel = this.fwMetadata.getInt(METADATA_ADAPTOR_IBSL, 1);
    }

    protected FrameworkLog createFrameworkLog() {
        return new DefaultLog();
    }
}

