/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class Headers
extends Dictionary {
    Object[] headers;
    Object[] values;
    int size = 0;

    public Headers(int initialCapacity) {
        this.headers = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
    }

    public Headers(Dictionary values) {
        this(values.size());
        Enumeration keys = values.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.set(key, values.get(key));
        }
    }

    public synchronized Enumeration keys() {
        return new ArrayEnumeration(this.headers, this.size);
    }

    public synchronized Enumeration elements() {
        return new ArrayEnumeration(this.values, this.size);
    }

    private int getIndex(Object key) {
        boolean stringKey = key instanceof String;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.headers[i2].equals(key)) {
                return i2;
            }
            if (!stringKey || !(this.headers[i2] instanceof String) || !((String)this.headers[i2]).equalsIgnoreCase((String)key)) continue;
            return i2;
        }
        return -1;
    }

    private Object remove(int remove) {
        Object removed = this.values[remove];
        for (int i2 = remove; i2 < this.size; ++i2) {
            if (i2 == this.headers.length - 1) {
                this.headers[i2] = null;
                this.values[i2] = null;
                continue;
            }
            this.headers[i2] = this.headers[i2 + 1];
            this.values[i2] = this.values[i2 + 1];
        }
        if (remove < this.size) {
            --this.size;
        }
        return removed;
    }

    private void add(Object header, Object value) {
        if (this.size == this.headers.length) {
            Object[] newHeaders = new Object[this.headers.length + 10];
            Object[] newValues = new Object[this.values.length + 10];
            System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.headers = newHeaders;
            this.values = newValues;
        }
        this.headers[this.size] = header;
        this.values[this.size] = value;
        ++this.size;
    }

    public synchronized Object get(Object key) {
        int i2 = -1;
        i2 = this.getIndex(key);
        if (i2 != -1) {
            return this.values[i2];
        }
        return null;
    }

    public synchronized Object set(Object key, Object value) {
        if (key instanceof String) {
            key = ((String)key).intern();
        }
        int i2 = this.getIndex(key);
        if (value == null) {
            if (i2 != -1) {
                return this.remove(i2);
            }
        } else {
            if (i2 != -1) {
                throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
            }
            this.add(key, value);
        }
        return null;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.values.toString();
    }

    public static Headers parseManifest(InputStream in) throws BundleException {
        try {
            BufferedReader br;
            Headers headers = new Headers(10);
            try {
                br = new BufferedReader(new InputStreamReader(in, "UTF8"));
            }
            catch (UnsupportedEncodingException e2) {
                br = new BufferedReader(new InputStreamReader(in));
            }
            String header = null;
            StringBuffer value = new StringBuffer(256);
            boolean firstLine = true;
            while (true) {
                int colon;
                String line;
                if ((line = br.readLine()) == null || line.length() == 0) {
                    if (firstLine) break;
                    headers.set(header, null);
                    headers.set(header, value.toString().trim());
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (firstLine) {
                        throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_SPACE, line));
                    }
                    value.append(line.substring(1));
                    continue;
                }
                if (!firstLine) {
                    headers.set(header, null);
                    headers.set(header, value.toString().trim());
                    value.setLength(0);
                }
                if ((colon = line.indexOf(58)) == -1) {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_LINE_NOCOLON, line));
                }
                header = line.substring(0, colon).trim();
                value.append(line.substring(colon + 1));
                firstLine = false;
            }
            Headers headers2 = headers;
            return headers2;
        }
        catch (IOException e3) {
            throw new BundleException(Msg.MANIFEST_IOEXCEPTION, e3);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ee) {}
        }
    }

    class ArrayEnumeration
    implements Enumeration {
        private Object[] array;
        int cur = 0;

        public ArrayEnumeration(Object[] array, int size) {
            this.array = new Object[size];
            System.arraycopy(array, 0, this.array, 0, this.array.length);
        }

        public boolean hasMoreElements() {
            return this.cur < this.array.length;
        }

        public Object nextElement() {
            return this.array[this.cur++];
        }
    }
}

