/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class BundleConstraint {
    private ResolverBundle bundle;
    private VersionConstraint bundleConstraint;
    private ResolverBundle matchingBundle;
    private ArrayList matchingBundles;

    BundleConstraint(ResolverBundle bundle, VersionConstraint bundleConstraint) {
        this.bundle = bundle;
        this.bundleConstraint = bundleConstraint;
    }

    boolean isFromFragment() {
        return this.bundleConstraint.getBundle().getHost() != null;
    }

    ResolverBundle getBundle() {
        return this.bundle;
    }

    BundleDescription getActualBundle() {
        return this.bundle.getBundle();
    }

    boolean isSatisfiedBy(ResolverBundle rb) {
        if (!this.bundle.getResolver().getPermissionChecker().checkBundlePermission(this.bundleConstraint, rb.getBundle())) {
            return false;
        }
        return this.bundleConstraint.isSatisfiedBy(rb.getBundle());
    }

    boolean isOptional() {
        if (this.bundleConstraint instanceof HostSpecification) {
            return false;
        }
        return ((BundleSpecification)this.bundleConstraint).isOptional();
    }

    VersionConstraint getVersionConstraint() {
        return this.bundleConstraint;
    }

    ResolverBundle getMatchingBundle() {
        return this.matchingBundle;
    }

    ResolverBundle[] getMatchingBundles() {
        if (this.matchingBundles == null) {
            return null;
        }
        ResolverBundle[] results = new ResolverBundle[this.matchingBundles.size()];
        int i2 = 0;
        Iterator iter = this.matchingBundles.iterator();
        while (iter.hasNext()) {
            results[i2] = (ResolverBundle)iter.next();
            ++i2;
        }
        return results.length == 0 ? null : results;
    }

    void addMatchingBundle(ResolverBundle rb) {
        if (this.matchingBundles == null) {
            this.matchingBundles = new ArrayList(1);
        }
        if (!this.matchingBundles.contains(rb)) {
            this.matchingBundles.add(rb);
        }
    }

    void removeMatchingBundle(ResolverBundle rb) {
        if (this.matchingBundles == null) {
            return;
        }
        this.matchingBundles.remove(rb);
    }

    void removeAllMatchingBundles() {
        this.matchingBundles = null;
    }

    void setMatchingBundle(ResolverBundle rb) {
        this.matchingBundle = rb;
    }

    public boolean foundMatchingBundles() {
        return this.matchingBundles == null ? false : this.matchingBundles.size() > 0;
    }
}

