/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateHelperImpl
implements StateHelper {
    private static StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] roots) {
        if (roots == null || roots.length == 0) {
            return new BundleDescription[0];
        }
        HashSet reachable = new HashSet(roots.length);
        for (int i2 = 0; i2 < roots.length; ++i2) {
            if (!roots[i2].isResolved()) continue;
            this.addDependentBundles(roots[i2], reachable);
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addDependentBundles(BundleDescription root, Set reachable) {
        if (reachable.contains(root)) {
            return;
        }
        reachable.add(root);
        BundleDescription[] dependents = root.getDependents();
        for (int i2 = 0; i2 < dependents.length; ++i2) {
            this.addDependentBundles(dependents[i2], reachable);
        }
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<VersionConstraint> unsatisfied = new ArrayList<VersionConstraint>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isResolvable(host)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        for (int i2 = 0; i2 < requiredBundles.length; ++i2) {
            if (requiredBundles[i2].isResolved() || this.isResolvable(requiredBundles[i2])) continue;
            unsatisfied.add(requiredBundles[i2]);
        }
        ImportPackageSpecification[] packages = bundle.getImportPackages();
        for (int i3 = 0; i3 < packages.length; ++i3) {
            if (packages[i3].isResolved() || this.isResolvable(packages[i3])) continue;
            unsatisfied.add(packages[i3]);
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    public boolean isResolvable(ImportPackageSpecification constraint) {
        ExportPackageDescription[] exports = constraint.getBundle().getContainingState().getExportedPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (!constraint.isSatisfiedBy(exports[i2])) continue;
            return true;
        }
        return false;
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable(specification);
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        for (int i2 = 0; i2 < availableBundles.length; ++i2) {
            if (!availableBundles[i2].isResolved() || !constraint.isSatisfiedBy(availableBundles[i2])) continue;
            return true;
        }
        return false;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList references = new ArrayList(toSort.length);
        for (int i2 = 0; i2 < toSort.length; ++i2) {
            if (!toSort[i2].isResolved()) continue;
            this.buildReferences(toSort[i2], references);
        }
        return ComputeNodeOrder.computeNodeOrder(toSort, (Object[][])references.toArray((T[])new Object[references.size()][]));
    }

    private void buildReferences(BundleDescription description, List references) {
        HostSpecification host = description.getHost();
        if (host != null) {
            if (host.getHosts() != null) {
                BundleDescription[] hosts = host.getHosts();
                for (int i2 = 0; i2 < hosts.length; ++i2) {
                    if (hosts[i2] == description) continue;
                    references.add(new Object[]{description, hosts[i2]});
                }
            }
        } else {
            this.buildReferences(description, ((BundleDescriptionImpl)description).getBundleDependencies(), references);
        }
    }

    private void buildReferences(BundleDescription description, List dependencies, List references) {
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.addReference(description, (BundleDescription)iter.next(), references);
        }
    }

    private void addReference(BundleDescription description, BundleDescription reference, List references) {
        if (description == reference || reference == null) {
            return;
        }
        references.add(new Object[]{description, reference});
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundle) {
        StateImpl state = (StateImpl)bundle.getContainingState();
        boolean strict = false;
        if (state != null) {
            strict = state.inStrictMode();
        }
        ArrayList<ExportPackageDescription> packageList = new ArrayList<ExportPackageDescription>();
        ArrayList<String> importList = new ArrayList<String>();
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        for (int i2 = 0; i2 < resolvedImports.length; ++i2) {
            packageList.add(resolvedImports[i2]);
            importList.add(resolvedImports[i2].getName());
        }
        BundleDescription[] requiredBundles = bundle.getResolvedRequires();
        ArrayList visited = new ArrayList(requiredBundles.length);
        for (int i3 = 0; i3 < requiredBundles.length; ++i3) {
            this.getPackages(requiredBundles[i3], bundle.getSymbolicName(), importList, packageList, visited, strict);
        }
        return packageList.toArray(new ExportPackageDescription[packageList.size()]);
    }

    private void getPackages(BundleDescription requiredBundle, String symbolicName, List importList, List packageList, List visited, boolean strict) {
        if (visited.contains(requiredBundle)) {
            return;
        }
        visited.add(requiredBundle);
        ExportPackageDescription[] exports = requiredBundle.getSelectedExports();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (this.isSystemExport(exports[i2]) || !this.isFriend(symbolicName, exports[i2], strict) || importList.contains(exports[i2].getName())) continue;
            packageList.add(exports[i2]);
        }
        BundleSpecification[] requiredBundles = requiredBundle.getRequiredBundles();
        for (int i3 = 0; i3 < requiredBundles.length; ++i3) {
            if (!requiredBundles[i3].isExported() || requiredBundles[i3].getSupplier() == null) continue;
            this.getPackages((BundleDescription)requiredBundles[i3].getSupplier(), symbolicName, importList, packageList, visited, strict);
        }
    }

    private boolean isSystemExport(ExportPackageDescription export) {
        StateImpl state = (StateImpl)export.getExporter().getContainingState();
        if (state == null) {
            return false;
        }
        ExportPackageDescription[] systemExports = state.getSystemPackages();
        for (int i2 = 0; i2 < systemExports.length; ++i2) {
            if (systemExports[i2] != export) continue;
            return true;
        }
        return false;
    }

    private boolean isFriend(String consumerBSN, ExportPackageDescription export, boolean strict) {
        if (!strict) {
            return true;
        }
        String[] friends = (String[])export.getDirective("x-friends");
        if (friends == null) {
            return true;
        }
        for (int i2 = 0; i2 < friends.length; ++i2) {
            if (!friends[i2].equals(consumerBSN)) continue;
            return true;
        }
        return false;
    }

    public int getAccessCode(BundleDescription bundle, ExportPackageDescription export) {
        if (((Boolean)export.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundle.getSymbolicName(), export, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

