/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Element;

public class XSDEcoreBuilder
extends MapBuilder {
    protected XSDSchema rootSchema;
    protected List simpleDiagnostics;
    protected List diagnostics;
    protected List xsdSchemas = new UniqueEList();
    protected Map targetNamespaceToEPackageMap = new HashMap();
    protected ExtendedMetaData extendedMetaData;
    protected Map eReferenceToOppositeNameMap = new HashMap();
    protected Map typeToTypeObjectMap = new HashMap();
    protected static final List DOMAINS = Arrays.asList("COM", "com", "ORG", "org");
    protected static final List PRIMITIVES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
    protected static final String[] PRIMITIVE_WRAPPERS = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short"};
    protected final List ANY_NAMESPACE_WILDCARD = Arrays.asList("##any");
    protected final List NOT_NULL_WILDCARD = Arrays.asList("!##");
    protected static final Class ecoreResourceFactoryImplClass;

    public XSDEcoreBuilder() {
        this(new BasicExtendedMetaData(new EPackageRegistryImpl()));
    }

    public XSDEcoreBuilder(ExtendedMetaData extendedMetaData) {
        this.extendedMetaData = extendedMetaData;
        this.populateTypeToTypeObjectMap(XMLTypePackage.eINSTANCE);
        this.populateTypeToTypeObjectMap(XMLNamespacePackage.eINSTANCE);
    }

    protected void populateTypeToTypeObjectMap(EPackage ePackage) {
        Iterator j2 = ePackage.getEClassifiers().iterator();
        while (j2.hasNext()) {
            EClassifier eClassifier = (EClassifier)j2.next();
            String xmlName = this.extendedMetaData.getName(eClassifier);
            if (xmlName == null || !xmlName.endsWith(":Object")) continue;
            this.typeToTypeObjectMap.put(this.extendedMetaData.getType(ePackage, xmlName.substring(0, xmlName.length() - 7)), eClassifier);
        }
    }

    public XSDSchema getSchema() {
        return this.rootSchema;
    }

    public void setValidate(boolean validate) {
        this.diagnostics = validate ? new ArrayList() : null;
    }

    public List getDiagnostics() {
        return this.diagnostics;
    }

    public XSDSchema getRootSchema() {
        return this.rootSchema;
    }

    public Map getTargetNamespaceToEPackageMap() {
        return this.targetNamespaceToEPackageMap;
    }

    public Map getXSDComponentToEModelElementMap() {
        return this.xsdComponentToEModelElementMap;
    }

    public EPackage getEPackage(XSDNamedComponent xsdNamedComponent) {
        String targetNamespace;
        EPackage ePackage;
        XSDSchema containingXSDSchema = xsdNamedComponent.getSchema();
        if (containingXSDSchema != null && !this.xsdSchemas.contains(containingXSDSchema)) {
            this.xsdSchemas.add(containingXSDSchema);
            this.addInput(containingXSDSchema);
            this.validate(containingXSDSchema);
        }
        if ((ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(targetNamespace = containingXSDSchema == null ? xsdNamedComponent.getTargetNamespace() : containingXSDSchema.getTargetNamespace())) == null) {
            if ("http://www.w3.org/XML/1998/namespace".equals(targetNamespace) && this.xsdSchemas.indexOf(containingXSDSchema) != 0) {
                ePackage = XMLNamespacePackage.eINSTANCE;
                Iterator i2 = containingXSDSchema.getAttributeDeclarations().iterator();
                while (i2.hasNext()) {
                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)i2.next();
                    if (XSDConstants.isSchemaInstanceNamespace(xsdAttributeDeclaration.getTargetNamespace())) continue;
                    EStructuralFeature eStructuralFeature = ExtendedMetaData.INSTANCE.getAttribute("http://www.w3.org/XML/1998/namespace", xsdAttributeDeclaration.getName());
                    this.map(xsdAttributeDeclaration, eStructuralFeature);
                    XSDSimpleTypeDefinition xsdTypeDefinition = xsdAttributeDeclaration.getAnonymousTypeDefinition();
                    if (xsdTypeDefinition == null) continue;
                    this.map(xsdTypeDefinition, eStructuralFeature.getEType());
                }
            } else {
                ePackage = EcoreFactory.eINSTANCE.createEPackage();
                this.setAnnotations(ePackage, containingXSDSchema);
                this.addOutput(ePackage);
                if (targetNamespace == null) {
                    if (containingXSDSchema == null) {
                        containingXSDSchema = this.rootSchema;
                    }
                    ePackage.setName(this.validName(containingXSDSchema.eResource().getURI().trimFileExtension().lastSegment(), true));
                    ePackage.setNsURI(containingXSDSchema.eResource().getURI().toString());
                } else {
                    List parsedName;
                    URI uri = URI.createURI(targetNamespace);
                    if (uri.isHierarchical()) {
                        String host = uri.host();
                        if (host != null && host.startsWith("www.")) {
                            host = host.substring(4);
                        }
                        parsedName = this.parseName(host, '.');
                        Collections.reverse(parsedName);
                        if (!parsedName.isEmpty()) {
                            parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
                        }
                        parsedName.addAll(this.parseName(uri.trimFileExtension().path(), '/'));
                    } else {
                        String opaquePart = uri.opaquePart();
                        int index = opaquePart.indexOf(":");
                        if (index != -1 && "urn".equalsIgnoreCase(uri.scheme())) {
                            parsedName = this.parseName(opaquePart.substring(0, index), '-');
                            if (parsedName.size() > 0 && DOMAINS.contains(parsedName.get(parsedName.size() - 1))) {
                                Collections.reverse(parsedName);
                                parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
                            }
                            parsedName.addAll(this.parseName(opaquePart.substring(index + 1), '/'));
                        } else {
                            parsedName = this.parseName(opaquePart, '/');
                        }
                    }
                    StringBuffer qualifiedPackageName = new StringBuffer();
                    Iterator i3 = parsedName.iterator();
                    while (i3.hasNext()) {
                        String packageName = (String)i3.next();
                        if (packageName.length() <= 0) continue;
                        if (qualifiedPackageName.length() > 0) {
                            qualifiedPackageName.append('.');
                        }
                        qualifiedPackageName.append(this.validName(packageName, false));
                    }
                    ePackage.setName(qualifiedPackageName.toString());
                    ePackage.setNsURI(targetNamespace);
                }
                String nsPrefix = ePackage.getName();
                int index = nsPrefix.lastIndexOf(46);
                ePackage.setNsPrefix(index == -1 ? nsPrefix : nsPrefix.substring(index + 1));
                this.extendedMetaData.setQualified(ePackage, targetNamespace != null);
                this.extendedMetaData.putPackage(targetNamespace, ePackage);
            }
            this.targetNamespaceToEPackageMap.put(targetNamespace, ePackage);
        }
        return ePackage;
    }

    public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdTypeDefinition);
        if (eClassifier == null) {
            eClassifier = this.computeEClassifier(xsdTypeDefinition);
            this.map(xsdTypeDefinition, eClassifier);
        }
        return eClassifier;
    }

    public EDataType getEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        EDataType eDataType = (EDataType)this.xsdComponentToEModelElementMap.get(xsdSimpleTypeDefinition);
        if (eDataType == null) {
            eDataType = this.computeEDataType(xsdSimpleTypeDefinition);
            this.map(xsdSimpleTypeDefinition, eDataType);
        }
        return eDataType;
    }

    public EClass getEClass(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        EClass eClass = (EClass)this.xsdComponentToEModelElementMap.get(xsdComplexTypeDefinition);
        if (eClass == null) {
            eClass = this.computeEClass(xsdComplexTypeDefinition);
            this.map(xsdComplexTypeDefinition, eClass);
        }
        return eClass;
    }

    protected EClassifier getBuiltInEClassifier(String namespace, String name) {
        return "anyType".equals(name) ? EcorePackage.eINSTANCE.getEObject() : this.extendedMetaData.getType(XMLTypePackage.eINSTANCE, name);
    }

    protected EClassifier computeEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        if (xsdTypeDefinition == null) {
            return this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if (xsdTypeDefinition instanceof XSDSimpleTypeDefinition) {
            return this.computeEDataType((XSDSimpleTypeDefinition)xsdTypeDefinition);
        }
        return this.computeEClass((XSDComplexTypeDefinition)xsdTypeDefinition);
    }

    protected EDataType computeEDataType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        String explicitInstanceClassName;
        if (xsdSimpleTypeDefinition == null) {
            return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace())) {
            EDataType result;
            String name = xsdSimpleTypeDefinition.getName();
            if (name != null && (result = (EDataType)this.getBuiltInEClassifier(xsdSimpleTypeDefinition.getTargetNamespace(), name)) != null) {
                return result;
            }
        } else if (xsdSimpleTypeDefinition.getContainer() == null) {
            return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
        }
        if ((explicitInstanceClassName = this.getEcoreAttribute(xsdSimpleTypeDefinition, "instanceClass")) != null) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.setAnnotations(eDataType, xsdSimpleTypeDefinition);
            String aliasName = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
            if (aliasName == null) {
                aliasName = this.validName(xsdSimpleTypeDefinition.getAliasName(), true);
            }
            eDataType.setName(aliasName);
            this.extendedMetaData.setName(eDataType, xsdSimpleTypeDefinition.getAliasName());
            eDataType.setInstanceClassName(explicitInstanceClassName);
            EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
            XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eDataType);
            this.checkForPrimitive(eDataType);
            this.handleFacets(xsdSimpleTypeDefinition, eDataType);
            return eDataType;
        }
        EEnum eEnum = this.computeEEnum(xsdSimpleTypeDefinition);
        if (eEnum != null) {
            return eEnum;
        }
        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        if (baseTypeDefinition != null) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.setAnnotations(eDataType, xsdSimpleTypeDefinition);
            String name = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
            if (name == null) {
                name = this.validName(xsdSimpleTypeDefinition.getAliasName(), true);
            }
            eDataType.setName(name);
            this.extendedMetaData.setName(eDataType, xsdSimpleTypeDefinition.getAliasName());
            EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
            XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eDataType);
            if (baseTypeDefinition.getVariety() != xsdSimpleTypeDefinition.getVariety()) {
                if (xsdSimpleTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL) {
                    EDataType itemEDataType = this.getEDataType(xsdSimpleTypeDefinition.getItemTypeDefinition());
                    this.extendedMetaData.setItemType(eDataType, itemEDataType);
                    eDataType.setInstanceClassName("java.util.List");
                } else {
                    String instanceClassName = null;
                    ArrayList<EDataType> memberTypes = new ArrayList<EDataType>();
                    Iterator i2 = xsdSimpleTypeDefinition.getMemberTypeDefinitions().iterator();
                    while (i2.hasNext()) {
                        XSDSimpleTypeDefinition memberTypeDefinition = (XSDSimpleTypeDefinition)i2.next();
                        EDataType memberEDataType = this.getEDataType(memberTypeDefinition);
                        memberTypes.add(memberEDataType);
                        String memberInstanceClassName = memberEDataType.getInstanceClassName();
                        if (memberInstanceClassName == null && memberEDataType instanceof EEnum) {
                            memberInstanceClassName = "org.eclipse.emf.common.util.Enumerator";
                        }
                        if (instanceClassName == null) {
                            instanceClassName = memberInstanceClassName;
                            continue;
                        }
                        if (instanceClassName == memberInstanceClassName) continue;
                        instanceClassName = "java.lang.Object";
                    }
                    this.extendedMetaData.setMemberTypes(eDataType, memberTypes);
                    eDataType.setInstanceClassName(instanceClassName);
                }
            } else {
                EDataType baseEDataType = this.getEDataType(baseTypeDefinition);
                this.extendedMetaData.setBaseType(eDataType, baseEDataType);
                String instanceClassName = baseEDataType.getInstanceClassName();
                eDataType.setInstanceClassName(instanceClassName == null ? "org.eclipse.emf.common.util.Enumerator" : instanceClassName);
            }
            this.checkForPrimitive(eDataType);
            this.handleFacets(xsdSimpleTypeDefinition, eDataType);
            return eDataType;
        }
        return (EDataType)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anySimpleType");
    }

    protected static boolean canSupportNull(EDataType eDataType) {
        return !(eDataType instanceof EEnum) && PRIMITIVES.indexOf(eDataType.getInstanceClassName()) == -1;
    }

    protected void checkForPrimitive(EDataType eDataType) {
        int index = PRIMITIVES.indexOf(eDataType.getInstanceClassName());
        if (index != -1 || eDataType instanceof EEnum) {
            EDataType eDataTypeObject = EcoreFactory.eINSTANCE.createEDataType();
            eDataTypeObject.setName(eDataType.getName() + "Object");
            if (index != -1) {
                eDataTypeObject.setInstanceClassName(PRIMITIVE_WRAPPERS[index]);
            } else {
                eDataTypeObject.setInstanceClassName("org.eclipse.emf.common.util.Enumerator");
            }
            this.extendedMetaData.setName(eDataTypeObject, this.extendedMetaData.getName(eDataType) + ":Object");
            XSDEcoreBuilder.addToSortedList(eDataType.getEPackage().getEClassifiers(), eDataTypeObject);
            this.extendedMetaData.setBaseType(eDataTypeObject, eDataType);
            this.typeToTypeObjectMap.put(eDataType, eDataTypeObject);
        }
    }

    protected void handleFacets(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, final EDataType eDataType) {
        final ArrayList enumeration = new ArrayList();
        final ArrayList pattern = new ArrayList();
        Iterator i2 = xsdSimpleTypeDefinition.getFacetContents().iterator();
        while (i2.hasNext()) {
            XSDFacet xsdFacet = (XSDFacet)i2.next();
            String ignore = this.getEcoreAttribute(xsdFacet, "ignore");
            if ("true".equalsIgnoreCase(ignore)) continue;
            new XSDSwitch(){

                public Object caseXSDEnumerationFacet(XSDEnumerationFacet xsdEnumerationFacet) {
                    enumeration.add(xsdEnumerationFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDFractionDigitsFacet(XSDFractionDigitsFacet xsdFractionDigitsFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setFractionDigitsFacet(eDataType, xsdFractionDigitsFacet.getValue());
                    return this;
                }

                public Object caseXSDLengthFacet(XSDLengthFacet xsdLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setLengthFacet(eDataType, xsdLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDMaxExclusiveFacet(XSDMaxExclusiveFacet xsdMaxExclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxExclusiveFacet(eDataType, xsdMaxExclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMaxInclusiveFacet(XSDMaxInclusiveFacet xsdMaxInclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxInclusiveFacet(eDataType, xsdMaxInclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMaxLengthFacet(XSDMaxLengthFacet xsdMaxLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMaxLengthFacet(eDataType, xsdMaxLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDMinExclusiveFacet(XSDMinExclusiveFacet xsdMinExclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinExclusiveFacet(eDataType, xsdMinExclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMinInclusiveFacet(XSDMinInclusiveFacet xsdMinInclusiveFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinInclusiveFacet(eDataType, xsdMinInclusiveFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDMinLengthFacet(XSDMinLengthFacet xsdMinLengthFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setMinLengthFacet(eDataType, xsdMinLengthFacet.getValue());
                    return this;
                }

                public Object caseXSDPatternFacet(XSDPatternFacet xsdPatternFacet) {
                    pattern.add(xsdPatternFacet.getLexicalValue());
                    return this;
                }

                public Object caseXSDTotalDigitsFacet(XSDTotalDigitsFacet xsdTotalDigitsFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setTotalDigitsFacet(eDataType, xsdTotalDigitsFacet.getValue());
                    return this;
                }

                public Object caseXSDWhiteSpaceFacet(XSDWhiteSpaceFacet xsdWhiteSpaceFacet) {
                    XSDEcoreBuilder.this.extendedMetaData.setWhiteSpaceFacet(eDataType, xsdWhiteSpaceFacet.getValue().getValue() + 1);
                    return this;
                }
            }.doSwitch(xsdFacet);
        }
        this.extendedMetaData.setEnumerationFacet(eDataType, enumeration);
        this.extendedMetaData.setPatternFacet(eDataType, pattern);
    }

    protected EEnum computeEEnum(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (!xsdSimpleTypeDefinition.getEnumerationFacets().isEmpty()) {
            ArrayList<XSDEnumerationFacet> enumerators = new ArrayList<XSDEnumerationFacet>();
            Iterator i2 = xsdSimpleTypeDefinition.getEnumerationFacets().iterator();
            block0: while (i2.hasNext()) {
                XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i2.next();
                String enumerator = xsdEnumerationFacet.getLexicalValue();
                if (enumerator != null && enumerator.length() != 0) {
                    if (Character.isJavaIdentifierStart(enumerator.charAt(0))) {
                        for (int j2 = enumerator.length() - 1; j2 > 0; --j2) {
                            if (Character.isJavaIdentifierPart(enumerator.charAt(j2))) continue;
                            enumerators.clear();
                            break block0;
                        }
                    } else {
                        enumerators.clear();
                        break;
                    }
                    enumerators.add(xsdEnumerationFacet);
                    continue;
                }
                enumerators.clear();
                break;
            }
            if (!enumerators.isEmpty()) {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                this.setAnnotations(eEnum, xsdSimpleTypeDefinition);
                String name = this.getEcoreAttribute(xsdSimpleTypeDefinition, "name");
                if (name == null) {
                    name = this.validName(xsdSimpleTypeDefinition.getAliasName(), true);
                }
                eEnum.setName(name);
                this.extendedMetaData.setName(eEnum, xsdSimpleTypeDefinition.getAliasName());
                EPackage ePackage = this.getEPackage(xsdSimpleTypeDefinition);
                XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eEnum);
                ListIterator i3 = enumerators.listIterator();
                while (i3.hasNext()) {
                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i3.next();
                    String enumerator = xsdEnumerationFacet.getLexicalValue();
                    EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                    this.setAnnotations(eEnumLiteral, xsdEnumerationFacet);
                    eEnumLiteral.setName(enumerator);
                    eEnumLiteral.setValue(i3.previousIndex());
                    eEnum.getELiterals().add(eEnumLiteral);
                    this.map(xsdEnumerationFacet, eEnumLiteral);
                }
                this.checkForPrimitive(eEnum);
                return eEnum;
            }
        }
        return null;
    }

    public EClass computeEClass(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        boolean isRestriction;
        EClassifier baseType;
        if (xsdComplexTypeDefinition == null) {
            return (EClass)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anyType");
        }
        if (XSDConstants.isSchemaForSchemaNamespace(xsdComplexTypeDefinition.getTargetNamespace())) {
            EClass result;
            String name = xsdComplexTypeDefinition.getName();
            if (name != null && (result = (EClass)this.getBuiltInEClassifier(xsdComplexTypeDefinition.getTargetNamespace(), name)) != null) {
                return result;
            }
        } else if (xsdComplexTypeDefinition.getContainer() == null) {
            return (EClass)this.getBuiltInEClassifier(this.rootSchema.getSchemaForSchemaNamespace(), "anyType");
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.setAnnotations(eClass, xsdComplexTypeDefinition);
        this.xsdComponentToEModelElementMap.put(xsdComplexTypeDefinition, eClass);
        String aliasName = this.getEcoreAttribute(xsdComplexTypeDefinition, "name");
        if (aliasName == null) {
            aliasName = this.validName(xsdComplexTypeDefinition.getAliasName(), true);
        }
        eClass.setName(aliasName);
        this.extendedMetaData.setName(eClass, xsdComplexTypeDefinition.getAliasName());
        EPackage ePackage = this.getEPackage(xsdComplexTypeDefinition);
        XSDEcoreBuilder.addToSortedList(ePackage.getEClassifiers(), eClass);
        if (xsdComplexTypeDefinition.isAbstract()) {
            eClass.setAbstract(true);
        }
        EClass baseClass = null;
        XSDTypeDefinition baseTypeDefinition = xsdComplexTypeDefinition.getBaseTypeDefinition();
        if (!XSDConstants.isURType(baseTypeDefinition) && (baseType = this.getEClassifier(baseTypeDefinition)) instanceof EClass && baseType != EcorePackage.eINSTANCE.getEObject()) {
            baseClass = (EClass)baseType;
            eClass.getESuperTypes().add(baseClass);
        }
        boolean bl = isRestriction = !eClass.getESuperTypes().isEmpty() && xsdComplexTypeDefinition.getDerivationMethod() == XSDDerivationMethod.RESTRICTION_LITERAL;
        if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
            this.extendedMetaData.setContentKind(eClass, 2);
            if (eClass.getEAllStructuralFeatures().isEmpty()) {
                this.createFeature(eClass, "value", this.getEClassifier(xsdComplexTypeDefinition.getSimpleType()), null, 0, 1);
            }
        } else {
            EStructuralFeature globalGroup = null;
            boolean isMixed = xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.MIXED_LITERAL;
            String featureMapName = this.getEcoreAttribute(xsdComplexTypeDefinition, "featureMap");
            if (eClass.getESuperTypes().isEmpty() ? "true".equals(this.getEcoreAttribute(xsdComplexTypeDefinition, "mixed")) : this.extendedMetaData.getMixedFeature((EClass)eClass.getESuperTypes().get(0)) != null) {
                isMixed = true;
            }
            this.extendedMetaData.setContentKind(eClass, isMixed ? 3 : (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.EMPTY_LITERAL ? 1 : 4));
            if (isMixed) {
                EStructuralFeature mixedFeature = this.extendedMetaData.getMixedFeature(eClass);
                if (mixedFeature == null) {
                    if (featureMapName == null) {
                        featureMapName = "mixed";
                    }
                    mixedFeature = this.createFeature(eClass, featureMapName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                    this.extendedMetaData.setName(mixedFeature, ":mixed");
                }
            } else {
                globalGroup = this.extendedMetaData.getElement(eClass, null, ":group");
                if (globalGroup == null && featureMapName != null && eClass.getESuperTypes().isEmpty()) {
                    globalGroup = this.createFeature(eClass, featureMapName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                    this.extendedMetaData.setName(globalGroup, ":group");
                    this.extendedMetaData.setFeatureKind(globalGroup, 6);
                }
            }
            if (xsdComplexTypeDefinition.getContent() != null) {
                HashMap<XSDTerm, EStructuralFeature> groups = new HashMap<XSDTerm, EStructuralFeature>();
                List particleInformation = this.collectParticles((XSDParticle)xsdComplexTypeDefinition.getContent());
                Iterator i2 = particleInformation.iterator();
                while (i2.hasNext()) {
                    EffectiveOccurrence effectiveOccurrence = (EffectiveOccurrence)i2.next();
                    XSDParticle xsdParticle = effectiveOccurrence.xsdParticle;
                    EStructuralFeature group = (EStructuralFeature)groups.get(effectiveOccurrence.xsdModelGroup);
                    XSDTerm xsdTerm = xsdParticle.getTerm();
                    EStructuralFeature eStructuralFeature = null;
                    String name = this.getEcoreAttribute(xsdParticle, "name");
                    if (xsdTerm instanceof XSDModelGroup) {
                        if (!isRestriction) {
                            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
                            if (name == null && (name = this.getEcoreAttribute(xsdParticle, "featureMap")) == null && (name = this.getEcoreAttribute(xsdModelGroup, "name")) == null && (name = this.getEcoreAttribute(xsdModelGroup, "featureMap")) == null) {
                                if (xsdModelGroup.getContainer() instanceof XSDModelGroupDefinition) {
                                    XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)xsdModelGroup.getContainer();
                                    name = this.getEcoreAttribute(xsdModelGroupDefinition, "name");
                                    if (name == null) {
                                        name = this.validName(xsdModelGroupDefinition.getName(), true);
                                    }
                                } else {
                                    name = "group";
                                }
                            }
                            eStructuralFeature = this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, 0, -1);
                            groups.put(xsdTerm, eStructuralFeature);
                            this.extendedMetaData.setName(eStructuralFeature, name + ":" + eClass.getEAllStructuralFeatures().indexOf(eStructuralFeature));
                        }
                    } else if (xsdTerm instanceof XSDWildcard) {
                        if (!isRestriction) {
                            if (name == null && (name = this.getEcoreAttribute(xsdTerm, "name")) == null) {
                                name = "any";
                            }
                            eStructuralFeature = this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                        }
                    } else {
                        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                        boolean isRedundant = false;
                        if (isRestriction) {
                            boolean bl2 = isRedundant = this.extendedMetaData.getElement(baseClass, xsdElementDeclaration.getTargetNamespace(), xsdElementDeclaration.getName()) != null;
                            if (!isRedundant) {
                                group = this.extendedMetaData.getElementWildcardAffiliation(baseClass, xsdElementDeclaration.getTargetNamespace(), xsdElementDeclaration.getName());
                            }
                        }
                        if (!isRedundant) {
                            String groupName;
                            if (name == null && (name = this.getEcoreAttribute(xsdElementDeclaration, "name")) == null) {
                                name = this.validName(xsdElementDeclaration.getName(), true);
                            }
                            if ((groupName = this.getEcoreAttribute(xsdParticle, "featureMap")) == null) {
                                groupName = this.getEcoreAttribute(xsdElementDeclaration, "featureMap");
                            }
                            if (!"".equals(groupName) && (groupName != null || xsdElementDeclaration.isAbstract() || xsdElementDeclaration.getSubstitutionGroup().size() > 1)) {
                                if (groupName == null) {
                                    groupName = name + "Group";
                                }
                                eStructuralFeature = this.createFeature(eClass, groupName, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                                eStructuralFeature.setChangeable(true);
                                this.extendedMetaData.setFeatureKind(eStructuralFeature, 6);
                                this.extendedMetaData.setName(eStructuralFeature, xsdElementDeclaration.getName() + ":group");
                                if (group != null) {
                                    this.extendedMetaData.setGroup(eStructuralFeature, group);
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                } else if (isMixed) {
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                } else if (globalGroup != null) {
                                    this.extendedMetaData.setGroup(eStructuralFeature, globalGroup);
                                    eStructuralFeature.setDerived(true);
                                    eStructuralFeature.setTransient(true);
                                    eStructuralFeature.setVolatile(true);
                                }
                                group = eStructuralFeature;
                            }
                            if (!(eStructuralFeature = this.createFeature(eClass, xsdElementDeclaration, name, (XSDComponent)xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs)).isChangeable() && group == null) {
                                eStructuralFeature.setChangeable(true);
                            }
                        }
                    }
                    if (eStructuralFeature == null) continue;
                    if (group != null) {
                        this.extendedMetaData.setGroup(eStructuralFeature, group);
                        eStructuralFeature.setDerived(true);
                        eStructuralFeature.setTransient(true);
                        eStructuralFeature.setVolatile(true);
                        continue;
                    }
                    if (isMixed) {
                        eStructuralFeature.setDerived(true);
                        eStructuralFeature.setTransient(true);
                        eStructuralFeature.setVolatile(true);
                        continue;
                    }
                    if (globalGroup == null) continue;
                    this.extendedMetaData.setGroup(eStructuralFeature, globalGroup);
                    eStructuralFeature.setDerived(true);
                    eStructuralFeature.setTransient(true);
                    eStructuralFeature.setVolatile(true);
                }
            }
        }
        HashSet<String> baseAttributeUses = new HashSet<String>();
        if (baseTypeDefinition instanceof XSDComplexTypeDefinition) {
            Iterator i3 = ((XSDComplexTypeDefinition)baseTypeDefinition).getAttributeUses().iterator();
            while (i3.hasNext()) {
                baseAttributeUses.add(((XSDAttributeUse)i3.next()).getAttributeDeclaration().getURI());
            }
        }
        Iterator i4 = xsdComplexTypeDefinition.getAttributeUses().iterator();
        while (i4.hasNext()) {
            EStructuralFeature attributeWildcardEStructuralFeature;
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i4.next();
            XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
            if (baseAttributeUses.contains(xsdAttributeDeclaration.getURI())) continue;
            String name = this.getEcoreAttribute(xsdAttributeUse, "name");
            if (name == null) {
                name = this.getEcoreAttribute(xsdAttributeDeclaration, "name");
            }
            if (name == null) {
                name = this.validName(xsdAttributeDeclaration.getName(), true);
            }
            EStructuralFeature eStructuralFeature = this.createFeature(eClass, xsdAttributeDeclaration, name, xsdAttributeUse, xsdAttributeUse.isRequired());
            if (!isRestriction || (attributeWildcardEStructuralFeature = this.extendedMetaData.getAttributeWildcardAffiliation(baseClass, xsdAttributeDeclaration.getTargetNamespace(), xsdAttributeDeclaration.getName())) == null) continue;
            this.extendedMetaData.setGroup(eStructuralFeature, attributeWildcardEStructuralFeature);
            eStructuralFeature.setDerived(true);
            eStructuralFeature.setTransient(true);
            eStructuralFeature.setVolatile(true);
        }
        XSDWildcard xsdWildcard = xsdComplexTypeDefinition.getAttributeWildcardContent();
        if (xsdWildcard != null) {
            String name = this.getEcoreAttribute(xsdWildcard, "name");
            if (name == null) {
                name = "anyAttribute";
            }
            this.createFeature(eClass, name, EcorePackage.eINSTANCE.getEFeatureMapEntry(), (XSDComponent)xsdWildcard, 0, -1);
        }
        if (isRestriction) {
            int baseContentKind = this.extendedMetaData.getContentKind((EClass)eClass.getESuperTypes().get(0));
            if (baseContentKind == 3 && xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
                this.extendedMetaData.setContentKind(eClass, 2);
                EStructuralFeature eStructuralFeature = this.createFeature(eClass, "rawValue", this.getBuiltInEClassifier(xsdComplexTypeDefinition.getSchema().getSchemaForSchemaNamespace(), "string"), null, 0, 1);
                eStructuralFeature.setDerived(true);
                eStructuralFeature.setTransient(true);
                eStructuralFeature.setVolatile(true);
                eStructuralFeature = this.createFeature(eClass, "value", this.getBuiltInEClassifier(xsdComplexTypeDefinition.getSchema().getSchemaForSchemaNamespace(), "anySimpleType"), null, 0, 1);
                eStructuralFeature.setDerived(true);
                eStructuralFeature.setTransient(true);
                eStructuralFeature.setVolatile(true);
                if ("SimpleAnyType".equals(eClass.getName()) && "http://www.eclipse.org/emf/2003/XMLType".equals(eClass.getEPackage().getNsURI())) {
                    eStructuralFeature = this.createFeature(eClass, "instanceType", EcorePackage.eINSTANCE.getEDataType(), null, 1, 1);
                    ((EReference)eStructuralFeature).setResolveProxies(false);
                }
            } else {
                this.extendedMetaData.setContentKind(eClass, baseContentKind);
            }
        }
        return eClass;
    }

    protected List getWildcards(XSDWildcard xsdWildcard) {
        switch (xsdWildcard.getNamespaceConstraintCategory().getValue()) {
            case 0: {
                return this.ANY_NAMESPACE_WILDCARD;
            }
            case 1: {
                String targetNamespace = null;
                XSDSchema containingXSDSchema = xsdWildcard.getSchema();
                if (containingXSDSchema != null) {
                    targetNamespace = containingXSDSchema.getTargetNamespace();
                }
                return targetNamespace == null ? this.NOT_NULL_WILDCARD : Collections.singletonList("!##" + targetNamespace);
            }
            case 2: {
                return xsdWildcard.getNamespaceConstraint();
            }
        }
        throw new UnsupportedOperationException("Unknown XSDNamespaceConstraintCategory: " + xsdWildcard.getNamespaceConstraintCategory().getName());
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent) {
        return this.createFeature(eClass, name, type, xsdComponent, 0, 1);
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        if (xsdComponent != null) {
            XSDSchema containingXSDSchema = xsdComponent.getSchema();
            if (containingXSDSchema != null && !this.xsdSchemas.contains(containingXSDSchema)) {
                this.xsdSchemas.add(containingXSDSchema);
                this.addInput(containingXSDSchema);
                this.validate(containingXSDSchema);
            }
        } else if (this.extendedMetaData.getContentKind(eClass) == 3) {
            if (type == EcorePackage.eINSTANCE.getEFeatureMapEntry()) {
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                this.setAnnotations(eAttribute, xsdComponent);
                eAttribute.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
                eAttribute.setUnique(false);
                eAttribute.setEType(type);
                eAttribute.setLowerBound(minOccurs);
                eAttribute.setUpperBound(maxOccurs);
                eClass.getEStructuralFeatures().add(eAttribute);
                this.extendedMetaData.setFeatureKind(eAttribute, 5);
                this.extendedMetaData.setName(eAttribute, ":" + eAttribute.getName());
                return eAttribute;
            }
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            this.setAnnotations(eReference, xsdComponent);
            eReference.setName(name);
            eReference.setEType(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            eReference.setLowerBound(0);
            eReference.setUpperBound(-1);
            eReference.setContainment(true);
            eReference.setResolveProxies(false);
            eReference.setTransient(true);
            eClass.getEStructuralFeatures().add(eReference);
            this.extendedMetaData.setFeatureKind(eReference, 2);
            return eReference;
        }
        if (type instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            this.setAnnotations(eReference, xsdComponent);
            eReference.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
            eReference.setEType(type);
            eReference.setLowerBound(minOccurs);
            eReference.setUpperBound(maxOccurs);
            eClass.getEStructuralFeatures().add(eReference);
            if (xsdComponent == null) {
                this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                this.extendedMetaData.setFeatureKind(eReference, 1);
            } else {
                this.map(xsdComponent, eReference);
                if (xsdComponent instanceof XSDParticle) {
                    eReference.setContainment(true);
                    eReference.setResolveProxies(false);
                    XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                    XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                    if (xsdTerm instanceof XSDElementDeclaration) {
                        String opposite;
                        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                        this.extendedMetaData.setFeatureKind(eReference, 4);
                        this.extendedMetaData.setName(eReference, xsdElementDeclaration.getName());
                        this.extendedMetaData.setNamespace(eReference, xsdElementDeclaration.getTargetNamespace());
                        if (xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                            eReference.setContainment(false);
                            eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition()));
                        }
                        if (maxOccurs == 1 && xsdElementDeclaration.isNillable()) {
                            eReference.setUnsettable(true);
                        }
                        if (xsdElementDeclaration.isAbstract()) {
                            eReference.setChangeable(false);
                        }
                        if ((opposite = this.getEcoreAttribute(xsdParticle, "opposite")) != null) {
                            this.eReferenceToOppositeNameMap.put(eReference, opposite);
                        }
                    } else if (xsdTerm instanceof XSDWildcard) {
                        XSDWildcard xsdWildcard = (XSDWildcard)xsdTerm;
                        this.extendedMetaData.setFeatureKind(eReference, 5);
                        this.extendedMetaData.setWildcards(eReference, this.getWildcards(xsdWildcard));
                        this.extendedMetaData.setProcessingKind(eReference, xsdWildcard.getProcessContents().getValue() + 1);
                        this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                    } else {
                        this.extendedMetaData.setFeatureKind(eReference, 6);
                        this.extendedMetaData.setName(eReference, ":" + eClass.getEAllStructuralFeatures().indexOf(eReference));
                    }
                } else if (xsdComponent instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
                    eReference.setContainment(true);
                    eReference.setResolveProxies(false);
                    this.extendedMetaData.setFeatureKind(eReference, 4);
                    this.extendedMetaData.setName(eReference, xsdElementDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdElementDeclaration.getTargetNamespace());
                    XSDElementDeclaration substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation();
                    if (substitutionGroupAffiliation != null) {
                        EStructuralFeature affiliation = this.getEStructuralFeature(substitutionGroupAffiliation);
                        this.extendedMetaData.setAffiliation(eReference, affiliation);
                    }
                    if (xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                        eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType((XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition()));
                    }
                    if (maxOccurs == 1 && xsdElementDeclaration.isNillable()) {
                        eReference.setUnsettable(true);
                    }
                    if (xsdElementDeclaration.isAbstract()) {
                        eReference.setChangeable(false);
                    }
                } else if (xsdComponent instanceof XSDAttributeUse) {
                    String opposite = this.getEcoreAttribute(xsdComponent, "opposite");
                    if (opposite != null) {
                        this.eReferenceToOppositeNameMap.put(eReference, opposite);
                    }
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    this.extendedMetaData.setFeatureKind(eReference, 2);
                    this.extendedMetaData.setName(eReference, xsdAttributeDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdAttributeDeclaration.getTargetNamespace());
                    eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType(xsdAttributeDeclaration.getTypeDefinition()));
                } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent;
                    this.extendedMetaData.setFeatureKind(eReference, 2);
                    this.extendedMetaData.setName(eReference, xsdAttributeDeclaration.getName());
                    this.extendedMetaData.setNamespace(eReference, xsdAttributeDeclaration.getTargetNamespace());
                    eReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType(xsdAttributeDeclaration.getTypeDefinition()));
                }
            }
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        this.setAnnotations(eAttribute, xsdComponent);
        eAttribute.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
        eAttribute.setUnique(false);
        eAttribute.setEType(type);
        eAttribute.setLowerBound(minOccurs);
        eAttribute.setUpperBound(maxOccurs);
        eClass.getEStructuralFeatures().add(eAttribute);
        if (xsdComponent == null) {
            this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
            this.extendedMetaData.setFeatureKind(eAttribute, 1);
        } else {
            this.map(xsdComponent, eAttribute);
            if (xsdComponent instanceof XSDAttributeUse) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                this.extendedMetaData.setFeatureKind(eAttribute, 2);
                this.extendedMetaData.setName(eAttribute, xsdAttributeDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdAttributeDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdAttributeUse.getLexicalValue());
                this.initialize(eAttribute, xsdAttributeDeclaration.getTypeDefinition());
            } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 2);
                this.extendedMetaData.setName(eAttribute, xsdAttributeDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdAttributeDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdAttributeDeclaration.getLexicalValue());
                this.initialize(eAttribute, xsdAttributeDeclaration.getTypeDefinition());
            } else if (xsdComponent instanceof XSDParticle) {
                XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                if (xsdTerm instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                    this.extendedMetaData.setFeatureKind(eAttribute, 4);
                    this.extendedMetaData.setName(eAttribute, xsdElementDeclaration.getName());
                    this.extendedMetaData.setNamespace(eAttribute, xsdElementDeclaration.getTargetNamespace());
                    eAttribute.setDefaultValueLiteral(xsdElementDeclaration.getLexicalValue());
                    if (xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                        this.initialize(eAttribute, (XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition());
                    }
                    if (xsdElementDeclaration.isNillable()) {
                        if (!XSDEcoreBuilder.canSupportNull((EDataType)type)) {
                            type = (EDataType)this.typeToTypeObjectMap.get(type);
                            eAttribute.setEType(type);
                        }
                        if (maxOccurs == 1) {
                            eAttribute.setUnsettable(true);
                        }
                    }
                    if (xsdElementDeclaration.isAbstract()) {
                        eAttribute.setChangeable(false);
                    }
                } else if (xsdTerm instanceof XSDWildcard) {
                    XSDWildcard xsdWildcard = (XSDWildcard)xsdTerm;
                    this.extendedMetaData.setFeatureKind(eAttribute, 5);
                    this.extendedMetaData.setWildcards(eAttribute, this.getWildcards(xsdWildcard));
                    this.extendedMetaData.setProcessingKind(eAttribute, xsdWildcard.getProcessContents().getValue() + 1);
                    this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
                } else {
                    this.extendedMetaData.setFeatureKind(eAttribute, 6);
                }
            } else if (xsdComponent instanceof XSDWildcard) {
                XSDWildcard xsdWildcard = (XSDWildcard)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 3);
                this.extendedMetaData.setWildcards(eAttribute, this.getWildcards(xsdWildcard));
                this.extendedMetaData.setProcessingKind(eAttribute, xsdWildcard.getProcessContents().getValue() + 1);
                this.extendedMetaData.setName(eAttribute, ":" + eClass.getEAllStructuralFeatures().indexOf(eAttribute));
            } else if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration substitutionGroupAffiliation;
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
                this.extendedMetaData.setFeatureKind(eAttribute, 4);
                this.extendedMetaData.setName(eAttribute, xsdElementDeclaration.getName());
                this.extendedMetaData.setNamespace(eAttribute, xsdElementDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdElementDeclaration.getLexicalValue());
                if (xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                    this.initialize(eAttribute, (XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition());
                }
                if ((substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation()) != null) {
                    EStructuralFeature affiliation = this.getEStructuralFeature(substitutionGroupAffiliation);
                    this.extendedMetaData.setAffiliation(eAttribute, affiliation);
                }
                if (xsdElementDeclaration.isNillable() && !XSDEcoreBuilder.canSupportNull((EDataType)type)) {
                    type = (EDataType)this.typeToTypeObjectMap.get(type);
                    eAttribute.setEType(type);
                    if (maxOccurs == 1) {
                        eAttribute.setUnsettable(true);
                    }
                }
                if (xsdElementDeclaration.isAbstract()) {
                    eAttribute.setChangeable(false);
                }
            }
        }
        if (maxOccurs == 1 && (type.getDefaultValue() != null || eAttribute.getDefaultValueLiteral() != null)) {
            eAttribute.setUnsettable(true);
        }
        return eAttribute;
    }

    protected EStructuralFeature createFeature(EClass eClass, XSDElementDeclaration xsdElementDeclaration, String name, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        XSDTypeDefinition elementTypeDefinition = xsdElementDeclaration.getTypeDefinition();
        EClassifier eClassifier = this.getEClassifier(elementTypeDefinition);
        XSDTypeDefinition referenceType = this.getEcoreTypeQNameAttribute(xsdElementDeclaration, "reference");
        if (referenceType != null) {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
            EClassifier referenceClassifier = this.getEClassifier(referenceType);
            boolean needsHolder = false;
            if (elementTypeDefinition instanceof XSDSimpleTypeDefinition && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)elementTypeDefinition).getVariety() == XSDVariety.LIST_LITERAL) {
                String holderName;
                needsHolder = true;
                EPackage holderPackage = this.getEPackage(xsdElementDeclaration);
                EClass holderClass = (EClass)this.extendedMetaData.getType(holderPackage, holderName = xsdElementDeclaration.getName() + ":holder");
                if (holderClass == null) {
                    holderClass = EcoreFactory.eINSTANCE.createEClass();
                    this.setAnnotations(holderClass, xsdElementDeclaration);
                    holderClass.setName(this.validName(holderName, true));
                    this.extendedMetaData.setName(holderClass, holderName);
                    this.extendedMetaData.setContentKind(holderClass, 2);
                    XSDEcoreBuilder.addToSortedList(holderPackage.getEClassifiers(), holderClass);
                    EReference holderReference = (EReference)this.createFeature(holderClass, "value", referenceClassifier, null, 0, -1);
                    holderReference.setResolveProxies(!XSDEcoreBuilder.isLocalReferenceType(xsdSimpleTypeDefinition));
                }
                referenceClassifier = holderClass;
            }
            EStructuralFeature result = this.createFeature(eClass, name, referenceClassifier, xsdComponent, minOccurs, maxOccurs);
            ((EReference)result).setContainment(needsHolder);
            if (needsHolder) {
                ((EReference)result).setUnsettable(false);
                ((EReference)result).setResolveProxies(false);
            }
            return result;
        }
        EStructuralFeature result = this.createFeature(eClass, name, eClassifier, xsdComponent, minOccurs, maxOccurs);
        return result;
    }

    protected EStructuralFeature createFeature(EClass eClass, XSDAttributeDeclaration xsdAttributeDeclaration, String name, XSDComponent xsdComponent, boolean isRequired) {
        boolean isMany;
        XSDSimpleTypeDefinition attributeTypeDefinition = xsdAttributeDeclaration.getTypeDefinition();
        XSDTypeDefinition referenceType = this.getEcoreTypeQNameAttribute(xsdAttributeDeclaration, "reference");
        if (referenceType != null) {
            int lowerBound = isRequired ? 1 : 0;
            int upperBound = 1;
            if (attributeTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL) {
                XSDMaxLengthFacet xsdMaxLengthFacet;
                XSDMinLengthFacet xsdMinLengthFacet;
                if (isRequired && (xsdMinLengthFacet = attributeTypeDefinition.getEffectiveMinLengthFacet()) != null) {
                    lowerBound = xsdMinLengthFacet.getValue();
                }
                upperBound = (xsdMaxLengthFacet = attributeTypeDefinition.getEffectiveMaxLengthFacet()) != null ? xsdMaxLengthFacet.getValue() : -1;
            }
            EClassifier referenceClassifier = this.getEClassifier(referenceType);
            EStructuralFeature result = this.createFeature(eClass, name, referenceClassifier, xsdComponent, lowerBound, upperBound);
            return result;
        }
        boolean bl = isMany = attributeTypeDefinition.getVariety() == XSDVariety.LIST_LITERAL && xsdComponent instanceof XSDAttributeUse && "true".equals(this.getEcoreAttribute(xsdComponent, "many"));
        if (isMany) {
            XSDMaxLengthFacet xsdMaxLengthFacet;
            XSDMinLengthFacet xsdMinLengthFacet;
            EDataType eDataType = this.getEDataType(attributeTypeDefinition.getItemTypeDefinition());
            int lowerBound = isRequired ? 1 : 0;
            int upperBound = -1;
            if (isRequired && (xsdMinLengthFacet = attributeTypeDefinition.getEffectiveMinLengthFacet()) != null) {
                lowerBound = xsdMinLengthFacet.getValue();
            }
            if ((xsdMaxLengthFacet = attributeTypeDefinition.getEffectiveMaxLengthFacet()) != null) {
                upperBound = xsdMaxLengthFacet.getValue();
            }
            EStructuralFeature result = this.createFeature(eClass, name, eDataType, xsdComponent, lowerBound, upperBound);
            return result;
        }
        EDataType eDataType = this.getEDataType(attributeTypeDefinition);
        EStructuralFeature result = this.createFeature(eClass, name, eDataType, xsdComponent, isRequired ? 1 : 0, 1);
        return result;
    }

    protected void initialize(EAttribute eAttribute, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (XSDConstants.isOrIsDerivedFromID(xsdSimpleTypeDefinition)) {
            eAttribute.setID(true);
        }
        if (eAttribute.getDefaultValueLiteral() == null && xsdSimpleTypeDefinition != null && xsdSimpleTypeDefinition.getEffectiveEnumerationFacet() != null && eAttribute.getEType().getDefaultValue() != null) {
            eAttribute.setDefaultValueLiteral(((XSDEnumerationFacet)xsdSimpleTypeDefinition.getEffectiveEnumerationFacet().getSimpleTypeDefinition().getEnumerationFacets().get(0)).getLexicalValue());
        }
    }

    public List collectParticles(XSDParticle xsdParticle) {
        ArrayList result = new ArrayList();
        this.collectParticlesHelper(result, xsdParticle, 1, 1, null);
        return result;
    }

    public void collectParticlesHelper(List result, XSDParticle xsdParticle, int minOccurs, int maxOccurs, XSDModelGroup target) {
        int particleMaxOccurs = xsdParticle.getMaxOccurs();
        int effectiveMinOccurs = minOccurs * xsdParticle.getMinOccurs();
        int effectiveMaxOccurs = maxOccurs == -1 || particleMaxOccurs == -1 ? -1 : maxOccurs * particleMaxOccurs;
        XSDTerm xsdTerm = xsdParticle.getTerm();
        if (xsdTerm instanceof XSDModelGroup) {
            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
            EList particles = xsdModelGroup.getParticles();
            if (particles.size() == 0) {
                return;
            }
            boolean isIgnored = particleMaxOccurs == 1 || particles.size() == 1 && ((XSDParticle)particles.get(0)).getTerm() instanceof XSDModelGroup;
            String featureMapName = this.getEcoreAttribute(xsdParticle, "name");
            if (featureMapName == null && (featureMapName = this.getEcoreAttribute(xsdParticle, "featureMap")) == null && (featureMapName = this.getEcoreAttribute(xsdTerm, "name")) == null) {
                featureMapName = this.getEcoreAttribute(xsdTerm, "featureMap");
            }
            if ("".equals(featureMapName)) {
                isIgnored = true;
            } else if (featureMapName != null) {
                isIgnored = false;
            } else if (target != null) {
                isIgnored = true;
            }
            if (!isIgnored) {
                EffectiveOccurrence effectiveOccurrence = new EffectiveOccurrence(effectiveMinOccurs, effectiveMaxOccurs, xsdParticle, null);
                result.add(effectiveOccurrence);
                target = xsdModelGroup;
            }
            if (xsdModelGroup.getCompositor() == XSDCompositor.CHOICE_LITERAL) {
                effectiveMinOccurs = 0;
            }
            Iterator i2 = ((XSDModelGroup)xsdTerm).getParticles().iterator();
            while (i2.hasNext()) {
                XSDParticle childXSDParticle = (XSDParticle)i2.next();
                this.collectParticlesHelper(result, childXSDParticle, effectiveMinOccurs, effectiveMaxOccurs, target);
            }
        } else {
            EffectiveOccurrence effectiveOccurrence = new EffectiveOccurrence(effectiveMinOccurs, effectiveMaxOccurs, xsdParticle, target);
            result.add(effectiveOccurrence);
        }
    }

    protected void fixXMLName(EClassifier eClassifier) {
        EDataType objectType = (EDataType)this.typeToTypeObjectMap.get(eClassifier);
        if (objectType != null) {
            this.extendedMetaData.setName(objectType, this.extendedMetaData.getName(eClassifier) + ":Object");
            this.extendedMetaData.setBaseType(objectType, (EDataType)eClassifier);
        }
        if (eClassifier instanceof EDataType) {
            List memberTypes;
            EDataType itemType;
            EDataType eDataType = (EDataType)eClassifier;
            EDataType baseType = this.extendedMetaData.getBaseType(eDataType);
            if (baseType != null && this.extendedMetaData.getName(baseType).endsWith("_._base")) {
                this.extendedMetaData.setName(baseType, this.extendedMetaData.getName(eClassifier) + "_._base");
                this.extendedMetaData.setBaseType(eDataType, baseType);
                this.fixXMLName(baseType);
            }
            if ((itemType = this.extendedMetaData.getItemType(eDataType)) != null && this.extendedMetaData.getName(itemType).endsWith("_._item")) {
                this.extendedMetaData.setName(itemType, this.extendedMetaData.getName(eClassifier) + "_._item");
                this.extendedMetaData.setItemType(eDataType, itemType);
                this.fixXMLName(itemType);
            }
            if (!(memberTypes = this.extendedMetaData.getMemberTypes(eDataType)).isEmpty()) {
                ListIterator i2 = memberTypes.listIterator();
                while (i2.hasNext()) {
                    EDataType memberType = (EDataType)i2.next();
                    if (!this.extendedMetaData.getName(memberType).endsWith("_._member_._" + i2.previousIndex())) continue;
                    this.extendedMetaData.setName(memberType, this.extendedMetaData.getName(eClassifier) + "_._member_._" + i2.previousIndex());
                    this.fixXMLName(memberType);
                }
                this.extendedMetaData.setMemberTypes(eDataType, memberTypes);
            }
        } else {
            EStructuralFeature simpleFeature = this.extendedMetaData.getSimpleFeature((EClass)eClassifier);
            if (simpleFeature != null && this.extendedMetaData.getName(simpleFeature.getEType()).endsWith("_._base")) {
                EDataType baseType = (EDataType)simpleFeature.getEType();
                this.extendedMetaData.setName(baseType, this.extendedMetaData.getName(eClassifier) + "_._base");
                this.fixXMLName(baseType);
            }
        }
    }

    protected void resolveNameConflicts() {
        Iterator i2 = this.targetNamespaceToEPackageMap.values().iterator();
        while (i2.hasNext()) {
            EPackage ePackage = (EPackage)i2.next();
            HashMap<String, EClassifier> eClassifierMap = new HashMap<String, EClassifier>();
            Iterator j2 = ePackage.getEClassifiers().iterator();
            while (j2.hasNext()) {
                EClassifier eClassifier = (EClassifier)j2.next();
                EClassifier otherEClassifier = (EClassifier)eClassifierMap.get(eClassifier.getName().toLowerCase());
                if (otherEClassifier != null) {
                    this.resolveNameConflict(eClassifierMap, eClassifier, "");
                }
                eClassifierMap.put(eClassifier.getName().toLowerCase(), eClassifier);
                String xmlName = this.extendedMetaData.getName(eClassifier);
                otherEClassifier = this.extendedMetaData.getType(ePackage, xmlName);
                if (otherEClassifier != eClassifier && xmlName.endsWith("_._type")) {
                    String baseName = xmlName.substring(0, xmlName.length() - 7);
                    int index = 1;
                    while (this.extendedMetaData.getType(ePackage, baseName + "_._" + index + "_._type") != null) {
                        ++index;
                    }
                    this.extendedMetaData.setName(eClassifier, baseName + "_._" + index + "_._type");
                    this.fixXMLName(eClassifier);
                }
                if (!(eClassifier instanceof EClass)) continue;
                HashMap<String, EStructuralFeature> eFeatureMap = new HashMap<String, EStructuralFeature>();
                Iterator k2 = ((EClass)eClassifier).getEAllStructuralFeatures().iterator();
                while (k2.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)k2.next();
                    this.resolveNameConflict(eFeatureMap, eStructuralFeature, "");
                    eFeatureMap.put(eStructuralFeature.getName().toLowerCase(), eStructuralFeature);
                }
            }
        }
    }

    protected void resolveNameConflict(Map map, ENamedElement eNamedElement, String suffix) {
        String name = eNamedElement.getName();
        if (!name.endsWith(suffix)) {
            name = name + suffix;
        }
        if (map.containsKey(name.toLowerCase())) {
            int index = 0;
            while (map.containsKey(name.toLowerCase() + ++index)) {
            }
            eNamedElement.setName(name + index);
        } else {
            eNamedElement.setName(name);
        }
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        Map extensionToFactoryMap = result.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("wsdl", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("xsd", new XSDResourceFactoryImpl());
        if (ecoreResourceFactoryImplClass != null) {
            try {
                extensionToFactoryMap.put("ecore", ecoreResourceFactoryImplClass.newInstance());
            }
            catch (Exception exception) {
                XSDPlugin.INSTANCE.log(exception);
            }
        }
        return result;
    }

    public Collection generateResources(URI uri) {
        return this.generateResources(Collections.singleton(uri));
    }

    public Collection generateResources(Collection uris) {
        ResourceSet resourceSet = this.createResourceSet();
        Iterator<Object> i2 = uris.iterator();
        while (i2.hasNext()) {
            URI uri = (URI)i2.next();
            Resource resource = resourceSet.getResource(uri, true);
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof XSDSchema)) continue;
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        i2 = this.targetNamespaceToEPackageMap.values().iterator();
        while (i2.hasNext()) {
            EPackage ePackage = (EPackage)i2.next();
            if (ePackage.eResource() != null) continue;
            Resource ecoreResource = resourceSet.createResource(URI.createURI("*.ecore"));
            ecoreResource.setURI(URI.createURI(ePackage.getNsURI()));
            ecoreResource.getContents().add(ePackage);
        }
        return new ArrayList(resourceSet.getResources());
    }

    public EStructuralFeature getEStructuralFeature(XSDFeature xsdFeature) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)this.xsdComponentToEModelElementMap.get(xsdFeature);
        if (eStructuralFeature == null) {
            EStructuralFeature result;
            String name;
            EPackage ePackage = this.getEPackage(xsdFeature);
            EClass documentEClass = this.extendedMetaData.getDocumentRoot(ePackage);
            if (documentEClass == null) {
                documentEClass = EcoreFactory.eINSTANCE.createEClass();
                name = this.getEcoreAttribute(xsdFeature.getSchema(), "documentRoot");
                if (name == null) {
                    name = "DocumentRoot";
                }
                documentEClass.setName(name);
                this.extendedMetaData.setDocumentRoot(documentEClass);
                ePackage.getEClassifiers().add(documentEClass);
                this.createFeature(documentEClass, "mixed", EcorePackage.eINSTANCE.getEFeatureMapEntry(), null, 0, -1);
                EStructuralFeature xmlnsPrefixMapFeature = this.createFeature(documentEClass, "xMLNSPrefixMap", EcorePackage.eINSTANCE.getEStringToStringMapEntry(), null, 0, -1);
                this.extendedMetaData.setName(xmlnsPrefixMapFeature, "xmlns:prefix");
                EStructuralFeature xsiSchemaLocationMapFeature = this.createFeature(documentEClass, "xSISchemaLocation", EcorePackage.eINSTANCE.getEStringToStringMapEntry(), null, 0, -1);
                this.extendedMetaData.setName(xsiSchemaLocationMapFeature, "xsi:schemaLocation");
            }
            if ((name = this.getEcoreAttribute(xsdFeature, "name")) == null) {
                name = this.validName(xsdFeature.getName(), false);
            }
            if (xsdFeature instanceof XSDElementDeclaration) {
                result = this.createFeature(documentEClass, (XSDElementDeclaration)xsdFeature, name, (XSDComponent)xsdFeature, 0, -2);
                result.setDerived(true);
                result.setTransient(true);
                result.setVolatile(true);
                return result;
            }
            result = this.createFeature(documentEClass, (XSDAttributeDeclaration)xsdFeature, name, xsdFeature, false);
            return result;
        }
        return eStructuralFeature;
    }

    public Collection generate(URI uri) {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.getResource(uri, true);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
        result.remove(XMLNamespacePackage.eINSTANCE);
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        return result;
    }

    public Collection generate(Collection uris) {
        if (this.simpleDiagnostics == null) {
            this.simpleDiagnostics = new ArrayList();
        }
        ResourceSet resourceSet = this.createResourceSet();
        Iterator i2 = uris.iterator();
        while (i2.hasNext()) {
            Resource resource = resourceSet.getResource((URI)i2.next(), true);
            Iterator j2 = resource.getContents().iterator();
            while (j2.hasNext()) {
                Object object = j2.next();
                if (!(object instanceof XSDSchema)) continue;
                this.generate((XSDSchema)object);
            }
        }
        ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
        result.remove(XMLNamespacePackage.eINSTANCE);
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        result.add(this.simpleDiagnostics);
        return result;
    }

    public void generate(XSDSchema xsdSchema) {
        Iterator<Object> i2;
        XSDAttributeDeclaration xmlLangAttribute;
        this.rootSchema = xsdSchema;
        if (this.xsdSchemas.add(xsdSchema)) {
            this.addInput(xsdSchema);
            this.validate(xsdSchema);
        }
        if (this.xsdSchemas.size() == 1 && !"http://www.w3.org/XML/1998/namespace".equals(xsdSchema.getTargetNamespace()) && (xmlLangAttribute = xsdSchema.resolveAttributeDeclaration("http://www.w3.org/XML/1998/namespace", "lang")).getContainer() != null) {
            this.getEPackage(xmlLangAttribute);
        }
        ArrayList visitedElementDeclarations = new ArrayList();
        ArrayList elementDeclarations = new ArrayList(xsdSchema.getElementDeclarations());
        ArrayList visitedAttributeDeclarations = new ArrayList();
        ArrayList attributeDeclarations = new ArrayList(xsdSchema.getAttributeDeclarations());
        ArrayList visitedTypeDefinitions = new ArrayList();
        ArrayList typeDefinitions = new ArrayList(xsdSchema.getTypeDefinitions());
        while (!(elementDeclarations.isEmpty() && attributeDeclarations.isEmpty() && typeDefinitions.isEmpty())) {
            i2 = elementDeclarations.iterator();
            while (i2.hasNext()) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)i2.next();
                this.getEStructuralFeature(xsdElementDeclaration);
            }
            visitedElementDeclarations.addAll(elementDeclarations);
            elementDeclarations = new ArrayList(xsdSchema.getElementDeclarations());
            elementDeclarations.removeAll(visitedElementDeclarations);
            i2 = attributeDeclarations.iterator();
            while (i2.hasNext()) {
                XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)i2.next();
                if (XSDConstants.isSchemaInstanceNamespace(xsdAttributeDeclaration.getTargetNamespace())) continue;
                this.getEStructuralFeature(xsdAttributeDeclaration);
            }
            visitedAttributeDeclarations.addAll(attributeDeclarations);
            attributeDeclarations = new ArrayList(xsdSchema.getAttributeDeclarations());
            attributeDeclarations.removeAll(visitedAttributeDeclarations);
            i2 = typeDefinitions.iterator();
            while (i2.hasNext()) {
                XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)i2.next();
                this.getEClassifier(xsdTypeDefinition);
            }
            visitedTypeDefinitions.addAll(typeDefinitions);
            typeDefinitions = new ArrayList(xsdSchema.getTypeDefinitions());
            typeDefinitions.removeAll(visitedTypeDefinitions);
        }
        this.resolveNameConflicts();
        i2 = this.xsdSchemas.iterator();
        while (i2.hasNext()) {
            String packageNsPrefix;
            XSDSchema generatedXSDSchema = (XSDSchema)i2.next();
            EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(generatedXSDSchema.getTargetNamespace());
            if (ePackage == null) continue;
            String packageName = this.getEcoreAttribute(generatedXSDSchema, "package");
            if (packageName != null) {
                ePackage.setName(packageName);
            }
            if ((packageNsPrefix = this.getEcoreAttribute(generatedXSDSchema, "nsPrefix")) == null) continue;
            ePackage.setNsPrefix(packageNsPrefix);
        }
        i2 = this.eReferenceToOppositeNameMap.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = (Map.Entry)i2.next();
            EReference eReference = (EReference)entry.getKey();
            String opposite = (String)entry.getValue();
            EClass oppositeEClass = eReference.getEReferenceType();
            if (eReference.isContainment()) {
                EReference eOpposite = EcoreFactory.eINSTANCE.createEReference();
                eOpposite.setName(opposite);
                eOpposite.setEType(eReference.getEContainingClass());
                eOpposite.setLowerBound(0);
                eOpposite.setEOpposite(eReference);
                eReference.setEOpposite(eOpposite);
                eOpposite.setTransient(true);
                oppositeEClass.getEStructuralFeatures().add(eOpposite);
                continue;
            }
            if (eReference.getEOpposite() != null) continue;
            EStructuralFeature eOppositeFeature = oppositeEClass.getEStructuralFeature(opposite);
            if (eOppositeFeature == null) {
                Iterator j2 = oppositeEClass.getEAllStructuralFeatures().iterator();
                while (i2.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)j2.next();
                    if (!opposite.equals(this.extendedMetaData.getName(feature))) continue;
                    eOppositeFeature = feature;
                    break;
                }
            }
            if (!(eOppositeFeature instanceof EReference)) continue;
            EReference eOpposite = (EReference)eOppositeFeature;
            eOpposite.setEOpposite(eReference);
            eReference.setEOpposite(eOpposite);
        }
        this.eReferenceToOppositeNameMap.clear();
    }

    protected String validName(String name, boolean isUpperCase) {
        List parsedName = this.parseName(name, '_');
        StringBuffer result = new StringBuffer();
        Iterator i2 = parsedName.iterator();
        while (i2.hasNext()) {
            String nameComponent = (String)i2.next();
            if (nameComponent.length() <= 0) continue;
            if (result.length() > 0 || isUpperCase) {
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
                continue;
            }
            result.append(nameComponent);
        }
        return result.length() == 0 ? "_" : (Character.isJavaIdentifierStart(result.charAt(0)) ? (isUpperCase ? result.toString() : this.uncapName(result.toString())) : "_" + result);
    }

    protected List parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuffer currentWord = new StringBuffer();
            boolean lastIsLower = false;
            int length = sourceName.length();
            for (int index = 0; index < length; ++index) {
                char curChar = sourceName.charAt(index);
                if (!Character.isJavaIdentifierPart(curChar)) {
                    curChar = separator;
                }
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar == separator) continue;
                currentWord.append(curChar);
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public String uncapName(String name) {
        int i2;
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        for (i2 = 0; i2 < name.length() && name.charAt(i2) != lowerName.charAt(i2); ++i2) {
        }
        if (i2 > 1 && i2 < name.length()) {
            --i2;
        }
        return name.substring(0, i2).toLowerCase() + name.substring(i2);
    }

    protected String getEcoreAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        if (xsdConcreteComponent == null) {
            return null;
        }
        Element element = xsdConcreteComponent.getElement();
        return this.getEcoreAttribute(element, attribute);
    }

    protected String getEcoreAttribute(Element element, String attribute) {
        return element != null && element.hasAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute) ? element.getAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute) : null;
    }

    protected XSDTypeDefinition getEcoreTypeQNameAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        String qName;
        XSDTypeDefinition result;
        Element element = xsdConcreteComponent.getElement();
        if (element != null && element.hasAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute) && (result = xsdConcreteComponent.resolveTypeDefinitionURI(XSDConstants.lookupQName(element, qName = element.getAttributeNS("http://www.eclipse.org/emf/2002/Ecore", attribute)))).getContainer() != null) {
            return result;
        }
        return null;
    }

    public static List sortNamedComponents(Collection eNamedElements) {
        Object[] objects = eNamedElements.toArray();
        Arrays.sort(objects, Comparator.INSTANCE);
        return Arrays.asList(objects);
    }

    public static void addToSortedList(List eNamedElements, ENamedElement eNamedElement) {
        int index = Collections.binarySearch(eNamedElements, eNamedElement, Comparator.INSTANCE);
        if (index < 0) {
            eNamedElements.add(-(index + 1), eNamedElement);
        } else if (eNamedElements.get(index) != eNamedElement) {
            eNamedElements.add(index, eNamedElement);
        }
    }

    public static boolean isLocalReferenceType(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        while (xsdSimpleTypeDefinition != null) {
            if (XSDConstants.isAnySimpleType(xsdSimpleTypeDefinition)) {
                return false;
            }
            String name = xsdSimpleTypeDefinition.getName();
            if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace()) && ("IDREF".equals(name) || "IDREFS".equals(name))) {
                return true;
            }
            xsdSimpleTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        }
        return false;
    }

    protected void setAnnotations(EModelElement eModelElement, XSDConcreteComponent xsdComponent) {
        ArrayList<XSDAnnotation> xsdAnnotations = new ArrayList<XSDAnnotation>();
        if (xsdComponent instanceof XSDParticle) {
            xsdComponent = ((XSDParticle)xsdComponent).getContent();
        }
        if (xsdComponent instanceof XSDAttributeDeclaration) {
            xsdAnnotations.add(((XSDAttributeDeclaration)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDAttributeUse) {
            xsdAnnotations.add(((XSDAttributeUse)xsdComponent).getContent().getAnnotation());
        } else if (xsdComponent instanceof XSDElementDeclaration) {
            xsdAnnotations.add(((XSDElementDeclaration)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDAttributeGroupDefinition) {
            xsdAnnotations.add(((XSDAttributeGroupDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDElementDeclaration) {
            xsdAnnotations.add(((XSDElementDeclaration)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDFacet) {
            xsdAnnotations.add(((XSDFacet)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDIdentityConstraintDefinition) {
            xsdAnnotations.add(((XSDIdentityConstraintDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDModelGroup) {
            xsdAnnotations.add(((XSDModelGroup)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDModelGroupDefinition) {
            xsdAnnotations.add(((XSDModelGroupDefinition)xsdComponent).getAnnotation());
        } else if (xsdComponent instanceof XSDSchema) {
            xsdAnnotations.addAll(((XSDSchema)xsdComponent).getAnnotations());
        } else if (xsdComponent instanceof XSDTypeDefinition) {
            xsdAnnotations.addAll(((XSDTypeDefinition)xsdComponent).getAnnotations());
        } else if (xsdComponent instanceof XSDWildcard) {
            xsdAnnotations.add(((XSDWildcard)xsdComponent).getAnnotation());
        }
        Iterator i2 = xsdAnnotations.iterator();
        while (i2.hasNext()) {
            Element element;
            XSDAnnotation xsdAnnotation = (XSDAnnotation)i2.next();
            if (xsdAnnotation == null || "true".equals(this.getEcoreAttribute(xsdAnnotation, "ignore"))) continue;
            Iterator j2 = xsdAnnotation.getUserInformation().iterator();
            while (j2.hasNext()) {
                element = (Element)j2.next();
                if (element.getFirstChild() == null || "true".equals(this.getEcoreAttribute(element, "ignore"))) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XSDResourceImpl.serialize((OutputStream)byteArrayOutputStream, element, "UTF-8");
                try {
                    String documentation = byteArrayOutputStream.toString("UTF8");
                    int start = documentation.indexOf("?>");
                    start = documentation.indexOf(">", start + 2);
                    int end = documentation.lastIndexOf("</");
                    String documentationBody = documentation.substring(start + 1, end);
                    String existingDocumentation = EcoreUtil.getDocumentation(eModelElement);
                    if (existingDocumentation != null) {
                        documentationBody = existingDocumentation + System.getProperty("line.separator") + documentationBody;
                    }
                    EcoreUtil.setDocumentation(eModelElement, documentationBody);
                }
                catch (UnsupportedEncodingException exception) {
                    throw new WrappedException(exception);
                }
            }
            j2 = xsdAnnotation.getApplicationInformation().iterator();
            while (j2.hasNext()) {
                element = (Element)j2.next();
                if (element.getFirstChild() == null || "true".equals(this.getEcoreAttribute(element, "ignore"))) continue;
                String sourceURI = element.hasAttributeNS(null, "source") ? element.getAttributeNS(null, "source") : null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XSDResourceImpl.serialize((OutputStream)byteArrayOutputStream, element, "UTF-8");
                try {
                    EAnnotation eAnnotation;
                    String existingApplicationInformation;
                    String applicationInformation = byteArrayOutputStream.toString("UTF8");
                    int start = applicationInformation.indexOf("?>");
                    start = applicationInformation.indexOf(">", start + 2);
                    int end = applicationInformation.lastIndexOf("</");
                    String applicationInformationBody = applicationInformation.substring(start + 1, end);
                    String key = this.getEcoreAttribute(element, "key");
                    if (key == null) {
                        key = "appinfo";
                    }
                    String string = existingApplicationInformation = (eAnnotation = eModelElement.getEAnnotation(sourceURI)) == null ? null : (String)eAnnotation.getDetails().get(key);
                    if (existingApplicationInformation != null) {
                        applicationInformationBody = existingApplicationInformation + System.getProperty("line.separator") + applicationInformationBody;
                    }
                    if (eAnnotation == null) {
                        eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                        eAnnotation.setSource(sourceURI);
                        eModelElement.getEAnnotations().add(eAnnotation);
                    }
                    eAnnotation.getDetails().put(key, applicationInformationBody);
                }
                catch (UnsupportedEncodingException exception) {
                    throw new WrappedException(exception);
                }
            }
        }
    }

    protected void validate(XSDSchema xsdSchema) {
        Iterator i2 = xsdSchema.getContents().iterator();
        while (i2.hasNext()) {
            Object content = i2.next();
            if (!(content instanceof XSDImport)) continue;
            XSDImport xsdImport = (XSDImport)content;
            xsdImport.resolveTypeDefinition(xsdImport.getNamespace(), "");
        }
        if (this.simpleDiagnostics != null || this.diagnostics != null) {
            xsdSchema.validate();
            if (!xsdSchema.getAllDiagnostics().isEmpty()) {
                if (this.simpleDiagnostics != null) {
                    i2 = xsdSchema.getAllDiagnostics().iterator();
                    while (i2.hasNext()) {
                        XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i2.next();
                        ArrayList<String> tuple = new ArrayList<String>();
                        tuple.add(xsdDiagnostic.getSeverity().toString());
                        String localizedSeverity = XSDPlugin.INSTANCE.getString("_UI_XSDDiagnosticSeverity_" + xsdDiagnostic.getSeverity());
                        tuple.add(XSDPlugin.INSTANCE.getString("_UI_DiagnosticFileLineColumn_message", new Object[]{localizedSeverity + ": " + xsdDiagnostic.getMessage() + " ", xsdDiagnostic.getLocationURI(), new Integer(xsdDiagnostic.getLine()), new Integer(xsdDiagnostic.getColumn())}));
                        this.simpleDiagnostics.add(tuple);
                    }
                }
                if (this.diagnostics != null) {
                    this.diagnostics.addAll(xsdSchema.getAllDiagnostics());
                }
            }
        }
    }

    static {
        Class theEcoreResourceFactoryImplClass = null;
        try {
            theEcoreResourceFactoryImplClass = CommonPlugin.loadClass("org.eclipse.emf.ecore.xmi", "org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ecoreResourceFactoryImplClass = theEcoreResourceFactoryImplClass;
    }

    public static class Comparator
    implements java.util.Comparator {
        public static Comparator INSTANCE = new Comparator();
        protected Collator collator = Collator.getInstance();

        public boolean equals(Object that) {
            return this == that;
        }

        public int compare(Object o1, Object o2) {
            ENamedElement eNamedElement1 = (ENamedElement)o1;
            ENamedElement eNamedElement2 = (ENamedElement)o2;
            String name1 = eNamedElement1.getName();
            String name2 = eNamedElement2.getName();
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return 1;
            }
            if (name2 == null) {
                return -1;
            }
            int result = this.collator.compare(name1, name2);
            return result;
        }
    }

    public static class EffectiveOccurrence {
        public int minOccurs;
        public int maxOccurs;
        public XSDParticle xsdParticle;
        public XSDModelGroup xsdModelGroup;

        public EffectiveOccurrence(int minOccurs, int maxOccurs, XSDParticle xsdParticle, XSDModelGroup xsdModelGroup) {
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.xsdParticle = xsdParticle;
            this.xsdModelGroup = xsdModelGroup;
        }
    }
}

