/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.protocol.classpath;

import com.metamatrix.common.protocol.MMURLConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Enumeration;

public class ClasspathURLConnection
extends MMURLConnection {
    public static String PROTOCOL = "classpath";

    public ClasspathURLConnection(URL u) {
        super(u);
    }

    public void connect() throws IOException {
        this.connected = true;
        if (this.action.equals("read") || this.action.equals("list")) {
            InputStream in = this.getResourceAsStream(this.url);
            if (in == null) {
                throw new FileNotFoundException(this.url.toString());
            }
            in.close();
            this.doOutput = false;
            this.doInput = true;
        } else {
            if (this.action.equals("write")) {
                this.doOutput = true;
                this.doInput = false;
                String msg = "classpath protocol does not support write. Failed to write to:" + this.url;
                throw new UnknownServiceException(msg);
            }
            if (this.action.equals("delete")) {
                String msg = "classpath protocol does not support delete. Failed to delete:" + this.url;
                throw new UnknownServiceException(msg);
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.action.equals("list")) {
            ArrayList<String> foundResouces = new ArrayList<String>();
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(this.url.getPath());
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                foundResouces.add(u.toString());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(foundResouces.toArray(new String[foundResouces.size()]));
            oos.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        InputStream in = null;
        in = this.getResourceAsStream(this.url);
        if (in != null) {
            return in;
        }
        String msg = "Resource not found for reading:" + this.url;
        throw new IOException(msg);
    }

    private InputStream getResourceAsStream(URL pathUrl) {
        InputStream in;
        String path = pathUrl.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path)) == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(path);
        }
        return in;
    }
}

