/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.visitor.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInlineView;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IPredicateCriteria;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.visitor.framework.AbstractLanguageVisitor;
import com.metamatrix.data.visitor.util.SQLReservedWords;
import java.util.Iterator;
import java.util.List;

public class SQLStringVisitor
extends AbstractLanguageVisitor
implements SQLReservedWords {
    private static final String ESCAPED_QUOTE = "''";
    private final int MAX_ALIAS_LENGTH = 0;
    protected static final String UNDEFINED = "<undefined>";
    protected static final String UNDEFINED_PARAM = "?";
    protected RuntimeMetadata metadata;
    protected StringBuffer buffer = new StringBuffer();
    static /* synthetic */ Class class$java$lang$Number;

    protected String getName(MetadataID id) {
        if (this.metadata == null) {
            return id.getName();
        }
        try {
            MetadataObject obj = this.metadata.getObject(id);
            if (obj == null) {
                return id.getName();
            }
            String nameInSource = obj.getNameInSource();
            if (nameInSource != null && nameInSource.length() > 0) {
                return nameInSource;
            }
            return id.getName();
        }
        catch (ConnectorException e) {
            return id.getName();
        }
    }

    public void append(ILanguageObject obj) {
        if (obj == null) {
            this.buffer.append(UNDEFINED);
        } else {
            this.visitNode(obj);
        }
    }

    protected void append(List items) {
        if (items != null && items.size() != 0) {
            this.append((ILanguageObject)items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.buffer.append(",").append(" ");
                this.append((ILanguageObject)items.get(i));
            }
        }
    }

    protected void append(ILanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.buffer.append(",").append(" ");
                this.append(items[i]);
            }
        }
    }

    protected String escapeString(String str) {
        return StringUtil.replaceAll((String)str, (String)"'", (String)ESCAPED_QUOTE);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void visit(IAggregate obj) {
        this.buffer.append(obj.getName()).append("(");
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        if (obj.getExpression() == null) {
            this.buffer.append("*");
        } else {
            this.append((ILanguageObject)obj.getExpression());
        }
        this.buffer.append(")");
    }

    public void visit(ICaseExpression obj) {
        int i;
        IElement element = obj.getExpression() instanceof IElement ? (IElement)obj.getExpression() : null;
        IFunction function = obj.getExpression() instanceof IFunction ? (IFunction)obj.getExpression() : null;
        this.buffer.append("CASE");
        this.buffer.append(" ");
        for (i = 0; i < obj.getWhenCount(); ++i) {
            if (!"NULL".equalsIgnoreCase(obj.getWhenExpression(i).toString())) continue;
            this.buffer.append("WHEN");
            this.buffer.append(" ");
            if (element != null) {
                this.visit(element);
            } else if (function != null) {
                this.visit(function);
            } else {
                this.append((ILanguageObject)obj.getExpression());
            }
            this.buffer.append(" ");
            this.buffer.append("IS");
            this.buffer.append(" ");
            this.buffer.append("NULL");
            this.buffer.append(" ");
            this.buffer.append("THEN");
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getThenExpression(i));
            this.buffer.append(" ");
        }
        for (i = 0; i < obj.getWhenCount(); ++i) {
            if ("NULL".equalsIgnoreCase(obj.getWhenExpression(i).toString())) continue;
            this.buffer.append("WHEN");
            this.buffer.append(" ");
            if (element != null) {
                this.visit(element);
            } else if (function != null) {
                this.visit(function);
            } else {
                this.append((ILanguageObject)obj.getExpression());
            }
            this.buffer.append("=");
            this.append((ILanguageObject)obj.getWhenExpression(i));
            this.buffer.append(" ");
            this.buffer.append("THEN");
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getThenExpression(i));
            this.buffer.append(" ");
        }
        if (obj.getElseExpression() != null) {
            this.buffer.append("ELSE");
            this.buffer.append(" ");
            if (obj.getElseExpression() instanceof IElement || obj.getElseExpression() instanceof IFunction) {
                if (element != null) {
                    this.visit(element);
                } else if (function != null) {
                    this.visit(function);
                } else {
                    this.append((ILanguageObject)obj.getExpression());
                }
            } else {
                this.append((ILanguageObject)obj.getElseExpression());
            }
            this.buffer.append(" ");
        }
        this.buffer.append("END");
    }

    public void visit(ICompareCriteria obj) {
        this.append((ILanguageObject)obj.getLeftExpression());
        this.buffer.append(" ");
        int op = obj.getOperator();
        switch (op) {
            case 0: {
                this.buffer.append("=");
                break;
            }
            case 5: {
                this.buffer.append(">=");
                break;
            }
            case 4: {
                this.buffer.append(">");
                break;
            }
            case 3: {
                this.buffer.append("<=");
                break;
            }
            case 2: {
                this.buffer.append("<");
                break;
            }
            case 1: {
                this.buffer.append("<>");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        this.append((ILanguageObject)obj.getRightExpression());
    }

    public void visit(ICompoundCriteria obj) {
        String opString = null;
        int op = obj.getOperator();
        switch (op) {
            case 0: {
                opString = "AND";
                break;
            }
            case 1: {
                opString = "OR";
                break;
            }
            default: {
                opString = UNDEFINED;
            }
        }
        List criteria = obj.getCriteria();
        if (criteria == null || criteria.size() == 0) {
            this.buffer.append(UNDEFINED);
        } else if (criteria.size() == 1) {
            this.append((ILanguageObject)criteria.get(0));
        } else {
            this.buffer.append("(");
            this.append((ILanguageObject)criteria.get(0));
            this.buffer.append(")");
            for (int i = 1; i < criteria.size(); ++i) {
                this.buffer.append(" ").append(opString).append(" ").append("(");
                this.append((ILanguageObject)criteria.get(i));
                this.buffer.append(")");
            }
        }
    }

    public void visit(IDelete obj) {
        this.buffer.append("DELETE").append(" ").append("FROM").append(" ");
        this.append((ILanguageObject)obj.getGroup());
        if (obj.getCriteria() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((ILanguageObject)obj.getCriteria());
        }
    }

    protected String replaceElementName(String group, String element) {
        return null;
    }

    public void visit(IElement obj) {
        String elemShortName;
        String replacementElement;
        String groupName = null;
        IGroup group = obj.getGroup();
        if (group != null) {
            MetadataID groupID;
            groupName = group.getDefinition() != null ? group.getContext() : ((groupID = group.getMetadataID()) != null ? this.getName(groupID) : group.getContext());
        }
        if ((replacementElement = this.replaceElementName(groupName, elemShortName = this.getElementShortName(obj))) != null) {
            this.buffer.append(replacementElement);
        } else {
            if (groupName != null) {
                this.buffer.append(groupName);
                this.buffer.append(".");
            }
            this.buffer.append(elemShortName);
        }
    }

    public String getElementShortName(IElement obj) {
        String elemShortName = null;
        MetadataID elementID = obj.getMetadataID();
        if (elementID != null) {
            elemShortName = this.getName(elementID);
        } else {
            String elementName = obj.getName();
            elemShortName = this.getShortName(elementName);
        }
        return elemShortName;
    }

    public String getShortName(String elementName) {
        int lastDot = elementName.lastIndexOf(".");
        String elemShortName = lastDot >= 0 ? elementName.substring(lastDot + 1) : elementName;
        return elemShortName;
    }

    public void visit(IProcedure obj) {
        this.buffer.append("EXEC").append(" ");
        if (obj.getMetadataID() != null) {
            this.buffer.append(this.getName(obj.getMetadataID()));
        } else {
            this.buffer.append(obj.getProcedureName());
        }
        this.buffer.append("(");
        List params = obj.getParameters();
        if (params != null && params.size() != 0) {
            IParameter param = null;
            for (int i = 0; i < params.size(); ++i) {
                param = (IParameter)params.get(i);
                if (param.getDirection() != 0 && param.getDirection() != 2) continue;
                if (i != 0) {
                    this.buffer.append(",").append(" ");
                }
                if (param.getValue() != null) {
                    this.buffer.append(param.getValue().toString());
                    continue;
                }
                this.buffer.append(UNDEFINED_PARAM);
            }
        }
        this.buffer.append(")");
    }

    public void visit(IExistsCriteria obj) {
        this.buffer.append("EXISTS").append(" ").append("(");
        this.append((ILanguageObject)obj.getQuery());
        this.buffer.append(")");
    }

    public void visit(IFrom obj) {
        this.buffer.append("FROM").append(" ");
        this.append(obj.getItems());
    }

    public void visit(IFunction obj) {
        String name = obj.getName();
        IExpression[] args = obj.getParameters();
        if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            Object firstArg = null;
            Object secondArg = null;
            if (args[1] instanceof IElement) {
                Object typeValue = ((ILiteral)args[0]).getValue();
                IExpression expression = args[1];
                firstArg = typeValue;
                secondArg = expression;
            } else {
                Object typeValue = ((ILiteral)args[1]).getValue();
                IExpression expression = args[0];
                firstArg = expression;
                secondArg = typeValue;
            }
            this.buffer.append(name);
            this.buffer.append("(");
            if (firstArg instanceof IExpression) {
                this.append((ILanguageObject)((IExpression)firstArg));
            } else {
                this.buffer.append(firstArg);
            }
            if (name.equalsIgnoreCase("CONVERT")) {
                this.buffer.append(",");
                this.buffer.append(" ");
            } else {
                this.buffer.append(" ");
                this.buffer.append("AS");
                this.buffer.append(" ");
            }
            if (secondArg instanceof IExpression) {
                this.append((ILanguageObject)secondArg);
            } else {
                this.buffer.append(secondArg);
            }
            this.buffer.append(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.buffer.append("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.append((ILanguageObject)args[i]);
                    if (i >= args.length - 1) continue;
                    this.buffer.append(" ");
                    this.buffer.append(name);
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.buffer.append(name);
            this.buffer.append("(");
            if (args != null && args.length > 0) {
                this.buffer.append(((ILiteral)args[0]).getValue());
                for (int i = 1; i < args.length; ++i) {
                    this.buffer.append(",");
                    this.buffer.append(" ");
                    this.append((ILanguageObject)args[i]);
                }
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(obj.getName()).append("(");
            this.append((ILanguageObject[])obj.getParameters());
            this.buffer.append(")");
        }
    }

    public void visit(IGroup obj) {
        MetadataID groupID = obj.getMetadataID();
        if (groupID != null) {
            this.buffer.append(this.getName(groupID));
        } else if (obj.getDefinition() == null) {
            this.buffer.append(obj.getContext());
        } else {
            this.buffer.append(obj.getDefinition());
        }
        if (obj.getDefinition() != null) {
            this.buffer.append(" ");
            if (this.useAsInGroupAlias()) {
                this.buffer.append("AS").append(" ");
            }
            this.buffer.append(obj.getContext());
        }
    }

    protected boolean useAsInGroupAlias() {
        return true;
    }

    public void visit(IGroupBy obj) {
        this.buffer.append("GROUP").append(" ").append("BY").append(" ");
        this.append(obj.getElements());
    }

    public void visit(IInCriteria obj) {
        this.append((ILanguageObject)obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append(obj.getRightExpressions());
        this.buffer.append(")");
    }

    public void visit(IInlineView obj) {
        this.buffer.append("(");
        if (obj.getOutput() != null) {
            this.buffer.append(obj.getOutput());
        } else {
            this.append((ILanguageObject)obj.getQuery());
        }
        this.buffer.append(")");
        this.buffer.append(" ");
        if (this.useAsInGroupAlias()) {
            this.buffer.append("AS");
            this.buffer.append(" ");
        }
        this.buffer.append(obj.getContext());
    }

    public void visit(IInsert obj) {
        this.formatBasicInsert(obj);
        this.buffer.append(" ").append("VALUES").append(" ").append("(");
        this.append(obj.getValues());
        this.buffer.append(")");
    }

    private void formatBasicInsert(IInsert obj) {
        this.buffer.append("INSERT").append(" ").append("INTO").append(" ");
        this.append((ILanguageObject)obj.getGroup());
        if (obj.getElements() != null && obj.getElements().size() != 0) {
            this.buffer.append(" ").append("(");
            this.append(obj.getElements());
            this.buffer.append(")");
        }
    }

    public void visit(IBulkInsert obj) {
        this.formatBasicInsert((IInsert)obj);
        this.buffer.append(" ").append("VALUES").append(" ").append("(");
        int elementCount = obj.getElements().size();
        for (int i = 0; i < elementCount; ++i) {
            this.buffer.append(UNDEFINED_PARAM);
            if (i >= elementCount - 1) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
    }

    public void visit(IIsNullCriteria obj) {
        this.append((ILanguageObject)obj.getExpression());
        this.buffer.append(" ").append("IS").append(" ");
        if (obj.isNegated()) {
            this.buffer.append("NOT").append(" ");
        }
        this.buffer.append("NULL");
    }

    public void visit(IJoin obj) {
        IFromItem leftItem = obj.getLeftItem();
        if (leftItem instanceof IJoin) {
            this.buffer.append("(");
            this.append((ILanguageObject)leftItem);
            this.buffer.append(")");
        } else {
            this.append((ILanguageObject)leftItem);
        }
        this.buffer.append(" ");
        int type = obj.getJoinType();
        switch (type) {
            case 1: {
                this.buffer.append("CROSS");
                break;
            }
            case 4: {
                this.buffer.append("FULL").append(" ").append("OUTER");
                break;
            }
            case 0: {
                this.buffer.append("INNER");
                break;
            }
            case 2: {
                this.buffer.append("LEFT").append(" ").append("OUTER");
                break;
            }
            case 3: {
                this.buffer.append("RIGHT").append(" ").append("OUTER");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ").append("JOIN").append(" ");
        IFromItem rightItem = obj.getRightItem();
        if (rightItem instanceof IJoin) {
            this.buffer.append("(");
            this.append((ILanguageObject)rightItem);
            this.buffer.append(")");
        } else {
            this.append((ILanguageObject)rightItem);
        }
        List criteria = obj.getCriteria();
        if (criteria != null && criteria.size() != 0) {
            this.buffer.append(" ").append("ON").append(" ");
            Iterator critIter = criteria.iterator();
            while (critIter.hasNext()) {
                ICriteria crit = (ICriteria)critIter.next();
                if (crit instanceof IPredicateCriteria) {
                    this.append((ILanguageObject)crit);
                } else {
                    this.buffer.append("(");
                    this.append((ILanguageObject)crit);
                    this.buffer.append(")");
                }
                if (!critIter.hasNext()) continue;
                this.buffer.append(" ").append("AND").append(" ");
            }
        }
    }

    public void visit(ILikeCriteria obj) {
        this.append((ILanguageObject)obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("LIKE").append(" ");
        this.append((ILanguageObject)obj.getRightExpression());
        if (obj.getEscapeCharacter() != null) {
            this.buffer.append(" ").append("ESCAPE").append(" ").append("'").append(obj.getEscapeCharacter().toString()).append("'");
        }
    }

    public void visit(ILimit obj) {
        this.buffer.append("LIMIT").append(" ");
        if (obj.getRowOffset() > 0) {
            this.buffer.append(obj.getRowOffset()).append(",").append(" ");
        }
        this.buffer.append(obj.getRowLimit());
    }

    public void visit(ILiteral obj) {
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            Class type = obj.getType();
            String val = obj.getValue().toString();
            if ((class$java$lang$Number == null ? (class$java$lang$Number = SQLStringVisitor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
                this.buffer.append(val);
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                this.buffer.append("{b'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                this.buffer.append("{ts'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                this.buffer.append("{t'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                this.buffer.append("{d'").append(val).append("'}");
            } else {
                this.buffer.append("'").append(this.escapeString(val)).append("'");
            }
        }
    }

    public void visit(INotCriteria obj) {
        this.buffer.append("NOT").append(" ").append("(");
        this.append((ILanguageObject)obj.getCriteria());
        this.buffer.append(")");
    }

    public void visit(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        this.append(obj.getItems());
    }

    public void visit(IOrderByItem obj) {
        if (obj.getElement() != null) {
            this.visit(obj.getElement());
        } else {
            String name = obj.getName();
            this.buffer.append(name);
        }
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    public void visit(IParameter obj) {
        if (obj.getValue() == null) {
            this.buffer.append(UNDEFINED_PARAM);
        } else if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            this.buffer.append(obj.getValue().toString());
        }
    }

    public void visit(IQuery obj) {
        this.appendQuery(obj);
    }

    protected void appendQuery(IQuery obj) {
        this.append((ILanguageObject)obj.getSelect());
        if (obj.getFrom() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((ILanguageObject)obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append((ILanguageObject)obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getLimit());
        }
    }

    public void visit(ISearchedCaseExpression obj) {
        this.buffer.append("CASE");
        int whenCount = obj.getWhenCount();
        for (int i = 0; i < whenCount; ++i) {
            this.buffer.append(" ").append("WHEN").append(" ");
            this.append((ILanguageObject)obj.getWhenCriteria(i));
            this.buffer.append(" ").append("THEN").append(" ");
            this.append((ILanguageObject)obj.getThenExpression(i));
        }
        if (obj.getElseExpression() != null) {
            this.buffer.append(" ").append("ELSE").append(" ");
            this.append((ILanguageObject)obj.getElseExpression());
        }
        this.buffer.append(" ").append("END");
    }

    public void visit(ISelect obj) {
        this.visitSelect(obj);
    }

    protected void visitSelect(ISelect obj) {
        this.buffer.append("SELECT").append(" ");
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getSelectSymbols());
    }

    public void visit(IScalarSubquery obj) {
        this.buffer.append("(");
        this.append((ILanguageObject)obj.getQuery());
        this.buffer.append(")");
    }

    public void visit(ISelectSymbol obj) {
        this.append((ILanguageObject)obj.getExpression());
        if (obj.hasAlias()) {
            this.buffer.append(" ").append("AS").append(" ").append(obj.getOutputName());
        }
    }

    public void visit(ISubqueryCompareCriteria obj) {
        this.append((ILanguageObject)obj.getLeftExpression());
        this.buffer.append(" ");
        int op = obj.getOperator();
        switch (op) {
            case 1: {
                this.buffer.append("=");
                break;
            }
            case 6: {
                this.buffer.append(">=");
                break;
            }
            case 5: {
                this.buffer.append(">");
                break;
            }
            case 4: {
                this.buffer.append("<=");
                break;
            }
            case 3: {
                this.buffer.append("<");
                break;
            }
            case 2: {
                this.buffer.append("<>");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        switch (obj.getQuantifier()) {
            case 1: {
                this.buffer.append("ALL");
                break;
            }
            case 0: {
                this.buffer.append("SOME");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        this.buffer.append("(");
        this.append((ILanguageObject)obj.getQuery());
        this.buffer.append(")");
    }

    public void visit(ISubqueryInCriteria obj) {
        this.append((ILanguageObject)obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append((ILanguageObject)obj.getQuery());
        this.buffer.append(")");
    }

    public void visit(IUpdate obj) {
        this.buffer.append("UPDATE").append(" ");
        this.append((ILanguageObject)obj.getGroup());
        this.buffer.append(" ").append("SET").append(" ");
        this.append(obj.getChanges());
        if (obj.getCriteria() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((ILanguageObject)obj.getCriteria());
        }
    }

    public void visit(IUnion obj) {
        this.appendQuery((IQuery)obj);
        Iterator queryIter = obj.getUnionQueries().iterator();
        Iterator allIter = obj.getUnionAllFlags().iterator();
        while (queryIter.hasNext()) {
            this.buffer.append(" ");
            this.buffer.append("UNION");
            Boolean allFlag = (Boolean)allIter.next();
            if (allFlag.equals(Boolean.TRUE)) {
                this.buffer.append(" ");
                this.buffer.append("ALL");
            }
            this.buffer.append(" ");
            IQuery query = (IQuery)queryIter.next();
            if (query instanceof IUnion) {
                this.buffer.append("(");
                this.append((ILanguageObject)query);
                this.buffer.append(")");
                continue;
            }
            this.appendQuery(query);
        }
        IOrderBy orderBy = obj.getUnionOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)orderBy);
        }
    }

    public static String getSQLString(ILanguageObject obj, RuntimeMetadata metadata) {
        SQLStringVisitor visitor = new SQLStringVisitor();
        visitor.setRuntimeMetadata(metadata);
        visitor.append(obj);
        return visitor.toString();
    }

    public void setRuntimeMetadata(RuntimeMetadata metadata) {
        this.metadata = metadata;
    }

    protected int getMaxSelectAliasLength() {
        return this.MAX_ALIAS_LENGTH;
    }

    protected int getMaxTableAliasLength() {
        return this.MAX_ALIAS_LENGTH;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

