/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.BatchFetcher;
import com.metamatrix.jdbc.BatchResults;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMBlob;
import com.metamatrix.jdbc.MMClob;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import com.metamatrix.query.util.ValueID;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class CursorResultsImpl
extends ResultsImpl
implements BatchFetcher {
    private int cursorType;
    private RequestID requestID = null;
    private String msgKey = null;
    private BatchResults batchResults;
    private int columnCount;
    private boolean[] isLOBColumn;
    private ResultsMessage currentResultMsg;
    static /* synthetic */ Class class$com$metamatrix$jdbc$CursorResultsImpl;
    static /* synthetic */ Class class$com$metamatrix$dqp$message$ResultsMessage;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$api$ResultSetMetaData;

    static CursorResultsImpl newInstance(ResultsMessage resultsMsg, MMStatement statement) {
        if (AOP.useproxy()) {
            return (CursorResultsImpl)((Object)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$CursorResultsImpl == null ? (class$com$metamatrix$jdbc$CursorResultsImpl = CursorResultsImpl.class$("com.metamatrix.jdbc.CursorResultsImpl")) : class$com$metamatrix$jdbc$CursorResultsImpl), (Class[])new Class[]{class$com$metamatrix$dqp$message$ResultsMessage == null ? (class$com$metamatrix$dqp$message$ResultsMessage = CursorResultsImpl.class$("com.metamatrix.dqp.message.ResultsMessage")) : class$com$metamatrix$dqp$message$ResultsMessage, class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = CursorResultsImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement}, (Object[])new Object[]{resultsMsg, statement}));
        }
        return new CursorResultsImpl(resultsMsg, statement);
    }

    static CursorResultsImpl newInstance(ResultsMessage resultsMsg, MMStatement statement, ResultSetMetaData rsmd) {
        if (AOP.useproxy()) {
            CursorResultsImpl obj = (CursorResultsImpl)((Object)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$CursorResultsImpl == null ? (class$com$metamatrix$jdbc$CursorResultsImpl = CursorResultsImpl.class$("com.metamatrix.jdbc.CursorResultsImpl")) : class$com$metamatrix$jdbc$CursorResultsImpl), (Class[])new Class[]{class$com$metamatrix$dqp$message$ResultsMessage == null ? (class$com$metamatrix$dqp$message$ResultsMessage = CursorResultsImpl.class$("com.metamatrix.dqp.message.ResultsMessage")) : class$com$metamatrix$dqp$message$ResultsMessage, class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = CursorResultsImpl.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, class$com$metamatrix$jdbc$api$ResultSetMetaData == null ? (class$com$metamatrix$jdbc$api$ResultSetMetaData = CursorResultsImpl.class$("com.metamatrix.jdbc.api.ResultSetMetaData")) : class$com$metamatrix$jdbc$api$ResultSetMetaData}, (Object[])new Object[]{resultsMsg, statement, rsmd}));
            return obj;
        }
        return new CursorResultsImpl(resultsMsg, statement, rsmd);
    }

    CursorResultsImpl(ResultsMessage resultsMsg, MMStatement statement) {
        this(resultsMsg, statement, null);
    }

    CursorResultsImpl(ResultsMessage resultsMsg, MMStatement statement, ResultSetMetaData rsmd) {
        super(resultsMsg, statement, rsmd);
        this.cursorType = statement.getResultSetType();
        this.requestID = resultsMsg.getRequestID();
        this.msgKey = resultsMsg.getMessageKey();
        try {
            this.columnCount = this.getMetaData().getColumnCount();
            this.isLOBColumn = new boolean[this.columnCount];
            java.sql.ResultSetMetaData rsMetadata = this.getMetaData();
            int columnType = 0;
            for (int i = 1; i <= this.columnCount; ++i) {
                columnType = rsMetadata.getColumnType(i);
                this.isLOBColumn[i - 1] = columnType == 2004 || columnType == 2005;
            }
            this.setResultsData(resultsMsg);
            this.batchResults.setBatchFetcher((BatchFetcher)this);
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void setResultsData(ResultsMessage resultsMsg) {
        if (resultsMsg.getException() != null) {
            this.setException(resultsMsg.getException());
            this.batchResults.setException((SQLException)MMSQLException.create((Throwable)resultsMsg.getException()));
            return;
        }
        List[] firstBatch = resultsMsg.getResults();
        if (resultsMsg.getFinalRow() >= 0) {
            this.finalRow = resultsMsg.getFinalRow();
        }
        boolean isLast = false;
        if (firstBatch.length == 0 || resultsMsg.getFinalRow() == resultsMsg.getLastRow()) {
            isLast = true;
        }
        if (this.batchResults == null) {
            this.batchResults = BatchResults.newInstance((List[])firstBatch, (int)resultsMsg.getFirstRow(), (int)resultsMsg.getLastRow(), (boolean)isLast, (int)resultsMsg.getFetchSize());
            this.batchResults.setLogger(this.getLogger());
        } else {
            this.batchResults.setBatch(resultsMsg.getFirstRow(), resultsMsg.getLastRow(), firstBatch, isLast);
        }
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            if (this.requestID != null && !this.statement.isClosed()) {
                CloseMessage closeMsg = new CloseMessage();
                closeMsg.setRequestID(this.requestID);
                this.statement.executeAsynch((Message)closeMsg, false);
            }
            this.isClosed = true;
        }
    }

    public int getFetchSize() throws SQLException {
        return this.batchResults.getFetchSize();
    }

    public boolean isFirst() throws SQLException {
        this.check("isFirst");
        return this.batchResults.isFirst();
    }

    private void check(String methodName) throws MMSQLException, SQLException {
        if (this.getException() != null) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Cant_check_method", new Object[]{methodName}));
        }
        this.checkClosed();
    }

    public boolean hasNext() throws SQLException {
        this.check("hasNext");
        return this.batchResults.hasNext();
    }

    public boolean isLast() throws SQLException {
        this.check("isLast");
        return this.batchResults.isLast();
    }

    public boolean next() throws SQLException {
        this.check("next");
        return this.batchResults.next();
    }

    public boolean hasPrevious() throws SQLException {
        this.check("hasPrevious");
        if (this.cursorType != 1004) {
            throw new MMSQLException(JDBCPlugin.Util.getString("CursorResultsImpl.Moving_back_on_fwd_only"));
        }
        return this.batchResults.hasPrevious();
    }

    public boolean previous() throws SQLException {
        this.check("previous");
        if (this.cursorType != 1004) {
            throw new MMSQLException(JDBCPlugin.Util.getString("CursorResultsImpl.Moving_back_on_fwd_only"));
        }
        return this.batchResults.previous();
    }

    public int getRow() throws SQLException {
        this.check("getRow");
        return this.batchResults.getCurrentRowNumber();
    }

    public Object getObject(int column) throws SQLException {
        return this.getObject(column, true);
    }

    private Object getObject(int column, boolean convertClobToString) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("ResultsImpl.Invalid_col_index", column));
        }
        List cursorRow = this.batchResults.getCurrentRow();
        this.currentValue = cursorRow.get(column - 1);
        if (this.currentValue != null && this.isLOBColumn[column - 1]) {
            ValueID id = (ValueID)this.currentValue;
            if (id.isBinary()) {
                return MMBlob.newInstance((MMStatement)((MMStatement)this.getStatement()), (ValueID)((ValueID)this.currentValue));
            }
            return MMClob.newInstance((MMStatement)((MMStatement)this.getStatement()), (ValueID)((ValueID)this.currentValue));
        }
        if (this.currentValue instanceof ValueID) {
            MMClob clob = MMClob.newInstance((MMStatement)((MMStatement)this.getStatement()), (ValueID)((ValueID)this.currentValue));
            if (convertClobToString) {
                return clob.toString();
            }
            return clob;
        }
        return this.currentValue;
    }

    public Object getObject(String columnName) throws SQLException {
        this.check("getObject");
        int index = this.findColumnIndex(columnName);
        return this.getObject(index);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.currentValue = this.getObject(columnIndex, false);
        if (this.currentValue == null) {
            return null;
        }
        return DataTypeTransformer.getClob((Object)this.currentValue);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public List getCurrentRecord() throws SQLException {
        this.check("getCurrentRecord");
        return this.batchResults.getCurrentRow();
    }

    public int getType() throws SQLException {
        return this.cursorType;
    }

    public boolean absolute(int row) throws SQLException {
        this.check("absolute");
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
            throw new MMSQLException(msg);
        }
        return this.batchResults.absolute(row);
    }

    protected Map getUpdatedPlanDescription() {
        if (this.currentResultMsg != null) {
            return this.currentResultMsg.getPlanDescription();
        }
        return null;
    }

    public void requestBatch(int beginRow, int endRow) throws SQLException {
        try {
            CursorRequestMessage requestMsg = new CursorRequestMessage();
            requestMsg.setBatchFirst(beginRow);
            requestMsg.setBatchLast(endRow);
            requestMsg.setRequestID(this.requestID);
            requestMsg.setMessageKey(this.msgKey);
            MessageListener listener = new MessageListener(){

                public void deliverMessage(Message msg, String messageKey) {
                    CursorResultsImpl.this.currentResultMsg = (ResultsMessage)msg;
                    CursorResultsImpl.this.setResultsData(CursorResultsImpl.this.currentResultMsg);
                }
            };
            this.statement.executeAsynch((Message)requestMsg, listener, false);
        }
        catch (Throwable ex) {
            this.isClosed = true;
            throw MMSQLException.create((Throwable)ex);
        }
    }

    public void beforeFirst() throws SQLException {
        this.check("beforeFirst");
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
            throw new MMSQLException(msg);
        }
        if (this.absolute(1)) {
            this.previous();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

