/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.base;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbcx.base.BaseConnectionWrapper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class BasePooledConnection
implements PooledConnection,
com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   3.10.1.1  $";
    protected BaseConnection realConnection;
    private Vector connectionEventListeners;
    protected boolean pooledConnectionBusy;
    protected BaseExceptions exceptions;
    private boolean connectionErrorOccurred;

    public BasePooledConnection(BaseConnection baseConnection) {
        this.realConnection = baseConnection;
        this.connectionEventListeners = new Vector();
        this.pooledConnectionBusy = false;
        this.exceptions = baseConnection.getExceptions();
    }

    public Statement createStatement() throws SQLException {
        return this.realConnection.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.realConnection.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.realConnection.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLException {
        return this.realConnection.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.realConnection.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.realConnection.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.realConnection.commit();
    }

    public void rollback() throws SQLException {
        this.realConnection.rollback();
    }

    public void abortConnection() throws SQLException {
        this.realConnection.abortConnection();
    }

    public void close() throws SQLException {
        this.realConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() throws SQLException {
        boolean bl;
        SQLWarning sQLWarning = null;
        Object object = this.realConnection;
        synchronized (object) {
            bl = this.realConnection.isClosed();
            if (bl) {
                sQLWarning = this.realConnection.getWarnings();
            }
        }
        if (bl) {
            while (sQLWarning != null) {
                object = sQLWarning.getSQLState();
                if (object != null && ((String)object).length() > 1 && ((String)object).charAt(0) == '0' && ((String)object).charAt(1) == '8') {
                    SQLException sQLException = new SQLException(sQLWarning.getMessage(), (String)object);
                    this.connectionErrorOccurred(sQLException);
                    return true;
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
        return bl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.realConnection.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.realConnection.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.realConnection.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.realConnection.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.realConnection.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.realConnection.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.realConnection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.realConnection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.realConnection.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.realConnection.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.realConnection.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.realConnection.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return this.realConnection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.realConnection.setTypeMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(List list, List list2) {
        try {
            BaseConnection baseConnection = this.realConnection;
            synchronized (baseConnection) {
                this.commonReset(list, list2);
                this.realConnection.reset();
            }
            this.connectionClosed();
        }
        catch (SQLException sQLException) {
            this.connectionErrorOccurred(sQLException);
        }
    }

    void commonReset(List list, List list2) throws SQLException {
        AutoCloseable autoCloseable;
        this.pooledConnectionBusy = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            autoCloseable = (Statement)iterator.next();
            autoCloseable.close();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            autoCloseable = (ResultSet)iterator.next();
            autoCloseable.close();
        }
    }

    void connectionClosed() throws SQLException {
        if (!this.connectionErrorOccurred) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            int n = this.connectionEventListeners.size();
            for (int i = 0; i < n; ++i) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(i);
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    void connectionErrorOccurred(SQLException sQLException) {
        this.connectionErrorOccurred = true;
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        int n = this.connectionEventListeners.size();
        for (int i = 0; i < n; ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(i);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        if (this.connectionEventListeners.contains(connectionEventListener)) {
            return;
        }
        this.connectionEventListeners.addElement(connectionEventListener);
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.pooledConnectionBusy) {
            throw this.exceptions.getException(6048);
        }
        BaseConnectionWrapper baseConnectionWrapper = new BaseConnectionWrapper(this, this.exceptions);
        this.pooledConnectionBusy = true;
        return baseConnectionWrapper;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        this.connectionEventListeners.removeElement(connectionEventListener);
    }

    public boolean unlock(String string) throws SQLException {
        return this.realConnection.unlock(string);
    }

    public void setHoldability(int n) throws SQLException {
        this.realConnection.setHoldability(n);
    }

    public int getHoldability() throws SQLException {
        return this.realConnection.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.realConnection.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.realConnection.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.realConnection.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.realConnection.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.realConnection.createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.realConnection.prepareStatement(string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.realConnection.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.realConnection.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.realConnection.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.realConnection.prepareStatement(string, stringArray);
    }

    public void setClientApplicationName(String string) throws SQLException {
        this.realConnection.setClientApplicationName(string);
    }

    public String getClientApplicationName() throws SQLException {
        return this.realConnection.getClientApplicationName();
    }

    public void setClientHostName(String string) throws SQLException {
        this.realConnection.setClientHostName(string);
    }

    public String getClientHostName() throws SQLException {
        return this.realConnection.getClientHostName();
    }

    public void setClientUser(String string) throws SQLException {
        this.realConnection.setClientUser(string);
    }

    public String getClientUser() throws SQLException {
        return this.realConnection.getClientUser();
    }

    public void setClientAccountingInfo(String string) throws SQLException {
        this.realConnection.setClientAccountingInfo(string);
    }

    public String getClientAccountingInfo() throws SQLException {
        return this.realConnection.getClientAccountingInfo();
    }
}

