/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.sybase.SybaseConnection;
import com.metamatrix.jdbc.sybase.SybaseImplConnection;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSExecuteRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilDebug;
import java.sql.SQLException;

public class SybaseImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.44.1.3  $";
    public static final int DBMS_NAME = 1;
    public static final int DBMS_VER = 2;
    public static final int DB_NAME = 6;
    public static final int OWNER_TERM = 10;
    public static final int TABLE_TERM = 11;
    public static final int MAX_OWNER_NAME_LENGTH = 12;
    public static final int TABLE_LENGTH = 13;
    public static final int MAX_QUAL_LENGTH = 14;
    public static final int COLUMN_LENGTH = 15;
    public static final int IDENTIFIER_CASE = 16;
    public static final int TX_ISOLATION = 17;
    public static final int COLLATION_SEQ = 18;
    public static final int SAVEPOINT_SUPPORT = 19;
    public static final int MULTI_RESULT_SETS = 20;
    public static final int ACCESSIBLE_TABLES = 22;
    public static final int USERID_LENGTH = 100;
    public static final int QUALIFIER_TERM = 101;
    public static final int NAMED_TRANSACTIONS = 102;
    public static final int SPROC_AS_LANGUAGE = 103;
    public static final int REMOTE_SPROC = 103;
    public static final int ACCESSIBLE_SPROC = 104;
    public static final int MAX_INDEX_COLS = 105;
    public static final int RENAME_TABLE = 106;
    public static final int RENAME_COLUMN = 107;
    public static final int DROP_COLUMN = 108;
    public static final int INCREASE_COLUMN_LENGTH = 109;
    public static final int DDL_IN_TRANSACTION = 110;
    public static final int DESCENDING_INDEXES = 111;
    public static final int SP_RENAME = 112;
    public static final int SYS_SPROC_VERSION = 500;
    static final Integer IntegerZero = new Integer(0);
    static BaseTypeInfos typeInfos;
    static BaseTypeInfo dateTypeInfo;
    static BaseTypeInfo timeTypeInfo;
    private BaseConnectionProperties connectionProps;

    public SybaseImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        this.connectionProps = baseConnectionProperties;
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        super.setup(baseConnection);
        this.isReadOnly = Boolean.FALSE;
        this.nullsAreSortedHigh = Boolean.FALSE;
        this.nullsAreSortedLow = Boolean.TRUE;
        this.nullsAreSortedAtStart = Boolean.FALSE;
        this.nullsAreSortedAtEnd = Boolean.FALSE;
        this.nullPlusNonNullIsNull = Boolean.TRUE;
        this.storesUpperCaseIdentifiers = Boolean.FALSE;
        this.storesLowerCaseIdentifiers = Boolean.FALSE;
        this.storesUpperCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesLowerCaseQuotedIdentifiers = Boolean.FALSE;
        this.SQLKeywords = new String("arith_overflow,break,browse,bulk,char_convert,checkpoint,clustered,commit,compute,confirm,controlrow,data_pgs,database,dbcc,disk,dummy,dump,endtran,errlvl,errorexit,exit,fillfactor,holdlock,identity_insert,if,kill,lineno,load,mirror,mirrorexit,noholdlock,nonclustered,numeric_truncation,offsets,once,over,perm,permanent,plan,print,proc,processexit,raiserror,read,readtext,reconfigure,replace,reserved_pgs,return,role,rowcnt,rowcount,rule,save,setuser,shared,shutdown,some,statistics,stripe,syb_identity,syb_restree,syb_terminate,temp,textsize,tran,trigger,truncate,tsequal,used_pgs,user_option,waitfor,while,writetext");
        this.numericFunctions = new String("abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan");
        this.stringFunctions = new String("ascii,char,concat,difference,insert,left,length,lcase,locate,ltrim,repeat,right,rtrim,soundex,space,substring,ucase");
        this.systemFunctions = new String("database,ifnull,user");
        this.timeDateFunctions = new String("curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,timestampadd,timestampdiff,second,week,year");
        this.supportsAlterTableWithAddColumn = Boolean.TRUE;
        this.supportsColumnAliasing = Boolean.TRUE;
        this.supportsTableCorrelationNames = Boolean.TRUE;
        this.supportsDifferentTableCorrelationNames = Boolean.FALSE;
        this.supportsExpressionsInOrderBy = Boolean.TRUE;
        this.supportsOrderByUnrelated = Boolean.FALSE;
        this.supportsGroupBy = Boolean.TRUE;
        this.supportsGroupByUnrelated = Boolean.TRUE;
        this.supportsGroupByBeyondSelect = Boolean.TRUE;
        this.supportsLikeEscapeClause = Boolean.FALSE;
        this.supportsMultipleOpenResults = Boolean.TRUE;
        this.supportsNonNullableColumns = Boolean.TRUE;
        this.supportsMinimumSQLGrammar = Boolean.TRUE;
        this.supportsCoreSQLGrammar = Boolean.TRUE;
        this.supportsExtendedSQLGrammar = Boolean.FALSE;
        this.supportsANSI92EntryLevelSQL = Boolean.TRUE;
        this.supportsANSI92IntermediateSQL = Boolean.FALSE;
        this.supportsANSI92FullSQL = Boolean.FALSE;
        this.supportsOuterJoins = Boolean.TRUE;
        this.supportsFullOuterJoins = Boolean.FALSE;
        this.supportsLimitedOuterJoins = Boolean.TRUE;
        this.supportsSavepoints = Boolean.TRUE;
        this.locatorsUpdateCopy = Boolean.TRUE;
        this.supportsSchemasInDataManipulation = Boolean.TRUE;
        this.supportsSchemasInProcedureCalls = Boolean.TRUE;
        this.supportsSchemasInTableDefinitions = Boolean.TRUE;
        this.supportsSchemasInIndexDefinitions = Boolean.TRUE;
        this.supportsSchemasInPrivilegeDefinitions = Boolean.TRUE;
        this.isCatalogAtStart = Boolean.TRUE;
        this.supportsCatalogsInDataManipulation = Boolean.TRUE;
        this.supportsCatalogsInProcedureCalls = Boolean.TRUE;
        this.supportsCatalogsInTableDefinitions = Boolean.TRUE;
        this.supportsCatalogsInIndexDefinitions = Boolean.TRUE;
        this.supportsCatalogsInPrivilegeDefinitions = Boolean.FALSE;
        this.supportsPositionedDelete = Boolean.FALSE;
        this.supportsPositionedUpdate = Boolean.FALSE;
        this.supportsSelectForUpdate = Boolean.FALSE;
        this.supportsStoredProcedures = Boolean.TRUE;
        this.supportsSubqueriesInComparisons = Boolean.TRUE;
        this.supportsSubqueriesInExists = Boolean.TRUE;
        this.supportsSubqueriesInIns = Boolean.TRUE;
        this.supportsSubqueriesInQuantifieds = Boolean.TRUE;
        this.supportsCorrelatedSubqueries = Boolean.TRUE;
        this.supportsUnion = Boolean.TRUE;
        this.supportsUnionAll = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.FALSE;
        this.supportsOpenCursorsAcrossRollback = Boolean.FALSE;
        this.supportsGetGeneratedKeys = Boolean.TRUE;
        this.supportsNamedParameters = Boolean.FALSE;
        this.maxConnections = IntegerZero;
        this.maxStatements = IntegerZero;
        this.resultSetHoldability = new Integer(1);
        this.maxColumnsInGroupBy = new Integer(16);
        this.maxColumnsInOrderBy = new Integer(16);
        this.maxColumnsInSelect = IntegerZero;
        this.maxColumnsInTable = new Integer(250);
        this.maxTablesInSelect = new Integer(256);
        this.maxRowSize = IntegerZero;
        this.maxBinaryLiteralLength = new Integer(255);
        this.maxCharLiteralLength = new Integer(255);
        this.maxCursorNameLength = new Integer(30);
        this.maxStatementLength = IntegerZero;
        this.maxIndexLength = new Integer(255);
        this.maxSchemaNameLength = new Integer(30);
        this.maxCatalogNameLength = new Integer(30);
        this.maxUserNameLength = new Integer(30);
        if (((SybaseImplConnection)this.getImplConnection()).connection.getServerVersion() >= 15.0f) {
            this.maxTableNameLength = new Integer(255);
            this.maxColumnNameLength = new Integer(255);
            this.maxProcedureNameLength = new Integer(255);
        } else {
            this.maxProcedureNameLength = new Integer(30);
            this.maxTableNameLength = new Integer(30);
            this.maxColumnNameLength = new Integer(30);
        }
        this.identifierQuoteString = "\"";
        this.procedureTerm = "stored procedure";
        this.catalogSeparator = ".";
        this.searchStringEscape = "\\";
        this.extraNameCharacters = "$#@";
        this.supportsTransactions = Boolean.TRUE;
        this.supportsMultipleTransactions = Boolean.TRUE;
        this.storesMixedCaseIdentifiers = Boolean.TRUE;
        this.supportsMixedCaseIdentifiers = Boolean.TRUE;
        this.storesMixedCaseQuotedIdentifiers = Boolean.TRUE;
        this.supportsMixedCaseQuotedIdentifiers = Boolean.TRUE;
        this.supportsResultSetTypeScrollInsensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
        this.supportsResultSetTypeScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollSensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.othersUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.updatesAreDetectedForwardOnly = Boolean.FALSE;
        this.deletesAreDetectedForwardOnly = Boolean.FALSE;
        this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        this.supportsBatchUpdates = Boolean.FALSE;
        this.usesLocalFiles = Boolean.FALSE;
        this.usesLocalFilePerTable = Boolean.FALSE;
        this.supportsIntegrityEnhancementFacility = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.TRUE;
        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
        this.supportsOpenStatementsAcrossCommit = Boolean.TRUE;
        this.supportsOpenStatementsAcrossRollback = Boolean.TRUE;
        this.dataDefinitionCausesTransactionCommit = Boolean.FALSE;
        this.dataDefinitionIgnoredInTransactions = Boolean.FALSE;
        this.doesMaxRowSizeIncludeBlobs = Boolean.FALSE;
        this.supportsConvert = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadCommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadUncommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelSerializable = Boolean.TRUE;
        this.supportsTransactionIsolationLevelRepeatableRead = (double)((SybaseConnection)baseConnection).getServerVersion() > 11.5 ? Boolean.TRUE : Boolean.FALSE;
        String string = Float.toString(((SybaseConnection)baseConnection).getServerVersion());
        int n = string.indexOf(".");
        this.databaseMajorVersion = new Integer(string.substring(0, n));
        this.databaseMinorVersion = new Integer(string.substring(n + 1));
        typeInfos = null;
        this.maxClientHostName = this.maxClientAppName = new Integer(30);
        this.maxClientUser = this.maxClientAppName;
        this.defaultTransactionIsolation = new Integer(2);
    }

    void processServerInfo() throws SQLException {
        SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
        SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(sybaseImplConnection.comm, sybaseImplConnection.reader, sybaseImplConnection.writer, "sp_server_info");
        sybaseTDSExecuteRequest.submitRequest();
        sybaseTDSExecuteRequest.setProcessMode(1);
        sybaseTDSExecuteRequest.processReply(null);
        block12: while (sybaseTDSExecuteRequest.getRow(null)) {
            Integer n = (Integer)sybaseTDSExecuteRequest.getColumnData(1, 4);
            String string = (String)sybaseTDSExecuteRequest.getColumnData(2, 10);
            String string2 = (String)sybaseTDSExecuteRequest.getColumnData(3, 10);
            switch (n) {
                case 1: {
                    if (sybaseImplConnection.useAlternateProductInfo) continue block12;
                    this.databaseProductName = string2;
                    continue block12;
                }
                case 2: {
                    if (sybaseImplConnection.useAlternateProductInfo) continue block12;
                    this.databaseProductVersion = string2;
                    continue block12;
                }
                case 10: {
                    this.schemaTerm = string2;
                    continue block12;
                }
                case 20: {
                    if (string2.compareTo("Y") == 0) {
                        this.supportsMultipleResultSets = Boolean.TRUE;
                        continue block12;
                    }
                    this.supportsMultipleResultSets = Boolean.FALSE;
                    continue block12;
                }
                case 101: {
                    this.catalogTerm = string2;
                    continue block12;
                }
                case 105: {
                    this.maxColumnsInIndex = new Integer(string2);
                    continue block12;
                }
                case 22: {
                    if (string2.compareTo("Y") == 0) {
                        this.allTablesAreSelectable = Boolean.TRUE;
                        continue block12;
                    }
                    this.allTablesAreSelectable = Boolean.FALSE;
                    continue block12;
                }
                case 104: {
                    if (string2.compareTo("Y") == 0) {
                        this.allProceduresAreCallable = Boolean.TRUE;
                        continue block12;
                    }
                    this.allProceduresAreCallable = Boolean.FALSE;
                    continue block12;
                }
                case 108: {
                    if (string2.compareTo("Y") == 0) {
                        this.supportsAlterTableWithDropColumn = Boolean.TRUE;
                        continue block12;
                    }
                    this.supportsAlterTableWithDropColumn = Boolean.FALSE;
                    continue block12;
                }
                case 110: {
                    if (string2.compareTo("Y") == 0) {
                        this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.TRUE;
                        this.supportsDataManipulationTransactionsOnly = Boolean.FALSE;
                        continue block12;
                    }
                    this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.FALSE;
                    this.supportsDataManipulationTransactionsOnly = Boolean.TRUE;
                    continue block12;
                }
            }
        }
        sybaseTDSExecuteRequest.discardReplyBytes();
    }

    public void initializeNonResultSetMetaData(int n) throws SQLException {
        switch (n) {
            case 101: 
            case 158: {
                return;
            }
            case 8: 
            case 9: {
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (!sybaseImplConnection.useAlternateProductInfo) break;
                SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(sybaseImplConnection.comm, sybaseImplConnection.reader, sybaseImplConnection.writer, "select @@version");
                sybaseTDSExecuteRequest.submitRequest();
                sybaseTDSExecuteRequest.setProcessMode(1);
                sybaseTDSExecuteRequest.processReply(null);
                sybaseTDSExecuteRequest.getRow(null);
                this.databaseProductVersion = (String)sybaseTDSExecuteRequest.getColumnData(1, 10);
                String string = (String)sybaseTDSExecuteRequest.getColumnData(1, 10);
                this.databaseProductName = string.substring(0, string.indexOf(47));
            }
        }
        this.processServerInfo();
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (n == n2) {
            return true;
        }
        if (n != 91 && n != 92 && n != 93 && n != -1 && n != -4 && n2 != 91 && n2 != 92 && n2 != 93 && n2 != -1 && n2 != -4) {
            return true;
        }
        switch (n) {
            case -3: 
            case -2: {
                switch (n2) {
                    case -4: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 12: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (n2) {
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                break;
            }
            case -1: {
                switch (n2) {
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                break;
            }
            case -4: {
                switch (n2) {
                    case -3: 
                    case -2: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) throws SQLException {
        String string = ",";
        String string2 = "This is a bogus statement designed to generate a server error.";
        String string3 = null;
        boolean bl = false;
        switch (n) {
            case 1: {
                String string4 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string5 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string6 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String[] stringArray = (String[])baseResultSetFilterDescriptor.getRestriction(4);
                if (string4 != null && string4.length() == 0 || string6 != null && string6.length() == 0) {
                    string3 = string2;
                    break;
                }
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                string3 = sybaseImplConnection.useAlternateMetaData ? this.formatCatalogQualifier(string4) + "sp_jdbc_tables " : this.formatCatalogQualifier(string4) + "sp_tables ";
                string3 = string3 + this.valueOfDatabaseMetaDataParam(string6, true) + string + this.valueOfDatabaseMetaDataParam(string5, true) + string + this.valueOfDatabaseMetaDataParam(string4, false) + string;
                if (stringArray == null) {
                    string3 = string3 + "null";
                    break;
                }
                String string7 = new String();
                for (int i = 0; i < stringArray.length; ++i) {
                    string7 = string7 + this.valueOfDatabaseMetaDataParam(stringArray[i], false);
                    if (i == stringArray.length - 1) continue;
                    string7 = string7 + string;
                }
                if (string7.length() > 28) {
                    string3 = string3 + "null";
                    bl = true;
                    break;
                }
                string3 = string3 + "\"" + string7 + "\"";
                break;
            }
            case 2: {
                String string8 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string9 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string10 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string11 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                string3 = sybaseImplConnection.useAlternateMetaData ? this.formatCatalogQualifier(string8) + "sp_jdbc_columns " : this.formatCatalogQualifier(string8) + "sp_columns ";
                string3 = string3 + this.valueOfDatabaseMetaDataParam(string10, true) + string + this.valueOfDatabaseMetaDataParam(string9, true) + string + this.valueOfDatabaseMetaDataParam(string8, false) + string + this.valueOfDatabaseMetaDataParam(string11, true);
                break;
            }
            case 5: {
                String string12 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string13 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string14 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string3 = this.formatCatalogQualifier(string12) + "sp_stored_procedures " + this.valueOfDatabaseMetaDataParam(string14, true) + string + this.valueOfDatabaseMetaDataParam(string13, true) + string + this.valueOfDatabaseMetaDataParam(string12, false);
                break;
            }
            case 6: {
                String string15 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string16 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string17 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string18 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.procedureCreationStatement == null) {
                    sybaseImplConnection.procedureCreationStatement = new StringBuffer(255);
                } else {
                    sybaseImplConnection.procedureCreationStatement.setLength(0);
                }
                if (string17 != null) {
                    try {
                        Object object;
                        String string19 = "select a.text from syscomments a, sysobjects b where b.id = a.id and b.uid=user_id() and b.name='";
                        String string20 = string17;
                        int n2 = string17.indexOf(";");
                        if (n2 == -1 || n2 == string17.length() - 1) {
                            if (n2 == string17.length() - 1) {
                                string20 = string17.substring(0, n2);
                            }
                            string19 = string19 + string20 + "' and a.number=1";
                        } else {
                            object = string17.substring(n2 + 1);
                            string20 = string17.substring(0, n2);
                            string19 = string19 + string20 + "' and a.number=" + (String)object;
                        }
                        object = new SybaseTDSExecuteRequest(sybaseImplConnection.comm, sybaseImplConnection.reader, sybaseImplConnection.writer, string19);
                        ((SybaseTDSExecuteRequest)object).submitRequest();
                        ((SybaseTDSRequest)object).processReply((short)1, null);
                        while (((SybaseTDSRequest)object).getRow(null)) {
                            sybaseImplConnection.procedureCreationStatement.append((String)((SybaseTDSRequest)object).getColumnData(1, 10));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                string3 = this.formatCatalogQualifier(string15) + "sp_sproc_columns " + this.valueOfDatabaseMetaDataParam(string17, true) + string + this.valueOfDatabaseMetaDataParam(string16, true) + string + this.valueOfDatabaseMetaDataParam(string15, false) + string + this.valueOfDatabaseMetaDataParam(string18, true);
                break;
            }
            case 16: {
                String string21 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string22 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string23 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                string3 = this.formatCatalogQualifier(string21) + "sp_table_privileges " + this.valueOfDatabaseMetaDataParam(string23, true) + string + this.valueOfDatabaseMetaDataParam(string22, true) + string + this.valueOfDatabaseMetaDataParam(string21, false);
                break;
            }
            case 9: {
                String string24 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string25 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string26 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string27 = (String)baseResultSetFilterDescriptor.getRestriction(4);
                if (string26 == null || string26.length() == 0) {
                    string3 = string2;
                    break;
                }
                string3 = this.formatCatalogQualifier(string24) + "sp_column_privileges " + this.valueOfDatabaseMetaDataParam(string26, false) + string + this.valueOfDatabaseMetaDataParam(string25, false) + string + this.valueOfDatabaseMetaDataParam(string24, false) + string + this.valueOfDatabaseMetaDataParam(string27, true);
                break;
            }
            case 14: {
                String string28 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string29 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string30 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.useAlternateMetaData) {
                    if (string29 != null && (string29.indexOf("%") != -1 || string29.indexOf("_") != -1 || string29.endsWith(" "))) {
                        string29 = "";
                    }
                    string3 = this.formatCatalogQualifier(string28) + "sp_jdbc_primarykey " + this.valueOfDatabaseMetaDataParam(string28, false) + string + this.valueOfDatabaseMetaDataParam(string29, false) + string + this.valueOfDatabaseMetaDataParam(string30, false);
                    break;
                }
                string3 = this.formatCatalogQualifier(string28) + "sp_pkeys " + this.valueOfDatabaseMetaDataParam(string30, false) + string + this.valueOfDatabaseMetaDataParam(string29, false) + string + this.valueOfDatabaseMetaDataParam(string28, false);
                break;
            }
            case 11: {
                String string31 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string32 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string33 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.useAlternateMetaData) {
                    if (string32 != null && (string32.indexOf("%") != -1 || string32.indexOf("_") != -1 || string32.endsWith(" "))) {
                        string32 = "";
                    }
                    string3 = this.formatCatalogQualifier(string31) + "sp_jdbc_fkeys " + this.valueOfDatabaseMetaDataParam(string33, false) + string + this.valueOfDatabaseMetaDataParam(string32, false) + string + this.valueOfDatabaseMetaDataParam(string31, false);
                    break;
                }
                string3 = this.formatCatalogQualifier(string31) + "sp_fkeys " + this.valueOfDatabaseMetaDataParam(string33, false) + string + this.valueOfDatabaseMetaDataParam(string32, false) + string + this.valueOfDatabaseMetaDataParam(string31, false);
                break;
            }
            case 12: {
                String string34 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string35 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string36 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.useAlternateMetaData) {
                    if (string35 != null && (string35.indexOf("%") != -1 || string35.indexOf("_") != -1 || string35.endsWith(" "))) {
                        string35 = "";
                    }
                    string3 = this.formatCatalogQualifier(string34) + "sp_jdbc_fkeys null, null, null, " + this.valueOfDatabaseMetaDataParam(string36, false) + string + this.valueOfDatabaseMetaDataParam(string35, false) + string + this.valueOfDatabaseMetaDataParam(string34, false);
                    break;
                }
                string3 = this.formatCatalogQualifier(string34) + "sp_fkeys null, null, null, " + this.valueOfDatabaseMetaDataParam(string36, false) + string + this.valueOfDatabaseMetaDataParam(string35, false) + string + this.valueOfDatabaseMetaDataParam(string34, false);
                break;
            }
            case 10: {
                String string37 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string38 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string39 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                String string40 = (String)baseResultSetFilterDescriptor.getRestriction(5);
                String string41 = (String)baseResultSetFilterDescriptor.getRestriction(6);
                String string42 = (String)baseResultSetFilterDescriptor.getRestriction(7);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.useAlternateMetaData) {
                    if (string38 != null && (string38.indexOf("%") != -1 || string38.indexOf("_") != -1 || string38.endsWith(" "))) {
                        string38 = "";
                    }
                    if (string41 != null && (string41.indexOf("%") != -1 || string41.indexOf("_") != -1 || string41.endsWith(" "))) {
                        string41 = "";
                    }
                    string3 = this.formatCatalogQualifier(string37) + "sp_jdbc_fkeys " + this.valueOfDatabaseMetaDataParam(string39, false) + string + this.valueOfDatabaseMetaDataParam(string38, false) + string + this.valueOfDatabaseMetaDataParam(string37, false) + string + this.valueOfDatabaseMetaDataParam(string42, false) + string + this.valueOfDatabaseMetaDataParam(string41, false) + string + this.valueOfDatabaseMetaDataParam(string40, false);
                    break;
                }
                string3 = this.formatCatalogQualifier(string37) + "sp_fkeys " + this.valueOfDatabaseMetaDataParam(string39, false) + string + this.valueOfDatabaseMetaDataParam(string38, false) + string + this.valueOfDatabaseMetaDataParam(string37, false) + string + this.valueOfDatabaseMetaDataParam(string42, false) + string + this.valueOfDatabaseMetaDataParam(string41, false) + string + this.valueOfDatabaseMetaDataParam(string40, false);
                break;
            }
            case 13: {
                String string43 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string44 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string45 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                Boolean bl2 = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
                Boolean bl3 = (Boolean)baseResultSetFilterDescriptor.getRestriction(5);
                if (string45 == null || string45.length() == 0) {
                    string3 = string2;
                    break;
                }
                string3 = this.formatCatalogQualifier(string43) + "sp_statistics " + this.valueOfDatabaseMetaDataParam(string45, false) + string + this.valueOfDatabaseMetaDataParam(string44, false) + string + this.valueOfDatabaseMetaDataParam(string43, false) + string + this.valueOfDatabaseMetaDataParam("%", false) + string + this.valueOfDatabaseMetaDataParam(bl2 != false ? "Y" : "N", false);
                string3 = "set ANSINULL off execute " + string3 + "set ANSINULL on";
                break;
            }
            case 7: {
                String string46 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string47 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string48 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                Integer n3 = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
                Boolean bl4 = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
                if (string48 == null || string48.length() == 0) {
                    string3 = string2;
                    break;
                }
                string3 = this.formatCatalogQualifier(string46) + "sp_special_columns " + this.valueOfDatabaseMetaDataParam(string48, false) + string + this.valueOfDatabaseMetaDataParam(string47, false) + string + this.valueOfDatabaseMetaDataParam(string46, false) + string + this.valueOfDatabaseMetaDataParam("R", false);
                break;
            }
            case 18: {
                String string49 = (String)baseResultSetFilterDescriptor.getRestriction(9);
                String string50 = (String)baseResultSetFilterDescriptor.getRestriction(10);
                String string51 = (String)baseResultSetFilterDescriptor.getRestriction(11);
                SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
                if (sybaseImplConnection.useAlternateMetaData) {
                    string3 = this.formatCatalogQualifier(string49) + "sp_jdbc_getversioncolumns " + this.valueOfDatabaseMetaDataParam(string49, false) + string + this.valueOfDatabaseMetaDataParam(string50, false) + string + this.valueOfDatabaseMetaDataParam(string51, false);
                    break;
                }
                string3 = this.formatCatalogQualifier(string49) + "sp_special_columns " + this.valueOfDatabaseMetaDataParam(string51, false) + string + this.valueOfDatabaseMetaDataParam(string50, false) + string + this.valueOfDatabaseMetaDataParam(string49, false) + string + this.valueOfDatabaseMetaDataParam("V", false);
                break;
            }
            case 17: {
                String string52 = (String)baseResultSetFilterDescriptor.getRestriction(1);
                String string53 = (String)baseResultSetFilterDescriptor.getRestriction(2);
                String string54 = (String)baseResultSetFilterDescriptor.getRestriction(3);
                int[] nArray = (int[])baseResultSetFilterDescriptor.getRestriction(4);
                string3 = "select db_name(), suser_name(), name, domain, type, null from systypes where usertype>100";
                break;
            }
            case 15: {
                string3 = "sp_tables '', '%', '', null";
                break;
            }
            case 8: {
                string3 = "select name from master.dbo.sysdatabases";
            }
        }
        if (baseResultSetFilterDescriptor != null) {
            if (bl) {
                baseResultSetFilterDescriptor.removeRestriction(1);
                baseResultSetFilterDescriptor.removeRestriction(2);
                baseResultSetFilterDescriptor.removeRestriction(3);
            } else {
                baseResultSetFilterDescriptor.removeAllRestrictions();
            }
        }
        return string3;
    }

    public BaseTypeInfos getTypeInfo() throws SQLException {
        SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
        SybaseConnection sybaseConnection = sybaseImplConnection.connection;
        Short s = new Short(0);
        Short s2 = new Short(1);
        Short s3 = new Short(2);
        Short s4 = new Short(3);
        Short s5 = new Short(4);
        Integer n = new Integer(10);
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        BaseTypeInfo baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "bit";
        baseTypeInfo.dataType = new Short(-7);
        baseTypeInfo.maxPrecision = new Integer(1);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "tinyint";
        baseTypeInfo.dataType = new Short(-6);
        baseTypeInfo.maxPrecision = new Integer(3);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.TRUE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.getServerVersion() >= 15.0f) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "bigint";
            baseTypeInfo.dataType = new Short(-5);
            baseTypeInfo.maxPrecision = new Integer(19);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.FALSE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = s;
            baseTypeInfo.maximumScale = s;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "unsigned int";
            baseTypeInfo.dataType = new Short(-5);
            baseTypeInfo.maxPrecision = new Integer(10);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.TRUE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = s;
            baseTypeInfo.maximumScale = s;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "image";
        baseTypeInfo.dataType = new Short(-4);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "0x";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s2;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "timestamp";
        baseTypeInfo.dataType = new Short(-3);
        baseTypeInfo.maxPrecision = new Integer(8);
        baseTypeInfo.literalPrefix = "0x";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "varbinary";
        baseTypeInfo.dataType = new Short(-3);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "0x";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "binary";
        baseTypeInfo.dataType = new Short(-2);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "0x";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "text";
        baseTypeInfo.dataType = new Short(-1);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s2;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.getServerVersion() >= 15.0f) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "unitext";
            baseTypeInfo.dataType = new Short(-1);
            baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
            baseTypeInfo.literalPrefix = "'";
            baseTypeInfo.literalSuffix = "'";
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.TRUE;
            baseTypeInfo.searchable = s2;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "char";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.supportsUniCharTypes) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "unichar";
            baseTypeInfo.dataType = new Short(1);
            baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
            baseTypeInfo.literalPrefix = "'";
            baseTypeInfo.literalSuffix = "'";
            baseTypeInfo.createParams = "length";
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.TRUE;
            baseTypeInfo.searchable = s4;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "nchar";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "numeric";
        baseTypeInfo.dataType = new Short(2);
        baseTypeInfo.maxPrecision = new Integer(38);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "precision,scale";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = new Short(38);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "decimal";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(38);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "precision,scale";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = new Short(38);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.getServerVersion() >= 15.0f) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "unsigned bigint";
            baseTypeInfo.dataType = new Short(3);
            baseTypeInfo.maxPrecision = new Integer(20);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.TRUE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = s;
            baseTypeInfo.maximumScale = s;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "money";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(19);
        baseTypeInfo.literalPrefix = "$";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.TRUE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s5;
        baseTypeInfo.maximumScale = s5;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "smallmoney";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(10);
        baseTypeInfo.literalPrefix = "$";
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.TRUE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s5;
        baseTypeInfo.maximumScale = s5;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "int";
        baseTypeInfo.dataType = new Short(4);
        baseTypeInfo.maxPrecision = n;
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.getServerVersion() >= 15.0f) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "unsigned smallint";
            baseTypeInfo.dataType = new Short(4);
            baseTypeInfo.maxPrecision = new Integer(5);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.TRUE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = s;
            baseTypeInfo.maximumScale = s;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "smallint";
        baseTypeInfo.dataType = new Short(5);
        baseTypeInfo.maxPrecision = new Integer(5);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s;
        baseTypeInfo.maximumScale = s;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "float";
        baseTypeInfo.dataType = new Short(6);
        baseTypeInfo.maxPrecision = new Integer(15);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "real";
        baseTypeInfo.dataType = new Short(7);
        baseTypeInfo.maxPrecision = new Integer(7);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "nvarchar";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "sysname";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(30);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "varchar";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (sybaseConnection.supportsUniCharTypes) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "univarchar";
            baseTypeInfo.dataType = new Short(12);
            baseTypeInfo.maxPrecision = new Integer(sybaseConnection.getPageSize());
            baseTypeInfo.literalPrefix = "'";
            baseTypeInfo.literalSuffix = "'";
            baseTypeInfo.createParams = "max length";
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.TRUE;
            baseTypeInfo.searchable = s4;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        if (sybaseConnection.supportsDateAndTimeTypes) {
            if (dateTypeInfo == null) {
                dateTypeInfo = new BaseTypeInfo();
                SybaseImplDatabaseMetaData.dateTypeInfo.typeName = "date";
                SybaseImplDatabaseMetaData.dateTypeInfo.dataType = new Short(91);
                SybaseImplDatabaseMetaData.dateTypeInfo.maxPrecision = new Integer(10);
                SybaseImplDatabaseMetaData.dateTypeInfo.literalPrefix = "'";
                SybaseImplDatabaseMetaData.dateTypeInfo.literalSuffix = "'";
                SybaseImplDatabaseMetaData.dateTypeInfo.createParams = null;
                SybaseImplDatabaseMetaData.dateTypeInfo.nullable = new Short(1);
                SybaseImplDatabaseMetaData.dateTypeInfo.caseSensitive = Boolean.FALSE;
                SybaseImplDatabaseMetaData.dateTypeInfo.searchable = new Short(3);
                SybaseImplDatabaseMetaData.dateTypeInfo.unsignedAttribute = null;
                SybaseImplDatabaseMetaData.dateTypeInfo.fixedPrecScale = Boolean.FALSE;
                SybaseImplDatabaseMetaData.dateTypeInfo.autoIncrement = null;
                SybaseImplDatabaseMetaData.dateTypeInfo.localTypeName = "date";
                SybaseImplDatabaseMetaData.dateTypeInfo.minimumScale = null;
                SybaseImplDatabaseMetaData.dateTypeInfo.maximumScale = null;
                SybaseImplDatabaseMetaData.dateTypeInfo.numPrecRadix = null;
            }
            baseTypeInfos.add(dateTypeInfo);
            if (timeTypeInfo == null) {
                timeTypeInfo = new BaseTypeInfo();
                SybaseImplDatabaseMetaData.timeTypeInfo.typeName = "time";
                SybaseImplDatabaseMetaData.timeTypeInfo.dataType = new Short(92);
                SybaseImplDatabaseMetaData.timeTypeInfo.maxPrecision = new Integer(12);
                SybaseImplDatabaseMetaData.timeTypeInfo.literalPrefix = "'";
                SybaseImplDatabaseMetaData.timeTypeInfo.literalSuffix = "'";
                SybaseImplDatabaseMetaData.timeTypeInfo.createParams = null;
                SybaseImplDatabaseMetaData.timeTypeInfo.nullable = new Short(1);
                SybaseImplDatabaseMetaData.timeTypeInfo.caseSensitive = Boolean.FALSE;
                SybaseImplDatabaseMetaData.timeTypeInfo.searchable = new Short(3);
                SybaseImplDatabaseMetaData.timeTypeInfo.unsignedAttribute = null;
                SybaseImplDatabaseMetaData.timeTypeInfo.fixedPrecScale = Boolean.FALSE;
                SybaseImplDatabaseMetaData.timeTypeInfo.autoIncrement = null;
                SybaseImplDatabaseMetaData.timeTypeInfo.localTypeName = "time";
                SybaseImplDatabaseMetaData.timeTypeInfo.minimumScale = s4;
                SybaseImplDatabaseMetaData.timeTypeInfo.maximumScale = s4;
                SybaseImplDatabaseMetaData.timeTypeInfo.numPrecRadix = null;
            }
            baseTypeInfos.add(timeTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "datetime";
        baseTypeInfo.dataType = new Short(93);
        baseTypeInfo.maxPrecision = new Integer(23);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s4;
        baseTypeInfo.maximumScale = s4;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "smalldatetime";
        baseTypeInfo.dataType = new Short(93);
        baseTypeInfo.maxPrecision = new Integer(16);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = s4;
        baseTypeInfo.maximumScale = s4;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        return baseTypeInfos;
    }

    public BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        baseTableTypes.add("SYSTEM TABLE");
        baseTableTypes.add("TABLE");
        baseTableTypes.add("VIEW");
        return baseTableTypes;
    }

    private String valueOfDatabaseMetaDataParam(String string, boolean bl) {
        char c;
        int n;
        int n2;
        String string2;
        if (string == null) {
            return "null";
        }
        if (bl) {
            string2 = new String();
            int n3 = string.length();
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                c = string.charAt(n);
                if (n2 != 0 || c == ' ' || c == '[' || c == ']') {
                    string2 = string2 + "[" + c + "]";
                    n2 = 0;
                    continue;
                }
                if (c == '\\') {
                    n2 = 1;
                    continue;
                }
                string2 = string2 + c;
            }
            if (n2 != 0) {
                string2 = string2 + '\\';
            }
        } else {
            string2 = string;
        }
        String string3 = new String();
        n2 = string2.length();
        for (n = 0; n < n2; ++n) {
            c = string2.charAt(n);
            string3 = c == '\'' ? string3 + "''" : string3 + c;
        }
        return "'" + string3 + "'";
    }

    private void sortTypeInfo(String[] stringArray, BaseTypeInfos baseTypeInfos) {
        boolean bl;
        int n = baseTypeInfos.count();
        UtilDebug.assert((String)"Unexpected type info obtained from the server.", (n == stringArray.length ? 1 : 0) != 0);
        for (int i = 0; i < n && (bl = true); ++i) {
            bl = false;
            for (int j = i; j < n; ++j) {
                Object object = baseTypeInfos.get(j);
                if (!stringArray[i].equals(object.typeName) || i == j) continue;
                object = baseTypeInfos.set(i, object);
                baseTypeInfos.set(j, object);
                bl = true;
            }
        }
    }

    private Boolean createBoolean(Short s) {
        if (s == null) {
            return null;
        }
        return s == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private Integer createInteger(Short s) {
        if (s == null) {
            return null;
        }
        return new Integer(s.shortValue());
    }

    private String formatCatalogQualifier(String string) {
        String string2 = string;
        string2 = string2 != null && string2.indexOf(95) == -1 && string2.indexOf(37) == -1 ? string2 + ".." : "";
        return string2;
    }

    protected String getUserName() throws SQLException {
        SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.getImplConnection();
        SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(sybaseImplConnection.comm, sybaseImplConnection.reader, sybaseImplConnection.writer, "select user_name()");
        sybaseTDSExecuteRequest.submitRequest();
        sybaseTDSExecuteRequest.processReply((short)1, null);
        sybaseTDSExecuteRequest.getRow(null);
        sybaseTDSExecuteRequest.getColumnDataForRow(1, 10);
        String string = (String)sybaseTDSExecuteRequest.getNativeColumn((int)1).data;
        sybaseTDSExecuteRequest.discardReplyBytes();
        return string;
    }

    static {
        dateTypeInfo = null;
        timeTypeInfo = null;
    }
}

