/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.sybase.SybaseImplConnection;
import com.metamatrix.jdbc.sybase.SybaseImplResultSet;
import com.metamatrix.jdbc.sybase.SybaseMetaData;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCancelRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCursorRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSExecuteRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSParameter;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSPreparedRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRPCRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilStringFunctions;
import com.metamatrix.util.UtilVectorUnsynced;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SybaseImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.42.1.0  $";
    public SybaseTDSCommunication comm;
    SybaseTDSRequest request;
    SybaseImplResultSet resultSet;
    int resultType;
    SybaseTDSParameter[] paramPool;
    private int numParamsToServer;
    boolean isCursorSelect;
    boolean procedureHasReturnParam;
    String procedureName;
    private UtilVectorUnsynced columnSpecification;
    private int columnTokenPosition;
    int resultSetScrollType;
    int resultSetConcurrency;
    public BaseExceptions exceptions;
    public UtilByteOrderedDataWriter writer;
    public UtilByteOrderedDataReader reader;
    private boolean isNormalStatement;
    private boolean isFirstExecuteOfPreparedStatement;
    private boolean executeAsRPC;
    private boolean isStoredProcCall;
    private BigDecimal autoGeneratedKeyValue;
    private boolean literalSubsituteParams = false;
    private String sqlForDescribeParams;

    public SybaseImplStatement(SybaseTDSCommunication sybaseTDSCommunication, int n, int n2, BaseExceptions baseExceptions) {
        this.comm = sybaseTDSCommunication;
        this.resultSetScrollType = n;
        this.resultSetConcurrency = n2;
        this.exceptions = baseExceptions;
        this.writer = sybaseTDSCommunication.getWriter();
        this.reader = sybaseTDSCommunication.createReader();
        this.initFields();
    }

    private void initFields() {
        this.request = null;
        this.resultSet = null;
        this.resultType = 0;
        this.isCursorSelect = false;
        this.procedureHasReturnParam = false;
        this.procedureName = null;
        this.paramPool = null;
        this.isNormalStatement = true;
        this.isFirstExecuteOfPreparedStatement = false;
        this.executeAsRPC = false;
    }

    public void close() throws SQLException {
        SybaseTDSRequest sybaseTDSRequest = this.request;
        this.reset();
        if (sybaseTDSRequest instanceof SybaseTDSPreparedRequest) {
            ((SybaseTDSPreparedRequest)sybaseTDSRequest).close(this.warnings);
        }
    }

    public void cleanupRequest() throws SQLException {
        if (this.request != null) {
            this.request.discardReplyBytes();
            if (this.isCursorSelect) {
                ((SybaseTDSCursorRequest)this.request).closeCursor(this.warnings);
            }
        }
    }

    public void reset() throws SQLException {
        this.cleanupRequest();
        if (this.request != null) {
            if (this.request instanceof SybaseTDSPreparedRequest) {
                this.request.setProcessMode(0);
                this.request = null;
            } else {
                this.request = null;
            }
        }
        super.reset();
    }

    protected void setSQL(BaseSQL baseSQL) {
        try {
            this.cleanupRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initFields();
        super.setSQL(baseSQL);
    }

    public void prepare(BaseParameters baseParameters) throws SQLException {
        this.isNormalStatement = false;
        this.isFirstExecuteOfPreparedStatement = true;
        String string = this.sql.getVerb();
        if (string.equalsIgnoreCase("execute") || string.equalsIgnoreCase("exec")) {
            return;
        }
        this.sqlForDescribeParams = this.sql.getFormatted();
        if (string.equalsIgnoreCase("select") && this.prepareExecuteMode != 2) {
            return;
        }
        String string2 = this.implConnection.connectProps.get("PrepareMethod");
        if (string2.equalsIgnoreCase("Direct")) {
            return;
        }
        int n = this.sql.getParameterCount();
        if (n == 0 && (string2.equalsIgnoreCase("StoredProcIfParam") || this.autoGeneratedKeysRequested || !string2.equalsIgnoreCase("StoredProc"))) {
            return;
        }
        String string3 = this.sqlForDescribeParams;
        this.sqlForDescribeParams = null;
        if (this.autoGeneratedKeysRequested) {
            string3 = string3 + " select @@identity";
        }
        try {
            this.request = this.prepareAndDescribe(string3, baseParameters);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 2782 || sQLException.getErrorCode() == 192 || sQLException.getErrorCode() == 111 || sQLException.getErrorCode() == 12828 || sQLException.getErrorCode() == 7332) {
                if (sQLException.getErrorCode() == 2782) {
                    // empty if block
                }
                String[] stringArray = new String[]{sQLException.getMessage()};
                this.warnings.add(7026, stringArray);
                return;
            }
            throw sQLException;
        }
    }

    private SybaseTDSRequest prepareAndDescribe(String string, BaseParameters baseParameters) throws SQLException {
        SybaseTDSPreparedRequest sybaseTDSPreparedRequest = new SybaseTDSPreparedRequest(this.comm, this.reader, this.writer, string);
        sybaseTDSPreparedRequest.prepare(this.warnings);
        if (baseParameters == null) {
            return sybaseTDSPreparedRequest;
        }
        if (sybaseTDSPreparedRequest.paramDescriptions != null) {
            int n = 0;
            while (n < sybaseTDSPreparedRequest.paramDescriptions.size()) {
                BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                SybaseMetaData sybaseMetaData = (SybaseMetaData)sybaseTDSPreparedRequest.paramDescriptions.get(n);
                baseParameterInfo.nativeTypeName = sybaseMetaData.typeName;
                baseParameterInfo.signed = sybaseMetaData.isSigned;
                baseParameterInfo.mode = 1;
                baseParameterInfo.nullable = 2;
                baseParameterInfo.setType(sybaseMetaData.sqlType);
                if (BaseData.isVariableLengthType(sybaseMetaData.sqlType) || sybaseMetaData.sqlType == 93) {
                    baseParameterInfo.precision = sybaseMetaData.precision;
                    baseParameterInfo.scale = sybaseMetaData.scale;
                }
                baseParameters.setParameterInfo(n, baseParameterInfo);
                ++n;
            }
        }
        return sybaseTDSPreparedRequest;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        block2: {
            if (this.sqlForDescribeParams == null) break block2;
            try {
                this.prepareAndDescribe(this.sqlForDescribeParams, baseParameters);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void execute() throws SQLException {
        if (this.request != null && this.request instanceof SybaseTDSPreparedRequest) {
            this.processParameters(true);
            this.request.setParams(this.paramPool, this.numParamsToServer);
            ((SybaseTDSPreparedRequest)this.request).execute(this.warnings);
            this.resultType = 0;
            return;
        }
        SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.implConnection;
        String string = this.processSQL();
        boolean bl = this.sql.hasForUpdate();
        if (this.isSimpleSelect() && ((SybaseImplConnection)this.implConnection).useServerSideCursor && this.prepareExecuteMode != 1) {
            if (this.numParamsToServer > 0 && UtilStringFunctions.searchStringCi(string, "LIKE") != -1) {
                if (bl) {
                    throw this.exceptions.getException(7022);
                }
                this.isCursorSelect = false;
            } else {
                this.isCursorSelect = true;
            }
        } else {
            this.isCursorSelect = false;
        }
        if (!this.isCursorSelect && bl) {
            this.isCursorSelect = true;
        }
        if (this.maxFieldSize == 0) {
            this.maxFieldSize = Integer.MAX_VALUE;
        }
        if (this.maxFieldSize != sybaseImplConnection.maxFieldSize) {
            this.executeSQL("set textsize " + this.maxFieldSize);
            sybaseImplConnection.maxFieldSize = this.maxFieldSize;
        }
        if (this.isCursorSelect) {
            this.request = new SybaseTDSCursorRequest(this.comm, this.reader, this.writer, string, bl);
            ((SybaseTDSCursorRequest)this.request).setFetchSize(this.maxRows, this.fetchSize);
        } else if (this.executeAsRPC) {
            this.request = new SybaseTDSRPCRequest(this.comm, this.reader, this.writer, this.procedureName);
        } else {
            if (this.isStoredProcCall) {
                int n = 0;
                while (n < this.numParamsToServer) {
                    SybaseTDSParameter sybaseTDSParameter = this.paramPool[n];
                    if (sybaseTDSParameter.isOutput && !sybaseTDSParameter.isInput) {
                        throw this.comm.exceptions.getException(7019);
                    }
                    ++n;
                }
            }
            this.request = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string);
        }
        this.request.setIsStoredProcCall(this.isStoredProcCall);
        this.request.setParams(this.paramPool, this.numParamsToServer);
        if (this.isCursorSelect) {
            try {
                ((SybaseTDSCursorRequest)this.request).openCursor(this.warnings);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 3804) {
                    this.request = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string);
                    this.isCursorSelect = false;
                }
                throw sQLException;
            }
        }
        if (!this.isCursorSelect) {
            try {
                this.request.submitRequest();
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().startsWith("DDTEK1")) {
                    this.comm.close();
                    throw sQLException;
                }
                throw sQLException;
            }
            if (this.databaseMetaDataResultSet != 0) {
                this.request.setProcessMode(1);
            }
        }
        this.resultType = 0;
    }

    private String processSQL() throws SQLException {
        if (this.databaseMetaDataResultSet != 0) {
            return this.sql.getOriginal();
        }
        if (this.sql.getType() == 2) {
            this.modifyCreateTableStatement();
        }
        if (this.isNormalStatement || this.isFirstExecuteOfPreparedStatement) {
            this.checkForProcedureParameters();
            this.isFirstExecuteOfPreparedStatement = false;
        }
        this.processParameters(false);
        String string = this.sql.getFormatted();
        if (this.procedureHasReturnParam) {
            int n = string.indexOf(61);
            string = string.substring(0, n) + string.substring(n + 1);
        }
        if (this.autoGeneratedKeysRequested) {
            string = string + " select @@identity";
        }
        return string;
    }

    private void setTokensForCurrentColumnDef(UtilVectorUnsynced utilVectorUnsynced) {
        this.columnSpecification = utilVectorUnsynced;
        this.columnTokenPosition = 0;
    }

    private String getNextColumnToken() {
        int n = this.columnSpecification.size();
        String string = null;
        while (this.columnTokenPosition < n) {
            string = (String)this.columnSpecification.elementAt(this.columnTokenPosition);
            ++this.columnTokenPosition;
            if (string.charAt(0) <= ' ') continue;
            return string;
        }
        return null;
    }

    public void modifyCreateTableStatement() {
        int n;
        int n2 = this.sql.getCreateTableColumnSpecificationCount();
        if (n2 == 0) {
            return;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        String[] stringArray2 = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            block19: {
                boolean bl;
                UtilVectorUnsynced utilVectorUnsynced;
                block21: {
                    String string;
                    block20: {
                        utilVectorUnsynced = this.sql.getCreateTableColumnSpecification(n4);
                        if (utilVectorUnsynced == null) break block19;
                        this.setTokensForCurrentColumnDef(utilVectorUnsynced);
                        string = this.getNextColumnToken();
                        if (string.equalsIgnoreCase("unique") || string.equalsIgnoreCase("primary") || string.equalsIgnoreCase("foreign") || string.equalsIgnoreCase("check")) break block19;
                        if (!string.equalsIgnoreCase("constraint")) break block20;
                        string = this.getNextColumnToken();
                        while (string != null) {
                            if (string.equalsIgnoreCase("PRIMARY")) {
                                string = this.getNextColumnToken();
                                if (!string.equalsIgnoreCase("KEY") || !(string = this.getNextColumnToken()).equalsIgnoreCase("(")) continue;
                                string = this.getNextColumnToken();
                                if (string.startsWith("\"") && string.endsWith("\"")) {
                                    string = string.substring(1, string.length() - 1);
                                }
                                stringArray[n3++] = string;
                                continue;
                            }
                            string = this.getNextColumnToken();
                        }
                        break block19;
                    }
                    string = this.getNextColumnToken();
                    if (string == null) {
                        return;
                    }
                    bl = string.equalsIgnoreCase("bit");
                    boolean bl2 = string.equalsIgnoreCase("double");
                    string = this.getNextColumnToken();
                    if (string == null) break block21;
                    if (string.equals("(")) {
                        do {
                            if ((string = this.getNextColumnToken()) != null) continue;
                            return;
                        } while (!string.equals(")"));
                        string = this.getNextColumnToken();
                    } else if (bl2 && string.equalsIgnoreCase("precision")) {
                        string = this.getNextColumnToken();
                    }
                    if (string != null) break block19;
                }
                String string = "";
                n = 0;
                while (n < utilVectorUnsynced.size()) {
                    string = string + (String)utilVectorUnsynced.elementAt(n);
                    ++n;
                }
                string = string + (bl ? " not null" : " null");
                stringArray2[n4] = string.trim();
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            if (stringArray2[n] != null) {
                boolean bl = false;
                int n5 = 0;
                while (n5 < n3) {
                    if (stringArray2[n].startsWith(stringArray[n5])) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    this.sql.setCreateTableColumnSpecification(n, stringArray2[n]);
                }
            }
            ++n;
        }
    }

    public void checkForProcedureParameters() throws SQLException {
        this.isStoredProcCall = false;
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n = 0;
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        while (true) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 6) {
                return;
            }
            if (baseSQLToken.type == 17) continue;
            if (n == 0) {
                if (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec")) {
                    n = 1;
                    this.isStoredProcCall = true;
                    continue;
                }
                return;
            }
            if (baseSQLToken.value.charAt(0) == '?') {
                if (n != true) continue;
                n = 2;
                continue;
            }
            if (baseSQLToken.value.charAt(0) == '=' && n == 2) {
                n = 3;
                this.procedureHasReturnParam = true;
                continue;
            }
            if (baseSQLToken.type == 9 && (n == 1 || n == 3)) {
                int n2;
                this.procedureName = baseSQLToken.value;
                this.executeAsRPC = true;
                n = 4;
                boolean bl = true;
                while (bl) {
                    n2 = baseSQLScanner.scanPosition;
                    baseSQLToken = baseSQLScanner.getNextToken();
                    while (baseSQLToken.type == 17) {
                        baseSQLToken = baseSQLScanner.getNextToken();
                    }
                    if (baseSQLToken.type == 5) {
                        this.procedureName = this.procedureName + ".";
                        baseSQLToken = baseSQLScanner.getNextToken();
                        while (baseSQLToken.type == 17) {
                            baseSQLToken = baseSQLScanner.getNextToken();
                        }
                        if (baseSQLToken.type == 5) {
                            this.procedureName = this.procedureName + ".";
                            baseSQLToken = baseSQLScanner.getNextToken();
                            while (baseSQLToken.type == 17) {
                                baseSQLToken = baseSQLScanner.getNextToken();
                            }
                        }
                        if (baseSQLToken.type == 9) {
                            this.procedureName = this.procedureName + baseSQLToken.value;
                            continue;
                        }
                        this.executeAsRPC = false;
                        return;
                    }
                    bl = false;
                    baseSQLScanner.scanPosition = n2;
                }
                n2 = baseSQLScanner.scanPosition;
                baseSQLToken = baseSQLScanner.getNextToken();
                while (baseSQLToken.type == 17) {
                    baseSQLToken = baseSQLScanner.getNextToken();
                }
                if (baseSQLToken.type == 15) {
                    this.procedureName = this.procedureName + ";";
                    baseSQLToken = baseSQLScanner.getNextToken();
                    while (baseSQLToken.type == 17) {
                        baseSQLToken = baseSQLScanner.getNextToken();
                    }
                    if (baseSQLToken.type == 9 && baseSQLToken.value != null) {
                        try {
                            Integer.parseInt(baseSQLToken.value);
                            this.procedureName = this.procedureName + baseSQLToken.value;
                        }
                        catch (Exception exception) {
                            this.executeAsRPC = false;
                            return;
                        }
                    }
                    baseSQLScanner.scanPosition = n2;
                    continue;
                }
                baseSQLScanner.scanPosition = n2;
                continue;
            }
            if (baseSQLToken.value.charAt(0) != ',' || n != 4) break;
        }
        this.executeAsRPC = false;
    }

    private String createLiteralParameter(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = null;
        while (!bl) {
            if ((n = string.indexOf("'", n)) == -1) {
                bl = true;
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.insert(n + n2, "'");
            ++n2;
            ++n;
        }
        if (stringBuffer == null) {
            return "'" + string + "'";
        }
        return "'" + stringBuffer.toString() + "'";
    }

    private void processParameters(boolean bl) throws SQLException {
        int n;
        boolean bl2;
        if (this.parameterSets == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        if (baseParameters == null) {
            return;
        }
        int n2 = baseParameters.count();
        if (n2 == 0) {
            return;
        }
        boolean bl3 = bl2 = this.procedureName != null && this.procedureName.charAt(0) == '$' && this.procedureName.endsWith("SybDtmXact");
        if (this.paramPool == null || this.paramPool.length < n2) {
            this.paramPool = new SybaseTDSParameter[n2];
            n = 0;
            while (n < n2) {
                this.paramPool[n] = new SybaseTDSParameter(this.implConnection.exceptions);
                ++n;
            }
        }
        this.numParamsToServer = 0;
        n = 1;
        while (n <= n2) {
            block19: {
                Object object;
                block25: {
                    block22: {
                        block23: {
                            Object object2;
                            block24: {
                                Object object3;
                                block21: {
                                    block20: {
                                        if (!bl) break block20;
                                        object2 = this.paramPool[this.numParamsToServer++];
                                        ((SybaseTDSParameter)object2).setup(this.comm, ((SybaseImplConnection)this.implConnection).connection, baseParameters, n, bl2);
                                        object3 = ((SybaseTDSPreparedRequest)this.request).paramDescriptions;
                                        if (n <= ((UtilVectorUnsynced)object3).size()) {
                                            ((SybaseTDSParameter)object2).setSqlType(((SybaseMetaData)((UtilVectorUnsynced)object3).get((int)(n - 1))).sqlType);
                                        }
                                        ((SybaseTDSParameter)object2).prepareTDSData();
                                        break block19;
                                    }
                                    if (n != 1 || !this.procedureHasReturnParam) break block21;
                                    this.sql.setParameter(0, "");
                                    break block19;
                                }
                                object2 = baseParameters.get(n, 1);
                                object3 = baseParameters.get(n, 2);
                                if (object3 != null) break block22;
                                if (this.executeAsRPC) break block23;
                                if (!((BaseData)object2).isNull()) break block24;
                                this.sql.setParameter(n - 1, "null");
                                break block19;
                            }
                            if ((double)((SybaseImplConnection)this.implConnection).connection.getServerVersion() < 12.5) {
                                try {
                                    object = null;
                                    switch (((BaseParameter)object2).sqlType) {
                                        case -4: 
                                        case -3: 
                                        case -2: 
                                        case 2004: {
                                            object = ((BaseData)object2).getString(-1, this.exceptions);
                                            if (((String)object).length() > 0) {
                                                this.sql.setParameter(n - 1, "0x" + (String)object);
                                            } else {
                                                this.sql.setParameter(n - 1, "null");
                                            }
                                            break block19;
                                        }
                                        case -1: 
                                        case 1: 
                                        case 12: 
                                        case 2005: {
                                            object = ((BaseData)object2).getString(-1, this.exceptions);
                                            if (((String)object).length() > 0) {
                                                this.sql.setParameter(n - 1, this.createLiteralParameter((String)object));
                                            } else {
                                                this.sql.setParameter(n - 1, "' '");
                                            }
                                            break block19;
                                        }
                                    }
                                }
                                catch (SQLException sQLException) {
                                    throw this.exceptions.getException(sQLException, 7025);
                                }
                                catch (Exception exception) {
                                    String[] stringArray = new String[]{exception.getMessage()};
                                    throw this.exceptions.getException(7024, stringArray);
                                }
                            }
                        }
                        this.sql.setParameter(n - 1, "@p" + String.valueOf(n));
                        break block25;
                    }
                    this.sql.setParameter(n - 1, "@p" + String.valueOf(n) + " output");
                }
                object = this.paramPool[this.numParamsToServer++];
                ((SybaseTDSParameter)object).setup(this.comm, ((SybaseImplConnection)this.implConnection).connection, baseParameters, n, bl2);
                ((SybaseTDSParameter)object).prepareTDSData();
            }
            ++n;
        }
    }

    public void returnOutputParams() {
        if (this.parameterSets == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        if (baseParameters == null) {
            return;
        }
        int n = 1;
        int n2 = 1;
        while (n2 <= baseParameters.count()) {
            BaseParameter baseParameter = baseParameters.getOutput(n2);
            if (baseParameter != null) {
                if (n2 == 1 && this.procedureHasReturnParam) {
                    int n3 = this.request.getReturnStatus();
                    baseParameter.setData(new Integer(n3));
                } else {
                    SybaseTDSParameter sybaseTDSParameter = this.request.getOutputParam(n);
                    baseParameter.setData(sybaseTDSParameter.baseDataType, sybaseTDSParameter.data);
                    ++n;
                }
            }
            ++n2;
        }
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        BaseColumns baseColumns2 = null;
        if (baseColumns == null) {
            baseColumns2 = this.request == null ? this.getColumnInfoBeforeExecute() : this.request.getColumnDescriptions();
            return baseColumns2;
        }
        if (this.databaseMetaDataResultSet == 3 || this.databaseMetaDataResultSet == 4) {
            return baseColumns;
        }
        baseColumns2 = this.request.getColumnDescriptions();
        if (baseColumns2 == null) {
            return baseColumns;
        }
        if (this.databaseMetaDataResultSet == 8) {
            BaseColumn baseColumn = baseColumns.get(1);
            BaseColumn baseColumn2 = baseColumns2.get(1);
            baseColumn.displaySize = baseColumn2.displaySize;
            return baseColumns;
        }
        int n = 1;
        while (n <= baseColumns.count(1)) {
            BaseColumn baseColumn = baseColumns.get(n);
            BaseColumn baseColumn3 = null;
            if (baseColumn.type == 12) {
                int n2 = n;
                if (this.databaseMetaDataResultSet == 2 && n >= 13) {
                    n2 += 2;
                }
                if (n2 <= baseColumns2.count(0)) {
                    baseColumn3 = baseColumns2.get(n2);
                    baseColumn.displaySize = baseColumn3.displaySize;
                }
            }
            ++n;
        }
        return baseColumns;
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        this.request.processReply((short)1, this.warnings);
        if (this.request.getResultType() == 2 && this.request.getRow(null)) {
            this.autoGeneratedKeyValue = (BigDecimal)this.request.getColumnData(1, 8);
            if (this.autoGeneratedKeyValue.intValue() != 0) {
                BaseColumns baseColumns = this.request.getColumnDescriptions();
                BaseColumn baseColumn = baseColumns.get(1);
                baseColumn.label = "SYB_IDENTITY";
                baseColumn.name = "SYB_IDENTITY";
                return baseColumns;
            }
        }
        return null;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        return new SybaseAutoGeneratedKeyResultSet();
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        this.resultSet = new SybaseImplResultSet(this.request);
        return this.resultSet;
    }

    public int getNextResultType() throws SQLException {
        if (this.resultType == 1) {
            return 1;
        }
        if (this.resultType == 2) {
            if (this.resultSet == null) {
                this.resultSet = new SybaseImplResultSet(this.request);
            }
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.isCursorSelect) {
            this.resultType = this.resultType == 0 ? 2 : 1;
        } else {
            this.request.processReply(this.warnings);
            this.resultType = this.request.getResultType();
            if (this.resultType == 1) {
                this.returnOutputParams();
            }
            if (this.databaseMetaDataResultSet != 0) {
                this.resultType = 2;
            }
        }
        return this.resultType;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        return this.request.getNumRowsAffected();
    }

    public boolean isSimpleSelect() {
        return this.sql.getType() == 1;
    }

    SybaseTDSRequest executeSQL(String string) throws SQLException {
        SybaseImplConnection sybaseImplConnection = (SybaseImplConnection)this.implConnection;
        return sybaseImplConnection.executeSQL(string, this.warnings);
    }

    public String getRowIdColumnName() {
        return "syb_identity";
    }

    public boolean useStatementConcatenationForBatchEmulation(UtilVectorUnsynced utilVectorUnsynced) {
        float f;
        if (!BaseClassUtility.exposeCtsIncompatibleOptions()) {
            return false;
        }
        String string = this.implConnection.connectProps.get("batchPerformanceWorkaround");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return false;
        }
        int n = 0;
        if (utilVectorUnsynced != null) {
            int n2 = utilVectorUnsynced.size();
            BaseParameters baseParameters = (BaseParameters)utilVectorUnsynced.elementAt(0);
            n = n2 * baseParameters.count();
        }
        if ((double)(f = ((SybaseImplConnection)this.implConnection).connection.getServerVersion()) < 12.5) {
            return n <= 2130;
        }
        return n <= 1095;
    }

    public boolean supportsDefaultKeyword() {
        return false;
    }

    public void cancel() throws SQLException {
        SybaseTDSCancelRequest sybaseTDSCancelRequest = new SybaseTDSCancelRequest(this.comm, this.reader, this.writer);
        sybaseTDSCancelRequest.submitRequest();
    }

    public void processCancelResponse() throws SQLException {
    }

    private BaseColumns getColumnInfoBeforeExecute() throws SQLException {
        BaseColumns baseColumns;
        block7: {
            baseColumns = null;
            BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
            if (!this.isSimpleSelect()) break block7;
            String string = this.sql.getFormatted();
            String string2 = "SET FMTONLY ON ";
            baseSQLScanner.setup(string, '\'', '\"');
            if (this.sql.getParameterCount() > 0) {
                while (true) {
                    BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                    if (!(baseSQLToken.type == 6 || baseSQLToken.type == 9 && baseSQLToken.value.equalsIgnoreCase("where"))) {
                        if (baseSQLToken.type == 8) {
                            string2 = string2 + "null";
                            continue;
                        }
                        string2 = string2 + baseSQLToken.value;
                        continue;
                    }
                    break;
                }
            } else {
                string2 = string2 + string;
            }
            string2 = string2 + " SET FMTONLY OFF";
            try {
                baseColumns = this.executeSQL(string2).getColumnDescriptions();
            }
            catch (Exception exception) {}
        }
        return baseColumns;
    }

    class SybaseAutoGeneratedKeyResultSet
    extends BaseImplResultSet {
        boolean returnedTheRow = false;

        SybaseAutoGeneratedKeyResultSet() {
        }

        public boolean fetchAtPosition(int n) throws SQLException {
            if (this.returnedTheRow) {
                return false;
            }
            this.returnedTheRow = true;
            return true;
        }

        public BaseData getData(int n, int n2) throws SQLException {
            return new BaseData(8, SybaseImplStatement.this.autoGeneratedKeyValue, SybaseImplStatement.this.comm.connection);
        }

        public void close() throws SQLException {
        }
    }
}

