/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIFUN_OLOBOPS
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   1.7.1.0  $";
    public static final int LOB_GETLEN = 1;
    public static final int LOB_READ = 2;
    public static final int LOB_TRIM = 32;
    public static final int LOB_WRITE = 64;
    public static final int LOB_OPEN = 256;
    public static final int LOB_TMPCREATE = 272;
    public static final int LOB_TMPFREE = 273;
    public static final int LOB_CLOSE = 512;
    public static final int LOB_GETCHUNKSIZE = 16384;
    public static final int LOB_BFILEEXISTS = 32768;
    public byte[] SourceLobLocator;
    public byte[] DestinationLobLocator;
    public int SourceOffset;
    public int DestinationOffset;
    public int DestinationLength;
    public boolean brequestCharset;
    public boolean brequestLobamt;
    public boolean brequestIfnull;
    public int lobops;
    public boolean lobscnl;
    public short CharSet;
    public long LobAmt;
    public int[] lobscnldata;
    public short isNull = 0;
    private OracleImplConnection implConn;

    public TTIFUN_OLOBOPS(int n, OracleImplConnection oracleImplConnection) {
        this.TTCCode = 3;
        this.FUNCode = 96;
        this.SourceLobLocator = null;
        this.DestinationLobLocator = null;
        this.SourceOffset = 0;
        this.DestinationOffset = 0;
        this.DestinationLength = 0;
        this.brequestLobamt = true;
        this.brequestIfnull = false;
        this.lobops = n;
        this.CharSet = 0;
        this.LobAmt = 0L;
        this.lobscnldata = null;
        if (this.lobops == 2) {
            this.SourceOffset = 1;
        }
        this.implConn = oracleImplConnection;
    }

    public TTIFUN_OLOBOPS(int n, byte[] byArray, OracleImplConnection oracleImplConnection) {
        this(n, oracleImplConnection);
        this.SourceLobLocator = byArray;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        if (this.SourceLobLocator != null) {
            oracleDataConsumer.writeBoolean(this.SourceLobLocator.length > 0);
            oracleDataConsumer.writeB4(this.SourceLobLocator.length);
        } else {
            oracleDataConsumer.writeByte((byte)0);
            oracleDataConsumer.writeByte((byte)0);
        }
        if (this.DestinationLobLocator != null) {
            oracleDataConsumer.writeBoolean(this.DestinationLobLocator.length > 0);
            oracleDataConsumer.writeB4(this.DestinationLobLocator.length);
        } else if (this.DestinationLength != 0) {
            oracleDataConsumer.writeByte((byte)0);
            oracleDataConsumer.writeB4(this.DestinationLength);
        } else {
            oracleDataConsumer.writeByte((byte)0);
            oracleDataConsumer.writeByte((byte)0);
        }
        if (this.implConn.oracleServerVersion >= 1000000000L) {
            oracleDataConsumer.writeByte((byte)0);
            oracleDataConsumer.writeByte((byte)0);
        } else {
            oracleDataConsumer.writeB4(this.SourceOffset);
            oracleDataConsumer.writeB4(this.DestinationOffset);
        }
        oracleDataConsumer.writeBoolean(this.CharSet != 0);
        if (this.brequestLobamt && this.implConn.oracleServerVersion < 1000000000L) {
            oracleDataConsumer.writeByte((byte)1);
        } else {
            oracleDataConsumer.writeByte((byte)0);
        }
        oracleDataConsumer.writeBoolean(this.brequestIfnull);
        oracleDataConsumer.writeB4(this.lobops);
        if (this.lobscnldata != null) {
            oracleDataConsumer.writeBoolean(this.lobscnldata.length > 0);
            oracleDataConsumer.writeB4(this.lobscnldata.length);
        } else {
            oracleDataConsumer.writeByte((byte)0);
            oracleDataConsumer.writeByte((byte)0);
        }
        if (this.implConn.oracleServerVersion >= 1000000000L) {
            oracleDataConsumer.writeB4(this.SourceOffset);
            oracleDataConsumer.writeB4(this.DestinationOffset);
            oracleDataConsumer.writeBoolean(this.brequestLobamt);
        }
        if (this.SourceLobLocator != null) {
            oracleDataConsumer.writeBytes(this.SourceLobLocator, 0, this.SourceLobLocator.length);
        }
        if (this.DestinationLobLocator != null) {
            oracleDataConsumer.writeBytes(this.DestinationLobLocator, 0, this.DestinationLobLocator.length);
        }
        if (this.CharSet != 0) {
            oracleDataConsumer.writeB2(this.CharSet);
        }
        if (this.brequestLobamt && this.implConn.oracleServerVersion < 1000000000L) {
            oracleDataConsumer.writeB4((int)this.LobAmt);
        }
        if (this.lobscnldata != null) {
            for (int i = 0; i < this.lobscnldata.length; ++i) {
                oracleDataConsumer.writeB4(this.lobscnldata[i]);
            }
        }
        if (this.brequestLobamt && this.implConn.oracleServerVersion >= 1000000000L) {
            oracleDataConsumer.writeB4((int)this.LobAmt);
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        if (this.SourceLobLocator != null) {
            oracleDataProvider.readBytes(this.SourceLobLocator, 0, this.SourceLobLocator.length);
        }
        if (this.DestinationLobLocator != null) {
            oracleDataProvider.readBytes(this.DestinationLobLocator, 0, this.DestinationLobLocator.length);
        }
        if (this.CharSet != 0) {
            this.CharSet = oracleDataProvider.readB2();
        }
        if (this.brequestLobamt) {
            this.LobAmt = oracleDataProvider.readSB4();
        }
        if (this.brequestIfnull) {
            this.isNull = oracleDataProvider.readB2();
        }
        if (this.lobscnldata != null) {
            for (int i = 0; i < this.lobscnldata.length; ++i) {
                this.lobscnldata[i] = oracleDataProvider.readB4();
            }
        }
    }
}

