/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public final class TDSRPCCursorExecuteRequest
extends TDSRPCExecuteRequest {
    private static String footprint = "$Revision:   3.20.1.5  $";
    private int requestedConcurrency;
    private int requestedScrollType;
    static final int DEFAULT_FETCH_SIZE = 1024;
    private int fetchSize;
    private boolean resultTypeHasBeenRequested;
    private boolean executingSQLDirectly;
    private SQLServerByteOrderedDataReader altReader;
    private TDSRPCParameter cursorHandleParam;
    private TDSRPCParameter scrollOptParam;
    private TDSRPCParameter concurrencyOptionsParam;
    private TDSRPCParameter rowCountParam;
    private TDSRPCParameter rowNumberParam;
    private TDSRPCParameter fetchTypeParam;
    private TDSRPCParameter optionsParam;
    private boolean useServerSideUpdatableCursors;
    private TDSRPCParameter operationTypeParam;
    private TDSRPCParameter tableNameParam;
    private String tableName;
    private TDSRPCParameter rowNumberToUpdateParam;
    private boolean currentRowWasDeleted = false;
    private boolean isPreparedStatement;
    private static final int CURSOR_WAS_AUTOCLOSED = 16;
    private boolean cursorIsOpen;
    private boolean discardingResultSet;
    public int lockingModeConcurrency;
    private boolean hasForUpdate;
    private boolean hasForReadOnly;

    public TDSRPCCursorExecuteRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, boolean bl, int n, int n2, String string, boolean bl2, int n3, boolean bl3, boolean bl4) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter, bl);
        this.requestedScrollType = n;
        this.requestedConcurrency = n2;
        this.tableName = string;
        this.useServerSideUpdatableCursors = bl2;
        this.lockingModeConcurrency = n3;
        this.hasForUpdate = bl3;
        this.hasForReadOnly = bl4;
        this.executingSQLDirectly = false;
        this.fetchSize = 1024;
        this.altReader = null;
    }

    protected boolean internalOutOfOrderAccessPerformed() {
        return !this.executingSQLDirectly;
    }

    public boolean usingNativeUpdatability() {
        return this.useServerSideUpdatableCursors && this.requestedConcurrency == 1008;
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case 121: {
                    this.returnStatus = this.reader.readInt32();
                    this.returnStatusIsValid = true;
                    if (this.returnStatus == 16) {
                        this.cursorIsOpen = false;
                    }
                    return true;
                }
            }
            return super.processReplyToken(by, baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
    }

    protected void createRPCParameters() {
        this.cursorHandleParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.scrollOptParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.concurrencyOptionsParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.rowCountParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.rowNumberParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.fetchTypeParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        this.optionsParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        super.createRPCParameters();
    }

    public void setFetchSize(int n, int n2) {
        this.fetchSize = n2 > 0 ? n2 : 1024;
        if (n > 0 && n < this.fetchSize) {
            this.fetchSize = n;
        }
    }

    protected void submitPrepare(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        this.resultTypeHasBeenRequested = false;
        this.addRPCToBatch("sp_cursorprepare", 0);
        this.prepareHandleParam.initializeInternalParam((byte)38, false, true, 4, 0, 0, null);
        this.addRPCParameter(this.prepareHandleParam);
        if (this.userParameters.size() == 0) {
            this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, 0, -1, 0, null);
        }
        this.addRPCParameter(this.userParamDefinitionsParam);
        this.stmtParam.initializeInternalParam((byte)99, true, false, this.sql.length(), this.sql.length(), 0, this.sql);
        this.addRPCParameter(this.stmtParam);
        this.optionsParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, 1);
        this.addRPCParameter(this.optionsParam);
        this.scrollOptParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSScrollType());
        this.addRPCParameter(this.scrollOptParam);
        this.concurrencyOptionsParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSConcurrency());
        this.addRPCParameter(this.concurrencyOptionsParam);
        this.submitRequest(sQLServerImplStatement);
        this.processReply(4, baseWarnings);
        if (this.executingSQLDirectly) {
            this.processReply(4, baseWarnings);
        }
    }

    protected void setupExecute(BaseWarnings baseWarnings) throws SQLException {
        this.resultTypeHasBeenRequested = false;
        this.addRPCToBatch("sp_cursorexecute", 2);
        this.prepareHandleParam.isOutput = false;
        this.prepareHandleParam.isInput = true;
        this.prepareHandleParam.actualLength = 4;
        this.addRPCParameter(this.prepareHandleParam);
        this.cursorHandleParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, 0);
        this.addRPCParameter(this.cursorHandleParam);
        this.scrollOptParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSScrollType());
        this.addRPCParameter(this.scrollOptParam);
        this.concurrencyOptionsParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSConcurrency());
        this.addRPCParameter(this.concurrencyOptionsParam);
        this.rowCountParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.fetchSize);
        this.addRPCParameter(this.rowCountParam);
        this.cursorIsOpen = true;
        this.discardingResultSet = false;
        this.addUserParametersToRPC();
    }

    protected void setupDirectExecute(BaseWarnings baseWarnings) throws SQLException {
        this.addRPCToBatch("sp_execute", 0);
        this.prepareHandleParam.isOutput = false;
        this.prepareHandleParam.isInput = true;
        this.prepareHandleParam.actualLength = 4;
        this.addRPCParameter(this.prepareHandleParam);
        this.addUserParametersToRPC();
    }

    protected void submitPrepExec(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        this.resultTypeHasBeenRequested = false;
        this.addRPCToBatch("sp_cursorprepexec", 0);
        this.prepareHandleParam.initializeInternalParam((byte)38, false, true, 4, 0, 0, null);
        this.addRPCParameter(this.prepareHandleParam);
        this.cursorHandleParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, 0);
        this.addRPCParameter(this.cursorHandleParam);
        if (this.userParameters.size() == 0) {
            this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, 0, -1, 0, null);
        }
        this.addRPCParameter(this.userParamDefinitionsParam);
        this.stmtParam.initializeInternalParam((byte)99, true, false, this.sql.length(), this.sql.length(), 0, this.sql);
        this.addRPCParameter(this.stmtParam);
        this.scrollOptParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSScrollType());
        this.addRPCParameter(this.scrollOptParam);
        this.concurrencyOptionsParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSConcurrency());
        this.addRPCParameter(this.concurrencyOptionsParam);
        this.rowCountParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.fetchSize);
        this.addRPCParameter(this.rowCountParam);
        this.cursorIsOpen = true;
        this.discardingResultSet = false;
        this.addUserParametersToRPC();
        this.submitRequest(sQLServerImplStatement);
        this.commonProcessReply(baseWarnings);
    }

    protected void setupUnpreparedExecute(BaseWarnings baseWarnings) throws SQLException {
        this.resultTypeHasBeenRequested = false;
        this.addRPCToBatch("sp_cursoropen", 0);
        this.cursorHandleParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, 0);
        this.addRPCParameter(this.cursorHandleParam);
        this.stmtParam.initializeInternalParam((byte)99, true, false, this.sql.length(), this.sql.length(), 0, this.sql);
        this.addRPCParameter(this.stmtParam);
        this.scrollOptParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSScrollType());
        this.addRPCParameter(this.scrollOptParam);
        this.concurrencyOptionsParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.determineTDSConcurrency());
        this.addRPCParameter(this.concurrencyOptionsParam);
        this.rowCountParam.initializeInternalParam((byte)38, true, true, 4, 4, 0, this.fetchSize);
        this.addRPCParameter(this.rowCountParam);
        if (this.userParameters.size() != 0) {
            this.addRPCParameter(this.userParamDefinitionsParam);
            this.addUserParametersToRPC();
        }
        this.cursorIsOpen = true;
        this.discardingResultSet = false;
    }

    protected void submitUnpreparedExecute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        this.setupUnpreparedExecute(baseWarnings);
        this.submitRequest(sQLServerImplStatement);
        this.commonProcessReply(baseWarnings);
    }

    protected void submitExecute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        if (this.executingSQLDirectly) {
            this.setupDirectExecute(baseWarnings);
        } else {
            this.setupExecute(baseWarnings);
        }
        this.submitRequest(sQLServerImplStatement);
        this.commonProcessReply(baseWarnings);
    }

    private void commonProcessReply(BaseWarnings baseWarnings) throws SQLException {
        if (this.getScrollTypeToReport() == 1003 && !this.usingNativeUpdatability()) {
            this.processReply(1, baseWarnings);
        } else {
            this.processReply(4, baseWarnings);
            if (!this.executingSQLDirectly && !this.usingNativeUpdatability()) {
                this.positionBeforeFirst(baseWarnings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCursorFetch(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader = null;
        try {
            if (n == 256) {
                sQLServerByteOrderedDataReader = this.reader;
                this.reader = this.getAltReader();
            }
            this.reset();
            this.setupCursorFetch(n, n2, baseWarnings);
            this.submitRequest(null);
            if (n == 256) {
                this.processReply(3, baseWarnings);
            } else {
                if (this.conn.getTDSVersion() == 2) {
                    this.processReply(1, baseWarnings);
                }
                this.resultType = 2;
            }
            this.currentRowWasDeleted = false;
            Object var6_5 = null;
            if (n == 256) {
                this.reader = sQLServerByteOrderedDataReader;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (n == 256) {
                this.reader = sQLServerByteOrderedDataReader;
            }
            throw throwable;
        }
    }

    private void setupCursorFetch(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        this.addRPCToBatch("sp_cursorfetch", 2);
        this.numRowsFetchedFromResultSet = 0;
        this.cursorHandleParam.isOutput = false;
        this.addRPCParameter(this.cursorHandleParam);
        this.fetchTypeParam.initializeInternalParam((byte)38, true, false, 4, 4, 0, n);
        this.addRPCParameter(this.fetchTypeParam);
        int n3 = n == 16 || n == 32 ? n2 : 1;
        boolean bl = n == 256;
        this.rowNumberParam.initializeInternalParam((byte)38, !bl, bl, 4, 4, 0, n3);
        this.addRPCParameter(this.rowNumberParam);
        int n4 = (n == 1 || n == 8) && n2 == 0 ? 0 : (this.getScrollTypeToReport() == 1003 && !this.usingNativeUpdatability() ? this.fetchSize : 1);
        this.rowCountParam.initializeInternalParam((byte)38, !bl, bl, 4, 4, 0, n4);
        this.addRPCParameter(this.rowCountParam);
    }

    public int getResultType() {
        if (this.executingSQLDirectly) {
            return super.getResultType();
        }
        if (this.resultTypeHasBeenRequested) {
            return 1;
        }
        this.resultTypeHasBeenRequested = true;
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor(BaseWarnings baseWarnings) throws SQLException {
        if (this.cursorIsOpen) {
            this.reset();
            this.addRPCToBatch("sp_cursorclose", 0);
            this.cursorHandleParam.isOutput = false;
            this.addRPCParameter(this.cursorHandleParam);
            try {
                try {
                    this.submitRequest(null);
                    this.processReply(3, baseWarnings);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != 16909) {
                        throw sQLException;
                    }
                    Object var4_3 = null;
                    this.cursorIsOpen = false;
                }
                Object var4_2 = null;
                this.cursorIsOpen = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.cursorIsOpen = false;
                throw throwable;
            }
        }
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly) {
            return super.getRow(baseWarnings);
        }
        if (super.getRow(baseWarnings)) {
            return true;
        }
        this.processReply(3, baseWarnings);
        if (this.getScrollTypeToReport() == 1003 && this.cursorIsOpen && !this.discardingResultSet) {
            this.submitCursorFetch(2, 1, baseWarnings);
            if (super.getRow(baseWarnings)) {
                return true;
            }
            this.processReply(3, baseWarnings);
        }
        return false;
    }

    public void unprepare(BaseWarnings baseWarnings) throws SQLException {
        if (!this.prepareHandleParam.data.isNull) {
            this.reset();
            this.addRPCToBatch("sp_cursorunprepare", 0);
            this.prepareHandleParam.isInput = true;
            this.prepareHandleParam.isOutput = false;
            this.prepareHandleParam.actualLength = 4;
            this.addRPCParameter(this.prepareHandleParam);
            this.submitRequest(null);
            this.processReply(3, baseWarnings);
        }
    }

    public boolean fetchNext(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly || this.getScrollTypeToReport() == 1003 && !this.usingNativeUpdatability()) {
            return this.getRow(baseWarnings);
        }
        this.submitCursorFetch(2, 1, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public boolean fetchPrevious(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(4, 1, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public boolean fetchFirst(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(1, 1, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public boolean fetchLast(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(8, 1, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public void positionBeforeFirst(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(1, 0, baseWarnings);
    }

    public void positionAfterLast(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(8, 0, baseWarnings);
    }

    public boolean fetchAbsolute(int n, BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(16, n, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public boolean fetchRelative(int n, BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(32, n, baseWarnings);
        return this.getRow(baseWarnings);
    }

    public int getCurrentPosition(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        int n = this.rowNumberParam.data.getIntegerNoConvert();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public boolean isAfterLastRow(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        int n = this.rowNumberParam.data.getIntegerNoConvert();
        int n2 = this.rowCountParam.data.getIntegerNoConvert();
        if (n2 == 0) {
            return false;
        }
        return n == -1;
    }

    public boolean isBeforeFirstRow(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        int n = this.rowNumberParam.data.getIntegerNoConvert();
        int n2 = this.rowCountParam.data.getIntegerNoConvert();
        return n2 != 0 && n == 0;
    }

    public boolean isOnLastRow(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        int n = this.rowNumberParam.data.getIntegerNoConvert();
        int n2 = this.rowCountParam.data.getIntegerNoConvert();
        return n2 > 0 && n == n2;
    }

    public boolean isOnFirstRow(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        int n = this.rowNumberParam.data.getIntegerNoConvert();
        return n == 1;
    }

    public boolean onDeletedRow() throws SQLException {
        return this.currentRowWasDeleted;
    }

    public void submitRowChange(int n, BaseData[] baseDataArray, BaseWarnings baseWarnings) throws SQLException {
        this.reset();
        this.addRPCToBatch("sp_cursor", 0);
        this.cursorHandleParam.isOutput = false;
        this.addRPCParameter(this.cursorHandleParam);
        if (this.operationTypeParam == null) {
            this.operationTypeParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        }
        this.operationTypeParam.initializeInternalParam((byte)38, true, false, 4, 4, 0, n);
        this.addRPCParameter(this.operationTypeParam);
        if (this.rowNumberToUpdateParam == null) {
            this.rowNumberToUpdateParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        }
        this.rowNumberToUpdateParam.initializeInternalParam((byte)38, true, false, 4, 4, 0, 1);
        this.addRPCParameter(this.rowNumberToUpdateParam);
        if (this.tableNameParam == null) {
            this.tableNameParam = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
        }
        this.tableNameParam.initializeInternalParam((byte)-25, true, false, 0, 0, 0, null);
        this.addRPCParameter(this.tableNameParam);
        if (baseDataArray != null) {
            int n2 = 0;
            while (n2 < baseDataArray.length) {
                if (baseDataArray[n2] != null) {
                    TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
                    tDSRPCParameter.initializeURSParam(this.getColumnDescriptions().get(n2 + 1), baseDataArray[n2]);
                    this.addRPCParameter(tDSRPCParameter);
                }
                ++n2;
            }
        } else if (n == 4) {
            TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), this.maxPrecision, this.conn.exceptions, this.conn.connection);
            tDSRPCParameter.initializeInternalParam((byte)99, true, false, 0, -1, 0, "INSERT " + this.tableName + " DEFAULT VALUES");
            this.addRPCParameter(tDSRPCParameter);
        }
        this.submitRequest(null);
        this.commonProcessReply(baseWarnings);
        if (n == 1) {
            this.reset();
            this.setupCursorFetch(128, 1, baseWarnings);
            this.submitRequest(null);
            if (this.conn.getTDSVersion() == 2) {
                this.processReply(1, baseWarnings);
            }
            this.getRow(baseWarnings);
            this.lastColumnProcessedForCurrentRow = 0;
            this.currentRowWasDeleted = false;
        } else if (n == 2) {
            this.currentRowWasDeleted = true;
        }
    }

    protected boolean processInfoTokenAction(int n, byte by, byte by2) {
        if (n == 16954) {
            this.executingSQLDirectly = true;
            this.cursorIsOpen = false;
            return false;
        }
        return true;
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        this.discardingResultSet = true;
        super.completeRowProcessing(baseWarnings);
        if (!this.executingSQLDirectly) {
            this.closeCursor(baseWarnings);
        }
    }

    private SQLServerByteOrderedDataReader getAltReader() {
        if (this.altReader == null) {
            this.altReader = this.conn.createReader();
        }
        return this.altReader;
    }

    public int getScrollTypeToReport() {
        if (this.executingSQLDirectly) {
            return 1003;
        }
        if (this.requestedScrollType == 1003) {
            return 1003;
        }
        switch (this.getNativeCursorType()) {
            case 8: {
                return 1004;
            }
            case 1: {
                return 1005;
            }
        }
        return 1003;
    }

    public int getNativeCursorType() {
        return this.scrollOptParam.data.getIntegerNoConvert() & 0xFF;
    }

    public int getConcurrency() {
        if (this.requestedConcurrency == 1007) {
            return 1007;
        }
        int n = this.concurrencyOptionsParam.data.getIntegerNoConvert();
        if ((n & 2) != 0) {
            return 1008;
        }
        return 1007;
    }

    private final int determineTDSScrollType() {
        int n;
        switch (this.requestedScrollType) {
            case 1003: {
                if ((this.determineTDSConcurrency() & 1) != 0) {
                    n = 24592;
                    break;
                }
                n = 4;
                break;
            }
            case 1004: {
                n = 8;
                break;
            }
            case 1005: {
                n = 1;
                break;
            }
            default: {
                n = 4;
            }
        }
        if (this.userParameters.size() > 0 && !this.procedureName.equals("sp_cursorexecute")) {
            n |= 0x1000;
        }
        return n;
    }

    private final int determineTDSConcurrency() {
        int n = this.requestedConcurrency == 1008 ? (this.hasForReadOnly ? 1 : (this.usingNativeUpdatability() ? (this.requestedScrollType != 1004 && this.tableName != null ? 2 : 1) : (this.lockingModeConcurrency == 0 ? 2 : 1))) : (this.hasForUpdate ? 2 : 1);
        return n |= 0x2000;
    }

    public final int getRowstatOrdinal() {
        return this.currentNativeColumns.length;
    }

    public final boolean getExecutingSQLDirectly() {
        return this.executingSQLDirectly;
    }

    public int getRowCount(BaseWarnings baseWarnings) throws SQLException {
        this.submitCursorFetch(256, 0, baseWarnings);
        return this.rowCountParam.data.getIntegerNoConvert();
    }
}

