/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDARequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class DRDAStatementRequest
extends DRDARequest {
    private static String footprint = "$Revision:   3.68.1.1  $";
    public BaseColumns columnDescriptions;
    public UtilPagedTempBuffer lobBuffer;
    public boolean cursorIsScrollable;
    public short cursorUpdateAbility;
    public short cursorSensitivity;
    public int[] doubleByteColumns;
    public BaseParameters parameterDescriptions;
    private UtilVectorUnsynced fdocaMap;
    private boolean hasEarlyDesc;
    public int numResultSets;
    public DRDAPkgNamCsn[] packageNameCsnList;
    public DB2ImplResultSet[] resultSetArray;
    public boolean reExecutingWithParamInfos;
    public boolean reExecutingWithClobSubstitution;
    int[] lobColumns;
    int lobInsertPos = 0;
    public DRDAParameter lobLocParam;
    public boolean hasLobCols;
    public UtilVectorUnsynced storedProcedureParams;
    public boolean hasClobColumns = false;
    public int queryDataLen;
    int[] type;
    public int numParams;

    public DRDAStatementRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter);
        this.packageConsistencyToken = dRDAPkgNamCsn;
        this.chainCommit = true;
        this.hasLobCols = false;
    }

    public void setParameters(BaseParameters baseParameters) {
        this.parameterDescriptions = baseParameters;
        if (baseParameters != null) {
            this.numParams = this.parameterDescriptions.count();
        }
        this.lobInsertPos = 0;
        if (this.lobColumns != null) {
            for (int i = 0; i < this.lobColumns.length - 1; ++i) {
                this.lobColumns[i] = 0;
            }
        }
    }

    public BaseColumns getColumns() {
        return new BaseColumns();
    }

    public void setToPrepared() throws SQLException {
        try {
            this.clearExceptions();
            this.storedProcedureParams = null;
            this.writer.empty();
            this.lobLocParam = null;
            this.lobInsertPos = 0;
            this.fdocaMap = null;
            this.hasEarlyDesc = false;
            this.numRowsAffected = 0;
            this.checkingForAdditionalUpdateCounts = false;
            this.queryDataEndPosition = 0L;
            this.queryDataLen = 0;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void reset() throws SQLException {
        this.clearExceptions();
        this.chainCommit = true;
        this.hasClobColumns = false;
        this.columnDescriptions = null;
        this.isStoredProcedure = false;
        this.lobLocParam = null;
        this.numResultSets = 0;
        this.packageNameCsnList = null;
        this.parameterDescriptions = null;
        this.queryDataEndPosition = 0L;
        this.queryDataLen = 0;
        this.reExecutingWithClobSubstitution = false;
        this.reExecutingWithParamInfos = false;
        this.resultSetArray = null;
        if (this.storedProcedureParams != null) {
            this.storedProcedureParams.clear();
        }
        this.lobColumns = null;
        this.lobInsertPos = 0;
        if (this.fdocaMap != null) {
            this.fdocaMap.clear();
        }
        this.hasEarlyDesc = false;
    }

    public final void writePRPSQLSTT(String string, boolean bl, boolean bl2) throws SQLException {
        try {
            int n;
            int n2;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = this.writer.writePacketHeader((short)1, (short)64, 1);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n2 = 2;
            }
            n = this.writer.writePacketHeader((short)1, (short)80, n2);
            int n3 = this.writer.writeCodePoint((short)8205);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8470);
            if (bl) {
                this.writer.writeInt8(241);
                if (this.comm.supportsExtendedTypSQLDA) {
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(8518);
                    this.writer.writeInt8(4);
                }
            } else {
                this.writer.writeInt8(240);
            }
            this.writer.writeCodePointLength(n3);
            this.writer.writePacketLength(n);
            int n4 = 0;
            n4 = bl2 ? this.writer.writePacketHeader((short)3, (short)0, n2) : this.writer.writePacketHeader((short)3, (short)64, n2);
            int n5 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt8(255);
            } else if (this.comm.serverType == 2) {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            } else {
                this.writer.writeEncodedStringWithLength16(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt16(0);
            }
            this.writer.writeCodePointLength(n5);
            this.writer.writePacketLength(n4);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public final void writeDSCSQLSTT() throws SQLException {
        try {
            int n;
            int n2;
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = this.writer.writePacketHeader((short)1, (short)0, n3);
            n = this.writer.writeCodePoint((short)8200);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8518);
            if (this.comm.supportsExtendedTypSQLDA) {
                this.writer.writeInt8(5);
            } else {
                this.writer.writeInt8(1);
            }
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public final void writeFDODSC(boolean bl) throws UtilException, SQLException {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.numParams;
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = this.comm.drdaUtil.getRowLength(this.parameterDescriptions, this.numParams, this.comm.exceptions, this.implConn.db2Connection, this.doubleByteColumns);
            boolean bl4 = false;
            if (n5 > 32000 && this.comm.enableFullSizeLobs && this.comm.allowsInsertIntoVarcharAsClob) {
                bl3 = true;
            }
            if (n4 > 84) {
                this.lobColumns = new int[n4];
                bl3 = false;
                n2 = n4 / 84;
                n3 = n4 % 84;
                if (n3 == 0) {
                    --n2;
                    n3 = 84;
                }
                n = 255;
            } else {
                n = n4 * 3 + 3;
            }
            this.writer.writeInt8(n);
            this.writer.writeBytes(DRDAConstants.GDA);
            for (int i = 0; i < n4; ++i) {
                int n6;
                bl2 = false;
                if (n2 != 0 && i % 84 == 0 && i != 0) {
                    n6 = 0;
                    n6 = n2 > 1 ? 255 : 3 * n3 + 3;
                    this.writer.writeInt8(n6);
                    this.writer.writeInt8(127);
                    this.writer.writeInt8(0);
                    --n2;
                }
                n6 = i + 1;
                BaseParameter baseParameter = this.parameterDescriptions.getInput(n6);
                BaseParameterInfo baseParameterInfo = this.parameterDescriptions.getParameterInfoOrNull(i);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.getOutput(n6);
                    bl2 = true;
                } else if (this.isStoredProcedure) {
                    BaseParameter baseParameter2 = this.parameterDescriptions.getOutput(n6);
                    if (baseParameter2 != null) {
                        bl2 = true;
                    }
                    if (baseParameterInfo == null) {
                        baseParameterInfo = this.parameterDescriptions.getParameterInfo(i);
                    }
                    if (baseParameter.sqlType != -3 && baseParameter.sqlType != -2 && baseParameter.sqlType != -4 && baseParameter.sqlType != 2004) {
                        baseParameter.sqlType = baseParameterInfo.sqlType;
                        baseParameter.scale = baseParameterInfo.scale;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("CHAR")) {
                        baseParameter.sqlType = -2;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("VARCHAR")) {
                        baseParameter.sqlType = -3;
                    } else if (baseParameterInfo.nativeTypeName.equalsIgnoreCase("BLOB")) {
                        baseParameter.sqlType = 2004;
                        baseParameterInfo.sqlType = 2004;
                    } else {
                        baseParameter.sqlType = -4;
                    }
                }
                int n7 = 0;
                int n8 = -1;
                int n9 = 0;
                boolean bl5 = false;
                n9 = baseParameter.scale <= 0 ? 0 : (baseParameter.sqlType == 3 || baseParameter.sqlType == 2 ? baseParameter.scale : 0);
                if (baseParameter != null) {
                    switch (baseParameter.sqlType) {
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            long l = 0L;
                            int n10 = 1;
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                                            if (baseParameter.getType() == 17) {
                                                l = ((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                                break;
                                            }
                                            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                            baseParameter.setData((Object)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                                            l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                            this.comm.DoubleByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                            l = utilPagedTempBuffer.getSize() / 2L;
                                            baseParameter.setData(17, (Object)new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions));
                                            break;
                                        }
                                        if (baseParameter.getType() == 16) {
                                            l = ((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions)).determineLength();
                                            break;
                                        }
                                        UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
                                        l = ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        this.comm.MultiByteClientTransliterator.encode(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)l, utilPagedTempBuffer.getOutputStream());
                                        l = utilPagedTempBuffer.getSize();
                                        baseParameter.setData(16, (Object)new BaseInputStreamWrapper(utilPagedTempBuffer.getInputStream(), utilPagedTempBuffer.getSize(), (BaseConnection)this.implConn.db2Connection, this.implConn.exceptions));
                                        break;
                                    }
                                    case 2: {
                                        l = ((byte[])baseParameter.getObject()).length;
                                        break;
                                    }
                                    default: {
                                        if (this.lobLocParam != null) {
                                            baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                            l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                            break;
                                        }
                                        String string = baseParameter.getString(-1, this.comm.exceptions);
                                        if (this.comm.useMultiByteCPForParams) {
                                            baseParameter.setBytes(BaseParameter.stringToBytes((String)string, (UtilTransliterator)this.comm.MultiByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                        } else {
                                            baseParameter.setBytes(BaseParameter.stringToBytes((String)string, (UtilTransliterator)this.comm.SingleByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                        }
                                        l = baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                                if (this.doubleByteColumns[i] == 412 || this.doubleByteColumns[i] == 413 && l != 0L) {
                                    baseParameter.sqlType = 2005;
                                    if (this.lobColumns == null) {
                                        this.lobColumns = new int[84];
                                    }
                                    if (!baseParameter.isNull()) {
                                        this.lobColumns[this.lobInsertPos++] = n6;
                                    }
                                } else {
                                    if (l == 0L) {
                                        bl4 = true;
                                    }
                                    baseParameter.sqlType = -1;
                                }
                            } else if ((l <= 32704L || this.comm.serverOS == 8 && l <= 32740L) && !bl3) {
                                if (this.isStoredProcedure && !bl2 && l <= 254L && l != 0L) {
                                    if (!baseParameter.isNull() && baseParameterInfo.sqlType != 12 && baseParameterInfo.sqlType != -1) {
                                        baseParameter.sqlType = 1;
                                        n10 = 0;
                                    }
                                } else {
                                    baseParameter.sqlType = -1;
                                }
                            } else if (!this.comm.enableFullSizeLobs || l == 0L) {
                                baseParameter.sqlType = -1;
                            } else {
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 18: 
                                    case 20: {
                                        break;
                                    }
                                    default: {
                                        if (baseParameter.isNull) break;
                                        baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                                    }
                                }
                                baseParameter.sqlType = 2005;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull()) {
                                    this.lobColumns[this.lobInsertPos++] = n6;
                                }
                            }
                            int n11 = this.doubleByteColumns != null && this.doubleByteColumns[i] != 0 ? 1 : 0;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, n11 != 0, bl4);
                            n7 = this.type[0];
                            int n12 = this.type[1];
                            n8 = n10 != 0 ? n12 : (int)l;
                            if (this.lobLocParam != null) {
                                n7 = this.lobLocParam.fdocaType;
                                n8 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl5 = true;
                            bl4 = false;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            long l = 0L;
                            if (baseParameterInfo != null) {
                                baseParameter.sqlType = baseParameterInfo.sqlType;
                                if (baseParameterInfo.nativeTypeName == "ROWID") {
                                    baseParameter.nativeType = 30;
                                }
                            }
                            if (!baseParameter.isNull()) {
                                switch (baseParameter.getType()) {
                                    case 2: {
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                        break;
                                    }
                                    case 19: {
                                        l += ((BaseBlob)baseParameter.getObject()).length();
                                        break;
                                    }
                                    case 14: {
                                        l += ((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength();
                                        break;
                                    }
                                    default: {
                                        baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                        l += (long)baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    }
                                }
                            }
                            if (baseParameter.getType() == 14 && this.comm.sendStreamAsBlob) {
                                baseParameter.sqlType = 2004;
                            }
                            if (l <= 32704L && baseParameter.sqlType != 2004) {
                                baseParameter.sqlType = -4;
                            } else if (this.comm.enableFullSizeLobs) {
                                baseParameter.sqlType = 2004;
                                if (this.lobColumns == null) {
                                    this.lobColumns = new int[84];
                                }
                                if (!baseParameter.isNull() && l != 0L) {
                                    this.lobColumns[this.lobInsertPos++] = n6;
                                }
                            } else {
                                baseParameter.sqlType = -4;
                            }
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n7 = this.type[0];
                            n8 = this.type[1];
                            if (this.lobLocParam != null) {
                                n7 = this.lobLocParam.fdocaType;
                                n8 = this.lobLocParam.fdocaLen;
                                baseParameter.sqlType = -2;
                                baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                            }
                            bl5 = true;
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n12;
                            int n11;
                            int n10;
                            this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                            n7 = this.type[0];
                            if (baseParameter.isNull()) {
                                if (bl2) {
                                    n9 = this.parameterDescriptions.getParameterInfo((int)i).scale;
                                    n8 = this.parameterDescriptions.getParameterInfo((int)i).precision;
                                } else {
                                    n8 = this.comm.serverOS == 8 ? 31 : 0;
                                    n9 = 0;
                                }
                                baseParameter.setNull(8);
                                break;
                            }
                            if (baseParameter.getType() == 2) {
                                n9 = baseParameter.scale;
                                n8 = baseParameter.getBytes(-1, this.comm.exceptions).length * 2 - 1;
                                break;
                            }
                            baseParameter.setBigDecimal(baseParameter.getBigDecimal(this.comm.exceptions));
                            BigDecimal bigDecimal = baseParameter.getBigDecimal(this.comm.exceptions);
                            baseParameter.scale = bigDecimal.scale();
                            n9 = bigDecimal.scale();
                            n8 = 0;
                            StringBuffer stringBuffer = null;
                            stringBuffer = (double)UtilJDKVersionChecker.getJVMVersion() >= 1.5 ? new StringBuffer(this.drdaUtil.bigDecToPlainString(bigDecimal)) : new StringBuffer(bigDecimal.toString());
                            if (stringBuffer.charAt(0) == '-') {
                                stringBuffer.append('D');
                            } else {
                                stringBuffer.append('C');
                            }
                            for (n10 = 0; n10 < stringBuffer.length(); ++n10) {
                                if (stringBuffer.charAt(n10) != '.' && stringBuffer.charAt(n10) != '-') continue;
                                stringBuffer.deleteCharAt(n10);
                            }
                            n8 = stringBuffer.length() - 1;
                            if (this.isStoredProcedure) {
                                n8 = baseParameterInfo.precision;
                                n9 = baseParameter.scale > baseParameterInfo.scale ? baseParameter.scale : baseParameterInfo.scale;
                                n10 = baseParameterInfo.scale - bigDecimal.scale();
                                n11 = stringBuffer.length() - 1;
                                for (n12 = 0; n12 < n10; ++n12) {
                                    stringBuffer.insert(n11, 0);
                                }
                                n12 = n8 - (stringBuffer.length() - 1);
                                for (int j = 0; j < n12; ++j) {
                                    stringBuffer.insert(0, 0);
                                }
                            }
                            if (stringBuffer.length() % 2 != 0) {
                                stringBuffer.insert(0, 0);
                            }
                            baseParameter.setData(2, (Object)this.drdaUtil.convertStringBufferToDRDADecimal(stringBuffer));
                            break;
                        }
                        case -7: 
                        case -6: 
                        case 16: {
                            baseParameter.sqlType = 5;
                        }
                        case 5: {
                            n9 = 0;
                            break;
                        }
                        case 7: {
                            if (!baseParameter.isNull()) {
                                if (baseParameter.getType() == 6 && !this.isStoredProcedure) {
                                    baseParameter.setDouble(baseParameter.getDouble(this.comm.exceptions));
                                    baseParameter.sqlType = 6;
                                    break;
                                }
                                baseParameter.setFloat(baseParameter.getFloat(this.comm.exceptions));
                                break;
                            }
                            baseParameter.setNull(6);
                            break;
                        }
                        case -5: {
                            bl5 = true;
                            break;
                        }
                    }
                }
                if (n8 == -1) {
                    this.type = this.drdaUtil.Jdbc2DrdaType(baseParameter, true, false, false);
                    n7 = this.type[0];
                    n8 = this.type[1];
                }
                this.writer.writeInt8(n7);
                baseParameter.nativeType = n7;
                if (bl5) {
                    if (!this.comm.isServerBigEndianOS) {
                        this.reader.interpretAsBigEndian = false;
                    }
                    this.writer.writeInt16(n8);
                } else if (baseParameter.sqlType == 3 || baseParameter.sqlType == 2) {
                    this.writer.writeInt8(n8);
                    this.writer.writeInt8(n9);
                } else {
                    this.writer.writeInt8(n9);
                    this.writer.writeInt8(n8);
                }
                this.reader.interpretAsBigEndian = true;
            }
            this.writer.writeBytes(DRDAConstants.ROWDESC);
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
    }

    public final void writeFDODTA() throws SQLException {
        try {
            boolean bl = false;
            this.writer.writeInt8(0);
            block32: for (int i = 0; i < this.numParams; ++i) {
                bl = false;
                int n = i + 1;
                BaseParameter baseParameter = this.parameterDescriptions.get(n, 1);
                if (baseParameter == null) {
                    baseParameter = this.parameterDescriptions.get(n, 2);
                    bl = true;
                }
                if (baseParameter == null) continue;
                if (baseParameter.isNull()) {
                    this.writer.writeInt8(255);
                    continue;
                }
                if (this.lobLocParam != null) {
                    if (this.lobLocParam.fdocaType % 2 != 0) {
                        this.writer.writeInt8(0);
                    }
                } else {
                    this.writer.writeInt8(0);
                }
                switch (baseParameter.sqlType) {
                    case 2004: {
                        baseParameter.setBinaryStream(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions));
                        this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                        continue block32;
                    }
                    case 2005: {
                        if (this.doubleByteColumns != null && this.doubleByteColumns[i] != 0) {
                            this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength() / 2);
                            continue block32;
                        }
                        this.writer.writeInt32((int)((BaseInputStreamWrapper)baseParameter.getObject()).determineLength());
                        continue block32;
                    }
                    case -7: {
                        if (baseParameter.getBoolean(this.comm.exceptions)) {
                            if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                                this.writer.writeInt8(49);
                                continue block32;
                            }
                            this.writer.writeInt8(241);
                            continue block32;
                        }
                        if (this.comm.serverOS == 3 || this.comm.serverOS == 8) {
                            this.writer.writeInt8(48);
                            continue block32;
                        }
                        this.writer.writeInt8(240);
                        continue block32;
                    }
                    case 5: {
                        this.writer.writeInt16(baseParameter.getShort(this.comm.exceptions));
                        continue block32;
                    }
                    case 4: {
                        this.writer.writeInt32(baseParameter.getInteger(this.comm.exceptions));
                        continue block32;
                    }
                    case -5: {
                        if (baseParameter.nativeType == 23 || baseParameter.nativeType == 22) {
                            this.writer.writeInt64(baseParameter.getLong(this.comm.exceptions));
                            continue block32;
                        }
                        this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                        continue block32;
                    }
                    case 6: 
                    case 8: {
                        this.writer.writeIEEE64BitDouble(baseParameter.getDouble(this.comm.exceptions));
                        continue block32;
                    }
                    case 7: {
                        this.writer.writeIEEE32BitFloat(baseParameter.getFloat(this.comm.exceptions));
                        continue block32;
                    }
                    case 2: 
                    case 3: {
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case 91: {
                        this.writer.writeEncodedString(baseParameter.getDate(this.comm.exceptions).toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 92: {
                        Object object = new StringBuffer(baseParameter.getTime(this.comm.exceptions).toString());
                        ((StringBuffer)object).setCharAt(2, '.');
                        ((StringBuffer)object).setCharAt(5, '.');
                        this.writer.writeEncodedString(((StringBuffer)object).toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 93: {
                        Object object = baseParameter.getTimestamp(this.comm.exceptions);
                        String string = object.toString();
                        int n2 = 20;
                        String string2 = string.substring(string.lastIndexOf(".") + 1);
                        if (string.length() > n2) {
                            string = string.substring(0, n2);
                        }
                        if (string2.length() > 6) {
                            string2 = string2.substring(0, 6);
                        } else {
                            while (string2.length() < 6) {
                                string2 = string2 + "0";
                            }
                        }
                        StringBuffer stringBuffer = new StringBuffer(string + string2);
                        stringBuffer.setCharAt(10, '-');
                        stringBuffer.setCharAt(13, '.');
                        stringBuffer.setCharAt(16, '.');
                        this.writer.writeEncodedString(stringBuffer.toString(), this.comm.SingleByteClientTransliterator);
                        continue block32;
                    }
                    case 1: {
                        switch (baseParameter.getType()) {
                            case 18: {
                                this.writer.writeReader(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 16: {
                                this.writer.writeStream(baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 15: {
                                this.writer.writeStream(baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 17: {
                                this.writer.writeStream(baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                        }
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -1: 
                    case 12: {
                        switch (baseParameter.getType()) {
                            case 18: {
                                this.writer.writeReaderWithLength16(baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 16: {
                                this.writer.writeStreamWithLength16(baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 15: {
                                this.writer.writeStreamWithLength16(baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                            case 17: {
                                this.writer.writeStreamWithLength16(baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                                continue block32;
                            }
                        }
                        this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -2: {
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                        continue block32;
                    }
                    case -4: 
                    case -3: {
                        if (baseParameter.getType() == 14) {
                            this.writer.writeStreamWithLength16(baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions), (int)((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.comm.exceptions)).determineLength());
                            continue block32;
                        }
                        this.writer.writeInt16(baseParameter.getBytes(-1, this.comm.exceptions).length);
                        this.writer.writeBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                    }
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8521: {
                    if (this.reader.getByte() == 241) {
                        this.cursorIsScrollable = true;
                        return true;
                    }
                    this.cursorIsScrollable = false;
                    return true;
                }
                case 8528: {
                    this.cursorUpdateAbility = this.reader.getByte();
                    return true;
                }
                case 8535: {
                    this.cursorSensitivity = this.reader.getByte();
                    return true;
                }
                case 9243: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                    } else if ((short)(n + 4) == -32764) {
                        n = this.reader.queryDataLength;
                    }
                    this.queryDataLen = n;
                    this.queryDataEndPosition = this.reader.readPosition + n;
                    if (this.processMode == 1) return false;
                    if (this.processMode == 0) {
                        return false;
                    }
                }
                case 8706: {
                    this.isCursorOpen = false;
                    if (this.continuingQuery) {
                        this.exception = this.comm.exceptions.getException(7080);
                        return true;
                    }
                    this.reader.readAndDiscardBytes(n);
                    return true;
                }
                case 8716: {
                    return true;
                }
                case 8715: 
                case 8722: {
                    this.moreData = false;
                    return true;
                }
                case 8719: {
                    this.reader.readAndDiscardBytes(n);
                    this.isCursorOpen = false;
                    this.moreData = false;
                    return true;
                }
                case 8479: {
                    if (this.reader.readUnsignedInt8() != 241) return true;
                    this.isCursorHeldOpen = true;
                    return true;
                }
                case 8469: {
                    this.implConn.endUnitOfWork(this.reader.getByte());
                    return true;
                }
                case 9233: {
                    if (n == 32772) {
                        this.reader.readAndDiscardBytes(4);
                    }
                    this.processSQLCA(baseWarnings);
                    if (this.comm.SQLAMLevel >= 7) {
                        this.processSQLDH(baseWarnings);
                    }
                    this.processSQLDA(baseWarnings);
                    return this.processMode != 3;
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void processEXTDTAParam(DRDAParameter dRDAParameter, boolean bl) throws SQLException {
        try {
            int n = new Long(dRDAParameter.lobLength).intValue();
            boolean bl2 = false;
            if (n != 0) {
                int n2 = 0;
                short s = this.reader.readInt16();
                if (s == -32760) {
                    this.reader.readAndDiscardBytes(2);
                    n2 = this.reader.readInt32();
                } else {
                    this.reader.readAndDiscardBytes(2);
                    n2 = s - 4;
                }
                if (dRDAParameter.isNullable && this.comm.SQLAMLevel >= 7) {
                    bl2 = this.reader.readUnsignedInt8() == 255;
                    --n2;
                }
                if (bl) {
                    this.reader.readAndDiscardBytes(n2);
                } else {
                    long l = 0L;
                    this.lobBuffer = new UtilPagedTempBuffer();
                    if (!bl2) {
                        if (dRDAParameter.baseParam.sqlType == 2005) {
                            int n3 = 0;
                            char[] cArray = new char[8192];
                            UtilTransliterator utilTransliterator = this.reader.transliterator;
                            this.reader.transliterator = dRDAParameter.baseParam.transliterator;
                            Reader reader = this.reader.getReader(n2);
                            while (n3 != -1) {
                                n3 = reader.read(cArray, 0, 8192);
                                if (n3 == -1) continue;
                                l += (long)this.lobBuffer.write(l, this.drdaUtil.UCS2CharsToBytes(cArray, n3));
                            }
                            dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                            this.reader.transliterator = utilTransliterator;
                        } else {
                            int n4 = 0;
                            byte[] byArray = new byte[16384];
                            while (n2 > 0) {
                                n4 = this.reader.readBytes(byArray, 0, Math.min(16384, n2));
                                l += (long)this.lobBuffer.write(l, byArray, 0, n4);
                                n2 -= n4;
                            }
                            dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(n, this.implConn, this.lobBuffer));
                        }
                    } else if (dRDAParameter.baseParam.sqlType == 2005) {
                        dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                    } else {
                        dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                    }
                }
            } else {
                this.lobBuffer = new UtilPagedTempBuffer();
                if (dRDAParameter.baseParam.sqlType == 2005) {
                    dRDAParameter.baseParam.setData(20, (Object)new DB2ImplClob(this.implConn, this.lobBuffer, dRDAParameter.baseParam.transliterator));
                } else {
                    dRDAParameter.baseParam.setData(19, (Object)new DB2ImplBlob(0L, this.implConn, this.lobBuffer));
                }
            }
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
        dRDAParameter.readExtendedData = true;
    }

    public final void processFDODSC(int n, boolean bl) throws UtilException {
        int n2 = this.reader.readPosition + n;
        String[] stringArray = new String[1];
        do {
            int n3 = this.reader.readUnsignedInt8asInt();
            byte by = this.reader.getByte();
            n3 -= 2;
            switch (by) {
                case 118: {
                    this.reader.readAndDiscardBytes(1);
                    if (bl) {
                        this.updateParameterDescriptions();
                        break;
                    }
                    this.updateColumnDescriptions();
                    break;
                }
                case 127: {
                    if (bl) {
                        this.updateParameterDescriptions();
                        break;
                    }
                    this.updateColumnDescriptions();
                    break;
                }
                case 120: {
                    short s;
                    short s2 = this.reader.readInt16();
                    byte[] byArray = new byte[2];
                    this.reader.readBytes(byArray, 0, byArray.length);
                    if (byArray[0] != 1) {
                        s = this.reader.getByte();
                        break;
                    }
                    s = this.reader.readUnsignedInt8();
                    byte by2 = this.reader.getByte();
                    byte by3 = this.reader.getByte();
                    int[] nArray = new int[]{this.reader.readUnsignedInt8(), s, this.reader.readUnsignedInt8(), this.reader.readInt32(), this.reader.getByte(), this.reader.getByte(), this.reader.readUnsignedInt16()};
                    if (this.fdocaMap == null) {
                        this.fdocaMap = new UtilVectorUnsynced();
                    }
                    int n4 = this.fdocaMap.size();
                    for (int i = 0; i < n4; ++i) {
                        if (((int[])this.fdocaMap.get(i))[0] != nArray[0]) continue;
                        this.fdocaMap.set(i, (Object)nArray);
                    }
                    this.fdocaMap.addElement((Object)nArray);
                    this.hasEarlyDesc = true;
                    break;
                }
                case 112: 
                case 113: {
                    this.reader.readAndDiscardBytes(n3);
                    break;
                }
                default: {
                    stringArray[0] = Integer.toHexString(by);
                    this.exception = this.comm.exceptions.getException(7073, stringArray);
                    this.reader.readAndDiscardBytes(n3);
                }
            }
        } while (this.reader.readPosition < n2 && this.reader.readPosition != 0);
    }

    public void updateColumnDescriptions() throws UtilException {
        int n = this.columnDescriptions.count(0);
        boolean bl = false;
        int n2 = -1;
        block13: for (int i = 0; i < n; ++i) {
            int n3;
            bl = false;
            n2 = -1;
            if (i % 84 == 0 && i != 0) {
                this.reader.readAndDiscardBytes(3);
            }
            DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(i + 1);
            dRDAColumn.fdocaType = this.reader.readUnsignedInt8();
            boolean bl2 = false;
            if (this.hasEarlyDesc) {
                n3 = this.fdocaMap.size();
                for (int j = 0; j < n3; ++j) {
                    if (((int[])this.fdocaMap.get(j))[0] != dRDAColumn.fdocaType) continue;
                    bl = true;
                    n2 = j;
                    dRDAColumn.fdocaType = ((int[])this.fdocaMap.get(j))[1];
                    bl2 = ((int[])this.fdocaMap.get(n2))[3] == 65535;
                }
            } else {
                boolean bl3 = bl2 = dRDAColumn.typeName.indexOf("BIT DATA") != -1;
            }
            if (this.hasClobColumns && !this.comm.enableFullSizeLobs) {
                if (dRDAColumn.type != 2005) {
                    dRDAColumn.type = this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false, bl2);
                }
            } else {
                dRDAColumn.type = this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" ? this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, true, bl2) : this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false, bl2);
            }
            dRDAColumn.fdocaScale = 0;
            dRDAColumn.setLongDataBuffer();
            dRDAColumn.isNullable = dRDAColumn.fdocaType % 2 == 0 ? 0 : 1;
            if (dRDAColumn.transliterator == null) {
                dRDAColumn.transliterator = this.comm.SingleByteServerTransliterator;
            }
            if (!bl2 && bl && ((int[])this.fdocaMap.get(n2))[3] != 0) {
                dRDAColumn.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n2))[3]));
            }
            switch (dRDAColumn.type) {
                case 2004: {
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    n3 = this.reader.readUnsignedInt16();
                    dRDAColumn.isSigned = false;
                    this.hasLobCols = true;
                    continue block13;
                }
                case -4: 
                case -3: 
                case -2: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen * 2;
                    dRDAColumn.isSigned = false;
                    continue block13;
                }
                case 3: {
                    dRDAColumn.precision = this.reader.getByte();
                    dRDAColumn.fdocaLen = dRDAColumn.precision / 2 + 1;
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.getByte();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    continue block13;
                }
                case 2: {
                    dRDAColumn.fdocaLen = dRDAColumn.precision = (int)this.reader.getByte();
                    dRDAColumn.scale = dRDAColumn.fdocaScale = (int)this.reader.getByte();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    continue block13;
                }
                case 5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 5;
                    dRDAColumn.displaySize = 6;
                    continue block13;
                }
                case 4: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 10;
                    dRDAColumn.displaySize = 11;
                    continue block13;
                }
                case -5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 19;
                    dRDAColumn.displaySize = 20;
                    continue block13;
                }
                case 7: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 7;
                    dRDAColumn.displaySize = dRDAColumn.precision + 6;
                    continue block13;
                }
                case 6: 
                case 8: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 15;
                    dRDAColumn.displaySize = dRDAColumn.precision + 7;
                    continue block13;
                }
                case 2005: {
                    if (this.comm.enableFullSizeLobs) {
                        if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                            this.useOUTOVRlob = true;
                        }
                        n3 = this.reader.readUnsignedInt16();
                        dRDAColumn.isSigned = false;
                        dRDAColumn.isCaseSensitive = true;
                        this.hasLobCols = true;
                        continue block13;
                    }
                    this.hasClobColumns = true;
                    dRDAColumn.isCaseSensitive = true;
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    dRDAColumn.scale = dRDAColumn.fdocaScale;
                    dRDAColumn.isSigned = false;
                    continue block13;
                }
                case -1: 
                case 1: 
                case 12: {
                    dRDAColumn.isCaseSensitive = true;
                }
                default: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    if (dRDAColumn.isDoubleByteColumn && dRDAColumn.type == 1) {
                        dRDAColumn.fdocaLen *= 2;
                    }
                    dRDAColumn.precision = dRDAColumn.fdocaLen;
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    dRDAColumn.isSigned = false;
                    dRDAColumn.scale = dRDAColumn.type == 93 ? 6 : dRDAColumn.fdocaScale;
                }
            }
        }
    }

    public final void updateParameterDescriptions() throws UtilException {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = -1;
        for (int i = 0; i < this.numParams; ++i) {
            int n4;
            bl2 = false;
            n3 = -1;
            if (i % 84 == 0 && i != 0) {
                this.reader.readAndDiscardBytes(3);
            }
            int n5 = i + 1;
            BaseParameter baseParameter = this.parameterDescriptions.getOutput(n5);
            bl = true;
            if (baseParameter == null) {
                baseParameter = this.parameterDescriptions.getInput(n5);
                bl = false;
            }
            n2 = this.reader.readUnsignedInt8();
            boolean bl3 = false;
            if (this.hasEarlyDesc) {
                n4 = this.fdocaMap.size();
                for (int j = 0; j < n4; ++j) {
                    if (((int[])this.fdocaMap.get(j))[0] != n2) continue;
                    bl2 = true;
                    n3 = j;
                    n2 = ((int[])this.fdocaMap.get(j))[1];
                    bl3 = ((int[])this.fdocaMap.get(n3))[3] == 65535;
                }
            }
            n4 = this.drdaUtil.Drda2JdbcType(n2, false, bl3);
            if (!bl3) {
                if (bl2) {
                    if (((int[])this.fdocaMap.get(n3))[3] != 0) {
                        baseParameter.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(((int[])this.fdocaMap.get(n3))[3]));
                    }
                } else {
                    baseParameter.transliterator = this.comm.SingleByteServerTransliterator;
                }
            }
            switch (n4) {
                case 2: 
                case 3: {
                    n = this.reader.getByte();
                    by = this.reader.getByte();
                    break;
                }
                default: {
                    by = 0;
                    n = this.reader.readUnsignedInt16();
                }
            }
            if (this.storedProcedureParams == null) {
                this.storedProcedureParams = new UtilVectorUnsynced();
            }
            this.storedProcedureParams.add((Object)new DRDAParameter(baseParameter, n2, n, by, bl));
        }
    }

    public final void updateParameterData() throws UtilException {
        int n = this.storedProcedureParams.size();
        boolean bl = false;
        byte by = this.reader.getByte();
        if (by == -1) {
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            DRDAParameter dRDAParameter = (DRDAParameter)this.storedProcedureParams.get(i);
            dRDAParameter.isNullable = dRDAParameter.fdocaType % 2 != 0;
            boolean bl2 = false;
            if (dRDAParameter.isNullable && !bl) {
                n2 = this.reader.readUnsignedInt8();
                bl2 = n2 == 255 || n2 == 128;
            }
            n2 = this.drdaUtil.Drda2JdbcType(dRDAParameter.fdocaType, false, false);
            if (!bl2 && !bl) {
                switch (n2) {
                    case 1: {
                        dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        break;
                    }
                    case -1: 
                    case 12: {
                        short s = this.reader.readInt16();
                        dRDAParameter.baseParam.setData(10, (Object)this.reader.readEncodedString(s, dRDAParameter.baseParam.transliterator));
                        break;
                    }
                    case 2005: {
                        dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        dRDAParameter.hasExtendedData = true;
                        if (dRDAParameter.fdocaType == 204 || dRDAParameter.fdocaType == 205) {
                            dRDAParameter.baseParam.transliterator = this.comm.DoubleByteServerTransliterator;
                            dRDAParameter.baseParam.sqlType = n2;
                            break;
                        }
                        dRDAParameter.baseParam.transliterator = dRDAParameter.baseParam.transliterator;
                        break;
                    }
                    case 2004: {
                        dRDAParameter.lobLength = this.reader.readUnsignedInt32();
                        dRDAParameter.hasExtendedData = true;
                        break;
                    }
                    case -5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(5, (Object)new Long(this.reader.readInt64()));
                        break;
                    }
                    case 5: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(3, (Object)new Short(this.reader.readInt16()));
                        break;
                    }
                    case 4: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        dRDAParameter.baseParam.setData(4, (Object)new Integer(this.reader.readInt32()));
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            long l = this.drdaUtil.ibm2IeeeDoubleFloat(this.reader.readInt64());
                            dRDAParameter.baseParam.setData(7, (Object)new Double(Double.longBitsToDouble(l)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(7, (Object)new Double(this.reader.readIEEE64BitDouble()));
                        break;
                    }
                    case 7: {
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        if (this.comm.serverOS == 3) {
                            int n3 = this.drdaUtil.ibm2IeeeSingleFloat(this.reader.readInt32());
                            dRDAParameter.baseParam.setData(6, (Object)new Float(Float.intBitsToFloat(n3)));
                            break;
                        }
                        dRDAParameter.baseParam.setData(6, (Object)new Float(this.reader.readIEEE32BitFloat()));
                        break;
                    }
                    case 3: {
                        int n4 = dRDAParameter.fdocaLen / 2 + 1;
                        Object object = new byte[n4];
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        this.reader.readBytes((byte[])object, 0, n4);
                        StringBuffer stringBuffer = new StringBuffer();
                        if ((object[n4 - 1] & 0xF) == 13) {
                            stringBuffer.append('-');
                        }
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = false;
                        for (int j = 0; j < n4 - 1; ++j) {
                            n7 = object[j];
                            n5 = n7 >>> 4 & 0xF;
                            n6 = n7 & 0xF;
                            stringBuffer.append(String.valueOf(n5) + String.valueOf(n6));
                        }
                        stringBuffer.append(String.valueOf(object[n4 - 1] >>> 4 & 0xF));
                        dRDAParameter.baseParam.setData(8, (Object)new BigDecimal(new BigInteger(stringBuffer.toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 2: {
                        int n8 = dRDAParameter.fdocaLen;
                        if (!this.comm.isServerBigEndianOS) {
                            this.reader.interpretAsBigEndian = false;
                        }
                        Object object = new StringBuffer(this.reader.readEncodedString(n8 - 1, dRDAParameter.baseParam.transliterator));
                        byte by2 = this.reader.getByte();
                        if ((by2 >>> 4 & 0xF) == 13) {
                            ((StringBuffer)object).insert(0, '-');
                        }
                        ((StringBuffer)object).append(String.valueOf(by2 & 0xF));
                        dRDAParameter.baseParam.setData(8, (Object)new BigDecimal(new BigInteger(((StringBuffer)object).toString()), dRDAParameter.fdocaScale));
                        break;
                    }
                    case 91: {
                        StringBuffer stringBuffer;
                        Object object;
                        Date date = null;
                        if (this.isStoredProcedure) {
                            object = this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator);
                            if (((String)object).charAt(4) != '-') {
                                stringBuffer = new StringBuffer(10);
                                stringBuffer.append(((String)object).substring(6));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(0, 2));
                                stringBuffer.append('-');
                                stringBuffer.append(((String)object).substring(3, 5));
                                date = Date.valueOf(stringBuffer.toString());
                            } else {
                                date = Date.valueOf((String)object);
                            }
                        } else {
                            date = Date.valueOf(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        }
                        dRDAParameter.baseParam.setData(11, (Object)date);
                        break;
                    }
                    case 92: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(2, ':');
                        stringBuffer.setCharAt(5, ':');
                        dRDAParameter.baseParam.setData(12, (Object)Time.valueOf(stringBuffer.toString()));
                        break;
                    }
                    case 93: {
                        StringBuffer stringBuffer = new StringBuffer(this.reader.readEncodedString(dRDAParameter.fdocaLen, dRDAParameter.baseParam.transliterator));
                        stringBuffer.setCharAt(10, ' ');
                        stringBuffer.setCharAt(13, ':');
                        stringBuffer.setCharAt(16, ':');
                        dRDAParameter.baseParam.setData(13, (Object)BaseTimestamp.valueOf((String)stringBuffer.toString()));
                        break;
                    }
                    case -2: {
                        byte[] byArray = new byte[dRDAParameter.fdocaLen];
                        this.reader.readBytes(byArray, 0, dRDAParameter.fdocaLen);
                        dRDAParameter.baseParam.setData(2, (Object)byArray);
                        break;
                    }
                    case -4: 
                    case -3: {
                        short s = this.reader.readInt16();
                        Object object = new byte[s];
                        if (s != 0) {
                            this.reader.readBytes((byte[])object, 0, s);
                        }
                        dRDAParameter.baseParam.setData(2, object);
                    }
                }
                this.reader.interpretAsBigEndian = true;
                continue;
            }
            if (!dRDAParameter.isOutParam) continue;
            dRDAParameter.baseParam.setNull(BaseData.getJavaObjectType(null, (int)dRDAParameter.baseParam.sqlType));
        }
    }

    public final void processSQLCINRD() throws UtilException, SQLException {
        if (this.comm.SQLAMLevel >= 7) {
            this.processSQLDH(this.implConn.warnings);
            this.processSQLDA(this.implConn.warnings);
        } else {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            int n = this.reader.readInt16();
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
            this.reader.interpretAsBigEndian = true;
            for (int i = 0; i < n; ++i) {
                DRDAColumn dRDAColumn = new DRDAColumn(1);
                dRDAColumn.baseDataObj = new BaseData(10, null, (BaseConnection)this.implConn.db2Connection);
                dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(i + 1);
                dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.columnDescriptions.add((BaseColumn)dRDAColumn);
                this.reader.interpretAsBigEndian = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void processSQLDA(BaseWarnings var1_1) throws UtilException, SQLException {
        if (!this.comm.isServerBigEndianOS) {
            this.reader.interpretAsBigEndian = false;
        }
        var2_2 = this.reader.readInt16();
        if (this.processMode != 4) {
            this.columnDescriptions = null;
            this.columnDescriptions = new BaseColumns();
        }
        for (var3_3 = 0; var3_3 < var2_2; ++var3_3) {
            if (!this.comm.isServerBigEndianOS) {
                this.reader.interpretAsBigEndian = false;
            }
            var4_4 = this.reader.readInt16();
            var5_5 = this.reader.readInt16();
            var6_6 = 0;
            var6_6 = this.comm.SQLAMLevel >= 6 ? new Long(this.reader.readInt64()).intValue() : this.reader.readInt32();
            var7_7 = this.reader.readInt16();
            if (var7_7 == 412 || var7_7 == 413) {
                if (this.doubleByteColumns == null) {
                    this.doubleByteColumns = new int[var2_2];
                } else if (var2_2 > this.doubleByteColumns.length) {
                    this.doubleByteColumns = new int[var2_2];
                }
                this.doubleByteColumns[var3_3] = var7_7;
            }
            this.reader.interpretAsBigEndian = true;
            var8_8 = this.reader.readInt16();
            var9_9 = (var8_8 & 65535) == 65535;
            var10_10 = false;
            if (this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" && var9_9) {
                var10_10 = true;
                var9_9 = false;
                var8_8 = 0;
            }
            var11_11 = this.drdaUtil.DB2ToJdbcType(var7_7, var9_9, var6_6);
            var12_12 = new DRDAColumn(var11_11);
            var12_12.typeName = this.drdaUtil.getDB2TypeName(var7_7, var9_9, var6_6);
            if (var8_8 != 0 && !var9_9) {
                if (var8_8 == 1200) {
                    var12_12.isDoubleByteColumn = true;
                }
                var12_12.transliteratorCharSet = Integer.toString(var8_8);
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else if (var10_10) {
                var12_12.transliteratorCharSet = this.implConn.charSetFor65535;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            } else {
                var12_12.transliterator = this.comm.defaultCCSIDTransliterator;
            }
            if (this.implConn.codePageOverride != null) {
                var12_12.transliteratorCharSet = this.implConn.codePageOverride;
                var12_12.transliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(var12_12.transliteratorCharSet);
            }
            var12_12.isNullable = var7_7 % 2 == 0 ? 0 : 1;
            var12_12.baseDataObj = new BaseData(10, null, (BaseConnection)this.implConn.db2Connection);
            switch (var11_11) {
                case 2004: {
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                }
                case -4: 
                case -3: 
                case -2: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6 * 2;
                    var12_12.isSigned = false;
                    break;
                }
                case 2: 
                case 3: {
                    var12_12.precision = var4_4;
                    var12_12.scale = var5_5;
                    var12_12.displaySize = var12_12.precision + 3;
                    var12_12.fdocaLen = var12_12.precision / 2 + 1;
                    break;
                }
                case 5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 5;
                    var12_12.displaySize = 6;
                    break;
                }
                case 4: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 10;
                    var12_12.displaySize = 11;
                    break;
                }
                case -5: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 19;
                    var12_12.displaySize = 20;
                    break;
                }
                case 7: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 7;
                    var12_12.displaySize = var12_12.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    var12_12.fdocaLen = var6_6;
                    var12_12.precision = 15;
                    var12_12.displaySize = var12_12.precision + 7;
                    break;
                }
                case 2005: {
                    if (!this.comm.enableFullSizeLobs) {
                        this.hasClobColumns = true;
                    }
                    if (this.comm.SQLAMLevel < 7 && !this.comm.allowsLobStreamingAtSQLAM6 || this.comm.SQLAMLevel >= 7 && !this.comm.allowsLobStreamingAtSQLAM7) {
                        this.useOUTOVRlob = true;
                    }
                    if (var7_7 != 412) ** GOTO lbl98
                    var12_12.fdocaType = 205;
                    ** GOTO lbl100
lbl98:
                    // 1 sources

                    if (var7_7 == 413) {
                        var12_12.fdocaType = 204;
                    }
                }
lbl100:
                // 5 sources

                case -1: 
                case 1: 
                case 12: {
                    var12_12.isCaseSensitive = true;
                }
                default: {
                    var12_12.fdocaLen = var6_6;
                    if (var12_12.isDoubleByteColumn && var12_12.type == 1) {
                        var12_12.fdocaLen *= 2;
                    }
                    var12_12.precision = var6_6;
                    var12_12.displaySize = var6_6;
                    var12_12.isSigned = false;
                    var12_12.scale = var11_11 == 93 ? 6 : (int)var5_5;
                }
            }
            if (this.comm.SQLAMLevel < 7) {
                var12_12.name = this.reader.readMutuallyExclusiveFDOCAString(var3_3 + 1);
                var12_12.label = this.reader.readMutuallyExclusiveFDOCAString(var12_12.name);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                if (this.comm.SQLAMLevel >= 6) {
                    this.processSQLUDT(var12_12, var1_1);
                }
            } else {
                this.processSQLDOPT(var12_12, var3_3, var1_1);
            }
            if (this.processMode == 4) {
                this.drdaUtil.convertColumnDescToParamDesc(var12_12, this.parameterDescriptions.getParameterInfo(var3_3));
                continue;
            }
            this.columnDescriptions.add((BaseColumn)var12_12);
        }
    }

    public final void processSQLDH(BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            String string = this.reader.readMutuallyExclusiveFDOCAString(this.implConn.user);
        }
    }

    public final void processSQLDOPT(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            this.reader.readAndDiscardBytes(2);
            dRDAColumn.name = this.reader.readMutuallyExclusiveFDOCAString(n + 1);
            dRDAColumn.label = this.reader.readMutuallyExclusiveFDOCAString(dRDAColumn.name);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.processSQLUDT(dRDAColumn, baseWarnings);
            this.processSQLDX(dRDAColumn, n, baseWarnings);
        }
    }

    public final void processSQLUDT(DRDAColumn dRDAColumn, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.comm.SQLAMLevel >= 7) {
                this.reader.readAndDiscardBytes(4);
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            } else {
                this.reader.readAndDiscardBytes(this.reader.readInt16());
                this.reader.readAndDiscardBytes(this.reader.readInt16());
            }
        }
    }

    public final void processSQLDX(DRDAColumn dRDAColumn, int n, BaseWarnings baseWarnings) throws UtilException, SQLException {
        if (this.reader.readUnsignedInt8() != 255) {
            if (this.reader.readInt16() == 1) {
                dRDAColumn.isKey = true;
            }
            this.reader.readAndDiscardBytes(2);
            short s = this.reader.readInt16();
            if (s != 0) {
                dRDAColumn.isAutoIncrement = true;
            }
            this.reader.readAndDiscardBytes(2);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readMutuallyExclusiveFDOCAString(0);
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
            this.reader.readAndDiscardBytes(this.reader.readInt16());
        }
    }
}

