/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class OracleNet8NSPTDAPacket {
    private static String footprint = "$Revision:   3.9.1.0  $";
    protected OracleNet8Communication comm;
    public OracleDataProvider reader;
    public OracleDataConsumer writer;
    private boolean headerStreamed = false;
    protected int NSPTDAflag1;
    protected int NSPTDAflag2;

    public OracleNet8NSPTDAPacket(OracleNet8Communication oracleNet8Communication) {
        this(oracleNet8Communication, false);
    }

    public OracleNet8NSPTDAPacket(OracleNet8Communication oracleNet8Communication, boolean bl) {
        this.comm = oracleNet8Communication;
        this.headerStreamed = false;
        this.reader = bl ? this.comm.getNewReader() : this.comm.getReader();
        this.writer = this.comm.getWriter();
    }

    public void appendTTISubPacket(TTIDataPacket tTIDataPacket) throws SQLException {
        try {
            if (!this.headerStreamed) {
                this.comm.setNSPTPacketType(6);
                this.writer.writeZeros(2);
                this.headerStreamed = true;
            }
            this.writer.writeByte((byte)tTIDataPacket.TTCCode);
            if (tTIDataPacket.TTCCode == 3) {
                this.writer.writeByte((byte)((TTIFUNDataPacket)tTIDataPacket).FUNCode);
                this.writer.writeZero();
            }
            tTIDataPacket.streamOut(this.writer);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void sendRequestNoReply() throws SQLException {
        try {
            if (this.comm.implConn.cancelPending) {
                this.comm.implConn.socketActivityPostCancel();
            }
            this.writer.send();
            this.headerStreamed = false;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void sendRequest() throws SQLException {
        try {
            if (this.comm.implConn.cancelPending) {
                this.comm.implConn.socketActivityPostCancel();
            }
            this.writer.send();
            this.headerStreamed = false;
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void receiveReply() throws SQLException {
        try {
            if (this.reader.getNSPacketType() == 12) {
                this.CheckAndProcessMarkerPacket(this.writer);
            }
            this.NSPTDAflag1 = this.reader.readByte();
            this.NSPTDAflag2 = this.reader.readByte();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void CheckAndProcessMarkerPacket(OracleDataConsumer oracleDataConsumer) throws SQLException {
        try {
            int n = this.processMarkerPacket();
            if (n == 0) {
                this.SendResetMarkerPacket(oracleDataConsumer);
                while (n != 1) {
                    this.reader.receivePacket();
                    n = this.processMarkerPacket();
                }
            } else if (n == 1) {
                this.SendResetMarkerPacket(oracleDataConsumer);
            }
            this.reader.receivePacket();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void SendResetMarkerPacket(OracleDataConsumer oracleDataConsumer) throws UtilException {
        oracleDataConsumer.setNSPTPacketType(12);
        oracleDataConsumer.writeByte((byte)1);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)2);
        oracleDataConsumer.send();
    }

    public void SendBreakMarkerPacket() throws UtilException {
        this.writer.setNSPTPacketType(12);
        this.writer.writeByte((byte)1);
        this.writer.writeByte((byte)0);
        this.writer.writeByte((byte)1);
        this.writer.send();
    }

    private int processMarkerPacket() throws UtilException, SQLException {
        byte by = this.reader.readByte();
        this.reader.readByte();
        if (by == 1) {
            byte by2 = this.reader.readByte();
            by = by2 == 2 ? (byte)1 : 0;
        }
        return by;
    }

    public int getNextTTCCode() throws SQLException {
        try {
            return this.reader.readByte();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void getNextNextTTISubpacket(TTIDataPacket tTIDataPacket) throws SQLException {
        try {
            tTIDataPacket.streamIn(this.reader);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

