/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.security.dh.ESDHKEKParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class ESDHKEKParameters
extends AlgorithmParametersSpi {
    ESDHKEKParameterSpec a;

    public void resetCounter() {
        this.a.resetCounter();
    }

    public void incrementCounter() {
        this.a.incrementCounter();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            ObjectID objectID = (ObjectID)aSN1Object2.getComponentAt(0);
            byte[] byArray2 = (byte[])aSN1Object2.getComponentAt(1).getValue();
            int n2 = aSN1Object.countComponents();
            if (n2 > 3) {
                throw new IOException("Invalid number of components for OtherInfo: " + n2);
            }
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(1);
            int n3 = cON_SPEC.getAsnType().getTag();
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            if (n3 == 0) {
                byArray3 = (byte[])((OCTET_STRING)cON_SPEC.getValue()).getValue();
                cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(2);
                n3 = cON_SPEC.getAsnType().getTag();
            }
            if (n3 != 2) {
                throw new IOException("Unexpected context specific tag number: " + n3);
            }
            byArray4 = (byte[])((OCTET_STRING)cON_SPEC.getValue()).getValue();
            try {
                this.a = new ESDHKEKParameterSpec(objectID, byArray4);
                if (byArray3 != null) {
                    this.a.setPartyAInfo(byArray3);
                }
                this.a.setCounter(byArray2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Cannot decode OtherInfo: " + illegalArgumentException.getMessage());
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ESDHKEKParameterSpec) {
            this.a = (ESDHKEKParameterSpec)algorithmParameterSpec;
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be ESDHKEKParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        ESDHKEKParameterSpec eSDHKEKParameterSpec = (ESDHKEKParameterSpec)this.a.clone();
        if (!eSDHKEKParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return eSDHKEKParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent(this.a.getCekWrapAlgorithm());
        sEQUENCE2.addComponent(new OCTET_STRING(this.a.getCounter()));
        sEQUENCE.addComponent(sEQUENCE2);
        byte[] byArray = this.a.getPartyAInfo();
        if (byArray != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, new OCTET_STRING(byArray)));
        }
        sEQUENCE.addComponent(new CON_SPEC(2, new OCTET_STRING(this.a.getSuppPubInfo())));
        return DerCoder.encode(sEQUENCE);
    }

    ESDHKEKParameters(ESDHKEKParameterSpec eSDHKEKParameterSpec) {
        if (eSDHKEKParameterSpec == null) {
            throw new IllegalArgumentException("Need ESDHKEKParameterSpec for initialization!");
        }
        this.a = eSDHKEKParameterSpec;
    }

    public ESDHKEKParameters() {
    }
}

