/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.util;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.MultipleRuntimeException;
import com.metamatrix.core.MetaMatrixCoreException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public class AdminExceptionConverter {
    private static final String MSG_SEPARATOR = ": ";

    public static AdminComponentException convertToComponentException(Throwable exceptionRoot) {
        return AdminExceptionConverter.convertToComponentException(exceptionRoot, null);
    }

    public static AdminProcessingException convertToProcessingException(Throwable exceptionRoot) {
        return AdminExceptionConverter.convertToProcessingException(exceptionRoot, null);
    }

    public static AdminComponentException convertToComponentException(Throwable exceptionRoot, String topLevelMsg) {
        AdminComponentException converted = null;
        Throwable origError = AdminExceptionConverter.getRootCause(exceptionRoot);
        if (origError instanceof AdminComponentException) {
            converted = (AdminComponentException)origError;
        } else {
            converted = topLevelMsg == null ? new AdminComponentException(origError.getClass().getName() + MSG_SEPARATOR + origError.getMessage()) : (origError.getMessage() == null || topLevelMsg.equals(origError.getMessage()) ? new AdminComponentException(topLevelMsg) : new AdminComponentException(topLevelMsg + MSG_SEPARATOR + origError.getMessage()));
            converted.setStackTrace(origError.getStackTrace());
        }
        return converted;
    }

    public static AdminProcessingException convertToProcessingException(Throwable exceptionRoot, String topLevelMsg) {
        AdminProcessingException converted = null;
        Throwable origError = AdminExceptionConverter.getRootCause(exceptionRoot);
        if (origError instanceof AdminProcessingException) {
            converted = (AdminProcessingException)origError;
        } else {
            converted = topLevelMsg == null ? new AdminProcessingException(origError.getClass().getName() + MSG_SEPARATOR + origError.getMessage()) : new AdminProcessingException(topLevelMsg + MSG_SEPARATOR + origError.getClass().getName() + MSG_SEPARATOR + origError.getMessage());
            converted.setStackTrace(origError.getStackTrace());
        }
        return converted;
    }

    private static Throwable getRootCause(Throwable parent) {
        Throwable result = null;
        if (parent == null) {
            result = parent;
        } else if (parent instanceof AdminException) {
            AdminException e = (AdminException)parent;
            result = AdminExceptionConverter.getRootCause(e.getCause());
            if (result == null) {
                result = e;
            }
        } else if (parent instanceof MetaMatrixCoreException) {
            MetaMatrixCoreException e = (MetaMatrixCoreException)parent;
            result = AdminExceptionConverter.getRootCause(e.getException());
            if (result == null) {
                result = e;
            }
        } else if (parent instanceof MetaMatrixRuntimeException) {
            MetaMatrixRuntimeException e = (MetaMatrixRuntimeException)parent;
            result = AdminExceptionConverter.getRootCause(e.getChild());
            if (result == null) {
                result = e;
            }
        } else if (parent instanceof InvocationTargetException) {
            InvocationTargetException e = (InvocationTargetException)parent;
            result = AdminExceptionConverter.getRootCause(e.getCause());
            if (result == null) {
                result = e;
            }
        } else if (parent instanceof MultipleException) {
            MultipleException e = (MultipleException)parent;
            AdminComponentException newRoot = new AdminComponentException(e.getMessage());
            newRoot.setStackTrace(e.getStackTrace());
            Iterator iter = e.getExceptions().iterator();
            while (iter.hasNext()) {
                result = AdminExceptionConverter.getRootCause((Throwable)iter.next());
                if (result != null) continue;
                AdminException aResult = AdminExceptionConverter.convertBasic(e);
                newRoot.addChild(aResult);
            }
            result = newRoot;
        } else if (parent instanceof MultipleRuntimeException) {
            MultipleRuntimeException e = (MultipleRuntimeException)parent;
            AdminComponentException newRoot = new AdminComponentException(e.getMessage());
            newRoot.setStackTrace(e.getStackTrace());
            Iterator iter = e.getThrowables().iterator();
            while (iter.hasNext()) {
                result = AdminExceptionConverter.getRootCause((Throwable)iter.next());
                if (result != null) continue;
                AdminException aResult = AdminExceptionConverter.convertBasic(e);
                newRoot.addChild(aResult);
            }
            result = newRoot;
        } else {
            result = parent;
        }
        return result;
    }

    private static AdminException convertBasic(Throwable toConvert) {
        AdminException converted = null;
        if (toConvert instanceof MetaMatrixProcessingException) {
            converted = new AdminProcessingException(toConvert.getMessage());
            converted.setStackTrace(toConvert.getStackTrace());
        } else {
            converted = new AdminComponentException(toConvert.getMessage());
            converted.setStackTrace(toConvert.getStackTrace());
        }
        return converted;
    }
}

