/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos.xaresource;

import com.atomikos.datasource.xa.XID;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.trmi.TrmiConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.TransactionManagerFactory;
import com.metamatrix.common.xa.XAServer;
import com.metamatrix.common.xa.atomikos.TransactionContextImpl;
import com.metamatrix.common.xa.atomikos.TransactionIDImpl;
import com.metamatrix.common.xa.atomikos.xaresource.XALogAdministrator;
import com.metamatrix.common.xa.atomikos.xaresource.XAPropagation;
import com.metamatrix.common.xa.atomikos.xaresource.XATransaction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XAServerImp
implements XAServer {
    private final int DEFAULT_TIME_OUT = 120;
    private CompositeTransactionManager ctm_;
    private ImportingTransactionManager itm_;
    private int lastTimeout_ = 120;
    private Map xidToTransactionMap_;
    private Map xidToParticipantMap_;
    private XALogAdministrator administrator_;
    private Collection unTerminatedXids = new HashSet();
    private static XAServer INSTANCE;

    public static synchronized XAServer getInstance(String vmName) throws XAException {
        if (INSTANCE == null) {
            MMTransactionManager tm = null;
            XALogAdministrator xala = null;
            try {
                tm = TransactionManagerFactory.getTransactionManager(vmName);
                xala = (XALogAdministrator)tm.getLogAdministrator();
            }
            catch (Exception e) {
                throw new XAException(-3);
            }
            CompositeTransactionManager ctm = TrmiConfiguration.getUserTransactionService().getCompositeTransactionManager();
            ImportingTransactionManager imptm = TrmiConfiguration.getUserTransactionService().getImportingTransactionManager();
            INSTANCE = new XAServerImp(ctm, imptm, xala);
            LogManager.logInfo("XA_TXN", CommonXAPlugin.Util.getString("MSG.003.031.0001"));
        }
        return INSTANCE;
    }

    private XAServerImp(CompositeTransactionManager ctm, ImportingTransactionManager itm, XALogAdministrator administrator) {
        this.ctm_ = ctm;
        this.itm_ = itm;
        this.administrator_ = administrator;
        this.xidToTransactionMap_ = new HashMap();
        this.xidToParticipantMap_ = new HashMap();
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.lastTimeout_ = timeout == 0 ? 120 : timeout;
        LogManager.logTrace("XA_TXN", new Object[]{"transaction time out is set to", new Integer(this.lastTimeout_)});
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return this.lastTimeout_;
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        LogManager.logTrace("XA_TXN", new Object[]{"starting transaction for", xid, new Integer(flags)});
        if (this.xidToTransactionMap_.containsKey(xid)) {
            LogManager.logTrace("XA_TXN", new Object[]{xid, "already started"});
            return;
        }
        XAPropagation propagation = new XAPropagation(new XATransaction(xid), this.getTransactionTimeout() * 1000);
        this.itm_.importTransaction((Propagation)propagation, false, false);
        CompositeTransaction ct = this.ctm_.suspend();
        this.xidToTransactionMap_.put(xid, ct);
        this.unTerminatedXids.add(xid);
        LogManager.logTrace("XA_TXN", new Object[]{xid, "started"});
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        xid = this.convertXid(xid);
        LogManager.logTrace("XA_TXN", new Object[]{"endding transaction for", xid, new Integer(flags)});
        if ((flags & 0x2000000) == 0x2000000) {
            LogManager.logTrace("XA_TXN", new Object[]{xid, "suspend ignored"});
            return;
        }
        CompositeTransaction ct = (CompositeTransaction)this.xidToTransactionMap_.get(xid);
        if (ct == null) {
            LogManager.logError("XA_TXN", CommonXAPlugin.Util.getString("ERR.003.031.0021", xid));
            throw new XAException(-6);
        }
        this.ctm_.resume(ct);
        Extent extent = null;
        try {
            extent = this.itm_.terminated(true);
        }
        catch (SysException e) {
            LogManager.logError("XA_TXN", (Throwable)e, CommonXAPlugin.Util.getString("ERR.003.031.0022", xid));
            throw new XAException(-3);
        }
        catch (RollbackException e) {
            LogManager.logError("XA_TXN", (Throwable)e, CommonXAPlugin.Util.getString("ERR.003.031.0022", xid));
            throw new XAException(100);
        }
        finally {
            this.unTerminatedXids.remove(xid);
        }
        Participant part = (Participant)extent.getParticipants().peek();
        if (part != null) {
            this.xidToParticipantMap_.put(xid, part);
        }
        LogManager.logTrace("XA_TXN", new Object[]{xid, "ended"});
    }

    public synchronized int prepare(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        LogManager.logTrace("XA_TXN", new Object[]{"preparing transaction for", xid});
        this.checkUnterminatedTxn(xid);
        int ret = 0;
        int result = 1;
        Participant part = (Participant)this.xidToParticipantMap_.get(xid);
        if (part == null) {
            throw new XAException(100);
        }
        try {
            result = part.prepare();
        }
        catch (RollbackException rb) {
            LogManager.logDetail("XA_TXN", (Throwable)rb, new Object[]{"failed preparing transaction with xid", xid});
            throw new XAException(100);
        }
        catch (HeurHazardException hh) {
            LogManager.logDetail("XA_TXN", (Throwable)hh, new Object[]{"failed preparing transaction with xid", xid});
            throw new XAException(8);
        }
        catch (HeurMixedException hm) {
            LogManager.logDetail("XA_TXN", (Throwable)hm, new Object[]{"failed preparing transaction with xid", xid});
            throw new XAException(5);
        }
        if (result == 0) {
            ret = 3;
            this.xidToTransactionMap_.remove(xid);
            this.xidToParticipantMap_.remove(xid);
        }
        LogManager.logTrace("XA_TXN", new Object[]{xid, "prepared", new Integer(ret)});
        return ret;
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        xid = this.convertXid(xid);
        this.checkUnterminatedTxn(xid);
        LogManager.logTrace("XA_TXN", new Object[]{"committing transaction for", xid, new Boolean(onePhase)});
        Participant part = (Participant)this.xidToParticipantMap_.get(xid);
        if (part == null) {
            if (onePhase) {
                throw new XAException(100);
            }
            throw new XAException(8);
        }
        try {
            part.commit(onePhase);
        }
        catch (RollbackException rb) {
            LogManager.logDetail("XA_TXN", (Throwable)rb, new Object[]{"failed committing transaction with xid", xid, "One phase: " + onePhase});
            throw new XAException(100);
        }
        catch (Exception e) {
            LogManager.logError("XA_TXN", (Throwable)e, CommonXAPlugin.Util.getString("ERR.003.031.0023", xid, new Boolean(onePhase)));
            throw new XAException(8);
        }
        finally {
            this.xidToTransactionMap_.remove(xid);
            this.xidToParticipantMap_.remove(xid);
        }
        LogManager.logTrace("XA_TXN", new Object[]{xid, "committed"});
    }

    public synchronized void rollback(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        LogManager.logTrace("XA_TXN", new Object[]{"rolling back transaction for", xid});
        this.checkUnterminatedTxn(xid);
        Participant part = (Participant)this.xidToParticipantMap_.get(xid);
        if (part == null && !this.administrator_.rollback(xid)) {
            LogManager.logDetail("XA_TXN", new Object[]{"failed rolling back transaction with xid", xid, "Participant not found"});
            throw new XAException(8);
        }
        try {
            part.rollback();
        }
        catch (Exception e) {
            LogManager.logDetail("XA_TXN", new Object[]{"failed rolling back transaction with xid", xid});
            throw new XAException(8);
        }
        finally {
            this.xidToTransactionMap_.remove(xid);
            this.xidToParticipantMap_.remove(xid);
        }
        LogManager.logTrace("XA_TXN", new Object[]{xid, "rolled back"});
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        Xid[] result = this.administrator_.recover();
        LogManager.logTrace("XA_TXN", new Object[]{"Recovered", result});
        return result;
    }

    public synchronized void forget(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        this.administrator_.forget(xid);
        LogManager.logTrace("XA_TXN", new Object[]{xid, "forgot"});
    }

    public synchronized TransactionContext resume(Xid xid) throws XAException {
        xid = this.convertXid(xid);
        CompositeTransaction ct = this.getCompositeTransaction(xid);
        this.ctm_.resume(ct);
        String topLevelTxnID = ct.getTid();
        TransactionIDImpl txID = new TransactionIDImpl(topLevelTxnID);
        TransactionContextImpl txnContext = new TransactionContextImpl(txID);
        return txnContext;
    }

    protected CompositeTransaction getCompositeTransaction(Xid xid) {
        return (CompositeTransaction)this.xidToTransactionMap_.get(xid);
    }

    private void checkUnterminatedTxn(Xid xid) {
        if (this.unTerminatedXids.contains(xid)) {
            try {
                this.end(xid, 0x4000000);
            }
            catch (Exception e) {
                LogManager.logError("XA_TXN", CommonXAPlugin.Util.getString("ERR.003.031.0024", xid));
            }
        }
    }

    private Xid convertXid(Xid originalXid) {
        XID convertedXid = new XID(new String(originalXid.getGlobalTransactionId()), new String(originalXid.getBranchQualifier()));
        return convertedXid;
    }
}

